<?php

/**
* $Id: faq.php,v 1.26 2005/01/11 18:39:51 malanciault Exp $
* Module: SmartFAQ
* Author: The SmartFactory <www.smartfactory.ca>
* Licence: GNU
*/

include_once("header.php");

$faqid = isset($_GET['faqid']) ? intval($_GET['faqid']) : 0;

If ($faqid == 0) {
	redirect_header("javascript:history.go(-1)", 1, _MD_SF_NOFAQSELECTED);
	exit();
}

// Creating the FAQ handler object
$faq_handler =& sf_gethandler('faq');

// Creating the FAQ object for the selected FAQ
$faqObj = new sfFaq($faqid);

// If the selected FAQ was not found, exit
If ($faqObj->notLoaded()) {
	redirect_header("javascript:history.go(-1)", 1, _MD_SF_NOFAQSELECTED);
	exit();
}

// Creating the category object that holds the selected FAQ
$categoryObj =& $faqObj->category();

// Creating the answer object
$answerObj =& $faqObj->answer();

// Check user permissions to access that category of the selected FAQ
if (!(faqAccessGranted($faqObj->getVar('faqid'), $faqObj->getVar('categoryid')))) {
	redirect_header("javascript:history.go(-1)", 1, _NOPERM);
	exit;
}

// Update the read counter of the selected FAQ
if (!$xoopsUser || ($xoopsUser->isAdmin($xoopsModule->mid()) && $xoopsModuleConfig['adminhits'] == 1) || ($xoopsUser && !$xoopsUser->isAdmin($xoopsModule->mid()))) {
	$faqObj->updateCounter();
}
$xoopsOption['template_main'] = 'smartfaq_faq.html';
include_once(XOOPS_ROOT_PATH . "/header.php");
include_once("footer.php");

$faq = $faqObj->toArray(null, $categoryObj, false);

// Populating the smarty variables with informations related to the selected FAQ
/*$faq['questionlink'] = $faqObj->question($xoopsModuleConfig['questionsize']);
$faq['question'] = $faqObj->question();

$faq['categoryid'] = $categoryObj->categoryid();
$faq['categoryname'] = $categoryObj->name();

$faq['categorydescription'] = $categoryObj->description();
$faq['counter'] = $faqObj->counter();
$faq['comments'] = $faqObj->comments();
$faq['cancomment'] = $faqObj->cancomment();
*/
$faq['categoryPath'] = $categoryObj->getCategoryPath(true);
$faq['answer'] = $answerObj->answer();
$faq['who_when'] = $faqObj->getWhoAndWhen();

$faq['adminlink'] = sf_getAdminLinks($faqObj->faqid());

$faq['comments'] = $faqObj->comments();

// Language constants
$xoopsTpl->assign('faq', $faq);
$xoopsTpl->assign('display_categoryname', false);

$xoopsTpl->assign('xcodes', $faqObj->getVar('xcodes'));
$xoopsTpl->assign('mail_link', 'mailto:?subject=' . sprintf(_MD_SF_INTARTICLE, $xoopsConfig['sitename']) . '&amp;body=' . sprintf(_MD_SF_INTARTFOUND, $xoopsConfig['sitename']) . ':  ' . XOOPS_URL . '/modules/' . $xoopsModule->dirname() . '/faq.php?faqid=' . $faqObj->getVar('faqid'));
$xoopsTpl->assign('lang_printerpage', _MD_SF_PRINTERFRIENDLY);
$xoopsTpl->assign('lang_sendstory', _MD_SF_SENDSTORY);
$xoopsTpl->assign('faqid', $faqObj->getVar('faqid'));
$xoopsTpl->assign('lang_reads', _MD_SF_READS);
$xoopsTpl->assign('lang_home', _MD_SF_HOME);
$xoopsTpl->assign('lang_faq', _MD_SF_FAQ);
$xoopsTpl->assign('lang_postedby', _MD_SF_POSTEDBY);
$xoopsTpl->assign('lang_on', _MD_SF_ON);
$xoopsTpl->assign('lang_datesub', _MD_SF_DATESUB);
$xoopsTpl->assign('lang_hitsdetail', _MD_SF_HITSDETAIL);
$xoopsTpl->assign('lang_hits', _MD_SF_READS);
$xoopsTpl->assign('lang_comments', _MD_SF_COMMENTS);

// Page Title Hack by marcan
$module_name = $myts->makeTboxData4Show($xoopsModule->getVar('name'));
$xoopsTpl->assign('xoops_pagetitle', $module_name . ' - ' . $categoryObj->name() . ' - ' . $faq['question']);
// End Page Title Hack by marcan

// Include the comments if the selected FAQ supports comments
if ($faqObj->cancomment() == 1) {
	include_once XOOPS_ROOT_PATH . "/include/comment_view.php";
}

include_once XOOPS_ROOT_PATH . '/footer.php';

?>