<?php

/**
* $Id: addfile.php,v 1.10 2005/09/14 17:58:47 malanciault Exp $
* Module: SmartSection
* Author: The SmartFactory <www.smartfactory.ca>
* Licence: GNU
*/

function smartsection_upload_file($another = false) 
{	
	include_once(SMARTSECTION_ROOT_PATH . "class/uploader.php");
	
	global $smartsection_isAdmin, $xoopsModuleConfig, $smartsection_item_handler, $smartsection_file_handler, $xoopsUser;
	
	$itemid = isset($_POST['itemid']) ? intval($_POST['itemid']) : 0;
	$uid = is_object($xoopsUser) ? $xoopsUser->uid() : 0;
	$session = SmartsectionSession::singleton();
	$session->set('smartsection_file_filename', $_POST['name']);
	$session->set('smartsection_file_description', $_POST['description']);
	$session->set('smartsection_file_status', $_POST['status']);
	$session->set('smartsection_file_uid', $uid);
	$session->set('smartsection_file_itemid', $itemid);	
	
	$itemObj = $smartsection_item_handler->get($itemid);
	
	$max_size = $xoopsModuleConfig['maximum_filesize']; 
	$max_imgwidth = $xoopsModuleConfig['maximum_image_width']; 
	$max_imgheight = $xoopsModuleConfig['maximum_image_height']; 
	
	$fileObj = $smartsection_file_handler->create();
	$fileObj->setVar('name', $_POST['name']);
	$fileObj->setVar('description', $_POST['description']);
	$fileObj->setVar('status', intval($_POST['status']));
	$fileObj->setVar('uid', $uid);
	$fileObj->setVar('itemid', $itemid);  

    // Get available mimetypes for file uploading
/*    $hMime =& xoops_getmodulehandler('mimetype');
    if ($smartsection_isAdmin) {
        $crit = new Criteria('mime_admin', 1);
    } else {
        $crit = new Criteria('mime_user', 1);
    }
    $mimetypes =& $hMime->getObjects($crit);
    // TODO : display the available mimetypes to the user
	*/
    if($xoopsModuleConfig['allowupload'] && is_uploaded_file($_FILES['userfile']['tmp_name'])){
        if (!$ret = $fileObj->checkUpload('userfile', $allowed_mimetypes, $errors)) {
            $errorstxt = implode('<br />', $errors);
            
            $message = sprintf(_SMARTSECTION_MESSAGE_FILE_ERROR, $errorstxt);
            redirect_header("addfile.php?op=mod&itemid=" . $itemid, 5, $message);
        }
    }
    
	// Storing the file
	If ( !$fileObj->store($allowed_mimetypes) ) {
		redirect_header("addfile.php?op=mod&itemid=" . $fileObj->itemid(), 3, _MD_SSECTION_FILEUPLOAD_ERROR . smartsection_formatErrors($fileObj->getErrors()));
		exit;
	}

	$redirect_page = $another ? 'addfile.php' : 'item.php';
	redirect_header($redirect_page . "?op=mod&itemid=" . $fileObj->itemid(), 2, _MD_SSECTION_FILEUPLOAD_SUCCESS);			
}

include_once("header.php");

Global $xoopsUser, $xoopsModuleConfig, $xoopsModule, $smartsection_item_handler, $smartsection_file_handler;

// If the user is not admin AND we don't allow user submission, exit
if (!($smartsection_isAdmin || 
	(isset($xoopsModuleConfig['allowsubmit']) && $xoopsModuleConfig['allowsubmit'] == 1 && (is_object($xoopsUser) || (isset($xoopsModuleConfig['anonpost']) && $xoopsModuleConfig['anonpost'] == 1))))
	) {
	redirect_header("index.php", 1, _NOPERM);
	exit();
}

$op = '';

if (isset($_GET['op'])) $op = $_GET['op'];
if (isset($_POST['op'])) $op = $_POST['op'];

$itemid = isset($_GET['itemid']) ? intval($_GET['itemid']) : 0;
$itemid = isset($_POST['itemid']) ? intval($_POST['itemid']) : $itemid;

If ($itemid == 0) {
	redirect_header("index.php", 2, _MD_SSECTION_NOITEMSELECTED);
	exit();
} else {
	$itemObj =& new SmartsectionItem($itemid);	
}

switch ($op) {
	case "uploadfile";
	smartsection_upload_file();	
	exit;
	break;
	
	case "uploadanother";
	smartsection_upload_file(true);	
	exit;
	break;	
	
	case 'form':
	default:
	
	$xoopsOption['template_main'] = 'smartsection_addfile.html';
	include_once(XOOPS_ROOT_PATH . "/header.php");
	include_once("footer.php");	
		
	$name = ($xoopsUser) ? (ucwords($xoopsUser->getVar("uname"))) : 'Anonymous';
	
	$xoopsTpl->assign('module_home', smartsection_module_home());
	
	$xoopsTpl->assign('categoryPath', _MD_SSECTION_ADD_FILE);
	$xoopsTpl->assign('lang_intro_title', sprintf(_MD_SSECTION_ADD_FILE_TITLE, $smartsection_moduleName));
	$xoopsTpl->assign('lang_intro_text',  _MD_SSECTION_GOODDAY . "<b>$name</b>, " . sprintf(_MD_SSECTION_ADD_FILE_INTRO, $itemObj->title()));
	
	include_once 'include/fileform.inc.php';
	
	include_once XOOPS_ROOT_PATH . '/footer.php';
	break;
}

?>