<?php

/**
* $Id: category.php,v 1.39 2005/11/30 21:45:56 malanciault Exp $
* Module: SmartSection
* Author: The SmartFactory <www.smartfactory.ca>
* Licence: GNU
*/

include_once("header.php");

global $smartsection_category_handler, $smartsection_item_handler;

$categoryid = isset($_GET['categoryid']) ? intval($_GET['categoryid']) : 0;

// Creating the category object for the selected category
$categoryObj = $smartsection_category_handler->get($categoryid);

// If the selected category was not found, exit
If ($categoryObj->notLoaded()) {
    redirect_header("javascript:history.go(-1)", 1, _MD_SSECTION_NOCATEGORYSELECTED);
    exit();
}

// Check user permissions to access this category
if (!$categoryObj->checkPermission()) {
    redirect_header("javascript:history.go(-1)", 1, _NOPERM);
    exit;
}

$item_page_id = isset($_GET['page']) ? intval($_GET['page']) : -1;

$totalItems = $smartsection_category_handler->publishedItemsCount();

// If there is no Item under this categories or the sub-categories, exit
If (!isset($totalItems[$categoryid]) || $totalItems[$categoryid] == 0) {
    //redirect_header("index.php", 1, _MD_SSECTION_MAINNOFAQS);
    //exit;
}
$xoopsOption['template_main'] = 'smartsection_category.html';
include_once(XOOPS_ROOT_PATH . "/header.php");
include_once("footer.php");


$gperm_handler = &xoops_gethandler('groupperm');
$hModule = &xoops_gethandler('module');
$module = &$hModule->getByDirname('smartsection');
$module_id = $module->getVar('mid');

// At which record shall we start
$start = isset($_GET['start']) ? intval($_GET['start']) : 0;

// creating the Item objects that belong to the selected category
switch ($xoopsModuleConfig['orderby']) {
	case 'title' :
    	$sort = 'title';
    	$order = 'ASC';	
	break;
	
	case 'date' :
    	$sort = 'datesub';
    	$order = 'DESC';
	break;
	
	default :
    	$sort = 'weight';
    	$order = 'ASC';	
	break;
}

$itemsObj = $smartsection_item_handler->getAllPublished($xoopsModuleConfig['indexperpage'], $start, $categoryid, $sort, $order);

If ($itemsObj) {
    $totalItemOnPage = count($itemsObj);
} else {
    $totalItemOnPage = 0;
}

// Arrays that will hold the informations passed on to smarty variables
$category = array();
$items = array();

// Populating the smarty variables with informations related to the selected category
$category = $categoryObj->toArray(null, true);
$category['categoryPath'] = $categoryObj->getCategoryPath($xoopsModuleConfig['linkedPath']);

//$totalItems = $smartsection_category_handler->publishedItemsCount($xoopsModuleConfig['displaylastitem']);

if ($xoopsModuleConfig['displaylastitem'] == 1) {
	// Get the last smartitem
	$last_itemObj = $smartsection_item_handler->getLastPublishedByCat();
}
$lastitemsize = intval($xoopsModuleConfig['lastitemsize']);

// Creating the sub-categories objects that belong to the selected category
$subcatsObj = $smartsection_category_handler->getCategories(0, 0, $categoryid);
$total_subcats = count($subcatsObj);

//$totalItems = array();
$total_items = 0;
/*If ($total_subcats != 0) {
    $subcat_keys = array_keys($subcatsObj);
    foreach ( $subcat_keys as $i) {
        $subcat_id = $subcatsObj[$i]->getVar('categoryid');
            
        If (isset($totalItems[$subcat_id]) && $totalItems[$subcat_id] > 0 ) {
            if (isset($last_itemObj[$subcat_id])) {
             	$subcatsObj[$i]->setVar('last_itemid', $last_itemObj[$subcat_id]->getVar('itemid'));
                $subcatsObj[$i]->setVar('last_title_link', "<a href='item.php?itemid=" . $last_itemObj[$subcat_id]->getVar('itemid') . "'>" . $last_itemObj[$subcat_id]->title() . "</a>");
            }
        }
           // if(isset($subcatid)){
            	$subcatsObj[$i]->setVar('itemcount', $totalItems[$subcat_id]);
            	$subcats[$subcat_id] = $subcatsObj[$i]->toArray();
           		$total_items += $totalItems[$subcat_id];
            //}
      //}replac  la ligne 95
    }
        if (isset($subcats)) {
    	$xoopsTpl->assign('subcats', $subcats);
    }
}
/*--------------------*/
	if ($xoopsModuleConfig['show_subcats'] != 'no' ) {
		// If this category has subcats
		if (isset($subcatsObj)) {
			foreach ($subcatsObj as $key => $subcat) {
				// Get the items count of this very category
				$subcat_total_items = isset($totalItems[$key]) ? $totalItems[$key] : 0;
				// Do we display empty sub-cats ?
				if (($subcat_total_items > 0) || ($xoopsModuleConfig['show_subcats'] == 'all' )) {
					$subcat_id = $subcat->getVar('categoryid');
					// If we retreived the last item object for this category
					if (isset($last_itemObj[$subcat_id])) {
						$subcat->setVar('last_itemid', $last_itemObj[$subcat_id]->itemid());
						$subcat->setVar('last_title_link', $last_itemObj[$key]->getItemLink(false, $lastitemsize));
					}
						
					$numItems= isset($totalItems[$subcat_id])? $totalItems[$key] :0;
					$subcat->setVar('itemcount', $numItems);
					// Put this subcat in the smarty variable
					$categories[$key] = $subcat->toArray();
					//$total += $numItems;					
				}
			}
		}
	}
	        if (isset($categories)) {
    	$xoopsTpl->assign('subcats', $categories);
	        }

/*--------------------*/

$thiscategory_itemcount = isset($totalItems[$categoryid]) ? $totalItems[$categoryid] : 0;
$category['total'] = $thiscategory_itemcount;
if (count($itemsObj)>0) {
    $userids = array();
    if($itemsObj){
	    foreach ($itemsObj as $key => $thisitem) {
	        $itemids[] = $thisitem->getVar('itemid');
	        $userids[$thisitem->uid()] = 1;
	    }
    }
    $member_handler = &xoops_gethandler('member');
    $users = $member_handler->getUsers(new Criteria('uid', "(".implode(',', array_keys($userids)).")", "IN"), true);
    // Adding the items of the selected category
    
    for ( $i = 0; $i < $totalItemOnPage; $i++ ) {
		$item = $itemsObj[$i]->toArray();
		$item['categoryname'] = $categoryObj->name();
		$item['categorylink'] = "<a href='" . smartsection_seo_genUrl('category', $itemsObj[$i]->categoryid(), $categoryObj->name()) . "'>" . $categoryObj->name() . "</a>";
		$item['who_when'] = $itemsObj[$i]->getWhoAndWhen($users);

        $xoopsTpl->append('items', $item);
    }
    //var_dump( $last_itemObj[$categoryObj->getVar('categoryid')]);
    if (isset($last_itemObj[$categoryObj->getVar('categoryid')]) && $last_itemObj[$categoryObj->getVar('categoryid')]) {
    	$category['last_itemid'] = $last_itemObj[$categoryObj->getVar('categoryid')]->getVar('itemid');
        $category['last_title_link'] = $last_itemObj[$categoryObj->getVar('categoryid')]->getItemLink(false, $lastitemsize);
    }
}

// Language constants

$xoopsTpl->assign(array('lang_on' => _MD_SSECTION_ON, 'lang_postedby' => _MD_SSECTION_POSTEDBY, 'lang_total' => $totalItemOnPage, 'lang_title' => _MD_SSECTION_TITLE, 'lang_datesub' => _MD_SSECTION_DATESUB, 'lang_hits' => _MD_SSECTION_HITS));
$xoopsTpl->assign('sectionname', $myts->displayTarea($xoopsModule->getVar('name')));
$xoopsTpl->assign('whereInSection', $myts->displayTarea($xoopsModule->getVar('name')));
$xoopsTpl->assign('modulename', $xoopsModule->dirname());
$xoopsTpl->assign('lang_category_summary', sprintf(_MD_SSECTION_CATEGORY_SUMMARY,$categoryObj->name()));
$xoopsTpl->assign('lang_category_summary_info', sprintf(_MD_SSECTION_CATEGORY_SUMMARY_INFO,$categoryObj->name()));
$xoopsTpl->assign('lang_items_title', sprintf(_MD_SSECTION_ITEMS_TITLE,$categoryObj->name()));
$xoopsTpl->assign('lang_items_info', _MD_SSECTION_ITEMS_INFO);
$xoopsTpl->assign('module_home', smartsection_module_home($xoopsModuleConfig['linkedPath']));
$xoopsTpl->assign('categoryPath', $category['categoryPath']);
$xoopsTpl->assign('lang_name_column',_MD_SSECTION_NAME);
$xoopsTpl->assign('lang_empty',_MD_SSECTION_EMPTY);
$xoopsTpl->assign('lang_view_more',_MD_SSECTION_VIEW_MORE);
//$xoopsTpl->assign('lang_items_list', _MD_SSECTION_ITEMS_LIST);
//$xoopsTpl->assign('lang_link_xplain', _MD_SSECTION_LINK_XPLAIN);

// The Navigation Bar
include_once XOOPS_ROOT_PATH . '/class/pagenav.php';
$pagenav = new XoopsPageNav($thiscategory_itemcount, $xoopsModuleConfig['indexperpage'], $start, 'start', 'categoryid=' . $categoryObj->getVar('categoryid'));
If ($xoopsModuleConfig['useimagenavpage'] == 1) {
    $category['navbar'] = '<div style="text-align:right;">' . $pagenav->renderImageNav() . '</div>';
} else {
    $category['navbar'] = '<div style="text-align:right;">' . $pagenav->renderNav() . '</div>';
}
$xoopsTpl->assign('category', $category);

// MetaTag Generator
smartsection_createMetaTags($categoryObj->name(), '', $categoryObj->description());

//code to include smartie
if (file_exists(XOOPS_ROOT_PATH . '/modules/smarttie/smarttie_links.php')) {
	include_once XOOPS_ROOT_PATH . '/modules/smarttie/smarttie_links.php';
		$xoopsTpl->assign('smarttie',1);
}
//end code for smarttie

// RSS Link
if($xoopsModuleConfig['show_rss_link'] == 1){
	$link=sprintf("<a href='%s' title='%s'><img src='%s' border=0 alt='%s'></a>",XOOPS_URL."/modules/smartsection/backend.php?categoryid=".$categoryid, _MD_SSECTION_RSSFEED, XOOPS_URL."/modules/smartsection/images/rss.gif",_MD_SSECTION_RSSFEED);
	$xoopsTpl->assign('rssfeed_link',$link);
}

include_once(XOOPS_ROOT_PATH . "/footer.php");

?>