<?php

class Xoops_UserDB extends Abstract_UserDB {

	var $xoopsMHandler;

	function Xoops_UserDB() 
	{
		$this->nobody    = new NobodyUser();
		$this->everybody = new EverybodyUser();
		$this->loggedIn  = new LoggedInUser();
		$this->xoopsMHandler =& xoops_gethandler('member');
	}


	function getUidList()
	{
		$uidList = array_keys($this->xoopsMHandler->getUserList());
		array_push($uidList, $this->nobody->getUid());
		array_push($uidList, $this->everybody->getUid());
		array_push($uidList, $this->loggedIn->getUid());

		sort($uidList);
		return $uidList;
	}


	function getUserByUsername($username, $level=0)
	{
		if (!strcmp($username, $this->nobody->getUsername())) {
			return $this->nobody;
		} elseif (!strcmp($username, $this->everybody->getUsername())) {
			return $this->everybody;
		} elseif (!strcmp($username, $this->loggedIn->getUsername())) {
			return $this->loggedIn;
		}

		$user = new Xoops_User();
		$user->loadByUsername($username);

		return $user;
	}


	function getUserByUid($uid) 
	{
		if (!$uid || !strcmp($uid, $this->nobody->getUid())) {
			return $this->nobody;
		} elseif ( !strcmp($uid, $this->everybody->getUid()) ) {
			return $this->everybody;
		} elseif ( !strcmp($uid, $this->loggedIn->getUid()) ) {
			return $this->loggedIn;
		}

		$user = new Xoops_User();
		$user->loadByUid($uid);

		return $user;
	}

}
?>