<?php
// $Id: category_manage.php,v 1.9 2006/09/30 03:15:20 ohwada Exp $

// 2006-09-20 K.OHWADA
// use happy_linux
// use XoopsGTicket

// 2006-09-18 K.OHWADA
// support xoops protector

// 2006-05-15 K.OHWADA
// new handler
// add class admin_category_manage
// use token ticket

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// admin category manage
// 2004/01/14 K.OHWADA
//=========================================================

include 'admin_header.php';

//=========================================================
// class admin_category_manage
//=========================================================
class admin_category_manage extends happy_linux_manage
{
// class
	var $_link_edit_handler;
	var $_link_handler;
	var $_catlink_handler;

	var $_strings;

	var $_cat_obj;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_category_manage()
{
	$this->happy_linux_manage( WEBLINKS_DIRNAME );

	$this->set_handler( 'category', WEBLINKS_DIRNAME, 'weblinks' );
	$this->set_id_name( 'cid' );
	$this->set_form_class( 'admin_form_category' );
	$this->set_script(   'category_manage.php' );
	$this->set_redirect( 'category_list.php', 'category_list.php?sortid=1' );
	$this->set_title( _AM_WEBLINKS_ADD_CATEGORY, _WLS_MODCAT, _WLS_DELCAT );
	$this->set_err_no_record( _WEBLINKS_NO_CATEGORY );
	$this->set_module_dirname( 'weblinks' );

	$this->_link_edit_handler =& weblinks_get_handler('link_edit', WEBLINKS_DIRNAME);
	$this->_link_handler      =& weblinks_get_handler('link',      WEBLINKS_DIRNAME);
	$this->_catlink_handler   =& weblinks_get_handler('catlink',   WEBLINKS_DIRNAME);

	$this->_strings  =& happy_linux_strings::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_category_manage();
	}

	return $instance;
}


//---------------------------------------------------------
// POST param
//---------------------------------------------------------
function get_post_op()
{
	$op = 'main';
	if     ( isset($_POST['del_cat']) )    $op = 'del_cat';
	elseif ( isset($_POST['delete']) )     $op = 'del_cat';
	elseif ( isset($_POST['op']) )         $op = $_POST['op'];
	elseif ( isset($_GET['op']) )          $op = $_GET['op'];
	return $op;
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_handler->load();
}

//---------------------------------------------------------
// main_add_form()
//---------------------------------------------------------
function add_form()
{
	$this->_main_add_form();
}

function _print_add_form()
{
	$obj =& $this->_handler->create();
	$obj->set('lflag', 1);
	$this->_form->_show_add($obj);
	return true;
}

//---------------------------------------------------------
// main_add_table()
//---------------------------------------------------------
function add_table()
{
	$this->_main_add_table( true );
}

function _check_add_table()
{
	$this->_clear_errors();

// support xoops protector
	if ( !$this->_post->is_post_set('pid') )
	{
		$this->_set_errors( _WLS_ERROR_CATEGORY );
	}

	$this->_check_fill_by_post('title',  _WLS_TITLEC);
	$this->_check_url_by_post( 'imgurl', _WEBLINKS_IMGURL_MAIN, false);

	return $this->returnExistError();
}

function _exec_add_table()
{
	$title = $this->_post->get_post_text('title');

	$obj =& $this->_handler->create();
	$obj->set_vars_by_post();

	$newid = $this->_handler->insert($obj);
	if ( !$newid )
	{
		$this->_set_errors( $this->_handler->getErrors() );
		return false;
	}

	$tags = array();
	$tags['CATEGORY_NAME'] = $title;
	$tags['CATEGORY_URL'] = WEBLINKS_URL.'/viewcat.php?cid='.$newid;
	$notification_handler =& xoops_gethandler('notification');
	$notification_handler->triggerEvent('global', 0, 'new_category', $tags);

	return true;
}

//---------------------------------------------------------
// main_mod_form()
//---------------------------------------------------------
function mod_form()
{
	$this->_main_mod_form();
}

//---------------------------------------------------------
// main_mod_table()
//---------------------------------------------------------
function mod_table()
{
	$this->_main_mod_table();
}

function _check_mod_table()
{
	return $this->_check_add_table();
}

//---------------------------------------------------------
// main_del_table()
//---------------------------------------------------------
function del_cat()
{
	if ( !$this->_get_obj() )
	{
		redirect_header( 'category_list.php', 3, _WEBLINKS_NO_CATEGORY );
		exit();
	}

	if ( !$this->_check_token() )
	{
		redirect_header( $this->_build_script_mod_form(), 3, "Token Error");
		exit();
	}

	$cid = $this->_post->get_post_int('cid');
	$ok  = $this->_post->get_post_int('ok');

	$this->_print_cp_header();
	$this->_print_bread_op( _WLS_DELCAT );
	$this->_print_title(    _WLS_DELCAT );

	$MAX_SUBCAT_DEL  = 4;
	$MAX_LINK_BELONG = 10;
	$MAX_LINK_DEL    = 10;

    if ( $ok == 1 ) 
	{
		echo "<h3>"._WLS_DELCAT."</h3>\n";
	}
	else
	{
		echo "<h3 style='color: #0000ff'>"._WLS_WARNING."</h3>\n";
	}

// The specified category
	echo "<h4>"._WLS_CATEGORY."</h4>\n";

	$title_s = $this->_obj->getVar('title', 's');
	echo "$cid: $title_s <br />\n";

// sub categories
	echo "<h4>"._WLS_SUBCATEGORY."</h4>\n";

	$sub_arr   = $this->_handler->getAllChildId($cid);

	$sub_count = count($sub_arr);
	if ($sub_count > 0)
	{
		foreach ($sub_arr as $sub) 
		{
			$obj2 = $this->_handler->get($sub);
			$title_s = $obj2->getVar('title', 's');
			echo "$sub: $title_s <br />\n";
		}
	}
	else
	{
		echo _WLS_SUBCATEGORY_NON."<br />\n";
	}

// limit over
	if ($sub_count > $MAX_SUBCAT_DEL)
	{
		echo "<br />\n";
		echo $this->_form->build_html_highlight( _WLS_ERROR_MAX_SUBCAT );
		echo " ($MAX_SUBCAT_DEL) <br />\n";
		echo "<hr />\n";
		$this->_print_cp_footer_with_goto_list();
		exit();
	}

// all link belonging to this category
	echo "<h4>"._WLS_LINK_BELONG."</h4>\n";

	$cid_arr    = array_merge( array($cid), $sub_arr );
	$lid_arr    = $this->_catlink_handler->get_lid_array_by_cid_array($cid_arr);
	$cid_count  = count($cid_arr);
	$link_count = count($lid_arr);
	$link_del_count = 0;

	if ($link_count > 0)
	{
		echo _WLS_LINK_BELONG_NUMBER.": ".count($lid_arr)."<br />\n";
		echo "<h4>"._WLS_LINK_MAYBE_DELETE."</h4>\n";

		if ($cid_count > 0)
		{
			echo _WLS_LINK_MAYBE_DELETE_DSC."<br /><br />\n";
		}

		foreach ($lid_arr as $lid)
		{

// get the number of the categories belonging to this link 
			$num = $this->_catlink_handler->get_count_by_lid($lid);

// the link belongs only to this category
			if ($num == 1)
			{
				$link_obj = $this->_link_handler->get($lid);

				if ( is_object($link_obj) )
				{
					$link_title_s = $link_obj->getVar('title', 's');
					echo "link: $lid: $link_title_s <br />\n";
				}
				else
				{
					$msg = "link not exist lid = $lid";
					$this->print_error($msg);
				}

				$link_del_count ++;
			}
		}

		if ($link_del_count == 0)
		{
			$this->print_warnig( _WLS_LINK_DELETE_NON );
		}
	}
	else
	{
		echo _WLS_LINK_BELONG_NON."<br />\n";
	}

// limit over
	if ($link_del_count > $MAX_LINK_DEL)
	{
		echo "<br />\n";
		echo $this->_form->build_html_highlight( _WLS_ERROR_MAX_LINK_DEL );
		echo " ($MAX_LINK_DEL) <br />\n";
		echo "<hr />\n";
		$this->_print_cp_footer_with_goto_list();
		exit();
	}

// limit over
	if ($link_count > $MAX_LINK_BELONG)
	{
		echo "<br />\n";
		echo $this->_form->build_html_highlight( _WLS_ERROR_MAX_LINK_BELONG );
		echo " ($MAX_LINK_BELONG) <br />\n";
		echo "<hr />\n";
		$this->_print_cp_footer_with_goto_list();
		exit();
	}

// excute
    if ( $ok == 1 ) 
    {
		echo "<br /><hr />\n";
		echo "<h4>"._WLS_CATEGORY_LINK_DELETE_EXCUTE."</h4>\n";

		$flag_error = false;

// sub category
		foreach ($sub_arr as $sub) 
		{
			$ret = $this->_exec_del_cat( $sub );
			if ( !$ret )
			{	$flag_error = true;	}
		}

		$ret = $this->_exec_del_cat($cid);
		if ( !$ret )
		{	$flag_error = true;	}

		echo "<h4>"._WLS_CATEGORY_LINK_DELETED."</h4>\n";

		if ($flag_error)
		{
			$this->print_error( _AM_WEBLINKS_ERROR_SOME );
		}

		echo "<hr />\n";
		$this->_print_cp_footer_with_goto_list();
		return;
	}

// confirm
	else 
	{
		$this->_form->del_cat_ok($cid);
		xoops_cp_footer();
 		return;
    }

	xoops_cp_footer();	// dummy
}

function _exec_del_cat($cid)
{
	$flag_error = false;

	$mid = $this->_system->get_mid();

// get the link id is belonging to this category 
	$lid_arr = $this->_catlink_handler->get_lid_array_by_cid($cid);

	foreach ($lid_arr as $lid)
	{

// get the number of the categories belonging to this link 
		$num = $this->_catlink_handler->get_count_by_lid($lid);

// delete this link, if it belongs only to this category
		if ($num == 1)
		{
			$link_obj = $this->_link_handler->get($lid);

			if ( is_object($link_obj) )
			{
				$title_s = $link_obj->getVar('title', 's');
				echo "$lid: $title_s <br />\n";
			}
			else
			{
				$flag_error = true;
				$msg = "link not exist lid = $lid ";
				$this->print_error($msg);
			}

// BUG 3095: the number of links does not change, if delete link
			$ret = $this->_link_edit_handler->del_link_vote_comm_by_lid($lid);
			if (!$ret)
			{
				$flag_error = true;
				$msg = $this->_link_edit_handler->getErrors(1);
				$this->print_error($msg);
			}
		}
	}

// delete category
	$obj = $this->_handler->get($cid);

	if ( is_object($obj) )
	{
		$title_s = $obj->getVar('title', 's');
		echo _WLS_CATEGORY_DELETED.": $cid: $title_s <br />\n";

		$ret = $this->_handler->delete($obj);
		if (!$ret)
		{
			$flag_error = true;
			$msg = $this->_handler->getErrors(1);
			$this->print_error($msg);
		}
	}
	else
	{
		$flag_error = true;
		$msg = "category not exist cid = $cid ";
		$this->print_error($msg);
	}

// delete comments & notifications
	xoops_notification_deletebyitem( $mid, 'category', $cid );

	if ( $flag_error ) { return false; }
	return true;
}

function _print_cp_footer_with_goto_list()
{
		echo "<br />\n";
		echo '- <a href="category_list.php">'._WEBLINKS_ADMIN_CATEGORY_LIST."</a><br />\n";
		xoops_cp_footer();
}

//---------------------------------------------------------
// reorder_cat
//---------------------------------------------------------
function reorder_cat()
{
	$pid = $this->_post->get_post_get_int('pid');
	$url = 'category_list.php?sortid=3&amp;pid='.$pid;

	if( !( $this->_check_token() ) ) 
	{
		redirect_header( $url, 3, "Token Error");
		exit();
	}

	if ( $this->_exec_reorder_cat() )
	{
		redirect_header( $url, 1, _WEBLINKS_ORDERS_UPDATED);
		exit();
	}

	xoops_cp_header();
	$this->_print_bread_op( _WLS_DELCAT );
	$this->_print_title(    _WLS_DELCAT );
	xoops_error("DB Error");
	echo $this->getErrors(1);
	xoops_cp_footer();
}

function _exec_reorder_cat()
{
	$this->_clear_errors();

	$order_arr = $this->_post->get_post('orders');

	foreach ($order_arr as $key => $value)
	{
		$cid    = intval($key);
		$orders = intval($value);
		$obj =& $this->_handler->get($cid);

		if ( is_object($obj) )
		{
			$obj->setVar('orders', $orders);

			$ret = $this->_handler->update($obj);
			if (!$ret)
			{
				$this->_set_error( $this->_handler->getErrors(1) );
			}
		}
		else
		{
			$msg = "category not exist cid = $cid ";
			$this->_set_error($msg);
		}
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// form test
//---------------------------------------------------------
function test()
{
	$arr = array(
    	'cid'    => 0,
    	'title'  => 'TEST',
    	'lflag'  => 1,
    	'orders' => 0,
    	'pid'    => 0,
    	'imgurl' => 'http://TEST/',
	);

	xoops_cp_header();
	$obj =& $this->_handler->create();
	$obj->assignVars($arr);
	$this->_form->_show_add_preview($obj);
	xoops_cp_footer();
}

//---------------------------------------------------------
// private print
//---------------------------------------------------------
function _print_menu()
{
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
}

// --- class end ---
}

//=========================================================
// class admin_form_category
//=========================================================
class admin_form_category extends happy_linux_form
{
	var $_handler;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_form_category()
{
	$this->happy_linux_form();

	$this->_handler  =& weblinks_get_handler('category',  WEBLINKS_DIRNAME);
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_form_category();
	}

	return $instance;
}

//---------------------------------------------------------
// show category
//---------------------------------------------------------
function _show(&$obj, $extra=null, $show_mode=0 )
{
	switch ($show_mode) 
	{
		case HAPPY_LINUX_MODE_MOD:
		case HAPPY_LINUX_MODE_MOD_PREVIEW:
			$show_mode  = HAPPY_LINUX_MODE_MOD;
			$form_title = _WLS_MODCAT;
			$op         = 'mod_table';
			$button_val = _MODIFY;
			break;

		case HAPPY_LINUX_MODE_ADD:
		case HAPPY_LINUX_MODE_ADD_PREVIEW:
		default:
			$form_title = _AM_WEBLINKS_ADD_CATEGORY;
			$op         = 'add_table';
			$button_val = _ADD;
			break;
	}

	$this->set_obj($obj);

	$cid    = $obj->getVar('cid', 'e');
	$selbox = $this->_handler->build_selbox( $obj->get('pid'), 1, 'pid', '', 'TOP', 0 );

	echo $this->build_form_begin( 'modCat' );
	echo $this->build_token();
	echo $this->build_html_input_hidden('op',  $op);
	echo $this->build_html_input_hidden('cid', $cid);
	echo $this->build_form_table_begin();
	echo $this->build_form_table_title( $form_title );

	if ( $show_mode == HAPPY_LINUX_MODE_MOD )
	{
		echo $this->build_form_table_line( _WLS_CATEGORYID, '<b>'.$cid.'</b>');
	}

	echo $this->build_obj_table_text( _WLS_TITLEC, 'title' );
	echo $this->_build_cat_lflag(  $obj->getVar('lflag',  'e') );
	echo $this->build_obj_table_text( _WEBLINKS_CAT_ORDER, 'orders' );
	echo $this->build_form_table_line(_WLS_PARENT, $selbox);
	echo $this->_build_cat_imgurl( $obj->getVar('imgurl', 'e'), 1 );

	$button = $this->build_html_input_submit('post', $button_val);
	if ( $show_mode == HAPPY_LINUX_MODE_MOD )
	{
		$button .= ' '.$this->build_html_input_submit('delete', _DELETE);
		$button .= ' '.$this->build_html_input_button_cancel('cancel', _CANCEL);
	}
	echo $this->build_form_table_line('', $button, 'foot', 'foot');

	echo $this->build_form_table_end();
	echo $this->build_form_end();

}

function del_cat()
{
	$this->_handler->get_tree_array(0);
	$category = $this->_handler->build_selbox(0, 0, 'cid');

	$builder = new weblinks_form_extend();
	$builder->start_theme_form( _WLS_DELCAT, 'delCat' );
	$builder->add_hidden('op', 'delCat');
	$builder->add_label( _WLS_CATEGORY, $category );
	$builder->add_submit_button( '', 'post', _DELETE );
	$builder->display();

}

function del_cat_ok($cid)
{
	echo $this->build_form_begin( 'delCat' );
	echo $this->build_token();
	echo $this->build_html_input_hidden('op',  'delCat');
	echo $this->build_html_input_hidden('ok',  1);
	echo $this->build_html_input_hidden('cid', $cid);
	echo $this->build_form_table_begin();
	echo $this->build_form_table_title(  _WLS_DELCAT );

	$button  = $this->build_html_input_submit('post', _DELETE);
	$button .= ' '.$this->build_html_input_button_cancel('cancel', _CANCEL);
	echo $this->build_form_table_line('', $button, 'foot', 'foot');

	echo $this->build_form_table_end();
	echo $this->build_form_end();
}

function _build_cat_lflag( $value=1 )
{
	$opt = array(
		_WLS_NOTLINKFLAG => 0,
		_WLS_LINKFLAG    => 1,
		);

	$ele = $this->build_form_table_radio_select('', 'lflag', $value, $opt);
	return $ele;
}

function _build_cat_imgurl( $value='', $flag=0 )
{
	$imgurl_desc = _WEBLINKS_IMGURL_MAIN_DSC1;

	if ($flag)
	{
		$imgurl_desc .= "<br />\n"._WEBLINKS_IMGURL_MAIN_DSC2;
	}

	if ( empty($value) )
	{
		$value = 'http://';
	}

	$imgurl_cap  = $this->build_form_caption( _WEBLINKS_IMGURL_MAIN, $imgurl_desc );
	$imgurl_text = $this->build_html_input_text('imgurl', $value, 100, 255);

	$text  = $this->build_html_tr_tag_begin('left', 'top');
	$text .= $this->build_html_td_tag_begin('left', '', 2, '', 'head');
	$text .= $this->substute_blank($imgurl_cap);
	$text .= $this->build_html_td_tag_end();
	$text .= $this->build_html_tr_tag_end();
	$text .= $this->build_html_td_tag_begin('left', '', 2, '', 'odd');
	$text .= $this->substute_blank($imgurl_text);
	$text .= $this->build_html_td_tag_end();
	$text .= $this->build_html_tr_tag_end();

	return $text;
}

// --- class end ---
}

//=========================================================
// main
//=========================================================
$manage =& admin_category_manage::getInstance();

$manage->init();
$op = $manage->get_post_op();

switch ($op) 
{
case 'addCat':
case 'add_table':
	$manage->add_table();
	break;

case 'modCat':
case 'mod_form':
	$manage->mod_form();
	break;

case 'modCatS':
case 'mod_table':
	$manage->mod_table();
	break;

case 'delCat':
case 'delete':
case 'del_cat':
	$manage->del_cat();
	break;

case 'reorderCat':
case 'reorder_cat':
	$manage->reorder_cat();
	break;

case 'test':
	$manage->test();
	break;

case 'main':
case 'add_form':
default:
	$manage->add_form();
	break;
}

exit();
// --- end of main ---

?>