<?php
// $Id: gen_record_class.php,v 1.1 2006/09/30 03:15:21 ohwada Exp $

//================================================================
// WebLinks Module
// 2006-09-20 K.OHWADA
//================================================================

//=========================================================
// class gen_record
//=========================================================
class gen_record extends happy_linux_basic_handler
{
	var $_system;

	var $_mid;

	var $_xoopscomments_table;
	var $_com_id_arr     = array();
	var $_com_itemid_arr = array();

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function gen_record()
{
	$this->happy_linux_basic_handler( WEBLINKS_DIRNAME );
	$this->set_debug_db_sql(   true );
	$this->set_debug_db_error( true );

	$this->_system =& happy_linux_system::getInstance();
	$this->_mid = $this->_system->get_mid();

	$this->_xoopscomments_table = $this->db_prefix("xoopscomments");
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new gen_record();
	}
	return $instance;
}

//---------------------------------------------------------
// category table
//---------------------------------------------------------
// --- category table ---
//  cid int(5)
//  pid int(5)
//  title varchar(50)
//  imgurl varchar(150)

function gen_category($MAX_CAT, $MAX_PARENT=0)
{
	echo "<h4>generete category table</h4>\n";

	if ($MAX_CAT == 0)
	{
		echo "skip <br />\n";
		return;
	}

	srand( (double)microtime()*1000000 );
	$imgurl_dir = XOOPS_URL."/modules/".WEBLINKS_DIRNAME."/images/category/";

// contant
	$pid = 0;

	for ($i=0; $i<$MAX_PARENT; $i++)
	{
// randum data
		$title  = "main_". $this->get_randum_title();
		$imgurl = $this->get_randum_category_image();

// ctegory table
		$this->insert_category($pid, $title, $imgurl);
	}

	echo "<br />\n";

// contant
	$imgurl = '';

	for ($i=0; $i<($MAX_CAT - $MAX_PARENT); $i++)
	{
// randum data
		$title  = "sub_". $this->get_randum_title();

		$max_pid = intval( ($MAX_PARENT + $i) / 2 );
		$pid     = rand(1, $max_pid);

// ctegory table
		$this->insert_category($pid, $title, $imgurl);
	}
}

function insert_category($pid, $title, $imgurl)
{
	$lflag  = 1;	// allow link 
	$orders = rand(1, 10);

	$cflag = 0;
	$tflag = 0;
	$displayimg     = '';
	$description    = '';
	$catdescription = '';
	$catfooter      = '';
	$groupid        = '';
	$editaccess     = '';

// table name
	$category_table = $this->prefix("category");

// category table
	$sql  = 'INSERT INTO '.$category_table.' (';
	$sql .= 'pid, ';
	$sql .= 'title, ';
	$sql .= 'imgurl, ';
	$sql .= 'cflag, ';
	$sql .= 'lflag, ';
	$sql .= 'tflag, ';
	$sql .= 'displayimg, ';
	$sql .= 'description, ';
	$sql .= 'catdescription, ';
	$sql .= 'catfooter, ';
	$sql .= 'groupid, ';
	$sql .= 'orders, ';
	$sql .= 'editaccess ';
	$sql .= ') VALUES (';
	$sql .= intval($pid).', ';
	$sql .= $this->quote($title).', ';
	$sql .= $this->quote($imgurl).', ';
	$sql .= intval($cflag).', ';
	$sql .= intval($lflag).', ';
	$sql .= intval($tflag).', ';
	$sql .= intval($displayimg).', ';
	$sql .= $this->quote($description).', ';
	$sql .= $this->quote($catdescription).', ';
	$sql .= $this->quote($catfooter).', ';
	$sql .= $this->quote($groupid).', ';
	$sql .= intval($orders).', ';
	$sql .= $this->quote($editaccess).' ';
	$sql .= ')';

	$this->query($sql);
}

//---------------------------------------------------------
// link table
//---------------------------------------------------------
// --- link table ---
//  lid int(11)
//  uid int(11)
//  title varchar(100)
//  url   varchar(250)
//  time_create int(10)
//  time_update int(10)
//  hits int(11)
//  rating double(6,4)
//  votes int(11)
//  comments int(11)
//  width  int(5)
//  height int(5)

// --- catlink table ---
//  jid int(11)
//  cid int(4)
//  lid int(11)

function gen_link($MAX_LINK, $MAX_CAT=0)
{
	echo "<h4>generete link table</h4>\n";

	if ($MAX_LINK == 0)
	{
		echo "skip <br />\n";
		return;
	}

	srand( (double)microtime()*1000000 );

	for ($i=0; $i<$MAX_LINK; $i++)
	{
		$newid = $this->insert_link();

		$catnum = rand(1,3);
		for ($j=0; $j<$catnum; $j++)
		{
			$cid = rand(1, $MAX_CAT);
			$this->insert_catlink($cid, $newid);
		}
	}
}

function insert_link($title='', $rss_flag=0, $rss_url='')
{
	if ( $title == '' )
	{
		$title = $this->get_randum_title();
	}

	$hits      = rand(0, 100);
	$title     = $this->get_randum_title();
	$banner    = $this->get_randum_banner( 5 );
	$passwd    = $this->get_randum_passwd_md5();
	$recommend = $this->get_randum_mark();
	$mutual    = $this->get_randum_mark();

	list($time_create, $time_update) = $this->get_randum_create_time();

	$description = "$title\n $time_create\n";

// no url per 10
	$url = "http://$title/";
	if (( $rss_flag == 0 ) && ( rand(0, 9) == 0 ))
	{
		$url = '';
	}

// name
	$name     = '';
	$mail     = '';
	$nameflag = 0;
	$mailflag = 0;

	$uid = rand(0, 10);
	if ($uid)
	{
		$user =& $this->_system->get_user_by_uid($uid);
		$name = $user['uname'];
		$mail = $user['email'];
		$nameflag = rand(0, 1);
		$mailflag = rand(0, 1);
	}

// broken per 10
	$broken = 0;
	if ( rand(0, 9) == 0 )
	{
		$broken = rand(1, 10);
	}

// figures image
	$width    = 20;
	$height   = 27;

	$cids     = '';
	$company  = '';
	$addr     = '';
	$tel      = '';
	$admincomment = '';
	$mark        = 0;
	$rating      = 0;
	$votes       = 0;
	$comments    = 0;
	$rss_xml     = '';
	$rss_update  = 0;
	$usercomment = '';
	$zip      = '';
	$state    = '';
	$city     = '';
	$addr2    = '';
	$fax      = '';
	$dohtml   = 0;
	$dosmiley = 1;
	$doxcode  = 1;
	$doimage  = 1;
	$dobr     = 1;
	$etc1 = '';
	$etc2 = '';
	$etc3 = '';
	$etc4 = '';
	$etc5 = '';
	$rssc_lid   = '';
	$aux_int_1  = 0;
	$aux_int_2  = 0;
	$aux_text_1 = '';
	$aux_text_2 = '';

	$search = "$title $url $description";

// insert
	$link_table = $this->prefix("link");

	$sql  = 'INSERT INTO '.$link_table.' (';
	$sql .= 'uid, ';
	$sql .= 'cids, ';
	$sql .= 'title, ';
	$sql .= 'url, ';
	$sql .= 'banner, ';
	$sql .= 'description, ';
	$sql .= 'name, ';
	$sql .= 'nameflag, ';
	$sql .= 'mail, ';
	$sql .= 'mailflag, ';
	$sql .= 'company, ';
	$sql .= 'addr, ';
	$sql .= 'tel, ';
	$sql .= 'search, ';
	$sql .= 'passwd, ';
	$sql .= 'admincomment, ';
	$sql .= 'mark, ';
	$sql .= 'time_create, ';
	$sql .= 'time_update, ';
	$sql .= 'hits, ';
	$sql .= 'rating, ';
	$sql .= 'votes, ';
	$sql .= 'comments, ';
	$sql .= 'width, ';
	$sql .= 'height, ';
	$sql .= 'recommend, ';
	$sql .= 'mutual, ';
	$sql .= 'broken, ';
	$sql .= 'rss_url, ';
	$sql .= 'rss_flag, ';
	$sql .= 'rss_xml, ';
	$sql .= 'rss_update, ';
	$sql .= 'usercomment, ';
	$sql .= 'zip, ';
	$sql .= 'state, ';
	$sql .= 'city, ';
	$sql .= 'addr2, ';
	$sql .= 'fax, ';
	$sql .= 'dohtml, ';
	$sql .= 'dosmiley, ';
	$sql .= 'doxcode, ';
	$sql .= 'doimage, ';
	$sql .= 'dobr, ';
	$sql .= 'etc1, ';
	$sql .= 'etc2, ';
	$sql .= 'etc3, ';
	$sql .= 'etc4, ';
	$sql .= 'etc5, ';
	$sql .= 'rssc_lid, ';
	$sql .= 'aux_int_1, ';
	$sql .= 'aux_int_2, ';
	$sql .= 'aux_text_1, ';
	$sql .= 'aux_text_2 ';
	$sql .= ') VALUES (';
	$sql .= intval($uid).', ';
	$sql .= $this->quote($cids).', ';
	$sql .= $this->quote($title).', ';
	$sql .= $this->quote($url).', ';
	$sql .= $this->quote($banner).', ';
	$sql .= $this->quote($description).', ';
	$sql .= $this->quote($name).', ';
	$sql .= intval($nameflag).', ';
	$sql .= $this->quote($mail).', ';
	$sql .= intval($mailflag).', ';
	$sql .= $this->quote($company).', ';
	$sql .= $this->quote($addr).', ';
	$sql .= $this->quote($tel).', ';
	$sql .= $this->quote($search).', ';
	$sql .= $this->quote($passwd).', ';
	$sql .= $this->quote($admincomment).', ';
	$sql .= $this->quote($mark).', ';
	$sql .= intval($time_create).', ';
	$sql .= intval($time_update).', ';
	$sql .= intval($hits).', ';
	$sql .= floatval($rating).', ';
	$sql .= intval($votes).', ';
	$sql .= intval($comments).', ';
	$sql .= intval($width).', ';
	$sql .= intval($height).', ';
	$sql .= intval($recommend).', ';
	$sql .= intval($mutual).', ';
	$sql .= intval($broken).', ';
	$sql .= $this->quote($rss_url).', ';
	$sql .= intval($rss_flag).', ';
	$sql .= intval($rss_xml).', ';
	$sql .= intval($rss_update).', ';
	$sql .= $this->quote($usercomment).', ';
	$sql .= $this->quote($zip).', ';
	$sql .= $this->quote($state).', ';
	$sql .= $this->quote($city).',';
	$sql .= $this->quote($addr2).', ';
	$sql .= $this->quote($fax).', ';
	$sql .= intval($dohtml).', ';
	$sql .= intval($dosmiley).', ';
	$sql .= intval($doxcode).', ';
	$sql .= intval($doimage).', ';
	$sql .= intval($dobr).', ';
	$sql .= $this->quote($etc1).', ';
	$sql .= $this->quote($etc2).', ';
	$sql .= $this->quote($etc3).', ';
	$sql .= $this->quote($etc4).', ';
	$sql .= $this->quote($etc5).', ';
	$sql .= intval($rssc_lid).', ';
	$sql .= intval($aux_int_1).', ';
	$sql .= intval($aux_int_2).', ';
	$sql .= $this->quote($aux_text_1).', ';
	$sql .= $this->quote($aux_text_2).' ';
	$sql .= ')';

	$this->query($sql);
	$newid = $this->getInsertId();
	return $newid;
}

function insert_catlink($cid, $lid)
{
	$catlink_table = $this->prefix("catlink");

	$sql  = "INSERT INTO ".$catlink_table." (";
	$sql .= "cid, lid";
	$sql .= ") VALUES (";
	$sql .= "$cid, $lid";
	$sql .= ")";

	$this->query($sql);
}

function get_link($lid)
{
	$link_table = $this->prefix("link");
	$sql = "SELECT * FROM ".$link_table." WHERE lid=".intval($lid);
	$row =& $this->get_row_by_sql($sql);
	return $row;
}

//---------------------------------------------------------
// votedata table
//---------------------------------------------------------
// --- votedata table ---
//  ratingid int(11)
//  lid int(11)
//  ratinguser int(11)
//  rating tinyint(3)
//  ratinghostname varchar(60)
//  ratingtimestamp int(10)

function gen_votedata($MAX_VOTE, $MAX_LINK=0)
{
	echo "<h4>generete votedata table</h4>\n";

	if ($MAX_VOTE == 0)
	{
		echo "skip <br />\n";
		return;
	}

	srand( (double)microtime()*1000000 );

// table name
	$votedata_table = $this->prefix("votedata");
	$link_table     = $this->prefix("link");

	for ($i=0; $i<$MAX_VOTE; $i++)
	{
// randum data
		$lid = rand(1, $MAX_LINK);
		$ratinguser = rand(1, 10);
		$rating     = rand(0, 10);
		$ratinghostname  = $this->get_randum_ip();
		$ratingtimestamp = $this->get_randum_time();

// votedata table
		$sql  = "INSERT INTO $votedata_table ";
		$sql .= "(lid, ratinguser, rating, ratinghostname, ratingtimestamp)";
		$sql .= "VALUES ";
		$sql .= "($lid, $ratinguser, $rating, '$ratinghostname', $ratingtimestamp)";

		$this->query($sql);
	}

	echo "<br />\n";

	$sql2  = "SELECT lid, count(lid) as c, sum(rating) as s FROM $votedata_table GROUP BY lid ";
	$rows2 =& $this->get_rows_by_sql($sql2);

	foreach ( $rows2 as $row2 )
	{
		$lid   = $row2['lid'];
		$count = $row2['c'];
		$sum   = $row2['s'];

		$rating = $sum / $count;

		$sql3 = "UPDATE $link_table SET rating=$rating, votes=$count WHERE lid=$lid";
		$this->query($sql3);
	}
}

//---------------------------------------------------------
// xoopscomments table
//---------------------------------------------------------
// com_id   mediumint(8)
// com_pid  mediumint(8)
// com_rootid  mediumint(8)
// com_modid   smallint(5)
// com_itemid  mediumint(8)
// com_icon    varchar(25)
// com_created  int(10)
// com_modified int(10)
// com_uid    mediumint(8)
// com_ip     varchar(15)
// com_title  varchar(255)
// com_text   text
// com_sig    tinyint(1)
// com_status tinyint(1)
// com_exparams  varchar(255)
// dohtml   tinyint(1)
// dosmiley tinyint(1)
// doxcode  tinyint(1)
// doimage  tinyint(1)
// dobr     tinyint(1)

function gen_comment( $MAX_COM, $MAX_LINK=0 )
{
	echo "<h4>generete xoopscomments table</h4>\n";

	if ($MAX_COM == 0)
	{
		echo "skip <br />\n";
		return;
	}

	srand( (double)microtime()*1000000 );

// table name
	$link_table = $this->prefix("link");

	$this->gen_comment_list( $this->_mid, $MAX_COM, $MAX_LINK );

	echo "<br />\n";

	$rows =& $this->get_comment_rows( $this->_mid );
	foreach ( $rows as $row )
	{
		$itemid = $row['com_itemid'];
		$count  = $row['c'];

		$sql= "UPDATE $link_table SET comments=$count WHERE lid=$itemid";
		$this->query($sql);
	}
}

function gen_comment_list( $mid, $MAX_COM, $MAX_ITEMID )
{
	$this->_com_id_arr     = array();
	$this->_com_itemid_arr = array();

	for ($i=0; $i<$MAX_COM; $i++)
	{
		$this->create_comment( $i, $mid, $MAX_ITEMID );
	}
}

function create_comment( $i, $mid, $MAX_ITEMID )
{

// table name
	$com_table  = $this->db_prefix("xoopscomments");

// constant
	$com_icon = '';
	$com_sig  = 0;
	$dohtml   = 0;
	$dosmiley = 1;
	$doxcode  = 1;
	$doimage  = 1;
	$dobr     = 1;
	$com_status   = 2;
	$com_exparams = '';
	$com_modid    = $mid;

// randum data
	$com_itemid   = rand(1, $MAX_ITEMID);
	$com_uid      = rand(1, 10);
	$com_ip       = $this->get_randum_ip();
	$com_title    = $this->get_randum_title();
	$com_created  = $this->get_randum_time();
	$com_modified = $com_created;

// other
	$com_text  = "$com_title\n $com_created\n";

// xoopscomments table
	$sql  = "INSERT INTO ".$this->_xoopscomments_table." ";
	$sql .= "(com_modid, com_itemid, com_icon, com_created, com_modified, com_uid, com_ip, com_title, com_text, com_sig, com_status, com_exparams, dohtml, dosmiley, doxcode, doimage, dobr)";
	$sql .= "VALUES ";
	$sql .= "($com_modid, $com_itemid, '$com_icon', $com_created, $com_modified, $com_uid, '$com_ip', '$com_title', '$com_text', $com_sig, $com_status, '$com_exparams', $dohtml, $dosmiley, $doxcode, $doimage, $dobr)";
	$this->query($sql);
	$newid = $this->getInsertId();

// pid: 1 per 2
	$com_id     = $newid;
	$com_rootid = $newid;
	$com_pid    = 0;

	if ($i % 2 == 0)
	{
		if ( isset( $this->_com_itemid_arr[$com_itemid] ) )
		{
			$pid_arr = $this->_com_itemid_arr[$com_itemid];
			$count   = count($pid_arr) - 1;

			if ( $count < 0 )
			{
				$count = 0;
			}

			$id = rand(0, $count);

			if ( isset( $pid_arr[$id] ))
			{
				$com_pid    = $pid_arr[$id];
				$com_rootid = $this->_com_id_arr[$com_pid]['com_rootid'];
			}
		}
	}

	$sql2  = "UPDATE ".$this->_xoopscomments_table." SET ";
	$sql2 .= "com_rootid=$com_rootid, ";
	$sql2 .= "com_pid=$com_pid ";
	$sql2 .= "WHERE com_id=$com_id";
	$this->query($sql2);

	$this->_com_id_arr[$com_id]['com_rootid'] = $com_rootid;
	$this->_com_itemid_arr[$com_itemid][]     = $com_id;
}

function &get_comment_rows( $mid )
{
	$sql  = "SELECT com_itemid, count(com_itemid) as c ";
	$sql .= "FROM ".$this->_xoopscomments_table." ";
	$sql .= "WHERE com_modid=".$mid." GROUP BY com_itemid ";
	$rows =& $this->get_rows_by_sql($sql);
	return $rows;
}

//---------------------------------------------------------
// update config
//---------------------------------------------------------
function update_config_by_name_array($name, $value)
{
	$this->update_config_by_name($name, serialize($value) );
}

function update_config_by_name($name, $value)
{
	$config_table = $this->prefix("config2");

	$sql = 'UPDATE '.$config_table.' SET ';
	$sql .= 'conf_value='.$this->quote($value).' ';
	$sql .= 'WHERE conf_name='.$this->quote($name);
	$this->query($sql);
}

//---------------------------------------------------------
// module_handler
//---------------------------------------------------------
function is_exist_module( $dirname )
{
	$module =& $this->_system->get_module_by_dirname( $dirname );
	if ( is_object($module) )
	{
		return true;
	}
	return false;
}

function get_mid_by_dirname( $dirname )
{
	$mid = $this->_system->get_mid_by_dirname( $dirname );
	return $mid;
}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function get_randum_category_image()
{
	$imgurl_dir = XOOPS_URL."/modules/".WEBLINKS_DIRNAME."/images/category";
	$imgurl = $imgurl_dir .'/'. $this->get_randum_image();
	return $imgurl;
}

function get_randum_banner( $num=0 )
{
	$banner_dir = XOOPS_URL."/modules/".WEBLINKS_DIRNAME."/images/link";
	$banner = '';

// once at $num times
	if (( $num == 0 )||( rand(0, $num) == 0 ))
	{
		$banner = $banner_dir .'/'. $this->get_randum_image();
	}

	return $banner;
}

function get_randum_image()
{
	$image = sprintf( "%01d", rand(0, 9) ) . ".gif";
	return $image;
}

function get_randum_create_time()
{
	$time  = time();
	$rand1 = rand(0, 365*24*60*60);	// 1 year
	$rand2 = rand(0, intval( $rand1/2 ) );
	$time_create = $time - $rand1;
	$time_update = $time - $rand2;

	return array($time_create, $time_update);
}

function get_randum_mark()
{
	$mark = 0;
// once at 10 times
	if ( rand(0, 9) == 9 )
	{
		$mark = 1;
	}
	return $mark;
}

function get_randum_passwd_md5()
{
	return md5( xoops_makepass() );
}

function get_randum_title()
{
	$title = $this->get_randum_char() . $this->get_randum_number_06();
	return $title;
}

function get_randum_char()
{
	return chr( rand(97,122) );
}

function get_randum_number_04()
{
	return sprintf( "%04d", rand(0,9999) );
}

function get_randum_number_06()
{
	return sprintf( "%06d", rand(0,999999) );
}

function get_randum_time()
{
	$time = time() - rand(0, 365*24*60*60);	// 1 year
	return $time;
}

function get_randum_ip()
{
	$ip = "192.168.1." . rand(1,255);
	return $ip;
}

// --- class end ---
}

?>