<?php
// $Id: test_form_class.php,v 1.1 2006/09/30 03:15:21 ohwada Exp $

//=========================================================
// WebLinks Module
// 2006-09-20 K.OHWADA
//=========================================================

//=========================================================
// class test_form
//=========================================================
class test_form extends gen_record
{
	var $_ADMIN_UNAME = 'admin';
	var $_ADMIN_PASS  = 'admin';
	var $_USER_UNAME  = 'bob';
	var $_USER_PASS   = 'bob';

	var $_MAX_CAT = 10;

// figures image
	var $_WIDTH  = 20;
	var $_HEIGHT = 27;

	var $_snoopy;
	var $_system;

	var $_user_submit_url;
	var $_user_modify_url;
	var $_admin_link_url;

	var $_flag_print_body = true;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function test_form()
{
	$this->gen_record();

	$this->_snoopy   =& new Snoopy();
	$this->_system   =& happy_linux_system::getInstance();

	$this->_user_submit_url = WEBLINKS_URL.'/submit.php';
	$this->_user_modify_url = WEBLINKS_URL.'/modlink.php';
	$this->_admin_link_url  = WEBLINKS_URL.'/admin/link_manage.php';
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new test_form();
	}
	return $instance;
}

//---------------------------------------------------------
// login
//---------------------------------------------------------
function admin_login()
{
	$ret = $this->login($this->_ADMIN_UNAME, $this->_ADMIN_PASS);
	return $ret;
}

function user_login()
{
	$ret = $this->login($this->_USER_UNAME, $this->_USER_PASS);
	return $ret;
}

function login($uname, $pass)
{
	$url = XOOPS_URL.'/user.php';

	$form = array(
		'uname' => $uname,
		'pass'  => $pass,
		'op'    => 'login',
	);

	$ret = $this->_snoopy->submit($url, $form);
	if ( !$ret )
	{
		echo "Error: cannnot connect login form: $url <br />\n";
		$this->print_body();
		return false;
	}

	$ret = $this->get_cookies();
	return $ret;
}

function get_cookies()
{
	$this->_snoopy->setcookies();
	$cookies = $this->_snoopy->cookies;
	if ( !is_array($cookies) || (count($cookies) == 0) )
	{
		echo "Error: login failed: cannot get cookie <br />\n";
		$this->print_body();
		return false;
	}
	return $cookies;
}

//---------------------------------------------------------
// fetch_form
//---------------------------------------------------------
function fetch($url)
{
	$ret = $this->_snoopy->fetch($url);
	if ( !$ret )
	{
		echo "Error: cannnot fetch : $url <br />\n";
		$this->print_body();
		return false;
	}
	return true;
}

function fetch_form($url)
{
	$ret = $this->_snoopy->fetchform($url);
	if ( !$ret )
	{
		echo "Error: cannnot fetch form: $url <br />\n";
		$this->print_body();
		return false;
	}
	return true;
}

//---------------------------------------------------------
// get ticket
// < input type="hidden" name="XOOPS_G_TICKET" value="e1c3d9c1ece8114441b7ac68e90e429b" />
//---------------------------------------------------------
function get_ticket( $result=null )
{
	$val = $this->get_hidden_value( 'XOOPS_G_TICKET', $result );
	if ( !$val )
	{
		echo "Error: cannot get ticket <br />\n";
		$this->print_body();
		return false;
	}
	return $val;
}

//---------------------------------------------------------
// get_hidden_value
// < input type="hidden" name="lid" id="lid" value="155" />
//---------------------------------------------------------
function get_hidden_value( $name, $result=null )
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	$pattern = '<\/?input[\s+]type="hidden"[\s+]name="'.$name.'".*value="(\w+)"[\s+]/>';
	$pattern = "'$pattern'Usi";

	preg_match($pattern, $result, $match);

//print_r($match);
//echo "<br>\n";

	if ( isset($match[1]) && $match[1] )
	{
		$val = $match[1];
		return $val;
	}

	return false;
}

//---------------------------------------------------------
// submit_form
//---------------------------------------------------------
function submit_form($url, $form)
{
	$this->_snoopy->referer = $url;

	$ret = $this->_snoopy->submit($url, $form);
	if ( !$ret )
	{
		echo "Error: cannnot submit form: $url <br />\n";
		$this->print_body();
		return false;
	}
	return true;
}

//---------------------------------------------------------
// get_results
//---------------------------------------------------------
function get_results()
{
	return $this->_snoopy->results;
}

function get_body( $result=null )
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	$str = eregi_replace("^.*<body[^>]*>", "", $result);
	$str = eregi_replace("</body>.*$",     "", $str);
	return $str;
}

function print_body( $flag_print=false, $result=null )
{
	if ( $flag_print || $this->_flag_print_body )
	{
		echo "<hr />\n";
		echo $this->get_body( $result );
		echo "<hr />\n";
	}
}

function match_result($str, $result=null)
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	if ( preg_match( "/".$str."/", $result ) )
	{
		return true;
	}
	return false;
}

function match_return_msg($str, $result=null)
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	preg_match( "/<!-- weblinks : (.*?) -->/", $result, $match );

	if ( isset($match[1]) && ( $match[1] == $str ) )
	{
		return true;
	}
	return false;
}

//---------------------------------------------------------
// set param
//---------------------------------------------------------
function set_admin_uname_pass( $uname, $pass )
{
	$this->_ADMIN_UNAME = $uname;
	$this->_ADMIN_PASS  = $pass;
}

function set_user_uname_pass( $uname, $pass )
{
	$this->_USER_UNAME = $uanme;
	$this->_USER_PASS  = $pass;
}

function get_admin_uname()
{
	return $this->_ADMIN_UNAME;
}

function get_user_uname()
{
	return $this->_USER_UNAME;
}

//---------------------------------------------------------
// user submit
//---------------------------------------------------------
function user_submit_link( $title )
{
	$banner   = $this->get_randum_banner( 0 );
	$rss_url  = WEBLINKS_URL.'/dev/rss_2.xml';
	$rss_flag = 2;	// rss

	$ret = $this->fetch_form($this->_user_submit_url);
	if ( !$ret )
	{
		return false;
	}

	$form = $this->build_link_form($this->_USER_UNAME, $title, $banner, $rss_flag, $rss_url);

	$ret = $this->submit_form($this->_user_submit_url, $form);
	if ( !$ret )
	{
		return false;
	}

	return true;
}

//---------------------------------------------------------
// user modify
//---------------------------------------------------------
function user_modify_link( $lid, $title )
{
	$banner   = $this->get_randum_banner( 0 );
	$rss_url  = WEBLINKS_URL.'/dev/rss_3.xml';
	$rss_flag = 2;	// rss

	$link_form_url = $this->_user_modify_url.'?lid='.$lid;
	$ret = $this->fetch_form($link_form_url);
	if ( !$ret )
	{
		return false;
	}

//	$this->print_body( true );

	$form = $this->build_link_form($this->_USER_UNAME, $title, $banner, $rss_flag, $rss_url, $lid);

	$ret = $this->submit_form($this->_user_modify_url, $form);
	if ( !$ret )
	{
		return false;
	}

	return true;
}

function is_link_owner($lid, $uname=null)
{
	$link_uid = 0;
	$row =& $this->get_link($lid);
	if ( is_array($row) && isset($row['uid']) )
	{
		$link_uid = $row['uid'];
	}

	if ( empty($uname) )
	{
		$uname = $this->_USER_UNAME;
	}

	$user =& $this->_system->get_user_by_uname( $uname );
	$uname_uid = $user['uid'];

	if ( $link_uid && ( $link_uid == $uname_uid ) )
	{
		return true;
	}
	return false;
}

//---------------------------------------------------------
// admin add link
//---------------------------------------------------------
function admin_add_link_add_link($title, $banner='', $rss_flag=0, $rss_url='')
{
	$ret = $this->fetch_form($this->_admin_link_url);
	if ( !$ret )
	{
		return false;
	}

	$form = $this->build_link_form($this->_ADMIN_UNAME, $title, $banner, $rss_flag, $rss_url);

	$ret = $this->submit_form($this->_admin_link_url, $form);
	if ( !$ret )
	{
		return false;
	}

	return true;
}

function build_link_form($name, $title, $banner='', $rss_flag=0, $rss_url='', $lid=0)
{

// user submit
	$submit  = 'submit';
	$request = 1;

// admin add link
	$op           = 'add_table';
	$admincomment = '';

// common
	$ticket = $this->get_ticket();

	$user =& $this->_system->get_user_by_uname($name);
	$uid  = $user['uid'];
	$mail = $user['email'];

	$passwd    = xoops_makepass();
	$recommend = 1;
	$mutual    = 1;
	$url         = "http://$title/";
	$description = "$title\n $passwd\n";

	$number  = $this->get_randum_number_06();
	$company = 'company_'. $number;
	$state   = 'state_'.   $number;
	$city    = 'city_'.    $number;
	$addr    = 'addr_'.    $number; 
	$addr2   = 'addr2_'.   $number;
	$zip     = 'zip_'.     $number;
	$tel     = 'tel_'.     $number;
	$fax     = 'fax_'.     $number; 

	$cid_arr = array();
	for ($j=0; $j<3; $j++)
	{
		$cid_arr[] = rand(1, $this->_MAX_CAT);
	}

	$form = array(

// user submit
    	'submit'  => $submit,
		'request' => $request,

// admin add link
    	'op'           => 'add_table',
    	'admincomment' => '',

// common
    	'XOOPS_G_TICKET' => $ticket,
    	'lid'    => $lid,
    	'title'  => $title,
    	'uid'    => $uid,
    	'url'    => $url,
    	'cid'    => $cid_arr,
    	'description_text' => $description,
    	'dohtml'    => 0,
    	'dosmiley'  => 1,
    	'doxcode'   => 1,
    	'doimage'   => 1,
    	'dobr'      => 1,
    	'recommend' => $recommend,
		'mutual'    => $mutual,
    	'banner'    => $banner,
    	'rss_url'   => $rss_url,
    	'rss_flag'  => $rss_flag,
    	'name'      => $name,
    	'nameflag'  => 1,
    	'mail'      => $mail,
    	'mailflag'  => 1,
    	'company'   => $company,
    	'zip'       => $zip,
    	'state'     => $state,
    	'city'      => $city,
    	'addr'      => $addr,
    	'addr2'     => $addr2,
    	'tel'       => $tel,
    	'fax'       => $fax,
    	'etc1'      => '',
    	'etc2'      => '',
    	'etc3'      => '',
    	'etc4'      => '',
    	'etc5'      => '',
    	'passwd_new'   => $passwd,
    	'passwd_2'     => $passwd,
    	'usercomment'  => '',
	);

	return $form;
}

function admin_add_link_add_banner($title, $banner='', $rss_flag=0, $rss_url='')
{
	$url    = "http://$title/";
	$width  = $this->_WIDTH;
	$height = $this->_HEIGHT;

	$ticket = $this->get_ticket();
	$lid    = $this->get_hidden_value( 'lid' );
	if ( !$lid )
	{
		echo "Error: cannot get lid <br />\n";
		echo $this->get_body() ."<br /><br />\n";
		return false;
	}

	$link_form = array(
   		'XOOPS_G_TICKET' => $ticket,
    	'op'       => 'add_banner',
    	'op_mode'  => 'add_banner',
    	'lid'      => $lid,
    	'title'    => $title,
    	'url'      => $url,
     	'banner'   => $banner,
    	'rss_url'  => $rss_url,
    	'rss_flag' => $rss_flag,
    	'width'    => $width,
		'height'   => $height,
	);

	$ret = $this->submit_form($this->_admin_link_url, $link_form);
	if ( !$ret )
	{
		return false;
	}

	return true;
}

function admin_add_link_add_rssc($title, $rss_flag=0, $rss_url='', $rssc_lid=0)
{
	$url      = "http://$title/";
	$rdf_url  = '';
	$atom_url = '';

	$ticket   = $this->get_ticket();
	$link_lid = $this->get_hidden_value( 'link_lid' );
	if ( !$link_lid )
	{
		echo "Error: cannot get lid <br />\n";
		echo $this->get_body() ."<br /><br />\n";
		return false;
	}

	$link_form_rssc = array(
		'XOOPS_G_TICKET' => $ticket,
		'op'           => 'add_rssc',
		'op_mode'      => 'add_link',
		'link_lid'     => $link_lid,
		'rssc_lid'     => $rssc_lid,
		'title'        => $title,
		'url'          => $url,
		'rdf_url'      => $rdf_url,
		'atom_url'     => $atom_url,
		'rss_url'      => $rss_url,
		'show_rss_url' => $rss_url,
		'rss_flag'     => $rss_flag,
	);

	$ret = $this->submit_form($this->_admin_link_url, $link_form_rssc);
	if ( !$ret )
	{
		return false;
	}

	$ticket   = $this->get_ticket();
	$rssc_lid = $this->get_hidden_value( 'rssc_lid' );
	if ( !$rssc_lid )
	{
		echo "Error: cannot get rssc_lid <br />\n";
		echo $this->get_body() ."<br /><br />\n";
		return false;
	}

	$link_form_refresh = array(
		'XOOPS_G_TICKET' => $ticket,
		'op'           => 'refresh_link',
		'op_mode'      => 'add_link',
		'rssc_lid'     => $rssc_lid,
	);

	$ret = $this->submit_form($this->_admin_link_url, $link_form_refresh);
	if ( !$ret )
	{
		return false;
	}

	return true;
}

//---------------------------------------------------------
// system
//---------------------------------------------------------
function &get_user_param()
{
	$ret =& $this->_system->get_user_param();
}

// --- class end ---
}

?>