<?php
// $Id: weblinks_category_handler.php,v 1.6 2006/10/14 13:45:12 ohwada Exp $

// 2006-10-14 K.OHWADA
// add get_parent_and_all_child_id()

// 2006-09-20 K.OHWADA
// use happy_linux
// add build_cat_path() get_cache_var_title()

// 2006-08-07 K.OHWADA
// bug: category is html sanitized twice in edit form

// 2006-05-15 K.OHWADA
// new handler
// not use weblinks_module_base
// NOT use another class

// 2006-05-12 K.OHWADA
// BUG 3922: Fatal error when use category image

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_category 
//   weblinks_category_handler
// 2004/01/14 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_category_handler') ) 
{

//=========================================================
// class weblinks_category
//=========================================================
class weblinks_category extends happy_linux_object
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_category()
{
	$this->happy_linux_object();

	$this->initVar('cid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('pid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('title',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('imgurl', XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('cflag',      XOBJ_DTYPE_INT, 0, false);
	$this->initVar('lflag',      XOBJ_DTYPE_INT, 0, false);
	$this->initVar('tflag',      XOBJ_DTYPE_INT, 0);
	$this->initVar('displayimg', XOBJ_DTYPE_INT, 0);
	$this->initVar('description',    XOBJ_DTYPE_TXTAREA);
	$this->initVar('catdescription', XOBJ_DTYPE_TXTAREA);
	$this->initVar('catfooter',      XOBJ_DTYPE_TXTAREA);
	$this->initVar('groupid',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('orders',      XOBJ_DTYPE_INT,   0);
	$this->initVar('editaccess',  XOBJ_DTYPE_TXTBOX, null, false, 255);
}

//---------------------------------------------------------
// set var
//---------------------------------------------------------
function set_vars_by_post()
{
	$this->setVars( $_POST );
	$this->set_pid_by_post();
}

function set_pid_by_post()
{
	if ( isset($_POST['pid']) )
	{
		$this->setVar('pid', intval($_POST['pid']) );
	}
	elseif ( isset($_POST['cid']) )
	{
		$this->setVar('pid', intval($_POST['cid']) );
	}
}

// --- class end ---
}

//=========================================================
// class table_category
//=========================================================
class weblinks_category_handler extends happy_linux_object_handler
{
// class
	var $_tree;

// config
	var $_conf_cat_sel;

// cache
	var $_cached_objs     = array();
	var $_tree_array      = array();
	var $_tree_info_array = array();

	var $_total_count = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_category_handler( $dirname )
{
	$this->happy_linux_object_handler( $dirname, 'category', 'cid', 'weblinks_category' );

	$this->set_debug_db_sql(   WEBLINKS_DEBUG_CATEGORY_SQL );
	$this->set_debug_db_error( WEBLINKS_DEBUG_ERROR );

	$this->_tree = new XoopsTree($this->_table, "cid", "pid");

	$config_basic_handler =& weblinks_get_handler( 'config2_basic', $dirname );
	$conf = $config_basic_handler->get_conf();
	$this->_conf_cat_sel = $conf['cat_sel'];

}

//---------------------------------------------------------
// basic function
// $flag_cid : for import from mylinks
//---------------------------------------------------------
function _build_insert_sql(&$obj, $flag_cid=false)
{
	foreach ($obj->gets() as $k => $v) 
	{	${$k} = $v;	}

	$sql  = 'INSERT INTO '.$this->_table.' (';

	if ( $flag_cid )
	{
		$sql .= 'cid, ';
	}

	$sql .= 'pid, ';
	$sql .= 'title, ';
	$sql .= 'imgurl, ';
	$sql .= 'cflag, ';
	$sql .= 'lflag, ';
	$sql .= 'tflag, ';
	$sql .= 'displayimg, ';
	$sql .= 'description, ';
	$sql .= 'catdescription, ';
	$sql .= 'catfooter, ';
	$sql .= 'groupid, ';
	$sql .= 'orders, ';
	$sql .= 'editaccess ';
	$sql .= ') VALUES (';

	if ( $flag_cid )
	{
		$sql .= intval($cid).', ';
	}

	$sql .= intval($pid).', ';
	$sql .= $this->quote($title).', ';
	$sql .= $this->quote($imgurl).', ';
	$sql .= intval($cflag).', ';
	$sql .= intval($lflag).', ';
	$sql .= intval($tflag).', ';
	$sql .= intval($displayimg).', ';
	$sql .= $this->quote($description).', ';
	$sql .= $this->quote($catdescription).', ';
	$sql .= $this->quote($catfooter).', ';
	$sql .= $this->quote($groupid).', ';
	$sql .= intval($orders).', ';
	$sql .= $this->quote($editaccess).' ';
	$sql .= ')';

	return $sql;
}

function _build_update_sql(&$obj)
{
	foreach ($obj->gets() as $k => $v) 
	{	${$k} = $v;	}

	$sql  = 'UPDATE '.$this->_table.' SET ';
	$sql .= 'pid='.intval($pid).', ';
	$sql .= 'title='.$this->quote($title).', ';
	$sql .= 'imgurl='.$this->quote($imgurl).', ';
	$sql .= 'cflag='.intval($cflag).', ';
	$sql .= 'lflag='.intval($lflag).', ';
	$sql .= 'tflag='.intval($tflag).', ';
	$sql .= 'displayimg='.intval($displayimg).', ';
	$sql .= 'description='.$this->quote($description).', ';
	$sql .= 'catdescription='.$this->quote($catdescription).', ';
	$sql .= 'catfooter='.$this->quote($catfooter).', ';
	$sql .= 'groupid='.$this->quote($groupid).', ';
	$sql .= 'orders='.intval($orders).', ';
	$sql .= 'editaccess='.$this->quote($editaccess).' ';
	$sql .= 'WHERE cid='.intval($cid);

	return $sql;
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function load()
{
	static $flag_init_load;

	if ( !isset($flag_init_load) ) 
	{
		$flag_init_load = 1;
		$this->_total_count = $this->getCount();
		$this->_load_cache();
		$this->get_tree_array();
	}
}

function _load_cache()
{
	$objs =& $this->getObjects();
	$this->_cached_objs = array();

	foreach ($objs as $obj) 
	{
		$cid = $obj->get('cid');
		$this->_cached_objs[$cid] = $obj;
	}
}

//---------------------------------------------------------
// get count
//---------------------------------------------------------
function get_count_all()
{
	$count = $this->getCount();
	$this->_total_count = $count;
	return $count;
}

function get_count_by_pid($pid)
{
	$pid = intval($pid);
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('pid', $pid, '=') );
	$count = $this->getCount($criteria);
	return $count;
}

function get_total()
{
	return $this->_total_count;
}

//---------------------------------------------------------
// get objects
//---------------------------------------------------------
function &get_objects_all($limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_desc($limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->setSort( 'cid DESC' );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_by_pid($pid=0, $limit=0, $start=0)
{
	$pid = intval($pid);
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('pid', $pid, '=') );
	$criteria->setSort( 'orders ASC, cid ASC' );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_by_title($title)
{
	$title = addslashes($title);
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('title', $title, '=') );
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_cid_array_by_title($title)
{
	$cid_arr = array();

	$objs =& $this->get_objects_by_title($title);

	if (count($objs) > 0)
	{
		foreach ($objs as $obj)
		{
			$cid_arr[] = $obj->get('cid');
		}
	}

	return $cid_arr;
}

//---------------------------------------------------------
// cache array
//---------------------------------------------------------
function &get_cache($cid)
{
	$cid = intval($cid);

	if ( isset($this->_cached_objs[$cid]) )
	{
		$obj =& $this->_cached_objs[$cid];
	}
	else
	{
		$obj =& $this->get($cid);
		if ( is_object($obj) )
		{
			$this->_cached_objs[$cid] = $obj;
		}
	}

	return $obj;
}

function &get_cache_var_all($cid, $format='n')
{
	$arr =  array();
	$obj =& $this->get_cache($cid);
	if ( is_object($obj) )
	{
		$arr =& $obj->getVarAll($format);
	}

	return $arr;
}

function get_cache_var($cid, $key, $format='n')
{
	$val =  false;
	$obj =& $this->get_cache($cid);
	if ( is_object($obj) )
	{
		$val = $obj->getVar($key, $format);
	}
	return $val;
}

function get_cache_var_title($cid, $format='n')
{
	return $this->get_cache_var($cid, 'title', $format='n');
}

function cache_exists($cid)
{
	if ( isset($this->_cached_objs[$cid]) )
	{
		return true;
	}

	return false;
}

//---------------------------------------------------------
// get category list
//---------------------------------------------------------
function get_cid_array_all($limit=0, $start=0)
{
	$limit   = intval($limit);
	$start   = intval($start);
	$objs    = $this->get_objects_all($limit, $start);
	$cid_arr = $this->_get_cid_array($objs);
	return $cid_arr;
}

function get_cid_array_by_pid($pid=0, $limit=0, $start=0)
{
	$pid     = intval($pid);
	$limit   = intval($limit);
	$start   = intval($start);
	$objs    = $this->get_objects_by_pid($pid, $limit, $start);
	$cid_arr = $this->_get_cid_array($objs);
	return $cid_arr;
}

function _get_cid_array(&$objs)
{
	$cid_arr = array();

	foreach ($objs as $obj)
	{
		if ( is_object($obj) )
		{
			$cid_arr[] = $obj->get('cid');
		}
	}

	return $cid_arr;
}

// Hack by Tom  $chitem
// admin can change the display number of subcategory 
// for viewcat.php
function build_sub_categorys($cid, $chitem=5)
{
	$space   = 0;
	$chcount = 0;
	$subcategories = '';

	$WEBLINKS_URL = XOOPS_URL."/modules/".$this->_DIRNAME;

// bug fix: show all sub categories when $chitem = 0
	if ($chitem > 0) 
	{
		$child_arr = $this->get_cid_array_by_pid($cid);
		foreach($child_arr as $ch_id)
		{
			$chtitle_s = $this->get_cache_var_title($ch_id, 's');

			if ($chcount >= $chitem) 
			{
				$subcategories .= "...";
				break;
			}

			if ($space>0) 
			{
				$subcategories .= ", ";
			}

			$url = $WEBLINKS_URL.'/viewcat.php?cid='.$ch_id;
			$subcategories .= "<a href='$url'>".$chtitle_s."</a>";
			$space++;
			$chcount++;
		}
	}

	return array($space, $chcount, $subcategories);
}

//=========================================================
// category tree
//=========================================================
//---------------------------------------------------------
// get tree
// recursive function
//---------------------------------------------------------
function get_tree_array( $cid=0 )
{
	$this->_tree_array      = array();
	$this->_tree_info_array = array();
	$this->_get_tree_recursive( $cid );
}

function _get_tree_recursive( $pid=0 )
{
	$cid_arr = $this->get_cid_array_by_pid($pid);

	if ( count($cid_arr) == 0 )  return false;

	foreach ($cid_arr as $cid) 
	{
		if ($pid == 0)
		{
			$path  = "$cid";
			$depth =  0;
		}
		else
		{
			$pid_path  = $this->_tree_info_array[$pid]['path'];
			$pid_depth = $this->_tree_info_array[$pid]['depth'];
			$path  = "$pid_path:$cid";
			$depth =  $pid_depth + 1;
		}

		$this->_tree_array[] = $cid;
		$this->_tree_info_array[$cid]['path']  = $path;
		$this->_tree_info_array[$cid]['depth'] = $depth;

		$this->_get_tree_recursive($cid);
	}

	return;
}

//---------------------------------------------------------
// get_tree
//---------------------------------------------------------
function get_tree($limit=0, $start=0)
{
	$limit = intval($limit);
	$start = intval($start);

	if ( ($limit == 0) && ($start == 0) )
	{
		return $this->_tree_array;
	}

	$total = $this->_total_count;
	$end   = $start + $limit;

	if ($start < 0)       return false;
	if ($end   < 0)       return false;
	if ($start > $total)  return false;
	if ($end   > $total)  $end = $total;

	$arr = array();

	for ($i=$start; $i<$end; $i++)
	{
		$arr[] = $this->_tree_array[$i];
	}

	return $arr;
}

function get_tree_info($cid)
{
	if ( isset($this->_tree_info_array[$cid]) )
	{
		$ret = $this->_tree_info_array[$cid];
		return $ret;
	}

	return false;
}

function &get_objects_tree($limit=0, $start=0)
{
	$limit = intval($limit);
	$start = intval($start);

	$cid_arr = $this->get_tree($limit, $start);

	$objs = array();

	foreach ($cid_arr as $cid) 
	{
		$objs[] =& $this->get($cid);
	}

	return $objs;
}

//---------------------------------------------------------
// category path
//---------------------------------------------------------
function build_cat_path($cid, $format='s')
{
	$cid = intval($cid);

	$catpath = '';
	$pid_arr = $this->_get_path_array($cid);

	foreach ($pid_arr as $pid) 
	{
		$title = $this->get_cache_var_title($pid, $format);

		if ($catpath)
		{
			$catpath .= ' : '.$title;
		}
		else
		{
			$catpath .= $title;
		}
	}

	return $catpath;
}

function &get_parent_path($cid)
{
	$cid        = intval($cid);
	$pid_arr    = $this->_get_path_array($cid);
	$path_array = array();

	if ( is_array($pid_arr) )
	{
		foreach ($pid_arr as $pid) 
		{
			$title = $this->get_cache_var_title($pid, 'n');
			$path_array[] = array('cid'=>$pid, 'title'=>$title);
		}
	}

	return $path_array;
}

function _get_path_array($cid)
{
	if ( isset( $this->_tree_info_array[$cid]['path'] ) )
	{
		$ret = split(":", $this->_tree_info_array[$cid]['path'] );
		return $ret;
	}
	return false;
}

function build_parent_path_multi($cid_arr)
{
	$path_array = array();

	if ( count($cid_arr) == 0 )  return $path_array;

	foreach ($cid_arr as $cid)
	{
		$path_array[] = $this->get_parent_path($cid);
	}

	return $path_array;
}

//=========================================================
// selbox
//=========================================================
function show_selbox_multi($cid_arr='')
{
	if ( count($cid_arr) == 0 )  return '';

	$selbox = '';

	foreach ($cid_arr as $cid)
	{
		$title_s = $this->get_cache_var_title($cid, 's');
		$selbox .= $title_s."<br />\n";
	}

	return $selbox;
}

//---------------------------------------------------------
// porting from makeMySelBox of xoopstree.php
// makes a nicely ordered selection box
// $preset_id is used to specify a preselected item
// set $none to 1 to add a option with value 0
//---------------------------------------------------------
function build_selbox($preset_id=0, $none=0, $sel_name='', $onchange='', $none_name='---', $flag=0)
{
	$selbox  = '';
	$selbox .= "<select name='".$sel_name."'";

	if ( $onchange != "" ) 
	{
		$selbox .= " onchange='".$onchange."'";
	}

	$selbox .= ">\n";

	if ( $none ) 
	{
		$selbox .=  "<option value='0'>".$none_name."</option>\n\n";
	}

	foreach ($this->_tree_array as $cid) 
	{
		$lflag = $this->get_cache_var($cid, 'lflag', 'n');

		if (($flag == 1)&&($lflag == 0))  continue;

		$catpath = $this->build_cat_path($cid, 's');

		$sel = '';
		if ( $cid == $preset_id ) 
		{
			$sel = "selected='selected'";
		}

		$selbox .= "<option value='$cid' $sel>$catpath</option>\n";
	}

	$selbox .= "</select>\n";

	return $selbox;
}

function build_selbox_multi( $cid_arr=array() )
{
// show always, if cid array is empty

	if ($cid_arr)
	{
		$cid_count = count($cid_arr);
	}
	else
	{
		$cid_count = 0;
	}

	$catsel_max = $this->_conf_cat_sel;
	if ($catsel_max < $cid_count) { $catsel_max = $cid_count; }

	$selbox = '';

	for($i=0; $i<$catsel_max; $i++)
	{
		$cid = 0;

		if ($i < $cid_count)
		{
			$cid = array_shift($cid_arr); 
		}

		$selbox .= $this->build_selbox( $cid, 1, "cid[]", '', _WLS_NOTSELECT, 1 );
		$selbox .= "<br />\n";
	}

	return $selbox;
}

//=========================================================
// use tree class
//=========================================================
// XoopsTree::getAllChildId is recursible function
function &getAllChildId( $cid, $order="cid" )
{
	$idarray = array();
	$arr     = $this->_tree->getAllChildId($cid, $order, $idarray);
	$arr_out = array_unique($arr);
	return $arr_out;
}

// for admin/category.php
function getPathFromId($cid)
{
	$ret = $this->tree->getPathFromId($cid, "title");
	return $ret;
}

function &get_parent_and_all_child_id( $cid, $order="cid" )
{
	$arr     = $this->getAllChildId( $cid, $order );
	$arr_out = array_unique( array_merge( array($cid), $arr ) );
	return $arr_out;
}

//---------------------------------------------------------
// create & drop table
//---------------------------------------------------------
function create_table()
{
$sql = "
CREATE TABLE ".$this->_table." (
  cid int(5) unsigned NOT NULL auto_increment,
  pid int(5) unsigned NOT NULL default '0',
  title varchar(50) NOT NULL default '',
  imgurl varchar(255) NOT NULL default '',
  cflag tinyint(2) NOT NULL default '0',
  lflag tinyint(2) NOT NULL default '0',
  tflag tinyint(2) NOT NULL default '0',
  displayimg int(10) NOT NULL default '0',
  description text NOT NULL default '',
  catdescription text NOT NULL default '',
  catfooter text NOT NULL default '',
  groupid varchar(255) default NULL,
  orders int(4) NOT NULL default '1',
  editaccess varchar(255) NOT NULL default '1 2 3',
  PRIMARY KEY  (cid),
  KEY pid (pid)
) TYPE=MyISAM
";

	$ret = $this->query($sql);
	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>