<?php
// $Id: weblinks_link_edit_handler.php,v 1.5 2006/10/14 03:01:10 ohwada Exp $

// 2006-10-12 K.OHWADA
// BUG 4318: cannot register bulk links.
// add create_add_link_by_arr()

// 2006-09-20 K.OHWADA
// use happy_linux
// use rssc
// change del_link_vote_comm_by_lid()

// 2006-07-23 K.OHWADA
// BUG 4154: always update time_update in admin mode

// 2006-06-10 K.OHWADA
// BUG 4030: cannot change recommend, mutual

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_edit_handler') ) 
{

//=========================================================
// class weblinks_link_edit_handler
//=========================================================
class weblinks_link_edit_handler extends happy_linux_error
{
	var $_DIRNAME;

	var $_config_handler;
	var $_link_handler;
	var $_category_handler;
	var $_catlink_handler;
	var $_modify_handler;
	var $_votedata_handler;
	var $_broken_handler;
	var $_rssc_handler;

	var $_menu;
	var $_system;
	var $_post;
	var $_form;
	var $_strings;
	var $_remote_image;

	var $_banner_error_code = 0;
	var $_banner_errors     = null;

	var $_newid;
	var $_cid_arr = array();

// cache
	var $_link_obj;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_edit_handler( $dirname )
{
	$this->happy_linux_error();

	$this->_DIRNAME = $dirname;

	$this->_config_handler   =& weblinks_get_handler( 'config2_basic', $dirname );
	$this->_link_handler     =& weblinks_get_handler( 'link',          $dirname );
	$this->_category_handler =& weblinks_get_handler( 'category',      $dirname );
	$this->_catlink_handler  =& weblinks_get_handler( 'catlink',       $dirname );
	$this->_modify_handler   =& weblinks_get_handler( 'modify',        $dirname );
	$this->_votedata_handler =& weblinks_get_handler( 'votedata',      $dirname );
	$this->_broken_handler   =& weblinks_get_handler( 'broken',        $dirname );
	$this->_rssc_handler     =& weblinks_get_handler( 'rssc',          $dirname );

	$this->_menu         =& weblinks_menu::getInstance( $dirname );
	$this->_system       =& happy_linux_system::getInstance();
	$this->_post         =& happy_linux_post::getInstance();
	$this->_form         =& happy_linux_form::getInstance();
	$this->_strings      =& happy_linux_strings::getInstance();
	$this->_remote_image =& happy_linux_remote_image::getInstance();
}

//---------------------------------------------------------
// POST param
//---------------------------------------------------------
function get_post_lid()
{
	$lid = $this->_post->get_post_int('lid');
	return $lid;
}

function get_post_url()
{
	$url = $this->_post->get_post_text('url');
	return $url;
}

function get_post_rssc_lid()
{
	$val = $this->_post->get_post_int('rssc_lid');
	return $val;
}

function get_post_rssc_lid_update()
{
	$val = $this->_post->get_post_int('rssc_lid_update');
	return $val;
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_category_handler->load();
}

function create()
{
	$obj =& $this->_link_handler->create();
	return $obj;
}

function &get($lid)
{
	$lid = intval($lid);
	$obj =& $this->_link_handler->get($lid);
	return $obj;
}

function check_exist_link($lid)
{
	$obj =& $this->get($lid);

	if ( is_object($obj) )
	{
		return true;
	}

	return false;
}

function getCount()
{
	$count = $this->_link_handler->getCount();
	return $count;
}

function insert( &$obj )
{
	$newid = $this->_link_handler->insert( $obj );
	return $newid;
}

//---------------------------------------------------------
// Does the user have authority
//---------------------------------------------------------
function has_auth_submit()
{
	$ret = $this->_menu->show_submit();
	return $ret;
}

function has_auth_submit_auto()
{
	$ret = $this->has_auth( 'auth_submit_auto_arr' );
	return $ret;
}

function has_auth_modify( $rec_uid, $flag_passwd )
{
	list($is_permit, $is_owner, $show_passwd) = 
		$this->has_auth_owner( 'auth_modify_arr', $rec_uid, $flag_passwd );

	if ($flag_passwd && $show_passwd)
	{
		$is_permit = true;
		$is_owner  = true;
	}

	return array($is_permit, $is_owner, $show_passwd);
}

function has_auth_modify_auto( $rec_uid, $flag_passwd )
{
	list($is_permit, $is_owner, $show_passwd) = 
		$this->has_auth_owner( 'auth_modify_auto_arr', $rec_uid, $flag_passwd );
	return $is_permit;
}

function get_config_by_name($name)
{
	$ret = $this->_config_handler->get_cache_by_name($name);
	return $ret;
}

function has_auth( $name )
{
	$ret = $this->_config_handler->has_auth( $name );
	return $ret;
}

function has_auth_owner( $name, $rec_uid, $flag_passwd )
{
	$ret = $this->_config_handler->has_auth_owner( $name, $rec_uid, $flag_passwd );
	return $ret;
}

//---------------------------------------------------------
// add new link
//---------------------------------------------------------
function add_link_by_post( $flag_banner=false )
{
	$newid = $this->add_link_to_link_by_post( $flag_banner );
	if ( !$newid )
	{
		return false;
	}

	$ret = $this->_catlink_handler->add_link_by_lid_cid_array($newid, $this->_cid_arr);
	if ( !$ret )
	{
		$this->_set_errors( $this->_catlink_handler->getErrors() );
		return false;
	}

	return $newid;
}

function add_link_to_link_by_post( $flag_banner=false )
{
// modify
	$this->_mid = $this->_post->get_post_int('mid');

	$obj =& $this->create_add_link_by_arr( $_POST, false, $flag_banner );

	$newid = $this->_link_handler->insert($obj);
	if ( !$newid )
	{
		$this->_set_errors( $this->_link_handler->getErrors() );
		return false;
	}

	return $newid;
}

// bulk manage
function &create_add_link_by_arr( $arr, $not_gpc=false, $flag_banner=false )
{
	$obj =& $this->create();

// desc option
	$obj->set_conf_desc_option( $this->_config_handler->has_auth_desc_option() );

// value
	$obj->assign_vars_post( $arr, $not_gpc );

// time
	$time = time();
	$obj->setVar('time_create', $time);
	$obj->setVar('time_update', $time);

// banner size
	$banner = $obj->get('banner');

	if ( $flag_banner )
	{
		$size =& $this->get_remote_banner_size( $banner );
		if ( is_array($size) && isset($size[0]) && isset($size[1]) )
		{
			$obj->setVar('width',  $size[0] );
			$obj->setVar('height', $size[1] );
		}
	}

// password
	$passwd = $this->get_passwd_md5_new_by_post( true );
	$obj->setVar( 'passwd', $passwd, true );

// cid array
	$this->_cid_arr = $obj->get_cid_array_by_post( $arr );

// search
	$search = $this->build_search( $obj, $this->_cid_arr );
	$obj->setVar( 'search', $search, true );

// BUG 4030: cannot change recommend, mutual
// recommend, mutual
	if( $this->_system->is_module_admin() )
	{
		$obj->set_checkbox( $arr, 'recommend' );
		$obj->set_checkbox( $arr, 'mutual' );
	}

	return $obj;
}

//---------------------------------------------------------
// update banner size
//---------------------------------------------------------
function update_banner_size_for_singlelink($lid)
{
	$obj =& $this->get($lid);
	if ( !is_object($obj) )
	{	return;	}

	$banner = $obj->get('banner');
	$width  = $obj->get('width');
	$height = $obj->get('height');

// read remote file, when not set
	if ( empty($banner) || $width || $height )
	{	return;	}

// read remote file, when not set
	$size =& $this->get_remote_banner_size($banner);
	if ( is_array($size) && isset($size[0]) && isset($size[1]) )
	{
		$this->update_banner_size_to_link($lid, $size[0], $size[1]);
	}
}

function &get_remote_banner_size($banner)
{
	$size = array(0, 0, 0, '');

	if ( empty($banner) )
	{
		return $size;
	}

	$view_obj  =& $this->create_view();
	$image_url =  $view_obj->assume_banner_url($banner);

	$size =& $this->get_remote_image_size($image_url);
	return $size;
}

function &create_view()
{
	$view_obj =& new weblinks_link_view( $this->_DIRNAME );
	return $view_obj;
}

function &create_edit()
{
	$edit_obj =& new weblinks_link_edit( $this->_DIRNAME );
	return $edit_obj;
}

function &get_remote_image_size($url)
{
	$size = array(0, 0, 0, '');

	$this->_banner_error_code = 0;
	$this->_banner_errors     = null;

	if ( empty($url) )
	{
		return $size;
	}

	$size =& $this->_remote_image->get_image_size($url);
	if (!$size)
	{
		$this->_banner_error_code = $this->_remote_image->getErrorCode();
		$this->_banner_errors     = $this->_remote_image->getErrors();
		return $size;
	}

	return $size;
}

function get_banner_error_code()
{
	return $this->_banner_error_code;
}

function get_banner_errors()
{
	return $this->_banner_errors;
}

function update_banner_size_to_link($lid, $width, $height)
{
	$obj =& $this->_link_handler->get($lid);
	if ( !is_object($obj) )
	{	return false;	}

	$obj->setVar('width',  $width);
	$obj->setVar('height', $height);
	$ret = $this->_link_handler->update($obj);
	return $ret;
}

function update_banner_and_size_by_post()
{
	$lid = $this->get_post_lid();

	$obj =& $this->get($lid);
	if ( !is_object($obj) )
	{	return false;	}

	$obj->set_var_key( $_POST, 'banner');
	$obj->set_var_key( $_POST, 'width');
	$obj->set_var_key( $_POST, 'height');

	$ret = $this->_link_handler->update($obj);
	return $ret;
}

//---------------------------------------------------------
// search field
//---------------------------------------------------------
function build_search( &$obj, $cid_arr )
{
	foreach( $obj->gets() as $k => $v)
	{
		${$k} = $v;
	}

	$search  = '';
	$search .= $url.' ';
	$search .= $title.' ';
	$search .= $company.' ';
	$search .= $zip.' ';
	$search .= $state.' ';
	$search .= $city.' ';
	$search .= $addr.' ';
	$search .= $addr2.' ';
	$search .= $tel.' ';
	$search .= $fax.' ';
	$search .= $description.' ';

	if ($nameflag)  { $search .= $name.' '; }
	if ($mailflag)  { $search .= $mail.' '; }

// change a category path
	if ( is_array($cid_arr) )
	{
		foreach ($cid_arr as $cid)
		{
			$path_array = $this->_category_handler->get_parent_path($cid);

			foreach ($path_array as $path)
			{
				$search .= $path['title'].' ';
			}
		}
	}

	$search = preg_replace("/\n|\r/",' ',$search);

	return $search;
}

//---------------------------------------------------------
// passwd field
//---------------------------------------------------------
function get_passwd_md5_new_by_post( $flag=false )
{
	if ( $flag && isset($_POST['passwd_md5']) && $_POST['passwd_md5'] )
	{
		$passwd = $this->_post->get_post_text('passwd_md5');
	}
	elseif ( isset($_POST['passwd_new']) && $_POST['passwd_new'] )
	{
		$passwd = $this->_post->get_post_text('passwd_new');
		$passwd = md5( $passwd );
	}
	else
	{
		$passwd = md5( xoops_makepass() );
	}

	return $passwd;
}

function get_passwd_md5_mod_by_post( $flag=false )
{
	$passwd = '';

	if ( $flag && isset($_POST['passwd_md5']) && $_POST['passwd_md5'] )
	{
		$passwd = $this->_post->get_post_text('passwd_md5');
	}
	elseif ( isset($_POST['passwd_new']) && $_POST['passwd_new'] )
	{
		$passwd = $this->_post->get_post_text('passwd_new');
		$passwd = md5( $passwd );
	}

	return $passwd;
}

//---------------------------------------------------------
// modify link
//---------------------------------------------------------
function mod_link_by_post( $lid, $flag_banner=false )
{
	$this->_clear_errors();

	$this->mod_link_to_link_by_post( $lid, $flag_banner );

	$ret = $this->_catlink_handler->delete_by_lid($lid);
	if (!$ret)
	{
		$this->_set_errors( $this->_catlink_handler->getErrors() );
	}

	$ret = $this->_catlink_handler->add_link_by_lid_cid_array($lid, $this->_cid_arr);
	if (!$ret)
	{
		$this->_set_errors( $this->_catlink_handler->getErrors() );
	}

	return $this->returnExistError();
}

function mod_link_to_link_by_post( $lid, $flag_banner=false )
{
	$obj =& $this->create_mod_link_by_post( $lid, $flag_banner );
	if ( !is_object($obj) )
	{
		$this->_set_errors_not_exist($lid);
		return false;
	}

	$ret = $this->_link_handler->update($obj);
	if (!$ret)
	{
		$this->_set_errors( $this->_link_handler->getErrors() );
		return false;
	}

	return true;
}

function &create_mod_link_by_post( $lid, $flag_banner=false )
{
	$obj =& $this->get($lid);
	if ( !is_object($obj) )
	{
		return false;
	}

// desc option
	$obj->set_conf_desc_option( $this->_config_handler->has_auth_desc_option() );

// value
	$obj->assign_vars_post( $_POST );

//-----
// BUG: always update time_update in admin mode
// TODO: updateflag parameter use in user form
//-----

// time update
	$flag_time_update = false;

// admin mode
	if ( isset($_POST['updateflag']) )
	{
		if ( intval($_POST['updateflag']) == 1 )
		{
			$flag_time_update = true;
		}
	}
// user mode
	else
	{
		$flag_time_update = true;
	}

	if ($flag_time_update)
	{
		$obj->setVar('time_update',  time() );
	}

// banner size
	$banner = $obj->get('banner');

	if ( $flag_banner )
	{
		$size =& $this->get_remote_banner_size( $banner );
		if ( is_array($size) && isset($size[0]) && isset($size[1]) )
		{
			$obj->setVar('width',  $size[0] );
			$obj->setVar('height', $size[1] );
		}
	}

// password
	$passwd = $this->get_passwd_md5_mod_by_post( true );
	if ($passwd)
	{
		$obj->setVar( 'passwd', $passwd, true );
	}

// cid array
	$this->_cid_arr = $obj->get_cid_array_by_post( $_POST );

// search
	$search = $this->build_search( $obj, $this->_cid_arr );
	$obj->setVar('search', $search);

// BUG 4030: cannot change recommend, mutual
// recommend, mutual
	if( $this->_system->is_module_admin() )
	{
		$obj->set_checkbox( $_POST, 'recommend' );
		$obj->set_checkbox( $_POST, 'mutual' );
	}

// rssc lid
	if ( $this->get_post_rssc_lid_update() )
	{
		$obj->setVar('rssc_lid', $this->get_post_rssc_lid() );
	}

	return $obj;
}

//---------------------------------------------------------
// build_submit_preview
//---------------------------------------------------------
function build_submit_preview()
{
	$this->_clear_errors();

	$rss_flag = 0;
	$rss_url  = '';

// create link object
	$obj =& $this->create_add_link_by_arr( $_POST, false, true );

// check url, banner & check rss url
	list($rss_flag, $rss_url) = $this->_check_url_banner_rssurl( $obj );

// create edit object
	$edit_obj =& $this->create_edit();
	$edit_obj->set_object($obj);
	$edit_obj->build_preview_for_template( $this->_cid_arr );

	$edit_obj->set('rss_flag', $rss_flag);
	$edit_obj->set('rss_url',  $this->_strings->sanitize_url($rss_url) );

	$show =& $edit_obj->get_vars();

	return $show;
}

function _check_url_banner_rssurl( &$obj )
{
	$this->_clear_errors();

	$url = $obj->get('url');

// check connect url
	if ( $url )
	{
		if ( !$this->_remote_image->check_url($url) )
	 	{
	 		$this->_set_errors( '<span style="color: #ff0000;">'._WEBLINKS_WARN_NOT_READ_URL."</span>" );
	 	}
	}

// banner error
	if ( $this->_banner_error_code )
	{
 		$this->_set_errors( '<span style="color: #ff0000;">'._WEBLINKS_WARN_BANNER_NOT_GET_SIZE."</span>" );
	}

	$rss_flag = 0;
	$rss_url  = '';

// create rssc object
	$rssc_obj =& $this->_rssc_handler->create_new_rssc_obj();
	if ( is_object($rssc_obj) )
	{
		$code     = $rssc_obj->get('auto_code');
		$rss_flag = $rssc_obj->get('rss_flag');
		$rss_url  = $rssc_obj->get('show_rss_url');

// discover
		switch ( $code )
		{
			case RSSC_CODE_DISCOVER_SUCCEEDED:
				 $this->_set_errors( '<b>'._RSSC_DISCOVER_SUCCEEDED."</b>" );
				break;

			case RSSC_CODE_DISCOVER_FAILED:
				 $this->_set_errors( '<span style="color: #ff0000;">'._RSSC_DISCOVER_FAILED."</span>" );
				break;
		}

// check connect rss url
		if ( $rss_url )
		{
			if ( !$this->_remote_image->check_url($rss_url) )
		 	{
		 		$this->_set_errors( '<span style="color: #ff0000;">'._RSSC_PARSE_NOT_READ_XML_URL."</span>" );
		 	}
		}
	}

	return array($rss_flag, $rss_url);
}

function check_preview_result()
{
	return $this->returnExistError();
}

function get_error_msg_preview( $format='s' )
{
	return $this->getErrors($format);
}


//---------------------------------------------------------
// build_modify_preview
//---------------------------------------------------------
function build_modify_preview( $lid )
{
	$this->_clear_errors();

	$rss_flag = 0;
	$rss_url  = '';

// create link object
	$obj =& $this->create_mod_link_by_post( $lid, true );

// check url, banner & check rss url
	list($rss_flag, $rss_url) = $this->_check_url_banner_rssurl( $obj );

// create edit object
	$edit_obj =& $this->create_edit();
	$edit_obj->set_object($obj);
	$edit_obj->build_preview_for_template( $this->_cid_arr );

	$edit_obj->set('rss_flag', $rss_flag);
	$edit_obj->set('rss_url',  $this->_strings->sanitize_url($rss_url) );

	$show =& $edit_obj->get_vars();

	return $show;
}

//---------------------------------------------------------
// event tags
//---------------------------------------------------------
function build_tags_addlink($newid)
{
	$tags = array();

	$link_obj = $this->get($newid);
	if ( !is_object($link_obj) )
	{
		return array($tags, 0);
	}

	$link_title = $link_obj->get('title');

	if ( !isset( $this->_cid_arr[0] ) )
	{
		return array($tags, 0);
	}

	$cid = $this->_cid_arr[0];

	$cat_obj = $this->_category_handler->get_cache($cid);
	if ( !is_object($cat_obj) )
	{
		return array($tags, $cid);
	}

	$cat_title = $cat_obj->get('title');

	$tags['LINK_NAME']     = $link_title;
	$tags['LINK_URL']      = XOOPS_URL.'/modules/'.$this->_DIRNAME.'/singlelink.php?lid='.$newid;
	$tags['CATEGORY_NAME'] = $cat_title;
	$tags['CATEGORY_URL']  = XOOPS_URL.'/modules/'.$this->_DIRNAME.'/viewcat.php?cid='.$cid;

	return array($tags, $cid);
}

//=========================================================
// modify table
//=========================================================
function add_link_to_modify_by_post( $mode=0 )
{
	$muid = $this->_system->get_uid();
	$time = time();

	$mod_obj =& $this->_modify_handler->create();

	if ($mode)
	{
		$lid = $this->_post->get_post_int('lid');

		$link_obj = $this->get($lid);
		if ( !is_object($link_obj) )
		{
			$this->_set_errors_not_exist($lid);
			return false;
		}

		$link = $link_obj->getVarAll('n');
		$mod_obj->assign_vars_post( $link );
		$passwd = $this->get_passwd_md5_mod_by_post();
	}
	else
	{
		$passwd = $this->get_passwd_md5_new_by_post();
	}

// desc option
	$mod_obj->set_conf_desc_option( $this->_config_handler->has_auth_desc_option() );

// value
	$mod_obj->assign_vars_post( $_POST );

	if ($passwd)
	{
		$mod_obj->setVar( 'passwd', $passwd, true );
	}

	$mod_obj->setVar('mode',        $mode);
	$mod_obj->setVar('muid',        $muid);
	$mod_obj->setVar('time_create', $time);
	$mod_obj->setVar('time_update', $time);

// cid array
	$this->_cid_arr = $mod_obj->get_cid_array_by_post( $_POST );
	$mod_obj->set_cids_by_cid_array( $this->_cid_arr );

	$search = $this->build_search( $mod_obj, $this->_cid_arr );
	$mod_obj->setVar('search', $search);

	$newid = $this->_modify_handler->insert($mod_obj);
	if ( !$newid )
	{
		$this->_set_errors( $this->_modify_handler->getErrors() );
		return false;
	}

	return $newid;
}

//=========================================================
// votedata table
// delete link, catlink, modify, votedata, broken, comments, notification
//=========================================================
function del_link_vote_comm_catlink_by_lid($lid)
{
	$this->_clear_errors();

	$ret1 = $this->del_link_vote_comm_by_lid($lid);

	$ret2 = $this->_catlink_handler->delete_by_lid($lid);
	if (!$ret2)
	{
		$this->_set_errors( $this->_catlink_handler->getErrors() );
	}

	return $this->returnExistError();
}

function del_link_vote_comm_by_lid($lid)
{
	$modid = $this->_system->get_mid();

	$ret1 = $this->_link_handler->delete_by_lid($lid);
	if (!$ret1)
	{
		$this->_set_errors( $this->_link_handler->getErrors() );
	}

	$ret2 = $this->_modify_handler->delete_by_lid($lid);
	if (!$ret2)
	{
		$this->_set_errors( $this->__modify_handler->getErrors() );
	}

	$ret3 = $this->_votedata_handler->delete_by_lid($lid);
	if (!$ret3)
	{
		$this->_set_errors( $this->_votedata_handler->getErrors() );
	}

	$ret4 = $this->_broken_handler->delete_by_lid($lid);
	if (!$ret4)
	{
		$this->_set_errors( $this->_broken_handler->getErrors() );
	}

	xoops_comment_delete( $modid, $lid);
	xoops_notification_deletebyitem ( $modid, 'link', $lid);

	return $this->returnExistError();
}

//---------------------------------------------------------
// token ticket
//---------------------------------------------------------
function make_token( $name='' )
{
	$ret = $this->_form->build_token($name);
	return $ret;
}

function check_token( $name='' )
{
	$ret = $this->_form->check_token($name);
	return $ret;
}

//---------------------------------------------------------
// error 
//---------------------------------------------------------
function _set_errors_not_exist($lid)
{
	$msg = "link not exist lid = $lid";
	$this->_set_errors( $msg );
}

// --- class end ---
}

// === class end ===
}

?>