<?php
// $Id: weblinks_link_view_edit.php,v 1.2 2006/10/14 13:45:12 ohwada Exp $

// 2006-10-14 K.OHWADA
// use weblinks_highlight

// 2006-09-20 K.OHWADA
// this new file
// use rssc WEBLINKS_RSSC_USE

//=========================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_link_view
//   weblinks_link_edit
// 2006-09-20 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_view') ) 
{

//=========================================================
// class weblinks_link_view_edit
//=========================================================
class weblinks_link_view extends happy_linux_basic
{
	var $_DIRNAME;

// handler
	var $_config_handler;
	var $_link_handler;
	var $_category_handler;
	var $_catlink_handler;
	var $_link_catlink_handler;
	var $_rssc_handler;

// class
	var $_system;
	var $_image_size;
	var $_highlight;

// local
	var $_conf;
	var $_link_obj;

//-----------------------------------------------
// This is for lower compatibility of mylinks
//-----------------------------------------------
	var $_DIR_SHOTS = 'images/shots/';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_view( $dirname )
{
	$this->happy_linux_basic();

	$this->_DIRNAME = $dirname;

	$this->_config_handler       =& weblinks_get_handler('config2_basic', $dirname );
	$this->_link_handler         =& weblinks_get_handler('link',          $dirname );
	$this->_category_handler     =& weblinks_get_handler('category',      $dirname );
	$this->_catlink_handler      =& weblinks_get_handler('catlink',       $dirname );
	$this->_link_catlink_handler =& weblinks_get_handler('link_catlink',  $dirname );
	$this->_rssc_handler         =& weblinks_get_handler('rssc',          $dirname );

	$this->_system       =& happy_linux_system::getInstance();
	$this->_image_size   =& happy_linux_image_size::getInstance();

	$this->_highlight    =& happy_linux_highlight::getInstance();
	$this->_highlight->set_replace_callback( 'happy_linux_highlighter_by_class' );
	$this->_highlight->set_class( 'weblinks_highlight' );

	$this->_conf = $this->_config_handler->get_conf();
}

//---------------------------------------------------------
// set object
//---------------------------------------------------------
function set_object( &$obj )
{
	$this->_link_obj =& $obj;
}

//---------------------------------------------------------
// show
//---------------------------------------------------------
function build_show( $flag_highlight=false, $keyword_array=null )
{
	$this->set_vars( $this->_link_obj->build_show() );

	$this->build_show_flag_new_update_pop();
	$this->build_show_flag_url();
	$this->build_show_image();
	$this->build_show_desc(       $flag_highlight, $keyword_array );
	$this->build_show_desc_short( $flag_highlight, $keyword_array );
	$this->build_show_modify();
	$this->build_show_flag_admin();

	$lid = $this->_link_obj->get('lid');
	$this->build_show_catpaths_by_lid($lid);
	$this->build_show_mail_by_lid($lid);

	$this->build_show_rss_url();

// dont show
	$this->set('name',        '');
	$this->set('mail',        '');
	$this->set('passwd',      '');
	$this->set('search',      '');
	$this->set('rss_xml',     '');
	$this->set('usercomment', '');
}

function build_show_flag_new_update_pop()
{
	$time_create = $this->_link_obj->get('time_create');
	$time_update = $this->_link_obj->get('time_update');
	$hits        = $this->_link_obj->get('hits');

	$flag_new    = 0;
	$flag_update = 0;
	$flag_pop    = 0;

	if ( $this->_conf['newdays'] > 0 )
	{
		$startdate = time() - (86400 * $this->_conf['newdays'] );

		if ( $startdate < $time_create ) 
		{
			$flag_new = 1;
		}
		elseif ( $startdate < $time_update )
		{
			$flag_update = 1;
		}
	}

	if ( $this->_conf['popular'] > 0 )
	{
		if ( $hits >= $this->_conf['popular'] )
		{
			$flag_pop = 1;
		}
	}

	$this->set('flag_new',    $flag_new);
	$this->set('flag_update', $flag_update);
	$this->set('flag_pop',    $flag_pop);	
}

function build_show_flag_url()
{
	$url = $this->_link_obj->get('url');
	$flag_url = 0;

	if ( $url && $this->_conf['view_url'] )
	{
		$flag_url = $this->_conf['view_url'];
	}

	$this->set('flag_url', $flag_url);
}

function build_show_desc( $flag_highlight=false, $keyword_array=null )
{
	$text = $this->_link_obj->description_disp();
	if ($flag_highlight)
	{
		$text = $this->_highlight->build_highlight_keyword_array($text, $keyword_array);
	}
	$this->set('description', $text);
}

function build_show_desc_short( $flag_highlight=false, $keyword_array=null )
{
	$text = $this->_link_obj->description_disp();
	$text = $this->replace_return_to_space($text);
	$text = $this->strip_space($text);

	if (strlen($text) > $this->_conf['descshort'] )
	{
		$text = $this->strip_tags_for_text($text);
		$text = $this->shorten_text($text, $this->_conf['descshort'], $keyword_array );
		$text = $this->sanitize_text($text);
	}

	if ($flag_highlight)
	{
		$text = $this->_highlight->build_highlight_keyword_array($text, $keyword_array);
	}

	$this->set('desc_short', $text);
}

function build_show_modify()
{
	$uid = $this->_link_obj->get('uid');
	$this->set('show_modify', $this->_config_handler->show_modify( $uid ) );
}

function build_show_flag_admin()
{
	$flag_admin = 0;
	if ( $this->_system->is_module_admin() )
	{
		$flag_admin = 1;
	}

	$this->set('flag_admin', $flag_admin);
}

function build_show_catpaths_by_lid($lid)
{
	$cid_arr = $this->_catlink_handler->get_cid_array_by_lid($lid);
	$this->build_show_catpaths_by_cid_arr($cid_arr);
}

function build_show_catpaths_by_cid_arr($cid_arr)
{
	$show_catpaths = false;
	$catpaths      = null;

	if ( is_array($cid_arr) && count($cid_arr) )
	{
		$catpaths = $this->_category_handler->build_parent_path_multi($cid_arr);
	}

	if ( is_array($catpaths) && count($catpaths) )
	{
		$show_catpaths = true;
	}

	$this->set('show_catpaths', $show_catpaths);
	$this->set('catpaths',      $catpaths);
}

function build_show_mail_by_lid($lid)
{
	$mail_subject = '';
	$mail_body    = '';

	if ($lid)
	{
		list($mail_subject, $mail_body) 
			= $this->_link_handler->build_link_mail($lid);
	}

	$this->set('mail_subject', $mail_subject);
	$this->set('mail_body',    $mail_body);
}

//---------------------------------------------------------
// banner
//---------------------------------------------------------
function build_show_image()
{
	$banner = $this->_link_obj->get('banner');
	$width  = $this->_link_obj->get('width');
	$height = $this->_link_obj->get('height');

	$image_url    = '';
	$link_width   = 0;
	$link_height  = 0;
	$list_width   = 0;
	$list_height  = 0;
	$list_width_5 = 0;

	if ( $banner )
	{
		$image_url = $this->assume_banner_url($banner);

// size exist
		if ($width && $height)
		{
			list ($list_width, $list_height) 
				= $this->_image_size->adjust_size($width, $height, $this->_conf['list_image_width'], $this->_conf['list_image_height'] );

			$list_width_5 = $list_width + 5;

			list ($link_width, $link_height) 
				= $this->_image_size->adjust_size($width, $height, $this->_conf['link_image_width'], $this->_conf['link_image_height'] );
		}

		$image_url = $this->sanitize_url($image_url);
	}

	$this->set('image_url',          $image_url);
	$this->set('image_link_width',   $link_width);
	$this->set('image_link_height',  $link_height);
	$this->set('image_list_width',   $list_width);
	$this->set('image_list_height',  $list_height);
	$this->set('image_list_width_5', $list_width_5);
}

function assume_banner_url($banner)
{
	if ( empty($banner) ) { return $banner; }

// URL style
	$url = $banner;
	if ( preg_match("/^https?:/", $url) )
	{
		return $url;
	}

// elliptical style
	$url = XOOPS_URL.$banner;
	$fp = fopen($url,"r");
	if ($fp)
  	{
		return $url;
  	}

// mylinks style
	$url = XOOPS_URL.'/modules/'.$this->_DIRNAME.'/'.$this->_DIR_SHOTS.'/'.$banner;
	return $url;

}

//---------------------------------------------------------
// rss url
//---------------------------------------------------------
function build_show_rss_url()
{
	$url  = '';
	$flag = 0;

	$rssc_lid = $this->_link_obj->get('rssc_lid');

	if ( WEBLINKS_RSSC_USE && $rssc_lid )
	{
		list($url, $flag)
			= $this->_rssc_handler->get_rss_url_flag($rssc_lid);
	}

	$this->set('rss_url',  $this->sanitize_url($url) );
	$this->set('rss_flag', $flag);
}

//---------------------------------------------------------
// build preview
//---------------------------------------------------------
function build_preview_catpaths_by_post( &$post )
{
	$cid_arr  = $this->_link_obj->get_cid_array_by_post( $post );
	$catpaths = $this->_category_handler->build_parent_path_multi($cid_arr);

	if ( is_array($catpaths) && count($catpaths) )
	{
		$show_catpaths = true;
	}

	$this->set('show_catpaths', $show_catpaths);
	$this->set('catpaths',      $catpaths);
}

//---------------------------------------------------------
// for rss
//---------------------------------------------------------
function build_rss( $flag_user=false )
{
	$this->set_vars( $this->_link_obj->getVarAll('n') );

// link
	$lid  = $this->_link_obj->get('lid');
	$link = XOOPS_URL.'/modules/'.$this->_DIRNAME.'/singlelink.php?lid='.$lid;
	$this->set('link', $link );

	$this->set('content', $this->_link_obj->description_disp() );

// author_name
	$uid = $this->_link_obj->get('uid');

	$author_name  = '';
	$author_email = '';
	$author_uri   = '';

	if ( $flag_user && $uid )
	{
		$user = $this->_system->get_user_by_uid( $uid );
		$author_name  = $user['uname'];
		$author_email = $user['email'];
		$author_uri   = $user['url'];
	}

	$this->set('author_name',  $author_name);
	$this->set('author_email', $author_email);
	$this->set('author_uri',   $author_uri);

// category
	$cid_arr  = $this->_catlink_handler->get_cid_array_by_lid($lid);
	$category = $this->_category_handler->get_cache_var_title($cid_arr[0], 'n');
	$this->set('category', $category);
}

// --- class end ---
}

//=========================================================
// class weblinks_link_edit
//=========================================================
class weblinks_link_edit extends weblinks_link_view
{
// class
	var $_post;

// conf
	var $_conf_desc_option;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_edit( $dirname )
{
	$this->weblinks_link_view( $dirname );

	$this->_post  =& happy_linux_post::getInstance();

	$this->_conf_desc_option = $this->_config_handler->has_auth_desc_option();

}

//---------------------------------------------------------
// submit
//---------------------------------------------------------
function build_submit()
{
	$link_obj =& $this->_link_handler->create();
	$this->set_object($link_obj);
	$this->set_vars( $link_obj->getVarAll('s') );

// user param
	$user = $this->_system->get_user_param();
	$this->set('uid',   $user['uid'] );
	$this->set('name',  $user['uname'] );
	$this->set('mail',  $user['email'] );

	$this->build_submit_cid_arr();
	$this->set('notify',     1);
	$this->set('updateflag', 1);

	$this->build_password_by_post();
	$this->build_submit_rss_url();
}

function build_submit_cid_arr()
{
	$cid_arr = array();
	if ( isset($_GET['cid']) )
	{
		$cid_arr = array($_GET['cid']);
	}
	$this->set('cid_arr', $cid_arr);
}

function build_submit_rss_url()
{
	$rss_flag  = 0;

	if ( WEBLINKS_RSSC_USE )
	{
		$rss_flag = $this->_rssc_handler->get_rss_flag_default();
	}

	$this->set('rss_url',  '');
	$this->set('rss_flag', $rss_flag);
	$this->build_rss_opt();
}

function build_rss_opt()
{
	$rss_opt  = array();

	if ( WEBLINKS_RSSC_USE )
	{
		$rss_opt = $this->_rssc_handler->get_rss_opt();
	}

	$this->set('rss_opt', $rss_opt);
}

function build_password_by_post()
{
	$passwd_new = $this->_post->get_post_text('passwd_new');
	$passwd_2   = $this->_post->get_post_text('passwd_2');

	list($passwd_old, $flag_passwd, $flag_code)
		= $this->_post->get_post_get_passwd_old();

	$this->set('passwd_new',  $passwd_new);
	$this->set('passwd_2',    $passwd_2);
	$this->set('passwd_old',  $passwd_old);
}

//---------------------------------------------------------
// submit preview
//---------------------------------------------------------
function build_submit_preview()
{
	$link_obj =& $this->_link_handler->create();
	$this->set_object($link_obj);
	$this->build_preview_by_post();
	$this->set('updateflag', 1);

	$this->build_password_by_post();
	$this->build_rss_url_by_post();
}

function build_preview_by_post()
{
	$this->_link_obj->set_conf_desc_option( $this->_conf_desc_option );
	$this->_link_obj->assign_vars_post( $_POST );
	$this->set_vars( $this->_link_obj->getVarAll('f') );
	$this->set('cid_arr',  $this->_link_obj->get_cid_array_by_post( $_POST ) );
	$this->set('notify',   $this->_post->get_post_int('notify') );
}

function build_rss_url_by_post()
{
	$rss_flag = $this->_post->get_post_int('rss_flag');
	$rss_url  = $this->_post->get_post_url('rss_url');
	$rss_url  = $this->sanitize_url($rss_url);

	$this->set('rss_flag', $rss_flag );
	$this->set('rss_url',  $rss_url );

	$this->build_rss_opt();
}

//---------------------------------------------------------
// admin modify
//---------------------------------------------------------
function build_modify($lid, $flag_owner=false)
{
	$this->set_vars( $this->_link_obj->getVarAll('e') );

// hidden value, when NOT owner
	if ( !$flag_owner )
	{
		list($name, $nameflag) = $this->_link_obj->name_edit_for_others();
		list($mail, $mailflag) = $this->_link_obj->mail_edit_for_others();
		$this->set('name',      $name);
		$this->set('mail',      $mail);
		$this->set('nameflag',  $nameflag);
		$this->set('mailflag',  $mailflag);
	}

	$this->build_modify_cid_arr_by_lid($lid);
	$this->set('notify',     0);
	$this->set('updateflag', 1);

	$this->build_password_by_post();
	$this->build_modify_rss_url();

}

function build_modify_cid_arr_by_lid($lid)
{
	$cid_arr   = $this->_catlink_handler->get_cid_array_by_lid($lid);
	$this->set('cid_arr', $cid_arr);
}

function build_modify_rss_url()
{
	$this->build_show_rss_url();
	$this->build_rss_opt();
}

//---------------------------------------------------------
// modify preview
//---------------------------------------------------------
function build_modify_preview()
{
	$this->build_preview_by_post();
	$this->set('updateflag', 1);

	$this->build_password_by_post();
	$this->build_rss_url_by_post();
}

//---------------------------------------------------------
// admin submit
//---------------------------------------------------------
function build_admin_submit()
{
	$this->build_submit();
}

//---------------------------------------------------------
// admin submit preview
//---------------------------------------------------------
function build_admin_submit_preview()
{
	$link_obj =& $this->_link_handler->create();
	$this->set_object($link_obj);
	$this->build_admin_preview_by_post();

	$this->build_rss_url_by_post();
}

function build_admin_preview_by_post()
{
	$this->build_preview_by_post();
	$this->build_desc_disp();
	$this->set('updateflag', $this->_post->get_post_int('updateflag') );
}

function build_desc_disp()
{
	$this->set('desc_disp',  $this->_link_obj->description_disp() );
}

//---------------------------------------------------------
// admin modify
//---------------------------------------------------------
function build_admin_modify($lid)
{
	$this->set_vars( $this->_link_obj->getVarAll('e') );

	$this->build_desc_disp();
	$this->build_modify_cid_arr_by_lid($lid);
	$this->set('updateflag', 0);

	$this->build_modify_rss_url();

}

//---------------------------------------------------------
// admin modify preview
//---------------------------------------------------------
function build_admin_modify_preview()
{
	$this->build_admin_preview_by_post();
	$this->build_admin_modify_preview_uid();

	$this->build_rss_url_by_post();
}

function build_admin_modify_preview_uid()
{
	if ( $muid = $this->_link_obj->is_set('muid') )
	{
		$muid = $this->_link_obj->get('muid');
		$this->set('uid', $muid);
	}
}

//---------------------------------------------------------
// admin approve
//---------------------------------------------------------
function build_admin_approve()
{
	$this->set_vars( $this->_link_obj->getVarAll('e') );

	$this->build_admin_approve_cid_arr();
	$this->build_admin_approve_uid();

	$this->set('updateflag', 1);

	$this->build_rss_opt();
}

function build_admin_approve_cid_arr()
{
	$cid_arr = $this->_link_obj->cid_array();
	$this->set('cid_arr', $cid_arr);
}

function build_admin_approve_uid()
{
	$muid = $this->_link_obj->get('muid');
	$this->set('uid', $muid);
}

//---------------------------------------------------------
// admin approve preview
//---------------------------------------------------------
function build_admin_approve_preview()
{
	$this->build_admin_preview_by_post();
}


//---------------------------------------------------------
// admin approve modify
//---------------------------------------------------------
function build_admin_approve_modify()
{
	$this->set_vars( $this->_link_obj->getVarAll('e') );

	$this->build_desc_disp();
	$this->build_admin_approve_cid_arr();
	$this->build_admin_approve_uid();

	$this->set('updateflag', 1);

	$this->build_rss_opt();
}

//---------------------------------------------------------
// admin approve modify preview
//---------------------------------------------------------
function build_admin_approve_modify_preview()
{
	$this->build_admin_preview_by_post();
}

//---------------------------------------------------------
// build_preview
//---------------------------------------------------------
function build_preview_for_template( $cid_arr )
{
	$this->set_vars( $this->_link_obj->build_show() );

	$this->build_show_flag_new_update_pop();
	$this->build_show_flag_url();
	$this->build_show_image();
	$this->build_show_desc_short();
	$this->build_show_modify();
	$this->build_show_flag_admin();

// catpaths
	$this->build_show_catpaths_by_cid_arr($cid_arr);

// mail
	$this->set('mail_subject', '');
	$this->set('mail_body',    '');

// dont show
	$this->set('name',        '');
	$this->set('mail',        '');
	$this->set('passwd',      '');
	$this->set('search',      '');
	$this->set('rss_xml',     '');
	$this->set('usercomment', '');
}

// --- class end ---
}

// === class end ===
}

?>