<?php
// $Id: lostpass.php,v 1.7 2006/09/30 03:15:20 ohwada Exp $

// 2006-09-20 K.OHWADA
// use happy_linux

// 2006-05-15 K.OHWADA
// add weblinks_lostpass()
// use new handler
// use token ticket

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// lostpass
// porting from system
// 2004/01/23 K.OHWADA
//================================================================

include 'header.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/form.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_mailer.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_sendmail.php';


//=========================================================
// class weblinks_lostpass
//=========================================================
class weblinks_lostpass extends happy_linux_error
{
	var $_link_handler;
	var $_system;
	var $_post;
	var $_form;

// post
	var $_post_lid;
	var $_post_email;

// link recored
	var $_link_name;

// local
	var $_passwd;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_lostpass()
{
	$this->happy_linux_error();
	$this->set_debug_print_error( WEBLINKS_DEBUG_ERROR );

	$this->_link_handler =& weblinks_get_handler( 'link', WEBLINKS_DIRNAME );

	$this->_system =& happy_linux_system::getInstance();
	$this->_post   =& happy_linux_post::getInstance();
	$this->_form   =& happy_linux_form::getInstance();

}

//---------------------------------------------------------
// update password
//---------------------------------------------------------
function update_password($lid)
{
	$obj =& $this->_link_handler->get($lid);
	if ( !is_object($obj) )
	{
		return -1;
	}

	if( !$this->_form->check_token() ) 
	{
		return -2;
	}

	$link_mail        = $obj->get('mail');
	$this->_link_name = $obj->get('name');

	if ( $this->_post_email != $link_mail )
	{
		return -3;
	}

	$this->_passwd = xoops_makepass();
	$passwd_md5 = md5( $this->_passwd );
	$obj->setVar('passwd', $passwd_md5);

	$ret = $this->_link_handler->update($obj);
	if (!$ret)
	{
		return -4;
	}

	return 0;	// OK
}

//---------------------------------------------------------
// get POST
//---------------------------------------------------------
function get_post_lid()
{
	$this->_post_lid = $this->_post->get_post_int('lid');
	return $this->_post_lid;
}

function get_post_email()
{
	$this->_post_email = $this->_post->get_post_text('email');
	return $this->_post_email;
}


//---------------------------------------------------------
// get property
//---------------------------------------------------------
function get_name()
{
	if ( $this->_link_name )
	{
		$name = $this->_link_name;
	}
	else
	{
		$name =  $this->_system->get_uname();
	}

	return $name;
}

function get_passwd()
{
	return $this->_passwd;
}

// --- class end ---
}


//=========================================================
// main
//=========================================================

$weblinks_sendmail  =& weblinks_sendmail::getInstance( WEBLINKS_DIRNAME );
$weblinks_lostpass  =& new weblinks_lostpass();

$xoopsOption['pagetype'] = "user";

// BUG 2932: dont work correctly when register_long_arrays = off
$lid   = $weblinks_lostpass->get_post_lid();
$email = $weblinks_lostpass->get_post_email();

$ret = $weblinks_lostpass->update_password($lid);

if ( $ret == -1 )
{
	redirect_header("index.php", 3, _WLS_ERRORNOLINK);
	exit();
}

if( $ret == -2 ) 
{
	redirect_header("singlelink.php?lid=".$lid, 3, "Token Error");
	exit();
}

if ( $ret == -3 )
{
	redirect_header("singlelink.php?lid=$lid", 3 ,_WLS_EMAILNOTFOUND);
	exit();
}

if ( $ret == -4 )
{
	redirect_header("singlelink.php?lid=$lid", 3, _US_MAILPWDNG);
	exit();
}

$name   = $weblinks_lostpass->get_name();
$passwd = $weblinks_lostpass->get_passwd();

$ret = $weblinks_sendmail->send_passwd_to_user($email, $name, $lid, $passwd);
if (!$ret)
{
	redirect_header("singlelink.php?lid=$lid", 5, "Mail Error");
}

$text = sprintf(_US_CONFMAIL, $name);
redirect_header("singlelink.php?lid=$lid", 1, $text);

exit();
// --- main end ---

?>