<?php
// $Id: weblinks_pagenavi.php,v 1.3 2005/10/28 11:56:02 ohwada Exp $

// 2002-02-03 K.OHWADA
// bug fix: Call-time pass-by-reference

//=========================================================
// class page navi
// created since v0.9
// divid from pagenavi
// 2005-01-20 K.OHWADA
//=========================================================

class weblinks_pagenavi extends pagenavi
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_pagenavi()
{
	pagenavi::pagenavi();

	$orderbey_array = array(
		'title ASC',       'title DESC',
		'time_update ASC', 'time_update DESC',
		'rating ASC',      'rating DESC',
		'hits ASC',        'hits DESC'
	);

	$lang_array = array(
		_WLS_TITLEATOZ,      _WLS_TITLEZTOA,
		_WLS_DATEOLD,        _WLS_DATENEW,
		_WLS_RATINGLTOH,     _WLS_RATINGHTOL,
		_WLS_POPULARITYLTOM, _WLS_POPULARITYMTOL
	);

	$this->set_orderbey_array( 7, $orderbey_array, $lang_array );

	global $xoopsModuleConfig;
	$this->set_sortid_default( $xoopsModuleConfig['orderby'] );
	$this->set_show( $xoopsModuleConfig['perpage'] );

}

//=========================================================
// template
//=========================================================
function assign_navi(&$tpl, $navi, $sortid='')
{
// bug fix: Call-time pass-by-reference
	$this->assign_pagenavi($tpl, $navi);

	if ($sortid == '')  $sortid = $this->sortid;
	$orderby_lang = $this->convert_lang_by_id($sortid);

	$tpl->assign('show_navi',  true);

	$tpl->assign('lang_sortby',     _WLS_SORTBY);
	$tpl->assign('lang_title',      _WLS_TITLE);
	$tpl->assign('lang_date',       _WLS_DATE);
	$tpl->assign('lang_rating',     _WLS_RATING);
	$tpl->assign('lang_popularity', _WLS_POPULARITY);
	$tpl->assign('lang_sort_0',     _WLS_TITLEATOZ);
	$tpl->assign('lang_sort_1',     _WLS_TITLEZTOA);
	$tpl->assign('lang_sort_2',     _WLS_DATEOLD);
	$tpl->assign('lang_sort_3',     _WLS_DATENEW);
	$tpl->assign('lang_sort_4',     _WLS_RATINGLTOH);
	$tpl->assign('lang_sort_5',     _WLS_RATINGHTOL);
	$tpl->assign('lang_sort_6',     _WLS_POPULARITYLTOM);
	$tpl->assign('lang_sort_7',     _WLS_POPULARITYMTOL);

	$tpl->assign('lang_cursortedby', sprintf(_WLS_CURSORTEDBY, $orderby_lang) );

}

//---------------------------------------------------------
}

?>
