<?php
// $Id: modify.php,v 1.4 2005/10/28 11:56:02 ohwada Exp $

// 2005-10-20 K.OHWADA
// REQ 3028: send apoval email to anonymous user
// add send_approved_to_anonymous()
// add send_refused_to_user() 

// 2005-09-27 K.OHWADA
// BUG 3031: timeout occurs if many waiting links
// add function list_xxx_link_xxx() print_xxx()

// 2005-01-20 K.OHWADA
// getErrorMsgAddLink

// 2004-12-14 K.OHWADA
// change caller index.php -> link_manage.php 

// 2004-10-20 K.OHWADA
// URL-less mode
// bug fix: approve notify mail dont send

//=========================================================
// admin modify
// use class weblinksCategory, weblinksLink
// divid this file from index.php
// 2004/01/14 K.OHWADA
//=========================================================

//---------------------------------------------------------
// list New Links
//---------------------------------------------------------
function listNewLinks()
{
	global $tbl_modify;
	global $WEBLINKS_MAX_LINK_IN_DETAIL;

// List links waiting for validation
	$total = $tbl_modify->getNumNew();

	xoops_cp_header();
	echo "<h4>"._WLS_WEBLINKSCONF."</h4>\n";
	print_link_index();
	echo "<h4>"._WLS_LINKSWAITING."&nbsp;($total)</h4>\n";

// BUG 3031: timeout occurs if many waiting links
	if ( $total > 0 ) 
	{
		$mid = get_get_int('mid');

		if ($mid > 0)
		{
			list_new_link_one($mid);
		}
		elseif ($total <= $WEBLINKS_MAX_LINK_IN_DETAIL)
		{
			list_new_link_detail();
		}
		else
		{
			list_new_link_page($total);
		}

	}
	else 
	{
		echo _WLS_NOSUBMITTED."<br />\n";
	}

	xoops_cp_footer();
}

function list_new_link_detail()
{
	global $tbl_modify;

	$mid_arr = $tbl_modify->getMidArrayNew();

	foreach ($mid_arr as $mid) 
	{
		list_new_link_one($mid);
	}
}

function list_new_link_one($mid)
{
	global $tbl_modify;

	$rec  = $tbl_modify->getRowByMid($mid);
	$link = $tbl_modify->makeEditDisplayAdmin($rec);

	LinkForm(2, $link);
	echo "<br /><br />\n";

}

function list_new_link_page($total)
{
	global $tbl_modify;
	global $pagenavi;
	global $WEBLINKS_MAX_LINK_IN_PAGE;

	$op = 'listNewLinks';

	$pagenavi = new pagenavi();
	$pagenavi->set_show($WEBLINKS_MAX_LINK_IN_PAGE);
	$pagenavi->get_get_parm();

	$offset = $pagenavi->get_start($total);

	print_start();

	$mid_arr = $tbl_modify->getMidArrayNew($WEBLINKS_MAX_LINK_IN_PAGE, $offset);

	foreach ($mid_arr as $mid)
	{
		$rec   = $tbl_modify->getRowByMid($mid);
		$title = $rec['title'];
		$url   = $rec['url'];

		print_line($op, $mid, $title, $url);
	}

	print_end($op, $total);
}

function print_start()
{

	echo "<table border='1'><tr>";
	echo "<th align='center'>"._WEBLINKS_MID."</th>";
	echo "<th align='center'>"._WLS_SITETITLE."</th>";
	echo "<th align='center'>"._WLS_SITEURL."</th>";
	echo "</tr>\n";

}

function print_end($op, $total)
{
	global $pagenavi;

	$navi = '';

	if ($total > 1)
	{
		$script = "link_manage.php?op=".$op;
		$navi   = $pagenavi->build_navi($script, $total, -1, -1);

		if ($navi == -1)
		{
			echo "system error: script = $script, total = $total <br>\n";
			xoops_cp_footer();
			exit();
		}

	}

	echo "</table><br />\n";
	echo "<div align='center'>$navi</div>\n";
}

function print_line($op, $mid, $title, $url)
{
	$mod_id = sprintf("%03d", $mid);

	$modlink = "link_manage.php?op=".$op."&amp;mid=".$mid;
	$title   = htmlspecialchars($title);

	echo "<tr>";
	echo "<td><a href='$modlink'>$mod_id</a></td>";
	echo "<td>$title</td>";
	echo "<td><a href='$url' target='_blank'>$url</a></td>";
	echo "</tr>\n";

}

//---------------------------------------------------------
// delete New Link
//---------------------------------------------------------
function delNewLink()
{
	global $eh;
	global $tbl_modify;

	$mid = get_post_get_int('mid');

	$tbl_modify->delete($mid)  or $eh->show("0013");

// send email to user and anonymous, refused to new link
// REQ 3028: send refused email to registered user and anonymous user
	send_refused_to_user($_POST);

	$redirect = get_redirect_at_new();
	redirect_header($redirect, 1, _WLS_LINKDELETED);
	exit();

}

function get_redirect_at_new()
{
	global $tbl_modify;

	$total = $tbl_modify->getNumNew();

// jump same page when remain New link
	if ($total > 0)
	{
		return "link_manage.php?op=listNewLinks";
	}
	else
	{
		return "link_list.php";
	}

}

//---------------------------------------------------------
// approve New Link
//---------------------------------------------------------
function approve()
{
	global $eh;
	global $tbl_link, $tbl_modify;

	$FLAG_EVENT_ANONYMOUS = 1;	// send email to anonymous

	$mid = get_post_int('mid');

// insert form
	if ( $tbl_link->checkFormAddLink($_POST) ) 
	{
		xoops_cp_header();
		echo $tbl_link->getErrorMsgAddLink();
		xoops_cp_footer();
		exit();
    }

// insert link
	$tbl_link->addLinkAppove($_POST) or $eh->show("0013");
	$newid = $tbl_link->getNewid();

// delete mopdify
	$tbl_modify->delete($mid) or $eh->show("0013");

// notification
	list($tags,$cid) = $tbl_link->makeTagsAddLink($newid);
	$notification_handler =& xoops_gethandler('notification');
	$notification_handler->triggerEvent('global', 0, 'new_link', $tags);
	$notification_handler->triggerEvent('category', $cid, 'new_link', $tags);

// send email to user, appoval to new link
// bug fix: approve notify mail dont send
	$notification_handler->triggerEvent('link', $mid, 'approve', $tags);

// send email to anonymous, appoval to new link
// REQ 3028: send appoval email to anonymous user
	if( $FLAG_EVENT_ANONYMOUS && ($_POST['uid'] == 0) && !empty($_POST['mail']) )
	{
		send_approved_to_anonymous($_POST, $tags);
	}

	$redirect = get_redirect_at_new();
	redirect_header($redirect, 1, _WLS_NEWLINKADDED);
	exit();
}

//---------------------------------------------------------
// list Modify Request
//---------------------------------------------------------
function listModReq()
{
	global $tbl_modify;
	global $WEBLINKS_MAX_LINK_IN_DETAIL;

	$total = $tbl_modify->getNumMod();

	xoops_cp_header();
	echo "<h4>"._WLS_WEBLINKSCONF."</h4>\n";
	print_link_index();
    echo "<h4>"._WLS_MODREQUESTS."&nbsp;($total)</h4>\n";

// BUG 3031: timeout occurs if many waiting links
	if ( $total > 0 ) 
	{
		$mid = get_get_int('mid');

		if ($mid > 0)
		{
			list_mod_req_one($mid);
		}
		elseif ($total <= $WEBLINKS_MAX_LINK_IN_DETAIL)
		{
			list_mod_req_detail();
		}
		else
		{
			list_mod_req_page($total);
		}

	}
	else 
	{
		echo _WLS_NOMODREQ."<br />\n";
	}

	xoops_cp_footer();
}

function list_mod_req_detail()
{
	global $tbl_modify;

	$mid_arr = $tbl_modify->getMidArrayMod();

	foreach ($mid_arr as $mid) 
	{
		list_mod_req_one($mid);
	}

}

function list_mod_req_one($mid)
{
	global $tbl_link, $tbl_modify;

	$rec1 = $tbl_modify->getRowByMid($mid);
	$new  = $tbl_modify->makeEditDisplayAdmin($rec1);

	$lid  = $rec1['lid'];
	$rec2 = $tbl_link->getRowByLid($lid);
	$old  = $tbl_link->makeEditDisplayApprove($rec2);

	ModLinkForm($old, $new);
	echo "<br /><br />\n";

}

function list_mod_req_page($total)
{
	global $tbl_modify;
	global $pagenavi;
	global $WEBLINKS_MAX_LINK_IN_PAGE;

	$op = 'listModReq';

	$pagenavi = new pagenavi();
	$pagenavi->set_show($WEBLINKS_MAX_LINK_IN_PAGE);
	$pagenavi->get_get_parm();

	$offset = $pagenavi->get_start($total);

	print_start();

	$mid_arr = $tbl_modify->getMidArrayMod($WEBLINKS_MAX_LINK_IN_PAGE, $offset);
	foreach ($mid_arr as $mid)
	{
		$rec   = $tbl_modify->getRowByMid($mid);
		$title = $rec['title'];
		$url   = $rec['url'];

		print_line($op, $mid, $title, $url);
	}

	print_end($op, $total);
}

//---------------------------------------------------------
// approve Modify Request
// modLinkS and ignoreModReq
//---------------------------------------------------------
function approveModReq()
{
	global $tbl_link, $tbl_modify;

	$mid = get_post_int('mid');

// check form
	$tbl_link->blankHttpPostUrl();
	if ( $tbl_link->checkFormModLinkAdmin($_POST) ) 
	{
		xoops_cp_header();
		echo $tbl_link->getErrorMsgModLink();
		xoops_cp_footer();
		exit();
    }

// update link
	$tbl_link->modLinkAdmin( $_POST ) or $eh->show("0013");

// delete modify
	$tbl_modify->delete($mid) or $eh->show("0013");

	$redirect = get_redirect_at_mod();
	redirect_header($redirect, 1, _WLS_DBUPDATED);
	exit();
}

//---------------------------------------------------------
// ignore Modify Request
//---------------------------------------------------------
function ignoreModReq()
{
	global $eh;
	global $tbl_modify;

	$mid = get_post_get_int('mid');

	$tbl_modify->delete( $mid ) or $eh->show("0013");

	$redirect = get_redirect_at_mod();
	redirect_header($redirect, 1, _WLS_MODREQDELETED);
	exit();
}

function get_redirect_at_mod()
{
	global $tbl_modify;

	$total = $tbl_modify->getNumMod();

// jump same page when remain New link
	if ($total > 0)
	{
		return "link_manage.php?op=listModReq";
	}
	else
	{
		return "link_list.php";
	}

}


//---------------------------------------------------------
// REQ 3028: send apoval email to anonymous user
// Notification to anonymous users
// added by SnAKes
//---------------------------------------------------------
function send_approved_to_anonymous(&$post, &$tags) 
{
	global $xoopsConfig;

	$file_tpl = "link_approve_notify_anon.tpl";
	$dir_tpl  = get_dir_mail_template($file_tpl);

	$xoopsMailer =& getMailer();
	$xoopsMailer->useMail();

	foreach ($tags as $k=>$v) 
	{
		$xoopsMailer->assign($k, preg_replace("/&/i", '&', $v));
	}

	$xoopsMailer->assign("UNAME", '');
	$xoopsMailer->assign("ULINK", '');
	$xoopsMailer->setTemplateDir($dir_tpl);
	$xoopsMailer->setTemplate($file_tpl);
	$xoopsMailer->setFromEmail($xoopsConfig['adminmail']);
	$xoopsMailer->setFromName($xoopsConfig['sitename']);
	$xoopsMailer->setToEmails( $post['mail'] );
	$xoopsMailer->setSubject(_WEBLINKS_LINK_APPROVED);
	$success = $xoopsMailer->send();
	return $success;
}

//---------------------------------------------------------
// REQ 3028: send apoval email to anonymous user
// Notification of refusal to registered user and anonymous user
// added by SnAKes
// TODO: user can choice recieve email or PM
//---------------------------------------------------------
function send_refused_to_user(&$post) 
{
	global $xoopsConfig;

	$FLAG_EVENT_USER      = 1;	// send email to user
	$FLAG_EVENT_ANONYMOUS = 1;	// send email to anonymous

	if( $FLAG_EVENT_USER && $post['uid'] )
	{
		$user_handler =& xoops_gethandler('user');
		$user = $user_handler->get( $post['uid'] );
		$mail = $user->getVar('email');
	}
	elseif( $FLAG_EVENT_ANONYMOUS && ($post['uid'] == 0) && !empty($post['mail']) )
	{
		$mail = $post['mail'];
	}
	else
	{
		return false;
	}

	$file_tpl = "link_refused_notify.tpl";
	$dir_tpl  = get_dir_mail_template($file_tpl);

	$xoopsMailer =& getMailer();
	$xoopsMailer->useMail();
	$xoopsMailer->assign("SITE_URL",  $post["url"]);
	$xoopsMailer->assign("SITE_NAME", $post["title"]);
	$xoopsMailer->assign("UNAME", '');
	$xoopsMailer->assign("ULINK", '');
	$xoopsMailer->setTemplateDir($dir_tpl);
	$xoopsMailer->setTemplate($file_tpl);
	$xoopsMailer->setFromEmail($xoopsConfig['adminmail']);
	$xoopsMailer->setFromName($xoopsConfig['sitename']);
	$xoopsMailer->setToEmails( $mail );
	$xoopsMailer->setSubject(_WEBLINKS_LINK_REFUSED);
	$success = $xoopsMailer->send();
}


?>