<?php
// $Id: remote_file.php,v 1.4 2005/10/28 11:56:02 ohwada Exp $

// 2005-10-20 K.OHWADA
// BUG 3108: errors occur when allow_url_fopen = off

//=========================================================
// class remote file
// use class snoopy
// 2005-01-20 K.OHWADA
//=========================================================

class remote_file
{
	var $fp;
	var $content;

// image
	var $dir_temp;

// class instance
	var $image;
	var $snoopy;

// variable
	var $flag_allow_url_fopen;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function remote_file()
{
// image
	global $MODULE_ROOT;
	$dir_temp = $MODULE_ROOT."/cache";
	$this->set_dir_temp($dir_temp);

// class instance
	$this->image  =& image_size::getInstance();
	$this->snoopy = new Snoopy();

// BUG 3108: errors occur when allow_url_fopen = off
// get_cfg_var('allow_url_fopen') -> ini_get('allow_url_fopen')
	$this->flag_allow_url_fopen = ini_get('allow_url_fopen');

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new remote_file();
	}

	return $instance;
}


//---------------------------------------------------------
// check_url
//---------------------------------------------------------
function check_url($url)
{

// BUG 3108: errors occur when allow_url_fopen = off
// allow_url_fopen
	if ( $this->flag_allow_url_fopen )
	{
		return $this->_check_url_local( $url );
	}
// not allow_url_fopen
	else
	{
		return $this->_check_url_remote( $url );
	}
}

function _check_url_local($url)
{
	if ( $this->open($url, "r") )
	{
		$this->close();
		return true;
	}
	else
	{
		return false;
	}
}


//=========================================================
// read_file
//=========================================================
function read_file($url)
{

// BUG 3108: errors occur when allow_url_fopen = off
// allow_url_fopen
	if ( $this->flag_allow_url_fopen )
	{
		return $this->_read_file_local( $url );
	}
// not allow_url_fopen
	else
	{
		return $this->_read_file_remote( $url );
	}

}


//=========================================================
// use class image_size
//=========================================================
//---------------------------------------------------------
//  get_image_size
//---------------------------------------------------------
function get_image_size($url)
{
	if ( !$url )  return array(0,0);

// BUG 3108: errors occur when allow_url_fopen = off
// allow_url_fopen
	if ( $this->flag_allow_url_fopen )
	{
		return $this->image->get_size($url);
	}
// not allow_url_fopen
	else
	{
		return $this->_get_image_size_local($url);
	}

}

function _get_image_size_local($url)
{
	if ( !$url )  return array(0,0);

	if ( !is_writable($this->dir_temp) )
	{
		return array(0,0);
	}

	$data = $this->_read_file_remote( $url );
	if ( !$data )
	{
		return array(0,0); 
	}

	$file = tempnam($this->dir_temp, "image");

	$ret1 = $this->write_file( $file, $data );
	if ( !$ret1 )
	{
		return array(0,0);
	}

	$ret2 = $this->image->get_size($file);

	unlink($file);

	return $ret2;

}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function set_dir_temp($value='')
{
	$this->dir_temp = $value;
}


//=========================================================
// private function
//=========================================================
//---------------------------------------------------------
// open & close file
//---------------------------------------------------------
function open( $filename, $mode )
{
	$this->fp = '';

	$fp = fopen($filename, $mode);

	if ($fp)
	{
		$this->fp = $fp;
	}

	return $fp;
}

function close()
{
	if ( $this->fp )
	{
		fclose($this->fp);
	}
}

//---------------------------------------------------------
// read file
//---------------------------------------------------------
function _read_file_local( $filename )
{
	$fp = $this->open( $filename, "r" );
	if ( !$fp )
	{
		return false;
	}

	$content = $this->read();
	$this->close();

	return $content;
}

function read()
{
	if ( !$this->fp )  return false;

	$content = '';

	do 
	{
		$data = fread($this->fp, 8192);
		if ( strlen($data) == 0 )  break;
		$content .= $data;
	} while(true);

	return $content;
}

//---------------------------------------------------------
// write file
//---------------------------------------------------------
function write_file( $filename, $data )
{
	$fp = $this->open( $filename, "w" );
	if ( !$fp )
	{
		return false;
	}

	$ret = $this->write($data);
	$this->close();

	return $ret;
}

function write($data)
{
	return fwrite($this->fp, $data);
}

//=========================================================
// use class spoopy
//=========================================================
function _check_url_remote( $url )
{
	return $this->snoopy->fetch( $url );
}

function _read_file_remote( $url )
{

	if ( $this->snoopy->fetch( $url ) )
	{
		return $this->snoopy->results;
	}
	else
	{
		return false;
	}
}


//---------------------------------------------------------
}

?>
