<?php
// $Id: feed_list.php,v 1.6 2006/09/20 00:22:25 ohwada Exp $

// 2006-09-10 K.OHWADA
// Notice: Only variables should be assigned by reference

// 2006-07-10 K.OHWADA
// use happy_linux_page_frame happy_linux_strings etc
// BUG: pagenavi dont work with lid or link
//   add _get_script_asc() _get_script_desc()

// 2006-06-04 K.OHWADA
// change to contant RSSC_ROOT_PATH

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================

include 'admin_header.php';

//=========================================================
// class admin list feed
//=========================================================
class admin_list_feed extends happy_linux_page_frame
{

	var $_post;
	var $_strings;

// constant
	var $LIST_NORMAL = 0;
	var $LIST_LID    = 1;
	var $LIST_LINK   = 2;

// variable
	var $_mode_list = 0;
	var $_lid  = 0;
	var $_link = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_list_feed()
{
	$this->happy_linux_page_frame();

	$this->set_lang_no_item( _NO_RECORD );
	$this->set_lang_id_asc(  _AM_RSSC_ID_ASC );
	$this->set_lang_id_desc( _AM_RSSC_ID_DESC );
	$this->set_lang_there_are( _RSSC_THEREARE );

	$this->set_handler('feed', RSSC_DIRNAME);
	$this->set_id_name('fid');

	$this->set_lang_title( _AM_RSSC_LIST_FEED );
	$this->set_lang_submit_value( _DELETE );
	$this->set_submit_colspan(0, 2, 4);
	$this->set_flag_form(true);

	$this->set_form_name('rssc_feed');
	$this->set_action('feed_manage.php');
	$this->set_operation('del_all');

// class instance
	$this->_post    =& happy_linux_post::getInstance();
	$this->_strings =& happy_linux_strings::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_list_feed();
	}
	return $instance;
}


//---------------------------------------------------------
// Pre processing
//---------------------------------------------------------
function _init()
{
	$this->_mode_list = $this->LIST_NORMAL;

	if ( isset($_GET['lid']) )
	{
		$this->_mode_list = $this->LIST_LID;
		$this->_lid = $this->_post->get_get_int('lid');
	}
	elseif ( isset($_GET['link']) )
	{
		$this->_mode_list = $this->LIST_LINK;;
		$this->_link  = $this->_post->get_get('link');
	}
}

function _print_top_extra()
{
	switch ($this->_mode_list)
	{
		case $this->LIST_LID:
			$condition = 'lid = '.$this->_lid;
			break;

		case $this->LIST_LINK:
			$condition = 'link LIKE '.$this->_link;
			break;

		case $this->LIST_NORMAL:
		default:
			$condition = '';
			break;
	}

	if ( $condition )
	{
		$total = $this->_get_total();
		printf(_AM_RSSC_THERE_ARE_MATCH, $total);
		echo "<br />\n";
		echo _AM_RSSC_CONDITION.": ".$condition. "<br /><br />\n";
	}
}

function _get_total()
{
	switch ($this->_mode_list)
	{
		case $this->LIST_LID:
			$total = $this->_handler->get_count_by_lid($this->_lid);
			break;

		case $this->LIST_LINK:
			$total = $this->_handler->get_count_by_link($this->_link);
			break;

		case $this->LIST_NORMAL:
		default:
			$total = $this->_handler->getCount();
			break;
	}

	return $total;
}



//---------------------------------------------------------
// items
//---------------------------------------------------------
// Notice: Only variables should be assigned by reference
function _get_table_header()
{
	$checkbox = $this->build_form_js_checkall();

	$arr = array(
		$checkbox,
		_RSSC_FEED_ID,
		_RSSC_TITLE,
		_RSSC_SITE_TITLE,
		_RSSC_UPDATED,
		_RSSC_CONTENT,
	);

	return $arr;
}

function &_get_items($limit=0, $start=0)
{
	switch ($this->_mode_list)
	{
		case $this->LIST_LID:
			if ($this->_sortid == 1)
			{
				$objs =& $this->_handler->get_objects_by_lid_desc($this->_lid, $limit, $start);
			}
			else
			{
				$objs =& $this->_handler->get_objects_by_lid($this->_lid, $limit, $start);
			}
			break;

		case $this->LIST_LINK:
			if ($this->_sortid == 1)
			{
				$objs =& $this->_handler->get_objects_by_link_desc($this->_link, $limit, $start);
			}
			else
			{
				$objs =& $this->_handler->get_objects_by_link($this->_link, $limit, $start);
			}
			break;

		case $this->LIST_NORMAL:
		default:
			$objs =& $this->_get_handler_objs($limit, $start);
			break;
	}

	return $objs;
}

function &_get_cols(&$obj)
{
	$fid = $obj->getVar('fid');
	$checkbox = $this->build_form_js_checkbox($fid);

	$jump = 'feed_manage.php?op=mod_form&amp;fid=';

	$updated_unix = $obj->getVar('updated_unix', 'n');
	$content = $obj->getVar('content', 'n');

	formatTimestamp( $updated_unix, 'mysql');

	if ($content)
	{
		$content_html = $this->_strings->build_summary($content, 50, 's');
	}
	else
	{
		$content_html = '&nbsp;';
	}

	$url_view_fid = RSSC_URL."/single_feed.php?fid=".$fid;
	$url_text_gif = RSSC_URL."/images/text.gif";
	$img_link  = $this->build_html_img_tag($url_text_gif, 0, 0, 0, 'link');
	$view_feed = $this->build_html_a_href_name($url_view_fid, $img_link, '', false);
	$link_feed = $this->_build_page_id_link_by_obj( $obj, 'fid', $jump);

	$arr = array(
		$checkbox,
		$view_feed.'&nbsp;&nbsp;'.$link_feed,
		$this->_build_page_name_link_by_obj($obj, 'link',      'title',      '_blank'),
		$this->_build_page_name_link_by_obj($obj, 'site_link', 'site_title', '_blank'),
		formatTimestamp($updated_unix, 'mysql'),
		$content_html,
	);

	return $arr;
}

//---------------------------------------------------------
// script
//---------------------------------------------------------
function _get_script_asc()
{
	switch ($this->_mode_list)
	{
		case $this->LIST_LID:
		case $this->LIST_LINK:
			$script = $this->_get_script().'&amp;sortid=0';
			break;

		case $this->LIST_NORMAL:
		default:
			$script = $this->_get_script().'?sortid=0';
			break;
	}

	return $script;
}

function _get_script_desc()
{
	switch ($this->_mode_list)
	{
		case $this->LIST_LID:
		case $this->LIST_LINK:
			$script = $this->_get_script().'&amp;sortid=1';
			break;

		case $this->LIST_NORMAL:
		default:
			$script = $this->_get_script().'?sortid=1';
			break;
	}

	return $script;
}

function _get_script()
{
	$script = xoops_getenv('PHP_SELF');

	switch ($this->_mode_list)
	{
		case $this->LIST_LID:
			$script .= '?lid='.$this->_lid;
			break;

		case $this->LIST_LINK:
			$script .= '?link='.$this->_link;
			break;

		case $this->LIST_NORMAL:
		default:
			break;
	}

	return $script;
}

// --- class end ---
}

//=========================================================
// main
//=========================================================
xoops_cp_header();
rssc_admin_print_header();
rssc_admin_print_menu();

$list =& admin_list_feed::getInstance();
$list->_show();

xoops_cp_footer();
exit();
// --- end of main ---

?>