<?php
/*
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2002 Bharat Mediratta
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
?>
<?php
// Hack prevention.
if (!empty($HTTP_GET_VARS["GALLERY_BASEDIR"]) ||
		!empty($HTTP_POST_VARS["GALLERY_BASEDIR"]) ||
		!empty($HTTP_COOKIE_VARS["GALLERY_BASEDIR"])) {
	print "Security violation\n";
	exit;
}
?>
<?php require("./init.php"); ?>

<?php
/* Read the album list */
$albumDB = new AlbumDB(FALSE);
$gallery->session->albumName = "";
$page = 1;

/* If there are albums in our list, display them in the table */
$numAlbums = $albumDB->numAlbums($gallery->user);
$numPhotos = $albumDB->getCachedNumPhotos($gallery->user);

if (!$gallery->session->albumListPage) {
	$gallery->session->albumListPage = 1;
}
$perPage = $gallery->app->default["albumsPerPage"];
$maxPages = max(ceil($numAlbums / $perPage), 1);

if ($gallery->session->albumListPage > $maxPages) {
	$gallery->session->albumListPage = $maxPages;
}

$pixelImage = "<img src=\"$imageDir/pixel_trans.gif\" width=\"1\" height=\"1\">";
$borderColor = $gallery->app->default["bordercolor"];

$navigator["page"] = $gallery->session->albumListPage;
$navigator["pageVar"] = "set_albumListPage";
$navigator["url"] = makeGalleryUrl("albums.php");
$navigator["maxPages"] = $maxPages;
$navigator["spread"] = 6;
$navigator["fullWidth"] = 100;
$navigator["widthUnits"] = "%";
$navigator["bordercolor"] = $borderColor;

$xoopsOption['template_main'] = 'xoopsgallery_index.html';
include_once XOOPS_ROOT_PATH.'/header.php';
$xoopsTpl->assign('gallery_version', $gallery->version);

if (!strcmp($gallery->app->default["showSearchEngine"], "yes")) {
	$xoopsTpl->assign('show_search', true);
}

$adminText = "<span class=\"admin\">";
$adminText .= pluralize($numAlbums, "ĤΥХ", "");
$adminText .= ",&nbsp;" . pluralize($numPhotos, "ĤΥե", "");
$adminHasCommands = false;
if ($maxPages > 1) {
	$adminText .= " on " . pluralize($maxPages, "ڡ", "") . "&nbsp;";
}
$adminText .= "</span>";
$adminCommands = "<span class=\"admin\">";

/*
if ($gallery->user->isLoggedIn()) {
	$displayName = $gallery->user->getFullname();
	if (empty($displayName)) {
		$displayName = $gallery->user->getUsername();
	}
	$adminCommands .= "褦 $displayName  &nbsp;&nbsp;<br>";
}
*/

if ($gallery->user->canCreateAlbums()) { 
	$adminCommands .= "<a href=" . doCommand("new-album", array(), "view_album.php") . ">[Хο]</a>&nbsp;";
	$adminHasCommands = true;
}

if ($gallery->user->isAdmin()) {
	if ($gallery->userDB->canModifyUser() ||
	    $gallery->userDB->canCreateUser() ||
	    $gallery->userDB->canDeleteUser()) {
		$adminCommands .= '<a href="#" onClick="'.popup("manage_users.php").'">[manage users]</a>&nbsp;';
		$adminHasCommands = true;
	}
}

if ($gallery->user->isLoggedIn()) {
	if ($gallery->userDB->canModifyUser()) {
		$adminCommands .= '<a href="#" onClick="'.popup("user_preferences.php").'">[preferences]</a>&nbsp;';
		$adminHasCommands = true;
	}
	
	if (!$GALLERY_EMBEDDED_INSIDE) {
		$adminCommands .= "<a href=". doCommand("logout", array(), "albums.php"). ">[logout]</a>";
	}
} else {
	if (!$GALLERY_EMBEDDED_INSIDE) {
		$adminCommands .= '<a href="#" onClick="'.popup("login.php").'">[login]</a>';
	}
}

$adminCommands .= "</span>";
$xoopsTpl->assign('adminbox', $adminText.'&nbsp;'.$adminCommands.'&nbsp;');
$xoopsTpl->assign('adminHasCommands', $adminHasCommands);
ob_start();
include($GALLERY_BASEDIR . "layout/navigator.inc");
$xoopsTpl->assign('navbar', ob_get_contents());
ob_end_clean();

$warning = '';
/* Display warnings about broken albums */
if (sizeof($albumDB->brokenAlbums) && $gallery->user->isAdmin()) {
	
    $warning = '<table bordercolor="red" border="2" cellpadding="2" cellspacing="2"><tr><td align="center"><b><u>꡼Ԥ</u></b></center><br>꡼ϲΥǥ쥯ȥΤޤ:<br><br>';
    
    foreach ($albumDB->brokenAlbums as $tmpAlbumName) {
		$warning .= "$tmpAlbumName<br />";
    }
    $warning .= '<br>ʤΥХǥ쥯ȥˤ (' . $gallery->app->albumDir . ').<br>ʥХǤϤޤ󡣥Хǥ쥯ȥ꤫Ʋ</td></tr></table>';
}
$xoopsTpl->assign('broken_album_warnings', $warning);

$start = ($gallery->session->albumListPage - 1) * $perPage + 1;
$end = min($start + $perPage - 1, $numAlbums);

for ($i = $start; $i <= $end; $i++) {
	$editlink = $desc = $adminlink = $last_modified = $num_photos = $num_views = $num_views_since = $num_views_resetlink = $album_tree = '';
	$image = array();
	$gallery->album = $albumDB->getAlbum($gallery->user, $i);
	$isRoot = $gallery->album->isRoot(); // Only display album if it is a root album
	if($isRoot) {
		$owner = $gallery->album->getOwner();
        	$tmpAlbumName = $gallery->album->fields["name"];
        	$albumURL = makeAlbumUrl($tmpAlbumName);

      $gallery->html_wrap['borderColor'] = $borderColor;
      $gallery->html_wrap['borderWidth'] = 1;
      $gallery->html_wrap['pixelImage'] = $imageDir . "/pixel_trans.gif";
      $scaleTo = $gallery->app->highlight_size;
      $highlightIndex = $gallery->album->getHighlight();
      if (isset($highlightIndex)) {
	  list($image['width'], $image['height']) = $gallery->album->getThumbDimensions($highlightIndex, $scaleTo);
      } else {
	  $image['width'] = $gallery->app->highlight_size;
	  $image['height'] = 100;
      }
      $image['image'] = $gallery->album->getHighlightTag($scaleTo);
      $image['link'] = $albumURL;

	$editlink = '<a href="'.$albumURL.'">'.editField($gallery->album, "title", $edit).'</a>';
	$desc = editField($gallery->album, "description", $edit);

	if ($gallery->user->canDeleteAlbum($gallery->album)) {
    	$adminlink .= '<a href="#" onClick="'.popup("delete_album.php?set_albumName={$tmpAlbumName}").'">[Хκ]</a>';
   	}

	if ($gallery->user->canWriteToAlbum($gallery->album)) {
		$adminlink .= '<a href="#" onClick="'.popup("move_album.php?set_albumName={$tmpAlbumName}&index=$i").'">[Хΰư]</a><a href="#" onClick="'.popup("rename_album.php?set_albumName={$tmpAlbumName}&index=$i").'">[Хե̾ѹ]</a>';
	}

	if ($gallery->user->canChangeTextOfAlbum($gallery->album)) {
		$adminlink .= '<a href="'.makeGalleryUrl("captionator.php", array("set_albumName" => $tmpAlbumName)).'">[ФԽ]</a>';
	}

	if ($gallery->user->isAdmin() || $gallery->user->isOwnerOfAlbum($gallery->album)) {
		$adminlink .= '<a href="#" onClick="'.popup("album_permissions.php?set_albumName={$tmpAlbumName}").'">[]</a>';
		if ($gallery->album->versionOutOfDate()) {
	 		if ($gallery->user->isAdmin()) {
				$adminlink .= ': ΥХϸŤʤäƤޤ<a href="#" onClick="'.popup("upgrade_album.php").'">[Хι]</a>';
			}
		}
	}
	if (!($gallery->album->fields["display_clicks"] == "no")) {
		$num_views = $gallery->album->getClicks();
		$num_views_since = sprintf(_MD_GALLERY_SINCE, formatTimestamp($gallery->album->getClicksTime(), 'm'));
	}
	$albumName=$gallery->album->fields["name"];
	if ($gallery->user->canWriteToAlbum($gallery->album) && (!($gallery->album->fields["display_clicks"] == "no"))) {
		$num_views_resetlink = '<a href="#" onClick="'.popup("'" . doCommand("reset-album-clicks", array("set_albumName" => $albumName), "albums.php") . "'" , 1).'">[󥿤Υꥻå]</a>';
	}

	if (!strcmp($gallery->app->showAlbumTree, "yes")) {
		$album_tree = printChildren($albumName);
	}
} // if isRoot() close

	$xoopsTpl->append('albums', array('image' => $image, 'owner_id' => $owner->uid, 'owner_name' => $owner->username, 'editlink' => $editlink, 'album_desc' => $desc, 'adminlink' => $adminlink, 'last_modified' => formatTimestamp($gallery->album->getLastModificationTime(), 'm'), 'num_photos' => $gallery->album->numPhotos(0), 'num_views' => $num_views, 'num_views_since' => $num_views_since, 'num_views_resetlink' => $num_views_resetlink, 'albumtree' => $album_tree));

} // for() loop      
$xoopsTpl->assign('lang_lastupdate', _MD_GALLERY_LUPDATE);
$xoopsTpl->assign('lang_views', _MD_GALLERY_VIEWS);
$xoopsTpl->assign('lang_administration', _MD_GALLERY_ADMIN);
$xoopsTpl->assign('lang_items', _MD_GALLERY_ITEMS);
$xoopsTpl->assign('lang_description', _DESCRIPTION);
$xoopsTpl->assign('lang_owner', _MD_GALLERY_OWNER);
$xoopsTpl->assign('lang_subalbums', _MD_GALLERY_SUBALBUM);
include XOOPS_ROOT_PATH.'/footer.php';
?>