<?php
// $Id: convert_encoding.php,v 1.4 2006/11/18 18:19:04 ohwada Exp $

// 2006-11-18 K.OHWADA
// for happy_search
// add convert_array_to_utf8()

// 2006-09-10 K.OHWADA
// small change

// 2006-07-10 K.OHWADA
// this is new file
// porting from rssc_convert.php

//=========================================================
// Happy Linux Framework Module
// 2006-07-10 K.OHWADA
//=========================================================

//=========================================================
// class happy_linux_convert
//=========================================================
class happy_linux_convert_encoding
{
	var $_MAX_DEPTH = 10;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_convert_encoding()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new happy_linux_convert_encoding();
	}
	return $instance;
}

//=========================================================
// public function
//=========================================================
function &convert_array($arr, $to, $from)
{
	$ret = $this->_convert_array_recursive(0, $arr, $to, $from);
	return $ret;
}

function &convert_array_to_utf8($arr, $encoding=null)
{
	if ( empty($encoding) )
	{
		$encoding = _CHARSET;
	}

	$ret = $this->_convert_array_recursive(0, $arr, 'UTF-8', $encoding);
	return $ret;
}

function &convert_array_from_utf8($arr, $encoding=null)
{
	if ( empty($encoding) )
	{
		$encoding = _CHARSET;
	}

	$ret = $this->_convert_array_recursive(0, $arr, $encoding, 'UTF-8');
	return $ret;
}

function _convert_array_recursive($num, $arr_in, $to, $from)
{
	$num ++;
	if ( $num > $this->_MAX_DEPTH )
	{	return false;	}

	if ( is_array($arr_in) )
	{
		$arr_out = array();
		reset($arr_in);

		foreach ($arr_in as $k => $v) 
		{
			if ( is_array($v) )
			{
				$arr_out[$k] = $this->_convert_array_recursive($num, $v, $to, $from);
			}
			else
			{
				$arr_out[$k] = $this->convert($v, $to, $from);
			}
		}

		return $arr_out;
	}

	$ret = $this->convert($arr_in, $to, $from);
	return $ret;
}

//---------------------------------------------------------
// multibyte
//---------------------------------------------------------
function convert($str, $to, $from)
{
	if ( $to == $from )
	{
		return $str;
	}

	if ( function_exists('mb_convert_encoding') )
	{
		$str = mb_convert_encoding($str, $to, $from);
	}
	elseif ( strtolower($to) == 'utf-8' )
	{
		$str = utf8_encode($str);
	}
	elseif ( strtolower($from) == 'utf-8' )
	{
		$str = utf8_decode($str);
	}
	return $str;
}

function convert_to_utf8($str, $encoding=null)
{
	if ( empty($encoding) )
	{
		$encoding = _CHARSET;
	}

	if ( function_exists('mb_convert_encoding') )
	{
		$str = mb_convert_encoding($str, 'UTF-8', $encoding);
	}
	else
	{
		$str = utf8_encode($str);
	}
	return $str;
}

function convert_from_utf8($str, $encoding=null)
{
	if ( empty($encoding) )
	{
		$encoding = _CHARSET;
	}

	if ( function_exists('mb_convert_encoding') )
	{
		$str = mb_convert_encoding($str, $encoding, 'UTF-8');
	}
	else
	{
		$str = utf8_decode($str);
	}
	return $str;
}

function set_internal_encoding( $encoding='UTF-8' )
{
	if ( function_exists('mb_internal_encoding') )
	{
		mb_internal_encoding( $encoding );
	}
}

// --- class end ---
}

?>