<?php
// $Id: admin_config_class.php,v 1.4 2007/02/27 14:45:57 ohwada Exp $

// 2007-02-20 K.OHWADA
// renew config table
// print_forum_installed_by_conf()

// 2006-10-01 K.OHWADA
// use happy_linux
// use XoopsGTicket
// google map
// add renew_config() template_clear()

// 2006-05-15 K.OHWADA
// change for weblinks

//=========================================================
// WebLinks Module
// this file contain 2 class
//   admin_config_form
//   admin_config_store
// porting form RSSC 
// 2006-05-15 K.OHWADA
//================================================================

//================================================================
// class admin_config_form
//================================================================
class admin_config_form extends happy_linux_config_form
{
// handler
	var $_linkitem_form;
	var $_system;
	var $_plugin;

// local
	var $_line_count = 0;

	var $_MENU_STYLE = "background-color: #E6E6E6; padding: 5px; border: 1px solid silver; ";

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_config_form()
{
	$this->happy_linux_config_form();

	$define =& weblinks_config2_define::getInstance( WEBLINKS_DIRNAME );
	$this->set_config_handler('config2', WEBLINKS_DIRNAME, 'weblinks');
	$this->set_config_define( $define );

	$this->_linkitem_form  =& weblinks_linkitem_form::getInstance( WEBLINKS_DIRNAME );

	$this->_system =& happy_linux_system::getInstance();
	$this->_plugin =& weblinks_plugin::getInstance( WEBLINKS_DIRNAME );

// init
	$this->load();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_config_form();
	}

	return $instance;
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init_form()
{
	$this->load();
}

//---------------------------------------------------------
// print
//---------------------------------------------------------
function print_menu_2()
{
	echo "<h3>"._WEBLINKS_ADMIN_MODULE_CONFIG_2." ("._AM_WEBLINKS_MODULE_CONFIG_DESC_2.") </h3>\n";
	$this->_print_menu_list_2();

	echo "<h4>"._AM_WEBLINKS_MODULE_CONFIG_3." ("._AM_WEBLINKS_MODULE_CONFIG_DESC_3.") </h4>\n";
	$this->_print_menu_list_3();

	echo "<h4>"._AM_WEBLINKS_MODULE_CONFIG_4." ("._AM_WEBLINKS_MODULE_CONFIG_DESC_4.") </h4>\n";
	$this->_print_menu_list_4();
}

function print_menu_3()
{
	echo "<h3>"._AM_WEBLINKS_MODULE_CONFIG_3." ("._AM_WEBLINKS_MODULE_CONFIG_DESC_3.") </h3>\n";
	$this->_print_menu_list_3();

	echo "<h4>"._WEBLINKS_ADMIN_MODULE_CONFIG_2." ("._AM_WEBLINKS_MODULE_CONFIG_DESC_2.") </h4>\n";
	$this->_print_menu_list_2();

	echo "<h4>"._AM_WEBLINKS_MODULE_CONFIG_4." ("._AM_WEBLINKS_MODULE_CONFIG_DESC_4.") </h4>\n";
	$this->_print_menu_list_4();
}

function print_menu_4()
{
	echo "<h3>"._AM_WEBLINKS_MODULE_CONFIG_4." ("._AM_WEBLINKS_MODULE_CONFIG_DESC_4.") </h3>\n";
	$this->_print_menu_list_4();

	echo "<h4>"._WEBLINKS_ADMIN_MODULE_CONFIG_2." ("._AM_WEBLINKS_MODULE_CONFIG_DESC_2.") </h4>\n";
	$this->_print_menu_list_2();

	echo "<h4>"._AM_WEBLINKS_MODULE_CONFIG_3." ("._AM_WEBLINKS_MODULE_CONFIG_DESC_3.") </h4>\n";
	$this->_print_menu_list_3();

}

function _print_menu_list_2()
{
	echo '<div style="'.$this->_MENU_STYLE.'">';
	echo "<ul>\n";
	echo '<li><a href="index.php#form_auth">'._WEBLINKS_ADMIN_AUTH."</a></li>\n";
	echo '<li><a href="index.php#form_cat">'._WEBLINKS_ADMIN_CAT_SET."</a></li>\n";
	echo '<li><a href="index.php#form_view">'._AM_WEBLINKS_CONF_VIEW."</a></li>\n";
	echo '<li><a href="index.php#form_topten">'._AM_WEBLINKS_CONF_TOPTEN."</a></li>\n";
	echo '<li><a href="index.php#form_search">'._AM_WEBLINKS_CONF_SEARCH."</a></li>\n";
	echo '<li><a href="index.php#form_performance">'._AM_WEBLINKS_CONF_PERFORMANCE."</a></li>\n";
	echo '<li><a href="index.php#form_bin">'._AM_WEBLINKS_FORM_BIN."</a></li>\n";
	echo '<li><a href="index.php#form_template">'._AM_WEBLINKS_CONF_TEMPLATE."</a></li>\n";
	echo "</ul>\n";
	echo "</div>\n";
}

function _print_menu_list_3()
{
	echo '<div style="'.$this->_MENU_STYLE.'">';
	echo "<ul>\n";
	echo '<li><a href="config_manage_3.php#form_link_register">'._AM_WEBLINKS_LINK_REGISTER."</a></li>\n";
	echo '<li><a href="config_manage_3.php#form_link_register_1">'._AM_WEBLINKS_LINK_REGISTER_1."</a></li>\n";
	echo '<li><a href="config_manage_3.php#form_link_guest">'._AM_WEBLINKS_CONF_LINK_GUEST."</a></li>\n";
	echo '<li><a href="config_manage_3.php#form_post">'._WEBLINKS_ADMIN_POST."</a></li>\n";
	echo '<li><a href="config_manage_3.php#form_submit">'._AM_WEBLINKS_CONF_SUBMIT."</a></li>\n";
	echo '<li><a href="config_manage_3.php#form_link">'._AM_WEBLINKS_CONF_LINK."</a></li>\n";
	echo '<li><a href="config_manage_3.php#form_link_image">'._AM_WEBLINKS_CONF_LINK_IMAGE."</a></li>\n";
	echo "</ul>\n";
	echo "</div>\n";
}

function _print_menu_list_4()
{
	echo '<div style="'.$this->_MENU_STYLE.'">';
	echo "<ul>\n";
	echo '<li><a href="config_manage_4.php#form_rss">'._WEBLINKS_ADMIN_RSS."</a></li>\n";
	echo '<li><a href="config_manage_4.php#form_rss_view">'._WEBLINKS_ADMIN_RSS_VIEW."</a></li>\n";
	echo '<li><a href="config_manage_4.php#form_cat_forum">'._AM_WEBLINKS_CONF_CAT_FORUM."</a></li>\n";
	echo '<li><a href="config_manage_4.php#form_link_forum">'._AM_WEBLINKS_CONF_LINK_FORUM."</a></li>\n";
	echo '<li><a href="config_manage_4.php#form_locate">'._AM_WEBLINKS_CONF_LOCATE."</a></li>\n";
	echo '<li><a href="config_manage_4.php#form_map">'._AM_WEBLINKS_CONF_MAP."</a></li>\n";
	echo '<li><a href="config_manage_4.php#form_google_map">'._AM_WEBLINKS_CONF_GOOGLE_MAP."</a></li>\n";
	echo '<li><a href="config_manage_4.php#form_google_seach">'._AM_WEBLINKS_CONF_GOOGLE_SEARCH."</a></li>\n";
	echo "</ul>\n";
	echo "</div>\n";
}

//---------------------------------------------------------
// show_auth
//---------------------------------------------------------
function show_form_auth($form_title)
{
	list($list_1, $list_2) = $this->get_group_list();

	$this->print_top('weblinks_config_auth', $form_title);

	$this->print_auth('auth_submit',      $list_1);
	$this->print_auth('auth_submit_auto', $list_1);
	$this->print_auth('auth_modify',      $list_2);
	$this->print_auth('auth_modify_auto', $list_2);
	$this->print_auth('auth_ratelink',    $list_1);

	$this->print_yesno('use_ratelink');
	$this->print_yesno('system_post_rate');
	$this->print_yesno('system_post_link');
	$this->print_yesno('use_brokenlink');
	$this->print_yesno('use_hits');

	$this->print_form_bottom();
}

function show_form_link_register($form_title)
{
	list($list_1, $list_2) = $this->get_group_list();

	$this->print_top('weblinks_config_link_register', $form_title);

	$this->print_auth('auth_dohtml',   $list_1);
	$this->print_auth('auth_dosmiley', $list_1);
	$this->print_auth('auth_doxcode',  $list_1);
	$this->print_auth('auth_doimage',  $list_1);
	$this->print_auth('auth_dobr',     $list_1);
	$this->print_yesno('type_desc');

	$this->print_form_bottom();
}

function show_form_link_register_1($form_title)
{
	list($list_1, $list_2) = $this->get_group_list();

	$this->print_top('weblinks_config_link_register_1', $form_title);

	$this->print_auth('auth_dohtml_1',   $list_1);
	$this->print_auth('auth_dosmiley_1', $list_1);
	$this->print_auth('auth_doxcode_1',  $list_1);
	$this->print_auth('auth_doimage_1',  $list_1);
	$this->print_auth('auth_dobr_1',     $list_1);
	$this->print_yesno('type_desc_1');

	$this->print_form_bottom();
}

function get_group_list()
{
	$member_handler =& xoops_gethandler('member');
	$group_list = $member_handler->getGroupList();

	$list_1 = array();
	foreach ( $group_list as $k => $v )
	{
		$list_1[$v] = $k;
	}

	$list_2 = $list_1;
	$list_2[ _WEBLINKS_AUTH_UID ]    = WEBLINKS_ID_AUTH_UID;
	$list_2[ _WEBLINKS_AUTH_PASSWD ] = WEBLINKS_ID_AUTH_PASSWD;

	return array($list_1, $list_2);
}

function print_top($form_name, $form_title)
{
	echo $this->build_form_begin($form_name);
	echo $this->build_token();
	echo $this->build_html_input_hidden('op', 'save');

	echo "<table class='outer' width='100%' ><tr>";
	echo "<th align='left' colspan='2'>".$form_title."</th>";
	echo "</tr>\n";
}

function print_auth($name, $opt)
{
	$cap  = $this->build_conf_caption_by_name($name);

	$id    = $this->get_by_name($name, 'conf_id');
	$value = $this->get_by_name($name, 'value');
	$size  = count($opt);

	$show   = $this->build_html_select_multiple($name, $value, $opt, $size);
	$show  .= $this->build_conf_hidden($id);

	echo "<tr>";
	echo "<td class='head'>$cap</td>";
	echo "<td class='odd'>$show</td>";
	echo "</tr>\n";
}

function print_yesno($name)
{
	$cap  = $this->build_conf_caption_by_name($name);
	$show = $this->build_conf_radio_yesno_by_name($name);

	echo "<tr>";
	echo "<td class='head'>$cap</td>";
	echo "<td class='odd'>$show</td>";
	echo "</tr>\n";
}

function print_text($name)
{
	$cap  = $this->build_conf_caption_by_name($name);
	$show = $this->build_conf_textbox_by_name($name);

	echo "<tr>";
	echo "<td class='head'>$cap</td>";
	echo "<td class='odd'>$show</td>";
	echo "</tr>\n";
}

//---------------------------------------------------------
// show_form_linkitem
//---------------------------------------------------------
function show_form_linkitem( $title )
{
	$this->_linkitem_form->show( $title );
}

//---------------------------------------------------------
// show_country_code
//---------------------------------------------------------
function show_form_country_code( $title )
{
	$cap1  = $this->build_conf_caption_by_name('country_code');
	$show1 = $this->build_conf_textbox_by_name('country_code');
	$cap2  = $this->build_form_caption('', _AM_WEBLINKS_CONF_RENEW_COUNTRY_CODE_DESC);

	echo '<table class="outer" width="100%" ><tr>';
	echo '<th align="left" colspan="2">'.$title."</th>";
	echo "</tr>\n";
	echo '<tr><td class="head">'.$cap1."</td>\n";
	echo '<td class="odd">';
	echo $this->build_form_begin('country_code');
	echo $this->build_token();
	echo $this->build_html_input_hidden('op', 'save');
	echo $show1;
	echo "<br /><br />\n";
	echo $this->build_html_input_submit( 'submit', _WEBLINKS_UPDATE );
	echo $this->build_form_end();
	echo "</td></tr>\n";
	echo '<tr><td class="head">'.$cap2."</td>\n";
	echo '<td class="odd">';
	echo $this->build_form_begin('renew');
	echo $this->build_token();
	echo $this->build_html_input_hidden('op', 'renew');
	echo $this->build_html_input_submit('submit', _AM_WEBLINKS_RENEW );
	echo $this->build_form_end();
	echo "</td></tr></table>\n";
	echo "<br />\n";
}

//---------------------------------------------------------
// show_template
//---------------------------------------------------------
function show_form_template( $title )
{
	echo $this->build_form_begin('template_clear');
	echo $this->build_token();
	echo $this->build_html_input_hidden('op', 'template_clear');
	echo "<table class='outer' width='100%' ><tr>";
	echo "<th align='left'>".$title."</th>";
	echo "</tr>\n";
	echo "<tr class='foot'><td>";
	echo $this->build_html_input_submit( 'submit', _HAPPY_LINUX_CLEAR );
	echo "</td></tr></table>\n";
	echo $this->build_form_end();
	echo "<br />\n";
}

//---------------------------------------------------------
// print html
//---------------------------------------------------------
function print_form_bottom()
{
	echo "<tr class='foot' ><td></td><td colspan='3'>";
	echo $this->build_html_input_submit( 'submit', _WEBLINKS_UPDATE );
	echo "</td></tr></table>\n";
	echo $this->build_form_end();
	echo "<br />\n";
}

//---------------------------------------------------------
// print html
// not use in weblinks
//---------------------------------------------------------
function print_top2($form_name, $name1, $name2)
{
	echo $this->build_form_begin($form_name);
	echo $this->build_token();
	echo $this->build_html_input_hidden('op', 'save');

	echo "<table class='outer' width='100%' ><tr>";
	echo "<th align='center'>"._AM_RSSC_CONF_NAME."</th>";
	echo "<th align='center'>".$name1."</th>";
	echo "<th align='center'>".$name2."</th>";
	echo "</tr>\n";
}

function print_top3($form_name, $name1, $name2, $name3)
{
	echo $this->build_form_begin($form_name);
	echo $this->build_token();
	echo $this->build_html_input_hidden('op', 'save');

	echo "<table class='outer' width='100%' ><tr>";
	echo "<th align='center'>"._AM_RSSC_CONF_NAME."</th>";
	echo "<th align='center'>".$name1."</th>";
	echo "<th align='center'>".$name2."</th>";
	echo "<th align='center'>".$name3."</th>";
	echo "</tr>\n";
}

function print_form_even_odd()
{
	if ($this->_line_count % 2 == 0) 
	{
		$class = 'even';
	}
	else 
	{
		$class = 'odd';
	}

	$this->_line_count ++;

	echo "<tr class='$class'>";
}

function print_two($name1, $name2='')
{
	if ( $name1 )
	{
		$title_show = $this->build_conf_caption_by_name($name1);
	}
	else
	{
		$title_show = $this->build_conf_caption_by_name($name2);
	}

	$name1_show = $this->build_conf_textbox_by_name($name1);
	$name2_show = $this->build_conf_textbox_by_name($name2);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='right'>$name1_show</td>";
	echo "<td align='right'>$name2_show</td></tr>\n";

}

function print_three($name1, $name2='', $name3='')
{
	if ( $name1 )
	{
		$title_show = $this->build_conf_caption_by_name($name1);
	}
	elseif ( $name2 )
	{
		$title_show = $this->build_conf_caption_by_name($name2);
	}
	else
	{
		$title_show = $this->build_conf_caption_by_name($name3);
	}

	$name1_show = $this->build_conf_textbox_by_name($name1);
	$name2_show = $this->build_conf_textbox_by_name($name2);
	$name3_show = $this->build_conf_textbox_by_name($name3);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='right'>$name1_show</td>";
	echo "<td align='right'>$name2_show</td>";
	echo "<td align='right'>$name3_show</td></tr>\n";

}

function print_sel2($name1, $name2='')
{
	$title_show = $this->build_conf_caption_by_name($name1);
	$name1_show = $this->build_conf_radio_select_by_name($name1);
	$name2_show = $this->build_conf_radio_select_by_name($name2);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='left'>$name1_show</td>";
	echo "<td align='left'>$name2_show</td></tr>\n";

}

function print_sel3($name1, $name2='', $name3='')
{
	$title_show = $this->build_conf_caption_by_name($name1);
	$name1_show = $this->build_conf_radio_select_by_name($name1);
	$name2_show = $this->build_conf_radio_select_by_name($name2);
	$name3_show = $this->build_conf_radio_select_by_name($name3);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='left'>$name1_show</td>";
	echo "<td align='left'>$name2_show</td>";
	echo "<td align='left'>$name3_show</td></tr>\n";

}

function print_form_conf_checkbox($name)
{
	$this->print_form_even_odd();

	$name_show = $this->build_conf_yseno_checkbox_by_name($name);
	$this->print_conf_line($name, $name_show);
}

function print_form_conf_radio($name)
{
	$this->print_form_even_odd();

	$title_show = $this->build_conf_caption_by_name($name);
	$name_show  = $this->build_conf_radio_select_by_name($name);

	echo "<td></td><td>$title_show</td><td></td><td></td>";
	echo "<td align='left' colspan='2'>$name_show</td>";
	echo "<td></td></tr>\n";
}

function print_conf_line($name, $name1_show, $name2_show='')
{
	$title_show = $this->build_conf_caption_by_name($name);

	echo "<td></td><td>$title_show</td><td></td><td></td>";
	echo "<td align='right'>$name1_show</td><td></td>";
	echo "<td align='right'>$name2_show</td></tr>\n";
}

function print_msg($title)
{
	echo "<h4>$title</h4>\n";
}

function print_error($title, $msg)
{
	echo "<h3><font color='red'>$title</font></h3>\n";
	echo "$msg<br /><br />\n";
}

//---------------------------------------------------------
// forum
//---------------------------------------------------------
function print_forum_installed_by_conf($conf_name)
{
	$dirname = $this->_plugin->get_forum_sel_value_by_conf($conf_name, 'dirname');
	if ($dirname)
	{
		$module = $this->_system->get_module_by_dirname( $dirname );
		if ( is_object($module) )
		{
			$version = sprintf( "%6.2f", ($module->getVar('version')/100) );
			$msg = sprintf( _AM_WEBLINKS_FORUM_INSTALLED, $dirname, $version );
			echo '<h4 style="color: #0000ff;">'.$msg."</h4>\n";
		}
		else
		{
			$msg = sprintf( _AM_WEBLINKS_RSSC_NOT_INSTALLED, $dirname );
			xoops_error( $msg );
		}
	}
}

// --- class end ---
}


//================================================================
// class admin_config
//================================================================
class admin_config_store extends weblinks_config_check_handler
{
	var $_class_file;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_config_store()
{
	$this->weblinks_config_check_handler( WEBLINKS_DIRNAME );

	$this->_class_file = happy_linux_file::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_config_store();
	}

	return $instance;
}

//---------------------------------------------------------
// save config
//---------------------------------------------------------
function save_config()
{
	if ( isset($_POST['save_linkitem']) )
	{
		$ret = $this->_linkitem_store_handler->save();
		if ( !$ret )
		{
			$this->_set_errors( $this->_linkitem_store_handler->getErrors() );
		}
	}
	else
	{
		$ret = $this->_config_store_handler->save();
		if ( !$ret )
		{
			$this->_set_errors( $this->_config_store_handler->getErrors() );
		}
	}

	return $ret;
}

//---------------------------------------------------------
// renew config
//---------------------------------------------------------
function renew_config()
{
	$ret = $this->_config_store_handler->renew_by_country_code();
	if ( !$ret )
	{
		$this->_set_errors( $this->_config_store_handler->getErrors() );
	}
	return $ret;
}

//---------------------------------------------------------
// template clear
//---------------------------------------------------------
function template_clear()
{
	$ext = 'html';
	$dir1 = WEBLINKS_ROOT_PATH.'/templates/parts/';
	$dir2 = WEBLINKS_ROOT_PATH.'/templates/xml/';
	$dir3 = WEBLINKS_ROOT_PATH.'/templates/map/';

	$arr1 =& $this->_class_file->get_files_in_dir($dir1, $ext, true);
	$arr2 =& $this->_class_file->get_files_in_dir($dir2, $ext, true);
	$arr3 =& $this->_class_file->get_files_in_dir($dir3, $ext, true);

	$arr = array_merge($arr1, $arr2, $arr3);

	foreach ($arr as $template)
	{
		$this->_clear_template( $template );
	}
}

function _clear_template( $template )
{
	$tpl = new XoopsTpl();
	$tpl->clear_compiled_tpl( $template );
}

// --- class end ---
}

?>