<?php
// $Id: test_form_user_modify_link.php,v 1.4 2007/03/06 02:01:51 ohwada Exp $

// 2007-03-01 K.OHWADA
// performance mode

//=========================================================
// WebLinks Module
// 2006-09-20 K.OHWADA
//=========================================================

//---------------------------------------------------------
// test parameter
//---------------------------------------------------------

$LID = 0;

//---------------------------------------------------------

include_once 'dev_header.php';
include_once 'test_form_class.php';

$is_link_owner = false;

$test =& weblinks_test_form::getInstance();

dev_header();
echo "<h3>test form: user modify link</h3>\n";

if ( isset($_POST['lid']) && intval($_POST['lid']) )
{
	$LID = intval($_POST['lid']);
}
else
{
	echo '<form method="post">';
	echo 'lid <input type="text" name="lid"> ';
	echo '<input type="submit" name="submit">';
	echo '</form>';
	dev_footer();
}

echo "lid: <b>". $LID ."</b> <br />\n";

if ( $test->is_link_owner($LID) )
{
	$is_link_owner = true;
	echo "user: <b>".$test->get_user_uname()."</b> is owner <br />\n";
}
else
{
	echo "user: <b>".$test->get_user_uname()."</b> is not owner <br />\n";
}

$link_url  = WEBLINKS_URL.'/modlink.php';
$list_url  = WEBLINKS_URL.'/admin/link_list.php?sortid=0';

$ret = $test->login_user();
if ( !$ret )
{
	dev_footer();
}

//---------------------------------------------------------
// not permit
//---------------------------------------------------------
echo "<h4>scenario 1: not permit</h4>\n";

$test->update_config_by_name( 'cat_path',  0 );
$test->update_config_by_name( 'cat_count', 0 );
$test->update_config_by_name_array( 'auth_modify',      array(1) );
$test->update_config_by_name_array( 'auth_modify_auto', array(1) );

$link_form_url = $link_url.'?lid='.$LID;
$ret = $test->fetch( $link_form_url );
if ( !$ret )
{
	dev_footer();
}

if ( $test->match_return_msg( 'not permit' ) )
{
	echo "<h4>Test OK !</h4>\n";
}
else
{
	echo "Error: test failed to fetch modify form <br />\n";
	$test->print_body( true );
	dev_footer();
}

//---------------------------------------------------------
// permit for registered user
//---------------------------------------------------------
echo "<h4>scenario 2: permit for registered user</h4>\n";

$test->update_config_by_name_array( 'auth_modify',      array(1,2) );

$title    = 'req_'.$test->get_randum_title();
$banner   = $test->get_randum_banner( 0 );
$rss_url  = WEBLINKS_URL.'/dev/rss_4.xml';
$rss_flag = 2;	// rss

$ret = $test->user_modify_link( $LID, $title, $banner, $rss_flag, $rss_url );
if ( !$ret )
{
	dev_footer();
}

if ( $test->match_return_msg( 'modify request link' ) )
{
	echo "<h4>Success !</h4>\n";
	echo "modify link: ".$title." <br /><br />\n";
}
else
{
	echo "Error: modify link form failed: <br />\n";
	$test->print_body( true );
	dev_footer();
}

//---------------------------------------------------------
// permit & approve for owner
//---------------------------------------------------------
echo "<h4>scenario 3: permit and approve for owner: no banner, no perfomance, no rss</h4>\n";

$test->update_config_by_name_array( 'auth_modify',      array(1, WEBLINKS_ID_AUTH_UID) );
$test->update_config_by_name_array( 'auth_modify_auto', array(1, WEBLINKS_ID_AUTH_UID) );

$title    = 'mod_'.$test->get_randum_title();
$banner   = '';
$rss_url  = WEBLINKS_URL.'/dev/rss_4.xml';
$rss_flag = 0;

$flag_ok = false;

if ( $is_link_owner )
{
	$ret = $test->user_modify_link( $LID, $title, $banner, $rss_flag, $rss_url );
	if ( !$ret )
	{
		dev_footer();
	}

	if ( $test->match_return_msg( 'modify approve link' ) )
	{
		$flag_ok = true;
		echo "<h4>Success !</h4>\n";
		echo "modify link: ".$title." <br /><br />\n";
	}
}
else
{
	$link_form_url = $link_url.'?lid='.$LID;
	$ret = $test->fetch( $link_form_url );
	if ( !$ret )
	{
		dev_footer();
	}

	if ( $test->match_return_msg( 'not permit' ) )
	{
		$flag_ok = true;
		echo "<h4>Test OK !</h4>\n";
	}
}

if ( !$flag_ok )
{
	echo "Error: modify link form failed: <br />\n";
	$test->print_body( true );
	dev_footer();
}


//---------------------------------------------------------
// permit & approve for owner
//---------------------------------------------------------
echo "<h4>scenario 4: permit and approve for owner: banner, perfomance, rss</h4>\n";

$test->update_config_by_name( 'cat_count', 1 );

$title    = 'mod_'.$test->get_randum_title();
$banner   = $test->get_randum_banner( 0 );
$rss_url  = WEBLINKS_URL.'/dev/rss_4.xml';
$rss_flag = 2;	// rss

$flag_ok = false;

if ( $is_link_owner )
{
	$ret = $test->user_modify_link( $LID, $title, $banner, $rss_flag, $rss_url );
	if ( !$ret )
	{
		dev_footer();
	}

	if ( $test->match_return_msg( 'modify approve link' ) )
	{
		$flag_ok = true;
		echo "<h4>Success !</h4>\n";
		echo "modify link: ".$title." <br /><br />\n";
	}
}
else
{
	$link_form_url = $link_url.'?lid='.$LID;
	$ret = $test->fetch( $link_form_url );
	if ( !$ret )
	{
		dev_footer();
	}

	if ( $test->match_return_msg( 'not permit' ) )
	{
		$flag_ok = true;
		echo "<h4>Test OK !</h4>\n";
	}
}

if ( !$flag_ok )
{
	echo "Error: modify link form failed: <br />\n";
	$test->print_body( true );
	dev_footer();
}

//---------------------------------------------------------
// permit & approve for owner
//---------------------------------------------------------
echo "<h4>scenario 5: permit and approve for owner: not owner</h4>\n";

$ret = $test->login_not_owner();
if ( !$ret )
{
	dev_footer();
}

$title    = 'mod_'.$test->get_randum_title();
$banner   = $test->get_randum_banner( 0 );
$rss_url  = WEBLINKS_URL.'/dev/rss_4.xml';
$rss_flag = 2;	// rss

$flag_ok = false;

if ( !$test->is_not_link_owner($LID) )
{
	$ret = $test->user_modify_link( $LID, $title, $banner, $rss_flag, $rss_url );
	if ( !$ret )
	{
		dev_footer();
	}

	if ( $test->match_return_msg( 'modify approve link' ) )
	{
		$flag_ok = true;
		echo "<h4>Success !</h4>\n";
		echo "modify link: ".$title." <br /><br />\n";
	}
}
else
{
	$link_form_url = $link_url.'?lid='.$LID;
	$ret = $test->fetch( $link_form_url );
	if ( !$ret )
	{
		dev_footer();
	}

	if ( $test->match_return_msg( 'not permit' ) )
	{
		$flag_ok = true;
		echo "<h4>Test OK !</h4>\n";
	}
}

if ( !$flag_ok )
{
	echo "Error: modify link form failed: <br />\n";
	$test->print_body( true );
	dev_footer();
}

echo '<a href="'.$list_url.'" target="_blank" >goto link list</a>'."<br />\n";
dev_footer();
// --- end of main ---

?>