<?php
// $Id: block_latest.php,v 1.9 2007/01/19 00:44:58 ohwada Exp $

// 2007-01-19 K.OHWADA
// b_rssc_shoten_text -> b_rssc_shorten_text
// clean up space

// 2006-12-02 K.OHWADA
// assign updated_unix and all

// 2006-10-26 K.OHWADA
// assign fid

// 2006-09-20 K.OHWADA
// show blog

// 2006-07-08 K.OHWADA
// corresponding to podcast
// add enclosure

// 2006-06-04 K.OHWADA
// assign site_title site_url

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// --- block function begin ---
if( !function_exists( 'b_rssc_show_latest' ) ) 
{

//---------------------------------------------------------
// show latest feeds
// $options
// [0] module directory name (rssc)
//---------------------------------------------------------
function b_rssc_show_latest( $options )
{
	global $xoopsDB;

	$DIRNAME = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0] ;

	$table_feed = $xoopsDB->prefix( $DIRNAME.'_feed' );

	$block = array();
	$block['lang_more'] = _BL_RSSC_MORE;
	$block['dirname']   = $DIRNAME;

// podcast
	$block['lang_podcast'] = _BL_RSSC_PODCAST;
	$block['unit_kb']      =  BL_RSSC_UNIT_KB;

// config data
	$conf_data = b_rssc_get_conf( $DIRNAME );
	if ( !$conf_data )
	{
		return $block;
	}

	$limit       = $conf_data['block_latest_perpage'];
	$max_title   = $conf_data['block_latest_max_title'];
	$max_summary = $conf_data['block_latest_max_summary'];
	$max_content = $conf_data['block_latest_max_content'];
	$num_content = $conf_data['block_latest_num_content'];

	$order  = b_rssc_get_order(  $conf_data['block_latest_order'] );
	$future = b_rssc_get_future( $conf_data['basic_future_days'] );

// feed data
	$sql  = 'SELECT * FROM '.$table_feed;
	$sql .= ' WHERE updated_unix <'.$future;
	$sql .= ' AND published_unix <'.$future;
	$sql .= ' ORDER BY '.$order;

	$res = $xoopsDB->query($sql, $limit, 0);
	if ( !$res )
	{
		return $block;
	}

	$feeds = array();

	while ($row = $xoopsDB->fetchArray($res)) 
	{
		$feeds[] = b_rssc_make_feed($row, $max_title, $max_summary, $max_content);
	}

	$block['feeds']       = $feeds;
	$block['num_content'] = $num_content;

	return $block;
}

//---------------------------------------------------------
// show headline
// $options
// [0] module directory name (rssc)
//---------------------------------------------------------
function b_rssc_show_headline( $options )
{
	global $xoopsDB;

	$DIRNAME = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0] ;

	$table_link   = $xoopsDB->prefix( $DIRNAME.'_link' );
	$table_feed   = $xoopsDB->prefix( $DIRNAME.'_feed' );

	$block = array();
	$block['lang_more'] = _BL_RSSC_MORE;
	$block['dirname']   = $DIRNAME;

// podcast
	$block['lang_podcast'] = _BL_RSSC_PODCAST;
	$block['unit_kb']      =  BL_RSSC_UNIT_KB;

// config data
	$conf_data = b_rssc_get_conf( $DIRNAME );
	if ( !$conf_data )
	{
		return $block;
	}

	$link_limit  = $conf_data['block_headline_links_perpage'];
	$limit       = $conf_data['block_headline_feeds_perlink'];
	$max_title   = $conf_data['block_headline_max_title'];
	$max_summary = $conf_data['block_headline_max_summary'];
	$max_content = $conf_data['block_headline_max_content'];
	$num_content = $conf_data['block_headline_num_content'];

	$order  = b_rssc_get_order(  $conf_data['block_headline_order'] );
	$future = b_rssc_get_future( $conf_data['basic_future_days'] );

// link data
	$sql1 = 'SELECT * FROM '.$table_link.' WHERE headline > 0 ORDER BY headline ASC';

	$res1 = $xoopsDB->query($sql1, $link_limit, 0);
	if ( !$res1 )
	{
		return  $block;
	}

	$links = array();

	while ($row1 = $xoopsDB->fetchArray($res1)) 
	{
		$lid = intval( $row1['lid'] );

		$link = array();
		$link['lid']   = $lid;
		$link['url']   = b_rssc_sanitize_url(  $row1['url'] );
		$link['title'] = b_rssc_sanitize_text( $row1['title'] );

// feed data
		$sql2  = 'SELECT * FROM '.$table_feed;
		$sql2 .= ' WHERE lid='.$lid;
		$sql2 .= ' AND updated_unix <'.  $future;
		$sql2 .= ' AND published_unix <'.$future;
		$sql2 .= ' ORDER BY '.$order;

		$res2 = $xoopsDB->query($sql2, $limit, 0);
		$feeds = array();

		while ($row2 = $xoopsDB->fetchArray($res2)) 
		{
			$feeds[] = b_rssc_make_feed($row2, $max_title, $max_summary, $max_content);
		}

		$link['feeds'] = $feeds;
		$links[] = $link;
	}

	$block['links']       = $links;
	$block['num_content'] = $num_content;

	return $block;
}

//---------------------------------------------------------
// show blog
// $options
// [0] module directory name (rssc)
//---------------------------------------------------------
function b_rssc_show_blog( $options )
{
	global $xoopsDB;

	$DIRNAME = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0] ;

	$table_feed = $xoopsDB->prefix( $DIRNAME.'_feed' );

	$block = array();
	$block['dirname'] = $DIRNAME;

// podcast
	$block['lang_podcast'] = _BL_RSSC_PODCAST;
	$block['unit_kb']      =  BL_RSSC_UNIT_KB;

// config data
	$conf_data = b_rssc_get_conf( $DIRNAME );
	if ( !$conf_data )
	{
		return $block;
	}

	$lid         = $conf_data['block_blog_lid'];
	$limit       = $conf_data['block_blog_perpage'];
	$max_title   = $conf_data['block_blog_max_title'];
	$max_summary = $conf_data['block_blog_max_summary'];
	$max_content = $conf_data['block_blog_max_content'];
	$num_content = $conf_data['block_blog_num_content'];

	$future = b_rssc_get_future( $conf_data['basic_future_days'] );
	$order  = b_rssc_get_order(  $conf_data['block_blog_order'] );

// no link id
	if ($lid == 0)
	{
		$block['feed_show']  = false;
		$block['lang_error'] = _BL_RSSC_NO_LINK_ID;
		return $block;
	}

// feed data
	$sql  = 'SELECT * FROM '.$table_feed;
	$sql .= ' WHERE lid='.intval($lid);
	$sql .= ' AND updated_unix <'.  $future;
	$sql .= ' AND published_unix <'.$future;
	$sql .= ' ORDER BY '.$order;

	$res   = $xoopsDB->query($sql, $limit, 0);
	$feeds = array();

	while ($row = $xoopsDB->fetchArray($res)) 
	{
		$feeds[] = b_rssc_make_feed($row, $max_title, $max_summary, $max_content);
	}

	$site_title = '---';
	$site_link  = '';

	if ( count($feeds) )
	{
		if ( isset($feeds[0]['site_title']) )
		{
			$site_title = $feeds[0]['site_title'];
		}
		if ( isset($feeds[0]['site_link']) )
		{
			$site_link = $feeds[0]['site_link'];
		}
	}
	else
	{
		$block['feed_show']  = false;
		$block['lang_error'] = _BL_RSSC_NO_FEED;
		return $block;
	}

	$block['feed_show']   = true;
	$block['site_title']  = $site_title;
	$block['site_link']   = $site_link;
	$block['feeds']       = $feeds;
	$block['num_content'] = $num_content;

	return $block;
}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function b_rssc_get_conf( $DIRNAME )
{
	global $xoopsDB;
	$table_config = $xoopsDB->prefix( $DIRNAME.'_config' );

// config data
	$conf = array();

	$sql = 'SELECT * FROM '.$table_config.' ORDER BY conf_id ASC';

	$res = $xoopsDB->query($sql, 0, 0);
	if ( !$res )
	{
		return false;
	}

	while ($row = $xoopsDB->fetchArray($res)) 
	{
		$conf[ $row['conf_name'] ] = $row['conf_value'];
	}

	return $conf;
}

function b_rssc_get_future($value)
{
	$time = time() + 86400 * intval($value);	// days
	return $time;
}

function b_rssc_get_order($value)
{
	switch ( $value )
	{
		case 1:
			$order = 'published_unix DESC, fid DESC';
			break;

		case 0:
		default:
			$order = 'updated_unix DESC, fid DESC';
			break;
	}

	return $order;
}

function b_rssc_make_feed($row, $max_title, $max_summary, $max_content)
{
	$site_title     = $row['site_title'];
	$title          = $row['title'];
	$content        = $row['content'];
	$published_unix = intval( $row['published_unix'] );
	$updated_unix   = intval( $row['updated_unix'] );

	$site_title = strip_tags( $site_title );
	$site_title = b_rssc_shorten_text($site_title, $max_title);
	$site_title = b_substitute_title($site_title);

	$title = strip_tags( $title );
	$title = b_rssc_shorten_text($title, $max_title);
	$title = b_substitute_title($title);

	$cont = str_replace(">",   "> ", $content);
	$cont = strip_tags( $cont );

	$summary = b_rssc_shorten_text($cont, $max_summary);

// unlimit , when $max_content = -1
	if ( $max_content == 0 )
	{
		$content = '';
	}
	elseif ( $max_content > 0 )
	{
		if ( strlen($content) > $max_content )
		{
			$content = b_rssc_shorten_text($cont, $max_content);
		}
	}

	$feed = array();
	$feed['fid']  = intval( $row['fid'] );
	$feed['lid']  = intval( $row['lid'] );
	$feed['uid']  = intval( $row['uid'] );
	$feed['mid']  = intval( $row['mid'] );
	$feed['p1']   = intval( $row['p1'] );
	$feed['p2']   = intval( $row['p2'] );
	$feed['p3']   = intval( $row['p3'] );

	$feed['site_link']    = b_rssc_sanitize_url(  $row['site_link'] );
	$feed['link']         = b_rssc_sanitize_url(  $row['link'] );
	$feed['author_uri']   = b_rssc_sanitize_text( $row['author_uri'] );
	$feed['site_title']   = b_rssc_sanitize_text( $site_title );
	$feed['title']        = b_rssc_sanitize_text( $title );
	$feed['summary']      = b_rssc_sanitize_text( $summary );
	$feed['entry_id']     = b_rssc_sanitize_text( $row['entry_id'] );
	$feed['guid']         = b_rssc_sanitize_text( $row['guid'] );
	$feed['category']     = b_rssc_sanitize_text( $row['category'] );
	$feed['author_name']  = b_rssc_sanitize_text( $row['author_name'] );
	$feed['author_email'] = b_rssc_sanitize_text( $row['author_email'] );
	$feed['type_cont']    = b_rssc_sanitize_text( $row['type_cont'] );
	$feed['content']      = $content;

	$feed['published_unix'] = $published_unix;
	$feed['updated_unix']   = $updated_unix;
	$feed['updated_long']   = formatTimestamp( $updated_unix, 'l' );
	$feed['updated_short']  = formatTimestamp( $updated_unix, 's' );
	$feed['updated_mysql']  = formatTimestamp( $updated_unix, 'mysql' );

// enclosure
	$feed['enclosure_url']    = b_rssc_sanitize_url(  $row['enclosure_url'] );
	$feed['enclosure_type']   = b_rssc_sanitize_text( $row['enclosure_type'] );
	$feed['enclosure_length']    = intval( $row['enclosure_length'] );
	$feed['enclosure_length_kb'] = intval( $row['enclosure_length']/1024 );

	return $feed;
}

function b_rssc_shorten_text($text, $max)
{
// clean up space
	$text = preg_replace("/\t/",' ',$text);
	$text = preg_replace("/\n/",' ',$text);
	$text = preg_replace("/\r/",' ',$text);
	$text = preg_replace("/&nbsp;/i", ' ', $text);
	$text = preg_replace("/[\x20]+/", ' ', $text);

// nothing, if zero
	if ($max == 0)
	{
		return '';
	}

// unlimited, if minus
	if ($max < 0)
	{
		return $text;
	}

// less than
	if ( strlen($text) <= $max)
	{
		return $text;
	}

// for multibyte environment
	if (function_exists('mb_strcut'))
	{
	// cut strings for multibayte byte length
		$text = mb_strcut( $text, 0, $max )." ...";
	}
	else
	{
		$text = substr( $text, 0, $max )." ...";
	}

	return $text;
}

function b_substitute_title($str)
{
	$val = preg_replace('/[\x00-\x20]/', '', $str);
	$val = preg_replace('/[\x7F]/',      '', $val);

	if ( strlen($val) > 0 )
	{
		return $str;
	}

	return "---";
}

function b_rssc_sanitize_url($str)
{
	$str = preg_replace('/&amp;/i', '&', $str);
	$str = htmlspecialchars($str,   ENT_QUOTES);
	return $str;
}

function b_rssc_sanitize_text($str)
{
	$str = htmlspecialchars($str,   ENT_QUOTES);
	$str = preg_replace('/&amp;/i', '&', $str);
	return $str;
}

// --- block function begin end ---
}

?>