<?php
// $Id: rssc_feed_handler.php,v 1.8 2006/09/11 07:59:27 ohwada Exp $

// 2006-09-01 K.OHWADA
// add get_objects_latest()   : remove get_latest()
// add get_objects_by_where() : remove get_feeds_by_where()
// add get_count_by_mid() get_objects_by_mid_order()
// remove get_feed_by_fid() get_feeds_by_lid()

// 2006-07-10 K.OHWADA
// use happy_linux_object happy_linux_object_handler
// use happy_linux_strings
// support podcast

// 2006-06-29 K.OHWADA
// get_objects_by_lid_desc
// get_objects_by_link_desc

// 2006-01-20 K.OHWADA
// small change

//=========================================================
// Rss Center Module
// class feed
// this file contain 2 class
//   rssc_feed
//   rssc_feed_handler
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_feed_hnadler') ) 
{

//=========================================================
// class feed
//=========================================================

class rssc_feed extends happy_linux_object
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_feed()
{
	$this->happy_linux_object();

	$this->initVar('fid', XOBJ_DTYPE_INT, null, false);
	$this->initVar('lid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('uid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('p1',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('p2',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('p3',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('site_title', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('site_link',  XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('title', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('link',  XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('entry_id', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('guid',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('updated_unix',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('published_unix', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('category',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('author_name',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('author_uri',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('author_email', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('type_cont',    XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('raws',    XOBJ_DTYPE_TXTAREA);
	$this->initVar('content', XOBJ_DTYPE_TXTAREA);
	$this->initVar('search',  XOBJ_DTYPE_TXTAREA);
	$this->initVar('aux_int_1',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_int_2',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_text_1', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('aux_text_2', XOBJ_DTYPE_TXTBOX, null, false, 255);

// enclosure
	$this->initVar('enclosure_url',    XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('enclosure_type',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('enclosure_length', XOBJ_DTYPE_INT, 0);
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function &getVarAll($format='n')
{
	$arr = array(
		'fid' => $this->getVar('fid', $format),
		'lid' => $this->getVar('lid', $format),
		'uid' => $this->getVar('uid', $format),
		'mid' => $this->getVar('mid', $format),
		'p1'  => $this->getVar('p1', $format),
		'p2'  => $this->getVar('p2', $format),
		'p3'  => $this->getVar('p3', $format),
		'site_title' => $this->getVar('site_title', $format),
		'site_link'  => $this->getVar('site_link',  $format),
		'title'      => $this->getVar('title', $format),
		'link'       => $this->getVar('link',  $format),
		'entry_id'   => $this->getVar('entry_id', $format),
		'guid'       => $this->getVar('guid', $format),
		'category'   => $this->getVar('category', $format),
		'author_name'  => $this->getVar('author_name', $format),
		'author_uri'   => $this->getVar('author_uri',  $format),
		'author_email' => $this->getVar('author_email',$format), 
		'type_cont'    => $this->getVar('type_cont',   $format), 
		'updated_unix'   => $this->getVar('updated_unix',   $format),
		'published_unix' => $this->getVar('published_unix', $format),
		'content'        => $this->getVar('content', $format),
		'search'         => $this->getVar('search',  $format),
		'raws'           => $this->get_export_raws(),

// enclosure
		'enclosure_url'       => $this->getVar( 'enclosure_url',    $format ),
		'enclosure_type'      => $this->getVar( 'enclosure_type',   $format ),
		'enclosure_length'    => $this->getVar( 'enclosure_length', $format ),
		'enclosure_length_kb' => $this->get_enclosure_length_kb(),
	);


	return $arr;
}

function set_search()
{
	$search = $this->get('title').' '.$this->get('content');
	$search = $this->strip_control($search);
	$search = $this->strip_style_tag($search);
	$search = $this->add_space_after_tag($search);
	$search = strip_tags($search);

	$this->setVar('search', $search, true);
}

function set_raws($item)
{
// atom
	if ( isset($item['atom_content']) )
	{
		$item['atom_content'] = '';
	}

	if ( isset($item['content']) )
	{
		$item['content'] = '';
	}

	$raws = serialize($item);
	$this->set('raws', $raws);
}

function get_raws()
{
	$ret  = false;
	$raws = $this->get('raws');
	if ( is_array($raws) )
	{
		$ret = unserialize($raws);
	}
	return $ret;
}

function &get_export_raws()
{
	$raws = $this->get_raws();
	$text = var_export($raws, TRUE);
	$ret  = htmlspecialchars($text, ENT_QUOTES);
	return $ret;
}

function &get_enclosure_length_kb()
{
	$length = $this->get( 'enclosure_length' );
	$kb = intval( $length/1024 );
	return $kb;
}

function &get_feed_and_raws()
{
	$feed_arr = $this->getVarAll();
	$raw_arr  = $this->get_raws();

	if ( !$raw_arr )
	{
		return $feed_arr;
	}

	$feed_new = $feed_arr;

// over write
	foreach ($raw_arr as $key => $value)
	{
		if (($key == 'content')||($key == 'encoded'))
		{
			$feed_new[$key] = $feed_arr['content'];
		}
		else
		{
			$feed_new[$key] = $value;
		}
	}

	return $feed_new;
}

// --- class end ---
}

//=========================================================
// class feed handler
//=========================================================
class rssc_feed_handler extends happy_linux_object_handler
{

// class
	var $_strings;

// input parameter
	var $_future_days = 3;	// 3 days

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_feed_handler( $dirname )
{
	$this->happy_linux_object_handler($dirname, 'feed', 'fid', 'rssc_feed');

	$this->set_debug_db_sql(   RSSC_DEBUG_FEED_SQL );
	$this->set_debug_db_error( RSSC_DEBUG_ERROR );

// class
	$this->_strings =& happy_linux_strings::getInstance();
}

//=========================================================
// Public
//=========================================================
//---------------------------------------------------------
// basic function
//---------------------------------------------------------

// for future
// now, admin cannot add feed record
function _build_insert_sql(&$obj)
{
	foreach ($obj->gets() as $k => $v) 
	{	${$k} = $v;	}

	$sql  = 'INSERT INTO '.$this->_table.' (';
	$sql .= 'lid, ';
	$sql .= 'uid, ';
	$sql .= 'mid, ';
	$sql .= 'p1, ';
	$sql .= 'p2, ';
	$sql .= 'p3, ';
	$sql .= 'site_title, ';
	$sql .= 'site_link, ';
	$sql .= 'title, ';
	$sql .= 'link, ';
	$sql .= 'entry_id, ';
	$sql .= 'guid, ';
	$sql .= 'updated_unix, ';
	$sql .= 'published_unix, ';
	$sql .= 'category, ';
	$sql .= 'author_name, ';
	$sql .= 'author_uri, ';
	$sql .= 'author_email, ';
	$sql .= 'type_cont, ';
	$sql .= 'raws, ';
	$sql .= 'content, ';
	$sql .= 'search, ';
	$sql .= 'aux_int_1, ';
	$sql .= 'aux_int_2, ';
	$sql .= 'aux_text_1, ';
	$sql .= 'aux_text_2, ';

// enclosure
	$sql .= 'enclosure_url, ';
	$sql .= 'enclosure_type, ';
	$sql .= 'enclosure_length ';

	$sql .= ') VALUES (';
	$sql .= intval($lid).', ';
	$sql .= intval($uid).', ';
	$sql .= intval($mid).', ';
	$sql .= intval($p1).', ';
	$sql .= intval($p2).', ';
	$sql .= intval($p3).', ';
	$sql .= $this->quote($site_title).', ';
	$sql .= $this->quote($site_link).', ';
	$sql .= $this->quote($title).', ';
	$sql .= $this->quote($link).', ';
	$sql .= $this->quote($entry_id).', ';
	$sql .= $this->quote($guid).', ';
	$sql .= intval($updated_unix).', ';
	$sql .= intval($published_unix).', ';
	$sql .= $this->quote($category).', ';
	$sql .= $this->quote($author_name).', ';
	$sql .= $this->quote($author_uri).', ';
	$sql .= $this->quote($author_email).', ';
	$sql .= $this->quote($type_cont).', ';
	$sql .= $this->quote($raws).', ';
	$sql .= $this->quote($content).', ';
	$sql .= $this->quote($search).', ';
	$sql .= intval($aux_int_1).', ';
	$sql .= intval($aux_int_2).', ';
	$sql .= $this->quote($aux_text_1).', ';
	$sql .= $this->quote($aux_text_2).', ';

// enclosure
	$sql .= $this->quote($enclosure_url).', ';
	$sql .= $this->quote($enclosure_type).', ';
	$sql .= intval($enclosure_length).' ';

	$sql .= ')';

	return $sql;
}

function _build_update_sql(&$obj)
{
	foreach ($obj->gets() as $k => $v) 
	{	${$k} = $v;	}

	$sql = 'UPDATE '.$this->_table.' SET ';
	$sql .= 'lid='.intval($lid).', ';
	$sql .= 'uid='.intval($uid).', ';
	$sql .= 'mid='.intval($mid).', ';
	$sql .= 'p1='.intval($p1).', ';
	$sql .= 'p2='.intval($p2).', ';
	$sql .= 'p3='.intval($p3).', ';
	$sql .= 'site_title='.$this->quote($site_title).', ';
	$sql .= 'site_link='.$this->quote($site_link).', ';
	$sql .= 'title='.$this->quote($title).', ';
	$sql .= 'link='.$this->quote($link).', ';
	$sql .= 'entry_id='.$this->quote($entry_id).', ';
	$sql .= 'guid='.$this->quote($guid).', ';
	$sql .= 'updated_unix='.intval($updated_unix).', ';
	$sql .= 'published_unix='.intval($published_unix).', ';
	$sql .= 'category='.$this->quote($category).', ';
	$sql .= 'author_name='.$this->quote($author_name).', ';
	$sql .= 'author_uri='.$this->quote($author_uri).', ';
	$sql .= 'author_email='.$this->quote($author_email).', ';
	$sql .= 'type_cont='.$this->quote($type_cont).', ';
	$sql .= 'raws='.$this->quote($raws).', ';
	$sql .= 'content='.$this->quote($content).', ';
	$sql .= 'search='.$this->quote($search).', ';
	$sql .= 'aux_int_1='.intval($aux_int_1).', ';
	$sql .= 'aux_int_2='.intval($aux_int_2).', ';
	$sql .= 'aux_text_1='.$this->quote($aux_text_1).', ';
	$sql .= 'aux_text_2='.$this->quote($aux_text_2).', ';

// enclosure
	$sql .= 'enclosure_url='.$this->quote($enclosure_url).', ';
	$sql .= 'enclosure_type='.$this->quote($enclosure_type).', ';
	$sql .= 'enclosure_length='.intval($enclosure_length).' ';

	$sql .= 'WHERE fid='.intval($fid);

	return $sql;
}

//---------------------------------------------------------
// get count
//---------------------------------------------------------
function get_total()
{
	$ret = $this->getCount();
	return $ret;
}

function get_count_by_lid($lid)
{
	$ret = 0;
	if ($lid)
	{
		$criteria = new CriteriaCompo();
		$criteria->add( $this->get_addtion_by_lid($lid) );
		$ret = $this->getCount($criteria);
	}
	return $ret;
}

function get_count_by_link($link)
{
	$ret = 0;
	if ($link)
	{
		$criteria =& new CriteriaCompo();
		$criteria->add( $this->get_addtion_by_link($link) );
		$ret = $this->getCount($criteria);
	}
	return $ret;
}

function &get_addtion_by_lid($lid)
{
	$addtion =& new Criteria('lid', $lid, '=');
	return $addtion;
}

function &get_addtion_by_link($link)
{
	$link = $link.'%';
	$addtion =& new Criteria('link', $link, 'LIKE');
	return $addtion;
}

function get_count_by_mid($mid)
{
	$ret = 0;
	if ($mid)
	{
		$criteria = new criteriaCompo();
		$criteria->add( new criteria('mid', $mid, '=') );
		$ret = $this->getCount($criteria);
	}
	return $ret;
}

//---------------------------------------------------------
// get objects
//---------------------------------------------------------
function &get_objects($limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects( $criteria );
	return $objs;
}

function &get_objects_by_lid($lid, $limit=0, $start=0)
{
	$objs = false;
	if ($lid)
	{
		$criteria = new CriteriaCompo();
		$criteria->setStart($start);
		$criteria->setLimit($limit);
		$criteria->add( $this->get_addtion_by_lid($lid) );
		$objs =& $this->getObjects( $criteria );
	}
	return $objs;
}

function &get_objects_by_lid_desc($lid, $limit=0, $start=0)
{
	$objs = false;
	if ($lid)
	{
		$criteria = new CriteriaCompo();
		$criteria->setStart($start);
		$criteria->setLimit($limit);
		$criteria->add( $this->get_addtion_by_lid($lid) );
		$criteria->setSort('fid DESC');
		$objs =& $this->getObjects( $criteria );
	}
	return $objs;
}

function &get_objects_by_lid_order($lid, $order='updated_unix DESC, fid DESC', $limit=0, $start=0)
{
	$future = $this->_get_future_time();

// set lid
	$criteria = new CriteriaCompo();
	$criteria->setSort(  $order );
	$criteria->setLimit( $limit );
	$criteria->setStart( $start );
	$criteria->add( new Criteria('lid', $lid, '=') );
	$criteria->add( new Criteria('updated_unix',   $future, '<') );
	$criteria->add( new Criteria('published_unix', $future, '<') );
	$objs =& $this->getObjects( $criteria );

	return $objs;
}

function &get_objects_by_link($link, $limit=0, $start=0)
{
	$objs = false;
	if ($link)
	{
		$criteria = new CriteriaCompo();
		$criteria->setStart($start);
		$criteria->setLimit($limit);
		$criteria->add( $this->get_addtion_by_link($link) );
		$objs =& $this->getObjects( $criteria );
	}
	return $objs;
}

function &get_objects_by_link_desc($link, $limit=0, $start=0)
{
	$objs = false;
	if ($link)
	{
		$criteria = new CriteriaCompo();
		$criteria->setStart($start);
		$criteria->setLimit($limit);
		$criteria->add( $this->get_addtion_by_link($link) );
		$criteria->setSort('fid DESC');
		$objs =& $this->getObjects( $criteria );
	}
	return $objs;
}

function &get_objects_latest($order='updated_unix DESC, fid DESC', $limit=0, $start=0)
{
	$future = $this->_get_future_time();

	$criteria = new CriteriaCompo();
	$criteria->setSort(  $order );
	$criteria->setLimit( $limit );
	$criteria->setStart( $start );
	$criteria->add( new Criteria('updated_unix',   $future, '<') );
	$criteria->add( new Criteria('published_unix', $future, '<') );
	$objs = $this->getObjects( $criteria );

	return $objs;
}

function &get_objects_by_mid_order($mid, $order='updated_unix DESC, fid DESC', $limit=0, $start=0)
{
	$objs = false;
	if ($mid)
	{
		$future = $this->_get_future_time();
		$criteria = new criteriaCompo();
		$criteria->add( new criteria('mid', $mid, '=') );
		$criteria->add( new Criteria('updated_unix',   $future, '<') );
		$criteria->add( new Criteria('published_unix', $future, '<') );
		$criteria->setSort($order);
		$criteria->setStart($start);
		$criteria->setLimit($limit);
		$objs =& $this->getObjects($criteria);
	}
	return $objs;
}

//---------------------------------------------------------
// search
//---------------------------------------------------------
function &get_objects_by_where($where, $order='', $limit=0, $start=0)
{
	$future = $this->_get_future_time();

	$sql  = 'SELECT * FROM '.$this->_table;
	$sql .= ' WHERE '.$where;
	$sql .= ' AND updated_unix <'.$future;
	$sql .= ' AND published_unix <'.$future;

	if ($order)
	{
		$sql .= ' ORDER BY '.$order;
	}
	else
	{
		$sql .= ' ORDER BY fid';
	}

	$objs =& $this->get_objects_by_sql($sql, $limit, $start);

	return $objs;
}

function get_count_by_where($where)
{
	$future = $this->_get_future_time();

	$sql = 'SELECT COUNT(*) FROM '.$this->_table;
	$sql .= ' WHERE '.$where;
	$sql .= ' AND updated_unix <'.$future;
	$sql .= ' AND published_unix <'.$future;

	$ret = $this->get_count_by_sql($sql);
	return $ret;
}

//---------------------------------------------------------
// future days
//---------------------------------------------------------
function set_future($value)
{
	$this->_future_days = intval($value);
}

//=========================================================
// private
//=========================================================
//---------------------------------------------------------
// get_future_time
// some feed have future date
// supress at showing
//---------------------------------------------------------
function _get_future_time()
{
	$time = time() + 86400 * $this->_future_days;
	return $time;
}


//=========================================================
// add_column_table
//=========================================================
function check_version_030()
{
	$ret = $this->existsFieldName( 'enclosure_url' );
	return $ret;
}

function add_column_table_030()
{
$sql = "
  ALTER TABLE ".$this->_table." ADD COLUMN (
  enclosure_url  varchar(255) default '',
  enclosure_type varchar(255) default '',
  enclosure_length int(5) default '0'
)";

	$ret = $this->query($sql);
	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>