<?php
// $Id: headline.php,v 1.10 2007/05/20 04:59:32 ohwada Exp $

// 2007-05-20 K.OHWADA
// XOOPS 2.0.16: module name

// 2006-09-15 K.OHWADA
// use main_search_title_html

// 2006-07-10 K.OHWADA
// use happy_linux_post happy_linux_system
// support podcast
// bread crumb

// 2006-06-04 K.OHWADA
// use header.php
// suppress Notice Undefined offset: 0

// 2006-04-16 K.OHWADA
// BUG 3864: suppress Notice Undefined offset: 0

//================================================================
// Rss center Module
// 2006-01-01 K.OHWADA
//================================================================

include 'header.php';
include_once RSSC_ROOT_PATH.'/class/magpie/rssc_magpie_parse.php';
include_once RSSC_ROOT_PATH.'/class/magpie/rssc_magpie_cache.php';
include_once RSSC_ROOT_PATH.'/class/rssc_link_basic_handler.php';
include_once RSSC_ROOT_PATH.'/class/rssc_feed_basic_handler.php';
include_once RSSC_ROOT_PATH.'/class/rssc_black_basic_handler.php';
include_once RSSC_ROOT_PATH.'/class/rssc_white_basic_handler.php';
include_once RSSC_ROOT_PATH.'/class/rssc_parse_handler.php';
include_once RSSC_ROOT_PATH.'/class/rssc_refresh_handler.php';
include_once RSSC_ROOT_PATH.'/class/rssc_headline_handler.php';
include_once RSSC_ROOT_PATH.'/class/rssc_view_handler.php';

$headline_handler =& rssc_get_handler( 'headline',     RSSC_DIRNAME );
$view_handler     =& rssc_get_handler( 'view',         RSSC_DIRNAME );
$conf_handler     =& rssc_get_handler( 'config_basic', RSSC_DIRNAME );
$system           =& happy_linux_system::getInstance();

// --- template start ---
// xoopsOption[template_main] should be defined before including header.php
$xoopsOption['template_main'] = RSSC_DIRNAME.'_headline.html';
include XOOPS_ROOT_PATH.'/header.php';

$conf =& $conf_handler->get_conf();
$link_limit = $conf['main_headline_links_perpage'];

$view_handler->setFeedStart( 0 );
$view_handler->setFeedLimit(  $conf['main_headline_feeds_perpage'] );
$view_handler->setFeedOrder(  $conf['main_headline_order'] );
$view_handler->setFutureDays( $conf['basic_future_days'] );

$view_handler->setFlagSanitize(1);	// sanitize

$view_handler->set_title_html(   $conf['main_headline_title_html'] );
$view_handler->set_content_html( $conf['main_headline_content_html'] );
$view_handler->set_max_title(    $conf['main_headline_max_title'] );
$view_handler->set_max_content(  $conf['main_headline_max_content'] );
$view_handler->set_max_summary(  $conf['main_headline_max_summary'] );

$is_admin = $view_handler->is_module_admin();
$lid_get  = $view_handler->get_get_lid();

$link_show = 0;
$feed_show = 0;
$lid       = 0;
$channel   = array();
$feeds     = array();
$error     = '';

if ( !$headline_handler->refresh_headline($link_limit) )
{
	$error = $headline_handler->getErrors('s');
}

$links =& $headline_handler->get_headline_links($link_limit);

if ($lid_get > 0)
{
	$lid = $lid_get;
}
// suppress Notice Undefined offset: 0
elseif ( isset($links[0]['lid']) )
{
	$lid = $links[0]['lid'];
}

if ( $view_handler->exists_link($lid) )
{
	foreach ($links as $link) 
	{
		$xoopsTpl->append('links', $link);
	}

	$channel =& $view_handler->getLink($lid);
	$feeds   =& $view_handler->getFeeds($lid);

	if ( is_array($channel) && (count($channel) > 0) )
	{
		$link_show = 1;
		$xoopsTpl->assign('channel', $channel);
	}

	if ( is_array($feeds) && (count($feeds) > 0) )
	{
		$feed_show = 1;

		foreach ($feeds as $feed) 
		{
			$xoopsTpl->append('feeds', $feed);
		}
	}
}

// XOOPS 2.0.16
$xoopsTpl->assign('module_name', $system->get_module_name() );

// bread crumb
$xoopsTpl->assign('lang_home', _HOME);

$xoopsTpl->assign('lang_main',        _RSSC_MAIN);
$xoopsTpl->assign('lang_headline',    _RSSC_HEADLINE);
$xoopsTpl->assign('lang_lastupdate',  _RSSC_LASTUPDATE);
$xoopsTpl->assign('lang_no_record',   _NO_RECORD);
$xoopsTpl->assign('lang_no_feed',     _RSSC_NO_FEED);

// podcast
$xoopsTpl->assign('lang_podcast', _RSSC_PODCAST);
$xoopsTpl->assign('unit_kb',      RSSC_UNIT_KB);

$xoopsTpl->assign('dirname',    RSSC_DIRNAME);
$xoopsTpl->assign('is_admin',   $is_admin);
$xoopsTpl->assign('link_show',  $link_show);
$xoopsTpl->assign('feed_show',  $feed_show);
$xoopsTpl->assign('rssc_error', $error);

include XOOPS_ROOT_PATH.'/footer.php';
exit();
// --- main end ---

?>