<?php
// $Id: single_link_utf8.php,v 1.6 2006/11/09 16:40:37 ohwada Exp $

// 2006-11-08 K.OHWADA
// use basic_highlight
// use main_link_title_html
// use happy_linux_http_output

// 2006-09-01 K.OHWADA
// use main_search_title_html
// highlight_keyword

// 2006-07-10 K.OHWADA
// use happy_linux_post happy_linux_system
// support podcast

// 2006-06-04 K.OHWADA
// this is new file

//================================================================
// Rss center Module
// 2006-06-04 K.OHWADA
//================================================================

include 'header.php';
include_once XOOPS_ROOT_PATH.'/class/template.php';

include_once RSSC_ROOT_PATH.'/class/magpie/rssc_magpie_parse.php';
include_once RSSC_ROOT_PATH.'/class/magpie/rssc_magpie_cache.php';
include_once RSSC_ROOT_PATH."/class/rssc_parse_handler.php";

$single =& rssc_single_link_utf8::getInstance();

// http start
happy_linux_http_output('pass');
header('Content-Type:text/html; charset=utf-8');

// template
$RSSC_TEMPLATE_NAME = "db:".RSSC_DIRNAME."_single_link_utf8.html";
$xoopsTpl = new XoopsTpl();

$lid   = $single->get_get_lid();
$mode  = $single->get_get_mode();

$single->set_keyword_by_request();
$urlencode = $single->get_keywords_urlencode();

$feed  = array();
$link  = array();
$error = '';
$link_show = 0;
$feed_show = 0;

if ( $single->exists_link($lid) )
{
	$data = $single->get_sanitized_parse_by_lid($lid, $mode);

	$link  = $data['link'];
	$feeds = $data['items'];

	if ( is_array($link) && count($link) )
	{
		$link_show = 1;
		$xoopsTpl->assign('link', $link);
	}

	if ( is_array($feeds) && count($feeds) )
	{
		$feed_show = 1;

		foreach ($feeds as $feed) 
		{
			$xoopsTpl->append('feeds', $feed);
		}
	}
}

$xoopsTpl->assign('xoops_url',        XOOPS_URL );
$xoopsTpl->assign('xoops_charset',    $single->get_encoding() );
$xoopsTpl->assign('xoops_sitename',   $single->get_sitename() );
$xoopsTpl->assign('module_name',      $single->get_module_name() );
$xoopsTpl->assign('is_admin',         $single->is_module_admin() );
$xoopsTpl->assign('xoops_themecss',   xoops_getcss() );

$xoopsTpl->assign('lang_single_link',  $single->convert( _RSSC_SINGLE_LINK ) );
//$xoopsTpl->assign('lang_summary',      $single->convert( _RSSC_SINGLE_SUMMARY ) );
//$xoopsTpl->assign('lang_content',      $single->convert( _RSSC_SINGLE_CONTENT ) );
$xoopsTpl->assign('lang_no_record',    $single->convert( _NO_RECORD ) );
$xoopsTpl->assign('lang_no_feed',      $single->convert( _RSSC_NO_FEED) );
$xoopsTpl->assign('lang_single_link_utf8', $single->convert( _RSSC_SINGLE_LINK_UTF8) );

// podcast
$xoopsTpl->assign('lang_podcast', $single->convert( _RSSC_PODCAST) );
$xoopsTpl->assign('unit_kb',      RSSC_UNIT_KB);

$xoopsTpl->assign('dirname',     RSSC_DIRNAME);
$xoopsTpl->assign('link_show',   $link_show);
$xoopsTpl->assign('feed_show',   $feed_show);
$xoopsTpl->assign('rssc_error',  $error);
$xoopsTpl->assign('lid',   $lid);
$xoopsTpl->assign('mode',  $mode);
$xoopsTpl->assign('link',  $link);
$xoopsTpl->assign('feed',  $feed);
$xoopsTpl->assign('rssc_keywords', $urlencode);

$xoopsTpl->display( $RSSC_TEMPLATE_NAME );

exit();
// --- main end ---

//=========================================================
// class rssc_single_link_utf8
//=========================================================
class rssc_single_link_utf8
{
	var $_link_handler;
	var $_conf_handler;
	var $_parse_handler;
	var $_system;
	var $_convert;
	var $_post;
	var $_strings;

	var $ENCODING_LOCAL = _CHARSET;
	var $ENCODING_UTF8  = 'UTF-8';

	var $_lid;
	var $_mode;
	var $_link_obj;

	var $_flag_highlight = false;
	var $_keyword_array  = null;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_single_link_utf8()
{
	$this->_link_handler  =& rssc_get_handler('link', RSSC_DIRNAME);
	$this->_conf_handler  =& rssc_get_handler( 'config_basic', RSSC_DIRNAME );
	$this->_parse_handler =& rssc_parse_handler::getInstance();

	$this->_post    =& happy_linux_post::getInstance();
	$this->_system  =& happy_linux_system::getInstance();
	$this->_convert =& happy_linux_convert_encoding::getInstance();
	$this->_strings =& happy_linux_strings::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_single_link_utf8();
	}

	return $instance;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function exists_link($lid)
{
	$link_obj =& $this->_link_handler->getCache( $lid );
	if ( is_object( $link_obj ) )
	{
		return true;
	}
	return false;
}

function &get_sanitized_parse_by_lid($lid, $mode)
{
	$false = false;

	$this->_convert->set_internal_encoding( $this->ENCODING_UTF8 );

	$conf =& $this->_conf_handler->get_conf();
	$limit = $conf['main_link_feeds_perlink'];

	$link_obj =& $this->_link_handler->getCache( $lid );
	if ( !is_object( $link_obj ) )
	{
		return $false;
	}

	$xml      =  $link_obj->getVar('xml', 'n');
	$encoding =  $link_obj->getVar('encoding', 'n');
	$title_s  =  $link_obj->getVar('title', 's');

	$link =& $link_obj->build_show();
	$link['title'] = $this->convert($title_s);

	$this->_parse_handler->set_local_encoding( $this->ENCODING_UTF8 );

	$parse_obj =& $this->_parse_handler->parse_by_xml($xml, $encoding);
	if ( !is_object($parse_obj) )
	{
		return $false;
	}

	$parse_obj->view_format();
	$parse_obj->set_title_html(     $conf['main_link_title_html'] );
	$parse_obj->set_max_title(      $conf['main_link_max_title'] );
	$parse_obj->set_content_html(   $conf['main_link_content_html'] );
	$parse_obj->set_max_content(    $conf['main_link_max_content'] );
	$parse_obj->set_max_summary(    $conf['main_link_max_summary'] );
	$parse_obj->set_flag_highlight( $conf['basic_highlight'] );
	$parse_obj->set_keyword_array(  $this->_keyword_array );
	$parse_obj->view_sanitize();

	$parse_data =& $parse_obj->get_vars();
	$items = $parse_data['items'];
	$arr   = array();

	if ( is_array($items) && count($items) )
	{
		$max = count($items);
		if ($max > $limit)
		{
			$max = $limit;
		}

		for ($i=0; $i<$max; $i++)
		{
			$arr[$i] = $items[$i];
		}
	}

	$ret = array();
	$ret['link']  = $link;
	$ret['items'] = $arr;

	return $ret;
}

function get_encoding()
{
	return $this->ENCODING_UTF8;
}

function &convert($text)
{
	$ret = $this->_convert->convert($text, $this->ENCODING_UTF8, $this->ENCODING_LOCAL);
	return $ret;
}

//---------------------------------------------------------
// parameter
//---------------------------------------------------------
function set_highlight($value)
{
	$this->_flag_highlight = (bool)$value;
}

function set_keyword_array($arr)
{
	if ( is_array($arr) && count($arr) )
	{
		$this->_keyword_array = $arr;
	}
}

function set_keyword_by_request()
{
	$this->set_keyword_array( $this->_post->get_get_keyword_array() );
}

function get_keywords_urlencode()
{
	return $this->_strings->urlencode_from_array( $this->_keyword_array );
}

//---------------------------------------------------------
// class system
//---------------------------------------------------------
function is_module_admin()
{
	return $this->_system->is_module_admin();
}

function get_module_name()
{
	return $this->convert( $this->_system->get_module_name() );
}

function get_sitename()
{
	return $this->convert( $this->_system->get_sitename() );
}

//---------------------------------------------------------
// class post
//---------------------------------------------------------
function get_get_lid()
{
	return $this->_post->get_get_int('lid');
}

function get_get_mode()
{
	return $this->_post->get_get_int('mode');
}

// --- class end ---
}

?>