<?php
// $Id: whatsnew_ping.php,v 1.4 2007/05/15 05:24:25 ohwada Exp $

// 2007-05-12 K.OHWADA
// module dupulication
// divid to whatsnew_config_basic_handler

// 2005-09-28 K.OHWADA
// change func.ping.php to class

//=========================================================
// What's New Module
// class send weblog update ping
// 2004/08/20 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('whatsnew_ping') ) 
{

//=========================================================
// class whatsnew_ping
//=========================================================
class whatsnew_ping
{
// constant
	var $_TIMEOUT_CONNECT = 3;	// 3 sec;
	var $_TIMEOUT_READ    = 3;	// 3 sec;

	var $_DIRNAME;
	var $FILE_PING;
	var $TEMPLATE_RSS;
	var $TEMPLATE_RDF;
	var $TEMPLATE_ATOM;

// class
	var $_config_handler;
	var $_weblog;

// variable
	var $_conf;
	var $_flag_print = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function whatsnew_ping( $dirname )
{
	$this->_DIRNAME     = $dirname;
	$WHATSNEW_ROOT_PATH = XOOPS_ROOT_PATH . '/modules/' . $dirname;

// constant
	$this->FILE_PING     = $WHATSNEW_ROOT_PATH.'/cache/ping.send.log';
	$this->TEMPLATE_RDF  = $WHATSNEW_ROOT_PATH.'/templates/xml/build_rdf.html';
	$this->TEMPLATE_RSS  = $WHATSNEW_ROOT_PATH.'/templates/xml/build_rss.html';
	$this->TEMPLATE_ATOM = $WHATSNEW_ROOT_PATH.'/templates/xml/build_atom.html';

// class
	$this->_weblog         =& happy_linux_weblog_updates::getInstance();
	$this->_config_handler =& whatsnew_config_basic_handler::getInstance();
	$this->_conf =& $this->_config_handler->load( $this->_DIRNAME );

}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new whatsnew_ping( $dirname );
	}
	return $instance;
}

//---------------------------------------------------------
// main function
//---------------------------------------------------------
// send ping after clear cache
function send_ping_cache()
{
	$this->clear_cache($this->TEMPLATE_RSS);
	$this->clear_cache($this->TEMPLATE_RDF);
	$this->clear_cache($this->TEMPLATE_ATOM);

	$this->send_ping();
}

function send_ping()
{
	$site_name    =  $this->_conf['site_name'];
	$site_url     =  $this->_conf['site_url'];
	$ping_log     =  $this->_conf['ping_log'];
	$ping_servers =  $this->_conf['ping_servers'];

	$today = date("Y/m/d H:i:s");

	if ($ping_log)
	{
		$fp = fopen($this->FILE_PING, "a");
		fwrite($fp,"$today \n");
	}

	$ping_arr = split("\n", $ping_servers);

	$this->_weblog->set_timeout($this->_TIMEOUT_CONNECT, $this->_TIMEOUT_READ);

	if ($this->_flag_print >= 2)
	{
		$this->_weblog->set_debug();
	}

	if ($this->_flag_print >= 1)
	{
		echo "<hr />\n";
	}

	foreach ($ping_arr as $url)
	{
		$url = trim($url);
	 	if (empty($url))  continue;

  		$this->_weblog->set_blog_data($site_name, $site_url);
  		$this->_weblog->send_ping($url);
		$msg = $this->_weblog->make_result();

		if ($this->_flag_print >= 1)
		{
			echo $msg;
			echo "<br /><br />\n";
		}

		if ($ping_log)
		{
			fwrite($fp, $msg);
		}
	}

	if ($this->_flag_print >= 1)
	{
		echo "<hr />\n";
	}

	if ($ping_log)
	{
		fclose($fp);
	}

	$this->_config_handler->update_force_by_name( 'ping_time', time() );
}

function get_config_pass()
{
	return $this->_conf['ping_pass'];
}

//---------------------------------------------------------
// template cache
//---------------------------------------------------------
function clear_cache($template)
{
	$tpl = new XoopsTpl();
	$tpl->clear_cache($template);
}

//---------------------------------------------------------
// set parameter
//---------------------------------------------------------
function set_flag_print($value)
{
	$this->_flag_print = intval($value);
}

// --- class end ---
}

// === class end ===
}

?>