<?php
// $Id: modify_list.php,v 1.1 2006/09/30 03:15:20 ohwada Exp $

// 2006-09-20 K.OHWADA
// this new file

//================================================================
// WebLinks Module
// 2006-09-20 K.OHWADA
//================================================================
include 'admin_header.php';

//=========================================================
// class admin_modify_list
//=========================================================
class admin_modify_list extends happy_linux_page_frame
{
	var $_strings;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_modify_list()
{
	$this->happy_linux_page_frame();
	$this->set_handler('modify', WEBLINKS_DIRNAME, 'weblinks');
	$this->set_id_name('mid');
	$this->set_max_sortid(3);
	$this->set_lang_no_item( _WEBLINKS_NO_LINK );

	$this->_broken_handler =& weblinks_get_handler( 'broken', WEBLINKS_DIRNAME );

	$this->_strings    =& happy_linux_strings::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_modify_list();
	}
	return $instance;
}

//---------------------------------------------------------
// handler
//---------------------------------------------------------
function &_get_table_header()
{
	$arr = array(
		_WEBLINKS_MID,
		_WLS_LINKID,
		_WLS_SITETITLE,
	);

	return $arr;
}

function _get_total()
{
	$total_all = $this->_get_total_all();

	switch ($this->_sortid)
	{
		case 1:
			$total = $total_all;
			break;

		case 2:
			$total = $this->_handler->get_count_new();
			break;

		case 3:
			$total = $this->_handler->get_count_mod();
			break;

		case 0:
		default:
			$total = $total_all;
			break;
	}

	return $total;
}

function &_get_items($limit=0, $start=0)
{
	switch ($this->_sortid)
	{
		case 1:
			$objs =& $this->_handler->get_objects_desc($limit, $start);
			break;

		case 2:
			$objs =& $this->_handler->get_objects_new($limit, $start);
			break;

		case 3:
			$objs =& $this->_handler->get_objects_mod($limit, $start);
			break;

		case 0:
		default:
			$objs =& $this->_handler->get_objects_asc($limit, $start);
			break;
	}

	return $objs;
}

function &_get_cols(&$obj)
{
	$mid     = $obj->get('mid');
	$lid     = $obj->get('lid');
	$mode    = $obj->get('mode');
	$title_s = $obj->getVar('title', 's');

	if ($mode == 1)
	{
		$jump_mod  = 'link_manage.php?op=list_mod&mid=';
		$jump_link = 'link_manage.php?op=mod_form&lid=';
		$link_link = $this->_build_page_id_link_by_obj( $obj, 'lid', $jump_link);
	}
	else
	{
		$jump_mod  = 'link_manage.php?op=list_new&mid=';
		$link_link = '---';
	}

	$link_mod = $this->_build_page_id_link_by_obj( $obj, 'mid', $jump_mod);

	$arr = array(
		$link_mod,
		$link_link,
		$title_s,
	);

	return $arr;
}

//---------------------------------------------------------
// print
//---------------------------------------------------------
function _print_top()
{
	$total_all = $this->_get_total_all();
	$total_new = $this->_handler->get_count_new();
	$total_mod = $this->_handler->get_count_mod();

	switch ($this->_sortid)
	{
		case 1:
			$title = _WEBLINKS_ADMIN_LINK_ALL_DESC;
			break;

		case 2:
			$title = _WLS_LINKSWAITING;
			break;

		case 3:
			$title = _WLS_MODREQUESTS;
			break;

		case 0:
		default:
			$title = _WEBLINKS_ADMIN_LINK_ALL_ASC;
			break;
	}

	$total_new = $this->build_html_highlight_number($total_new);
	$total_mod = $this->build_html_highlight_number($total_mod);

	echo "<h4>"._WEBLINKS_ADMIN_LINK_LIST."</h4>\n";
	printf(_WLS_THEREARE, $total_all);
	echo "<br /><br />\n";

	echo "<table width='80%' border='0' cellspacing='1' class='outer'>";
	echo "<tr class='odd'><td>";
	echo "<li><a href='modify_list.php?sortid=0'>"._WEBLINKS_ADMIN_LINK_ALL_ASC."</a> ($total_all) </li>\n";
	echo "<li><a href='modify_list.php?sortid=1'>"._WEBLINKS_ADMIN_LINK_ALL_DESC."</a> ($total_all) </li>\n";
	echo "<li><a href='modify_list.php?sortid=2'>"._WLS_LINKSWAITING."</a> ($total_new) </li>\n";
	echo "<li><a href='modify_list.php?sortid=3'>"._WLS_MODREQUESTS."</a> ($total_mod) </li>\n";
	echo"</td></tr></table>\n";

	echo "<h4>".$title."</h4>\n";

	echo "<br />\n";
}

// --- class end ---
}


//=========================================================
// main
//=========================================================
xoops_cp_header();

weblinks_admin_print_header();
weblinks_admin_print_menu();

$list =& admin_modify_list::getInstance();
$list->_show();

xoops_cp_footer();
exit();
// --- end of main ---

?>