<?php
// $Id: weblinks_config2_basic_handler.php,v 1.10 2007/08/08 04:18:30 ohwada Exp $

// 2007-08-01 K.OHWADA
// admin can add etc column

// 2007-06-10 K.OHWADA
// get_module_name()

// 2007-03-07 K.OHWADA
// notice in module initial

// 2007-03-01 K.OHWADA
// user can use textarea1
// change has_auth_desc_option()

// 2007-02-04 K.OHWADA
// Notice: Only variables should be assigned by reference in file class/weblinks_link.php

// 2007-01-20 K.OHWADA
// auth_dohtml_1

// 2006-12-10 K.OHWADA
// add _load()

// 2006-09-20 K.OHWADA
// use happy_linux

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_config2_basic_handler') ) 
{

//=========================================================
// class weblinks_config2_basic_handler
// this class handle MySQL table directly
// this class does not use another class
//=========================================================
class weblinks_config2_basic_handler extends happy_linux_basic_handler
{
	var $_system;

	var $_xoops_uid              = 0;
	var $_use_passwd             = false;
	var $_has_auth_modify        = false;
	var $_has_auth_modify_uid    = false;
	var $_has_auth_modify_passwd = false;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_config2_basic_handler( $dirname )
{
	$this->happy_linux_basic_handler( $dirname );

	$this->set_table_name('config2');
	$this->set_id_name('conf_id');

	$this->set_debug_db_sql(     WEBLINKS_DEBUG_CONFIG2_BASIC_SQL );
	$this->set_debug_db_error(   WEBLINKS_DEBUG_ERROR );
	$this->set_debug_print_time( WEBLINKS_DEBUG_TIME );

	$this->_system    =& happy_linux_system::getInstance();
	$this->_xoops_uid = $this->_system->get_uid();
}

//---------------------------------------------------------
// initiatl load
//---------------------------------------------------------
function init()
{
	static $flag_init_load;

	if ( !isset($flag_init_load) )
	{
		$flag_init_load = 1;
		$this->_load();
	}
}

// for debug
function _load()
{
	if ( $this->get_debug_print_time() )
	{
		$happy_linux_time =& happy_linux_time::getInstance();
		$happy_linux_time->print_lap_time( "weblinks_config2_basic_handler" );
	}

	$arr =& $this->_get_config_data();

// if not initial
	if ( !is_array($arr) || ( count($arr) == 0 ) )
	{	return false;	}

	$arr['auth_submit_arr']      = unserialize( $arr['auth_submit'] );
	$arr['auth_submit_auto_arr'] = unserialize( $arr['auth_submit_auto'] );
	$arr['auth_modify_arr']      = unserialize( $arr['auth_modify'] );
	$arr['auth_modify_auto_arr'] = unserialize( $arr['auth_modify_auto'] );
	$arr['auth_ratelink_arr']    = unserialize( $arr['auth_ratelink'] );
	$arr['rss_site_arr']  =& $this->_conv_to_array( $arr['rss_site'] );
	$arr['rss_black_arr'] =& $this->_conv_to_array( $arr['rss_black'] );
	$arr['rss_white_arr'] =& $this->_conv_to_array( $arr['rss_white'] );

// added auth_dohtml in v1.30
	if ( isset($arr['auth_dohtml']) )
	{
		$arr['dohtml_arr']     = unserialize( $arr['auth_dohtml'] );
		$arr['dosmiley_arr']   = unserialize( $arr['auth_dosmiley'] );
		$arr['doxcode_arr']    = unserialize( $arr['auth_doxcode'] );
		$arr['doimage_arr']    = unserialize( $arr['auth_doimage'] );
		$arr['dobr_arr']       = unserialize( $arr['auth_dobr'] );
	}

// added auth_dohtml_1 in v1.40
	if ( isset($arr['auth_dohtml_1']) )
	{
		$arr['dohtml_1_arr']   = unserialize( $arr['auth_dohtml_1'] );
		$arr['dosmiley_1_arr'] = unserialize( $arr['auth_dosmiley_1'] );
		$arr['doxcode_1_arr']  = unserialize( $arr['auth_doxcode_1'] );
		$arr['doimage_1_arr']  = unserialize( $arr['auth_doimage_1'] );
		$arr['dobr_1_arr']     = unserialize( $arr['auth_dobr_1'] );
	}

// added in v1.60
	if ( isset($arr['link_num_etc']) )
	{
		if ( $arr['link_num_etc'] < 0 )
		{
			$arr['link_num_etc'] = 0;
		}
		elseif ( $arr['link_num_etc'] > WEBLINKS_LINK_NUM_ETC )
		{
			$arr['link_num_etc'] = WEBLINKS_LINK_NUM_ETC;
		}
	}
	else
	{
		$arr['link_num_etc'] = WEBLINKS_LINK_NUM_ETC;
	}

	$this->_conf_cached = $arr;

// for show_modify
// notice in module initial
	$this->_use_passwd             = $this->get_conf_by_name( 'use_passwd' );
	$this->_has_auth_modify        = $this->has_auth(         'auth_modify_arr' );
	$this->_has_auth_modify_uid    = $this->_has_auth_uid(    'auth_modify_arr' );
	$this->_has_auth_modify_passwd = $this->_has_auth_passwd( 'auth_modify_arr' );

	if ( $this->get_debug_print_time() )
	{
		$happy_linux_time->print_lap_time();
	}
}

//=========================================================
// function for MySQL table
//=========================================================
function &_conv_to_array($str)
{
	$ret =& $this->convert_string_to_array($str, "\n");
	return $ret;
}

//---------------------------------------------------------
// has authority
//---------------------------------------------------------
function show_modify( $rec_uid )
{
	$has_auth        = $this->_has_auth_modify;
	$has_auth_uid    = $this->_has_auth_modify_uid;
	$has_auth_passwd = $this->_has_auth_modify_passwd;
	$flag_passwd     = false;

	list($is_permit, $is_owner, $show_passwd) =
		$this->_has_auth_owner( $has_auth, $has_auth_uid, $has_auth_passwd, $rec_uid, $flag_passwd );

	if ( $is_permit || $show_passwd )
	{
		return true;
	}

	return false;
}

function has_auth_ratelink()
{
	$ret = $this->has_auth( 'auth_ratelink_arr' );
	return $ret;
}

// Notice: Only variables should be assigned by reference in file class/weblinks_link.php
function &has_auth_desc_option()
{
	$arr = array(
		'dohtml'    => $this->has_auth( 'dohtml_arr' ),
		'dosmiley'  => $this->has_auth( 'dosmiley_arr' ),
		'doxcode'   => $this->has_auth( 'doxcode_arr' ),
		'doimage'   => $this->has_auth( 'doimage_arr' ),
		'dobr'      => $this->has_auth( 'dobr_arr' ),

		'dohtml1'   => $this->has_auth( 'dohtml_1_arr' ),
		'dosmiley1' => $this->has_auth( 'dosmiley_1_arr' ),
		'doxcode1'  => $this->has_auth( 'doxcode_1_arr' ),
		'doimage1'  => $this->has_auth( 'doimage_1_arr' ),
		'dobr1'     => $this->has_auth( 'dobr_1_arr' ),
	);

	return $arr;
}

function has_auth_owner(  $auth_arr_name, $rec_uid, $flag_passwd=false )
{
	$has_auth        = $this->has_auth(        $auth_arr_name );
	$has_auth_uid    = $this->_has_auth_uid(    $auth_arr_name );
	$has_auth_passwd = $this->_has_auth_passwd( $auth_arr_name );

	$ret =& $this->_has_auth_owner( $has_auth, $has_auth_uid, $has_auth_passwd, $rec_uid, $flag_passwd );
	return $ret;
}

function has_auth( $auth_arr_name )
{
	if ( $this->_system->is_module_admin() )
	{
		return true;
	}

	$auth_arr =& $this->get_conf_by_name( $auth_arr_name );
	$groups   =& $this->_system->get_user_groups();

	if ( is_array($auth_arr) && count($auth_arr) &&
	     is_array($groups) && count($groups) )
	{
		if ( array_intersect( $auth_arr, $groups ) )
		{
			return true;
		}
	}

	return false;
}

function _has_auth_owner( $has_auth, $has_auth_uid, $has_auth_passwd, $rec_uid, $flag_passwd=false )
{
	$is_permit   = false;
	$is_owner    = false;
	$show_passwd = false;

	$rec_uid    = intval($rec_uid);

	if ( $has_auth )
	{
		$is_permit = true;
	}

// uid
	if ( ( $this->_xoops_uid > 0 )&&( $this->_xoops_uid == $rec_uid )&& $has_auth_uid )
	{
		$is_permit = true;
		$is_owner  = true;
	}

// passwd
	if ( ( $this->_xoops_uid == 0 ) && $this->_use_passwd && $has_auth_passwd )
	{
		$show_passwd = true;

		if ( $flag_passwd )
		{
			$is_permit = true;
			$is_owner  = true;
		}
	}

	return array($is_permit, $is_owner, $show_passwd);
}

function _has_auth_uid( $auth_arr_name )
{
	$auth_arr = $this->get_conf_by_name( $auth_arr_name );
	if ( in_array( WEBLINKS_ID_AUTH_UID, $auth_arr ) )
	{
		return true;
	}
	return false;
}

function _has_auth_passwd( $auth_arr_name )
{
	$auth_arr = $this->get_conf_by_name( $auth_arr_name );
	if ( in_array( WEBLINKS_ID_AUTH_PASSWD, $auth_arr ) )
	{
		return true;
	}
	return false;
}

//---------------------------------------------------------
// module_name
//---------------------------------------------------------
function get_module_name( $name, $flag_dirname=true, $flag_mod_name=true, $format='s' )
{
	$val = false;

	$dirname = $this->get_conf_by_name( $name );
	if ( $dirname )
	{
		$module_name = $this->_system->get_module_name_by_dirname( $dirname, $format );

		if ( $flag_dirname && $flag_mod_name)
		{
			$val = $dirname.': '.$module_name;
		}
		elseif ( $flag_dirname )
		{
			$val = $dirname;
		}
		elseif ( $flag_mod_name )
		{
			$val = $module_name;
		}
	}

	return $val;
}

// --- class end ---
}

// === class end ===
}

?>