<?php
// $Id: misc.class.php,v 1.1.1.1 2010/08/30 12:42:04 ohwada Exp $

//=========================================================
// Twitter Login with Service_Twitter
// 2010-08-01 K.OHWADA
//=========================================================

class twitter_misc
{
	var $_NAME_STATUS = 'status';

	var $_TITLE    = 'Twitter ログインのデモ (PEAR)';
	var $_LIB_DESC = 'PEAR/Service/Twitter';

function twitter_misc()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance))  {
		$instance =& new twitter_misc();
	}
	return $instance;
}

function get_post_status()
{
	return $this->get_post_by_key( $this->_NAME_STATUS );
}

function get_get_by_key( $key )
{
	$str = isset($_GET[ $key ]) ? $_GET[ $key ] : null;
	return $str;
}

function get_post_by_key( $key )
{
	$str = isset($_POST[ $key ]) ? $_POST[ $key ] : null;
	return $str;
}

function print_login_form()
{
	$body = $this->build_login_form();
	$this->print_html($body);
}

function build_login_form()
{
	$str = <<< EOF
<h1> $this->_TITLE </h1>
Twitter のアカウントでログインします。<br>
ログイン後はtwitterの投稿できます。<br>
ライブラリイ： $this->_LIB_DESC <br><br>
<a href="?op=login">
[Twitter アカウントでログインする]
</a><br><br>
<a href="http://linux.ohwada.jp/modules/smartsection/item.php?itemid=498" target="_blank">解説： Twitter ログイン - PEAR</a>
EOF;

	return $str;
}

function print_tweet_form( $user )
{
	$flag  = $this->get_get_by_key( 'flag' );
	$error = $this->get_get_by_key( 'error' );

	$body  = $this->build_login_now( $user );
	$body .= $this->build_result_msg( $flag, $error );
	$body .= $this->build_tweet_form();
	$this->print_html($body);
}

function build_login_now( $user )
{
	$url  = 'http://twitter.com/'.$user;

	$str = <<< EOF
<h1> $this->_TITLE </h1>
<h3>ログインID: <a href="$url" target="_blank">@$user</a></h3>
<a href="?">[ホーム]</a> 
<a href="?op=logout">[ログアウト]</a> 
EOF;

	return $str;
}

function build_result_msg( $flag, $error )
{
	$str = '';
	if ( $flag == 1 ) {
		$str .= '<p style="background-color: lightgreen;">ツィート 出来ました</p>
'."\n";
	} elseif ( $flag == -1 ) {
		$str .= '<p style="background-color: red;">う～ん！ Twitter に嫌われたみたい！</p>'."\n";
        $str .= '<div style="color: red;">';
		$str .= $error;
		$str .= '</div>'."\n";
	}

	return $str;
}

function build_tweet_form()
{

	$str = <<< EOF
<p>いまどうしてる？</p>
<form action="tweet.php" method="post" id="statusform">
<textarea name="$this->_NAME_STATUS" id="status" rows="2" cols="70%" onkeypress="return imposemax(this);"></textarea>
<br/><input type="submit" id="submit" value="ツィートする"/>
</form>
EOF;

	return $str;
}

function print_html( $body )
{
	echo '<?xml version="1.0" encoding="UTF-8"?>';

?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title><?php echo  $this->_TITLE; ?></title>
<script language="javascript" type="text/javascript">
<!--
function imposemax(Object) {
	return (Object.value.length <= 140);
}
-->
</script>
</head>
<body>
<?php echo $body; ?>
</body>
</html>
<?php
// --- print_tweet_form end --- 
}

// === class end ===
}

?>