<?php
// $Id: Action.class.php,v 1.1.1.1 2010/09/07 09:15:13 ohwada Exp $

//=========================================================
// Exauth Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Exauth_Action 
{
    // コンポーネント
	var $_container     = null;
	var $_commonMain    = null;
	var $_configView    = null;
	var $_usersView     = null;
	var $_usersAction   = null;
	var $_pagesView     = null;
	var $_pagesAction   = null;
	var $_modulesView   = null;
	var $_uploadsAction = null;
	var	$_session       = null;
	var	$_db            = null;

	// ローカル変数
	var $_user_id      = null;
	var $_redirect_url = null;

	var $_config_general = null;
	var $_timezone_data  = null;

	var $_error_code = array();
	var $_error_msg  = array();
	var	$_error_msg_admin = array();

	var $_lang_err_someting        = null ;
	var $_lang_err_pass_disaccord  = null ;
	var $_lang_err_mes_disclaimer  = null ;
	var $_lang_err_mes_input_key   = null ;
	var $_lang_mes_error_duplicate = null ;
	var $_lang_action_closesite    = null ;
	var $_lang_err_file_upload_noability = null ;

	var	$_ACTIVATE_KEY_LEN = 8 ;
	var $_ALLOW_ITEMS = array('login_id', 'handle', 'email');

/**
 * コンストラクター
 *
 * @access	public
 */
	function Exauth_Action() 
	{
		$this->_container   =& DIContainerFactory::getContainer();
		$this->_commonMain  =& $this->_container->getComponent("commonMain");
		$this->_configView  =& $this->_container->getComponent("configView");
		$this->_usersView   =& $this->_container->getComponent("usersView");
		$this->_usersAction =& $this->_container->getComponent("usersAction");
		$this->_pagesView   =& $this->_container->getComponent("pagesView");
		$this->_pagesAction =& $this->_container->getComponent("pagesAction");
		$this->_modulesView =& $this->_container->getComponent("modulesView");
		$this->_session     =& $this->_container->getComponent("Session");
		$this->_db          =& $this->_container->getComponent("DbObject");

	}

	function set_lang() 
	{
		$this->_lang_err_someting        = EXAUTH_ERR_SOMETING ;
		$this->_lang_err_pass_disaccord  = EXAUTH_ERR_PASS_DISACCORD ;
		$this->_lang_err_mes_disclaimer  = EXAUTH_ERR_MES_DISCLAIMER ;
		$this->_lang_err_mes_input_key   = EXAUTH_ERR_MES_INPUT_KEY ;
		$this->_lang_mes_error_duplicate = EXAUTH_MES_ERROR_DUPLICATE ;
		$this->_lang_action_closesite    = EXAUTH_ACTION_CLOSESITE ;
		$this->_lang_err_file_upload_noability = EXAUTH_ERR_FILE_UPLOAD_NOABILITY ;
	}

	function get_error_msg()
	{
		$code  = $this->get_error_code( true );
		$error = $this->get_error_msg_raw( true );
		if ( empty($error) && $code ) {
			$error = $this->_lang_err_someting .' ('.$code.')';
		}
		return $error;
	}

	function get_error_code( $flag=false ) 
	{
		if ( $flag && is_array($this->_error_code) ) {
			if ( count($this->_error_code) == 0 ) {
				return 0;
			} else {
				return $this->_error_code[0];
			}
		}
		return $this->_error_code;
	}

	function get_error_msg_raw( $flag=false ) 
	{
		if ( $flag && is_array($this->_error_msg) ) {
			if ( count($this->_error_msg) == 0 ) {
				return null;
			}
			if ( count($this->_error_msg) == 1 ) {
				return $this->_error_msg[0];
			}
			return implode( "<br />\n", $this->_error_msg );
		}
		return $this->_error_msg ;
	}

	function set_error_code( $code ) 
	{
		$this->_error_code[] = $code;
	}

	function set_error_msg( $msg ) 
	{
		$this->_error_msg[] = $msg ;
	}

	function set_error_msg_single( $msg ) 
	{
		$this->_error_msg = array( $msg );
	}

	function set_error_admin( $msg ) 
	{
		$this->_error_msg_admin[] = $msg ;
	}

//---------------------------------------------------------
// ユーザ登録する
//---------------------------------------------------------
    function register( $param_input )
	{

// token が正しくないなら、登録画面を再表示する
		if ( ! $this->check_token() ) {
			$this->set_error_msg( $this->_lang_err_someting.' (1)' );
			return 261;
		}

		$param_valid = $this->register_validate( $param_input, true );

// 入力が正しくないなら、登録画面を再表示する
		if ( !$param_valid ) {
			return 262;
		}

// 登録と同時に承認する
		$param_valid['autoregist_approver'] = _AUTOREGIST_AUTO ;

		$param_register = $this->register_excute( $param_input + $param_valid );

// 登録できないときは、登録画面を再表示する
		if ( !isset( $param_register['user_id'] ) ) {
			return 263;
		}

		$user_id    = $param_register['user_id'];
		$param_user = $this->get_login_user_param( $user_id );

// user 情報が取得できないときは、エラー表示
		if ( !isset( $param_user['user_id'] ) ) {
			return 264;
		}

		$this->_user_id = $user_id ;

// ログイン処理
		$this->login_excute( $param_user );
		return 0;
	}

//---------------------------------------------------------
// ログインする
//---------------------------------------------------------
    function login( $param_input )
	{
		$login_id = $param_input['login_id'] ;
		$password = $param_input['password'] ;

// token が正しくないなら、ログイン画面を再表示する
		if ( ! $this->check_token() ) {
			$this->set_error_msg( $this->_lang_err_someting.' (1)' );
			return 271;
		}

// 入力が正しくないなら、ログイン画面を再表示する
		if ( empty($login_id) || empty($password) ) {
			$this->set_error_msg( $this->_lang_err_someting.' (2)' );
			return 272;
		}

// ログイン認証
		$user = $this->get_user_by_login_password( $login_id, $password );
		if ( !isset($user['user_id']) ) {
			$this->set_error_msg( $this->_lang_err_someting.' (3)' );
			return 273;
		}

		$this->_user_id = $user['user_id'];
		$param_user = $this->get_user_param_extra( $user );

// user 情報が取得できないときは、エラー表示
		if ( !$param_user ) {
			return 274;
		}

// ログイン処理
		$this->login_excute( $param_user );
		return 0;
	}

    function get_user_id()
    {
		return $this->_user_id;
	}

//---------------------------------------------------------
// items にパスワードを自動生成する
//---------------------------------------------------------
    function create_password_in_items( $items )
    {
		$item_id = $this->get_item_id_by_name( 'USER_ITEM_PASSWORD' );
		$val     = $this->create_password();
		$items[ $item_id ] = $val;
		return $items;
	}

    function create_password( $length=10, $type='pronounceable', $chars='' )
	{
   		require_once 'Text/Password.php';
		$str = Text_Password::create( $length, $type, $chars );
		return $str;
	}

//---------------------------------------------------------
// 新規登録の検査
// 参照 Login_Validator_ItemsInputs
//---------------------------------------------------------
    function register_validate( $p, $flag_allow=false )
    {
		$this->_uploadsAction =& $this->_container->getComponent("uploadsAction");

		$p_items                  = $p['items'];
		$items_public             = $p['items_public'];
		$items_reception          = $p['items_reception'];
		$items_password_confirm   = $p['items_password_confirm'];
		$autoregist_disclaimer_ok = $p['autoregist_disclaimer_ok'];
		$autoregist_input_key     = $p['autoregist_input_key'];
		$param0                   = $p['param0'];

		$config = $this->get_config_enter_exit();

    	if ($config['autoregist_use']['conf_value'] != _ON) {
			$this->set_error_code( 201 );
			return false;
    	}

    	$show_items =& $this->get_users_items_admin();
    	if ($show_items === false) {
			$this->set_error_code( 202 );
			return false;
    	}

    	$autoregist_use_items = explode("|", $config['autoregist_use_items']['conf_value']);
    	foreach($autoregist_use_items as $autoregist_use_item) 
		{
    		$buf_arr = explode(":", $autoregist_use_item);
    		if(isset($buf_arr[0]) && $buf_arr[0] != "") {
    			$autoregist_use_items[$buf_arr[0]] = $buf_arr[0];
    			$autoregist_use_items_req[$buf_arr[0]] = $buf_arr[1];
    		}
    	}
    	
    	$files = $this->get_file_original_name();
    	$files_key = array_keys($files);			
    	
    	foreach ($show_items as $show_items_key => $s_items) 
		{

			if ( $flag_allow && !$this->allow_items( $s_items ) ) {
				continue;
			}

    		if(!isset($autoregist_use_items[$s_items['item_id']])) {
    			// 自動ログインの項目ではない
    			if(isset($p_items) && isset($p_items[$s_items['item_id']])) {
					$this->set_error_code( 203 );
					return false;
    			}
    			continue;	
    		}
    		$err_prefix = $s_items['item_id'].":";
    		if($s_items['define_flag'] == _ON && defined($s_items['item_name'])) {
    			$s_items['item_name'] = constant($s_items['item_name']);
    			$show_items[$show_items_key]['item_name'] = $s_items['item_name'];
    		}
			if($s_items['type'] == "file") {
				// File
				// 必須入力チェック
				if($s_items['require_flag'] == _ON || (isset($autoregist_use_items_req[$s_items['item_id']]) && $autoregist_use_items_req[$s_items['item_id']] == _ON)) {
					
					$error_flag = true;
					foreach($files_key as $file_key) {
						if($s_items['item_id'] == $file_key && ($files[$file_key] != "" && $files[$file_key] != null)) {
							$error_flag = false;
							break;
						}
					}
					if($error_flag) {
						//ファイルアップロード未対応携帯なのに、このファイルは必須扱いになっている...
						//
						//つまり、この携帯からは登録できないので、PCから登録していただくか、
						//管理者にお願いして、必須から任意にかえていただくことを薦めます。
						//
						if (empty($files)) {
							$this->set_error_msg(  $err_prefix.$this->_lang_err_file_upload_noability );
							$this->set_error_code( 204 );
							return false;
						} else {
							$this->set_error_msg(  $err_prefix.sprintf(_REQUIRED, $s_items['item_name']) );	
							$this->set_error_code( 205 );
							return false;
						}
					}
				}
				continue;
			}
    		
    		if(isset($p_items) && isset($p_items[$s_items['item_id']])) {
    			$content = $p_items[$s_items['item_id']];
    		} else {
    			$content = "";
    		}
    		
    		// 必須入力チェック
    		if($s_items['require_flag'] == _ON || (isset($autoregist_use_items_req[$s_items['item_id']]) && $autoregist_use_items_req[$s_items['item_id']] == _ON)) {
    			// 必須項目
    			if ($content == "") {
 					$this->set_error_msg(  $err_prefix.sprintf(_REQUIRED, $s_items['item_name']) );
					$this->set_error_code( 206 );
					continue;
    			}
    		}
    		
    		if($s_items['tag_name'] == "login_id") {
	 			// 入力文字チェック
	 			$login_id = $content;
	 			$login_len = strlen($content);
		    	if($login_len < USER_LOGIN_ID_MINSIZE || $login_len > USER_LOGIN_ID_MAXSIZE) {
 					$this->set_error_msg(  $err_prefix.sprintf(_MAXRANGE_ERROR, USER_ITEM_LOGIN, USER_LOGIN_ID_MINSIZE, USER_LOGIN_ID_MAXSIZE) );
					$this->set_error_code( 207 );
					continue;
		    	}
		    	
		    	// 半角英数または、記号
		    	if(preg_match(_REGEXP_ALLOW_HALFSIZE_SYMBOL, $login_id)) {
 					$this->set_error_msg(  $err_prefix.sprintf(_HALFSIZESYMBOL_ERROR, USER_ITEM_LOGIN) );
					$this->set_error_code( 208 );
					continue;
		    	}
	 			
	 			// 重複チェック
	 			$count = $this->get_users_count_by_login_id( $login_id );
	 			if($count >= 1) {
 					$this->set_error_msg(  $err_prefix.sprintf($this->_lang_mes_error_duplicate, USER_ITEM_LOGIN, USER_ITEM_LOGIN) );
					$this->set_error_code( 209 );
					continue;
	 			}

	 		} else if($s_items['tag_name'] == "password") {
		    	$new_password = $content;
		    	// 入力文字チェック
		    	$pass_len = strlen($new_password);
		    	if($pass_len < USER_PASSWORD_MINSIZE || $pass_len > USER_PASSWORD_MAXSIZE) {
 					$this->set_error_msg(  $err_prefix.sprintf(_MAXRANGE_ERROR, USER_ITEM_PASSWORD, USER_PASSWORD_MINSIZE, USER_PASSWORD_MAXSIZE) );
					$this->set_error_code( 211 );
					continue;
		    	}
		    	
		    	if(!isset($items_password_confirm[$s_items['item_id']]) || $new_password != $items_password_confirm[$s_items['item_id']]) {
 					$this->set_error_msg(  $err_prefix.$this->_lang_err_pass_disaccord );
					$this->set_error_code( 212 );
					continue;
	    		}
		    	// 半角英数または、記号
		    	if(preg_match(_REGEXP_ALLOW_HALFSIZE_SYMBOL, $new_password)) {
 					$this->set_error_msg(  $err_prefix.sprintf(_HALFSIZESYMBOL_ERROR, USER_ITEM_PASSWORD) );
					$this->set_error_code( 213 );
					continue;
		    	}

	 		} else if($s_items['tag_name'] == "handle") {
	 			// 重複チェック
	 			$count = $this->get_users_count_by_handle( $content );
	 			if($count >= 1) {
 					$this->set_error_msg(  $err_prefix.sprintf($this->_lang_mes_error_duplicate, USER_ITEM_HANDLE, USER_ITEM_HANDLE) );
					$this->set_error_code( 214 );
					continue;
	 			}
	 		}
	 		if($s_items['type'] == "email" || $s_items['type'] == "mobile_email") {
	 			$email = $content;
	 			
	 			// 入力文字チェック
	 			if ( $email != "" && !strpos($email, "@") ) {
 					$this->set_error_msg(  $err_prefix.sprintf(_FORMAT_WRONG_ERROR, $s_items['item_name']) );
					$this->set_error_code( 215 );
					continue;
	 			}
	 			// 重複チェック
	 			if($email != "") {
					$count = $this->get_users_count_by_email( $email );
		 			if($count >= 1) {
 						$this->set_error_msg(  $err_prefix.sprintf($this->_lang_mes_error_duplicate, $s_items['item_name'] , $s_items['item_name'] ) );
						$this->set_error_code( 216 );
						continue;
		 			}
	 			}
	 			// メール受信可否
	 			if(isset($items_reception) && isset($items_reception[$s_items['item_id']])) {
		 			if($s_items['allow_email_reception_flag'] == _OFF || 
		 				!($items_reception[$s_items['item_id']] == _ON || 
		 					$items_reception[$s_items['item_id']] == _OFF)) {

 						$this->set_error_msg(  $err_prefix._INVALID_INPUT );
						$this->set_error_code( 217 );
						continue;
		 			}
	 			}
	 			
	 		}
 			
	 		// 公開設定
	 		if(isset($items_public) && isset($items_public[$s_items['item_id']])) {
	 			if($s_items['allow_public_flag'] == _OFF || 
	 				!($items_public[$s_items['item_id']] == _ON || 
	 					$items_public[$s_items['item_id']] == _OFF)) {
					$this->set_error_msg(  $err_prefix._INVALID_INPUT );
					$this->set_error_code( 218 );
					continue;
	 			}
 			}
    	}
    	
    	// 利用許諾
    	if(!isset($autoregist_disclaimer_ok)) {
 			$this->set_error_msg(  $this->_lang_err_mes_disclaimer );
			$this->set_error_code( 219 );
    	}

 		if ( $this->_error_code ) {
			return false;
		}

    	// 入力キー
    	if ($config['autoregist_use_input_key']['conf_value'] == _ON && 
    		$config['autoregist_input_key']['conf_value'] != $autoregist_input_key) {

 			$this->set_error_msg(  $this->_lang_err_mes_input_key );
			$this->set_error_code( 221 );
			return false;
    	}
    	
    	// File
    	$filelist = $this->get_uploads_filelist();
    	
		foreach($filelist as $key => $file) {
			if(isset($file['error_mes']) && $file['error_mes'] != "" && $file['error_mes'] != _FILE_UPLOAD_ERR_UPLOAD_NOFILE) {
				$err_prefix = $key.":";
 				$this->set_error_msg(  $err_prefix.$file['error_mes'] );
				$this->set_error_code( 222 );
				return false;

            }
		}

    	if( isset($param0) && $param0 ) {
    		$name_show_items = $param0 ;
		} else {
			$name_show_items = 'show_items';
		}

		$param = array(
			$name_show_items      => $show_items,
			'autoregist_approver' => $config['autoregist_approver']['conf_value'],
			'autoregist_author'   => $config['autoregist_author']['conf_value'],
			'autoregist_defroom'  => $config['autoregist_defroom']['conf_value'],
			'config'              => $config,
			'filelist'            => $filelist,
		);

		return $param;
    }
        
	/**
	 * fetch時コールバックメソッド
	 * @param result adodb object
	 * @return array items
	 * @access	private
	 */
	function &_getItemsFetchcallback($result) 
	{
		$ret = array();
		while ($row = $result->fetchRow()) {
			$ret[$row['item_id']] = $row;
		}
		return $ret;
	}

    function get_users_items_admin()
	{
    	$where_params = array(
    		"user_authority_id" => _AUTH_ADMIN		// 管理者固定
    	);
    	$show_items =& $this->_usersView->getItems($where_params, null, null, null, array($this, "_getItemsFetchcallback"));
		return $show_items;
	}

    function get_users_count_by_login_id( $login_id )
	{
	 	// 重複チェック
	 	$where_params = array("login_id" => $login_id);
	 	$users =& $this->_usersView->getUsers($where_params);
	 	$count = count($users);
		return $count;
	}

    function get_users_count_by_handle( $handle )
	{
		// 重複チェック
	 	$where_params = array("handle" => $handle);
	 	$users =& $this->_usersView->getUsers($where_params);
	 	$count = count($users);
		return $count;
	}

    function get_users_count_by_email( $email )
	{
		// 重複チェック
		$where_param = array(
			"({items}.type = 'email' OR {items}.type = 'mobile_email')  " => null,
			"{users_items_link}.content" => $email
		);
		$chk_items =& $this->_usersView->getItems($where_param);
		$count = count($chk_items);
		return $count;
	}

	function get_file_original_name()
	{
		return array();

// TODO
// Fatal error: Call to a member function getOriginalName() on a non-object
		$fileUpload =& $this->_container->getComponent("fileUpload");
    	$files = $fileUpload->getOriginalName();
		return $files;
	}

	function get_uploads_filelist()
	{
    	$garbage_flag = _OFF;
    	$filelist = $this->_uploadsAction->uploads($garbage_flag);
		return $filelist;
	}

    function allow_items( $item )
	{
		if ( in_array( $item['tag_name'], $this->_ALLOW_ITEMS ) ) {
			return true;
		}
		return false;
	}

//---------------------------------------------------------
// 新規登録の処理
// Openid_Action_Main_Register
// 参照 Login_Action_Main_Autoregist
//---------------------------------------------------------
    function register_excute( $p )
    {
		$this->_uploadsAction =& $this->_container->getComponent("uploadsAction");

		$autoregist_approver = $p['autoregist_approver'];
		$autoregist_author   = $p['autoregist_author'];
		$autoregist_defroom  = $p['autoregist_defroom'];

		$this->_config_general = $this->get_config_general();
		$this->_timezone_data  = timezone_date();

    	// ----------------------------------------------------------------------
		// --- 基本項目(usersテーブル)                                        ---
		// ----------------------------------------------------------------------
		$user_param = $this->get_register_user_param( $p );
		$user           = $user_param['user'];
		$handle         = $user_param['handle'];
		$post_mail_body = $user_param['post_mail_body'];

		$new_user_id = $this->set_user( $user );
		if ($new_user_id === false) {
			$this->set_error_code( 251 );
			return false;
		}

		// ----------------------------------------------------------------------
		// --- 詳細項目(users_items_linkデータ登録)                           ---
		// ----------------------------------------------------------------------
		$email_arr = $this->set_users_items_link( $new_user_id, $p, $user_param );
		if ($email_arr === false) {
			$this->set_error_code( 252 );
			return false;
		}

    	$authoritiy = $this->get_authority_by_id( intval($autoregist_author) );

    	if ($autoregist_defroom == _OFF) {
    		// ----------------------------------------------------------------------
			// ---参加ルーム(pages_users_link登録)                          　　  ---
			// ----------------------------------------------------------------------
			// 自動登録時にデフォルトのルームに参加するかどうか
    		// 参加させない場合、不参加で登録する
			$result = $this->set_pages_default_room( $new_user_id );
			if ($result === false) { 
				$this->set_error_code( 253 );
				return false;
			}

    	} else {
    		// ----------------------------------------------------------------------
			// ---参加ルーム(pages_users_link登録)                          　　  ---
			// ----------------------------------------------------------------------
			// 自動登録時にデフォルトのルームに参加し、デフォルトの参加が一般で、登録会員のベース権限がゲスト権限の場合、
			// ゲストとして参加させる必要がある。
    		if($authoritiy !== false && $authoritiy['user_authority_id'] == _AUTH_GUEST) {
				$result = $this->set_pages_default_guest();
		    	if ($result === false) {
					$this->set_error_code( 254 );
					return false;
				}
			}
    	}

    	// ----------------------------------------------------------------------
		// --- プライベートスペース作成                                       ---
		// ----------------------------------------------------------------------

		$permalink_handle = preg_replace( _PERMALINK_PROHIBITION, _PERMALINK_PROHIBITION_REPLACE, $handle );

		$private_page_id = $this->set_page_private( $new_user_id, $user, $handle, $permalink_handle, $authoritiy );
    	if ($private_page_id === false) {
			$this->set_error_code( 256 );
			return false;
		}

    	// ----------------------------------------------------------------------
		// --- 月別アクセス回数初期値登録		                              ---
		// ----------------------------------------------------------------------
		$result = $this->set_monthly_number( $new_user_id, $private_page_id );
		if ($result === false) {
			$this->set_error_code( 257 );
    		return false;
    	}

    	// ----------------------------------------------------------------------
		// --- 初期ページ追加　　　　　　		                              ---
		// ----------------------------------------------------------------------
		$result = $this->set_private_room( $private_page_id, $new_user_id, $handle );
		if($result === false)  {
			$this->set_error_code( 258 );
    		return false;
    	}

    	// ----------------------------------------------------------------------
		// --- マイポータル作成　　　　　　		                              ---
		// ----------------------------------------------------------------------
		$open_private_space = $this->_config_general['open_private_space']['conf_value'];
		if( $open_private_space == _OPEN_PRIVATE_SPACE_MYPORTAL_GROUP ||
			$open_private_space == _OPEN_PRIVATE_SPACE_MYPORTAL_PUBLIC ) {

			$result = $this->set_page_mypotal( $user, $permalink_handle, $authoritiy );
    		if($result === false)  {
				$this->set_error_code( 259 );
	    		return false;
	    	}
		}

    	// ----------------------------------------------------------------------
		// --- メール送信処理            		                              ---
		// ----------------------------------------------------------------------
		$this->send_mail( $new_user_id, $autoregist_approver, $user_param, $email_arr );

		$ret = array(
			'user_id'        => $new_user_id ,
			'use_ssl'        => $this->_config_general['use_ssl']['conf_value'] ,
		 	'post_mail_body' => $post_mail_body ,
		);
		return $ret;
    }

//---------------------------------------------------------
// 基本項目 (usersテーブル) 設定
//---------------------------------------------------------
	function get_register_user_param( $p )
	{
		$timezoneMain  =& $this->_container->getComponent("timezoneMain");

		$items               = $p['items'];
		$items_public        = $p['items_public'];
		$items_reception     = $p['items_reception'];
		$show_items          = $p['show_items'];
		$filelist            = $p['filelist'];
		$config              = $p['config'];
		$autoregist_approver = $p['autoregist_approver'];
		$autoregist_author   = $p['autoregist_author'];

		$handle = null;
		$post_mail_body = null;

		if ($autoregist_approver == _AUTOREGIST_SELF) {
			$active_flag = _USER_ACTIVE_FLAG_MAILED;
			$activate_key = $this->_getActivateKey(LOGIN_ACTIVATE_KYE_LEN);

			$mail_autoregist_subject = $config['mail_approval_subject']['conf_value'];
			$mail_autoregist_body = $config['mail_approval_body']['conf_value']."<br />";

		} else if($autoregist_approver == _AUTOREGIST_AUTO) {
			$active_flag = _USER_ACTIVE_FLAG_ON;
			$activate_key = "";

			$mail_autoregist_subject = "";
			$mail_autoregist_body = "";

		} else {
			$active_flag = _USER_ACTIVE_FLAG_PENDING;
			$activate_key = $this->_getActivateKey(	$this->_ACTIVATE_KEY_LEN );

			$mail_autoregist_subject = $config['mail_add_announce_subject']['conf_value'];
			$mail_autoregist_body = $config['mail_add_announce_body']['conf_value']."<br />";
		}

		$user = array(
			"role_authority_id" => intval($autoregist_author),
			"activate_key" => $activate_key,
			"active_flag" => $active_flag,
			"password_regist_time" =>  $this->_timezone_data,
			"last_login_time" => "",
			"previous_login_time" => "",
			"lang_dirname" => $this->_config_general['language']['conf_value'],
			"timezone_offset" => $this->_config_general['default_TZ']['conf_value']
		);

		$users_items_link = array();
		$users_items_link_flag_arr = array();
		$files_key = array_keys( $this->get_file_original_name() );

		foreach($show_items as $item_id => $item) 
		{
			if(!isset($items[$item_id]) && !(isset($filelist[$item_id]['upload_id']))) {
				continue;
			}

			$users_items_link[$item_id] = array(
				"user_id" => 0,
				"item_id" => $item_id,
				"public_flag" => _OFF,
				"email_reception_flag" => _OFF
			);

			if($item['tag_name'] != "" && $item['tag_name'] != "user_name"  &&
					$item['tag_name'] != "email") {
				$tag_name = $item['tag_name'];
				switch ($item['tag_name']) {
					//case "role_authority_name":
					//	$tag_name = "role_authority_id";
					//	break;
					//case "active_flag_lang":
					//	$tag_name = "active_flag";
					//	break;
					case "handle":
						$handle = $items[$item_id];
						break;
					case "lang_dirname_lang":
						$tag_name = "lang_dirname";
						break;
					case "timezone_offset_lang":
						$tag_name = "timezone_offset";
						if(defined($items[$item_id])) {
							$items[$item_id] = $timezoneMain->getFloatTimeZone(constant( $items[$item_id]) );
						}
						break;
				}
				$users_items_link_flag_arr[$item_id] = false;

				if($item['tag_name'] == "password") {
					$items[$item_id] = md5($items[$item_id]);
				} else {
					$post_mail_body .= $item['item_name']._SEPARATOR2.$items[$item_id]."\n";
				}
				$user[$tag_name] = $items[$item_id];

			} else {
				// users_items_linkデータ
				if($item['type'] == "radio" || $item['type'] == "checkbox" ||
					$item['type'] == "select") {
					if(is_array($items[$item_id])) {
						$users_items_link[$item_id]['content'] = implode("|", $items[$item_id]);
						$post_mail_body .= $item['item_name']._SEPARATOR2.implode(",", $items[$item_id])."\n";
					} else if($items[$item_id] == "") {
						$users_items_link[$item_id]['content'] = "";
						$post_mail_body .= $item['item_name']._SEPARATOR2.$items[$item_id]."\n";
					} else {
						$users_items_link[$item_id]['content'] = $items[$item_id] . "|";
						$post_mail_body .= $item['item_name']._SEPARATOR2.$items[$item_id]."\n";
					}
				} else {
					if(isset($filelist[$item_id]['upload_id'])) {
						$users_items_link[$item_id]['content'] = "?action=common_download_user&upload_id=".$filelist[$item_id]['upload_id'];
					} else {
						$users_items_link[$item_id]['content'] = $items[$item_id];
						$post_mail_body .= $item['item_name']._SEPARATOR2.$items[$item_id]."\n";
					}
				}
				$users_items_link_flag_arr[$item_id] = true;
			}

			if($item['allow_public_flag'] ==_ON && isset($items_public[$item_id]) &&
				$items_public[$item_id] == _ON) {
				$users_items_link[$item_id]['public_flag'] = _ON;
			}
			if($item['allow_email_reception_flag'] ==_ON && isset($items_reception[$item_id]) &&
				 $items_reception[$item_id] == _ON) {
				$users_items_link[$item_id]['email_reception_flag'] = _ON;
			}
		}

		if ( $handle == "" ) {
			$handle = _PRIVATE_SPACE_NAME;
		}

		$user_param = array( 
			'active_flag'               => $active_flag,
			'activate_key'              => $activate_key,
			'user'                      => $user, 
			'users_items_link'          => $users_items_link, 
			'users_items_link_flag_arr' => $users_items_link_flag_arr, 
			'handle'                    => $handle,
			'mail_autoregist_subject'   => $mail_autoregist_subject,
			'mail_autoregist_body'      => $mail_autoregist_body,
			'post_mail_body'            => $post_mail_body,
		);

		return $user_param;
	}

    /**
	 * アクティベーションキーを取得
	 *
	 * @param string $length 生成するアクティベーションキーの桁数
	 * @return string	アクティベーションキー
	 * @access	public
	 */
	function _getActivateKey($length) 
	{
		$duplicationFlag = true;

		$sql = "SELECT activate_key FROM {users} WHERE activate_key = ?";

		while ($duplicationFlag) {
			$activateKey = md5(uniqid(mt_rand(), 1));
			$activateKey = substr($activateKey, 0, $length);
			$user_params = array(
				$activateKey
			);

			$recordSet = $this->_db->execute($sql, $user_params);
			if ($recordSet === false) {
				$this->_db->addError();
				return false;
			}

			if (empty($recordSet)) {
				$duplicationFlag = false;
			}
		}

		return $activateKey;
	}

//---------------------------------------------------------
// 基本項目 (usersテーブル) 設定
//---------------------------------------------------------
	function set_user( $user )
	{
		$new_user_id = $this->_usersAction->insUser( $user );
		if ($new_user_id === false) {
			$this->set_error_admin(  $this->_usersAction->_db->ErrorMsg() );
			return false;
		}
		return $new_user_id;
	}

//---------------------------------------------------------
// 詳細項目 (users_items_link) 設定
//---------------------------------------------------------
	function set_users_items_link( $new_user_id, $p, $user_param )
	{
		$show_items = $p['show_items'];
		$filelist   = $p['filelist'];

		$users_items_link          = $user_param['users_items_link'];
		$users_items_link_flag_arr = $user_param['users_items_link_flag_arr'];

		//$email = "";
		$email_arr = array();
    	foreach ( $users_items_link as $item_id => $users_item_link ) 
		{
    		//$users_item_link[]
    		// users_items_linkが変更ないか、users_items_linkがなく初期値であれば
    		if ( $users_items_link_flag_arr[$item_id] == true  ) {
    			if(($users_items_link[$item_id]['content'] == '' &&
					   $users_items_link[$item_id]['public_flag'] == _OFF &&
					   $users_items_link[$item_id]['email_reception_flag'] == _OFF
					)) {
						//初期値のまま
						continue;
				}

				// 新規追加
				$users_item_link['user_id'] = $new_user_id;

    			$content = $users_item_link['content'];

    			$result = $this->_usersAction->insUserItemLink($users_item_link);
				if($result === false) {
					$this->set_error_admin(  $this->_usersAction->_db->ErrorMsg() );
					return false;
				}

    			if ($show_items[$item_id]['type'] == "file") {
					$upload_result = $this->set_avatar( $new_user_id, $filelist, $item_id );
					if ($upload_result === false) {
						return false;
					}

    			//} else if($show_items[$item_id]['tag_name'] == "email") {
    			} else if($show_items[$item_id]['type'] == "email" || $show_items[$item_id]['type'] == "mobile_email") {
    				$email_arr[] = $content;
    			}
			}
    	}
		return $email_arr;
	}

	function set_avatar( $new_user_id, $filelist, $item_id )
	{
		$upload_id = $filelist[$item_id]['upload_id'];
		$upload_params = array(
			"unique_id" => $new_user_id
		);
		$upload_where_params = array(
			"upload_id" => $upload_id,
		);
		$upload_result = $this->_uploadsAction->updUploads($upload_params, $upload_where_params);
		if ( $upload_result === false ) {
			return false;
		}
		return true;
	}

//---------------------------------------------------------
// 自動登録時にデフォルトのルームに参加する
// 参加させない場合、不参加で登録する
//---------------------------------------------------------
	function set_pages_default_room( $new_user_id )
	{
		$pages =& $this->get_pages_default_room();
		if ($pages === false) { 
			return false;
		}
		if ($pages == null) {
			return true;
		}

		foreach ($pages as $page) 
		{
			// 不参加として登録
			$user_params = array(
	    		"room_id" => $page['page_id'],
	    		"user_id" => $new_user_id,
	    		"role_authority_id" => _ROLE_AUTH_OTHER,
	    		"createroom_flag" => _OFF
	    	);
			$result = $this->_pagesAction->insPageUsersLink($user_params);
		    if ($result === false) {
				return false;
			}
		}
		return true;
	}

	function get_pages_default_room()
	{
		$where_params = array(
			"default_entry_flag" => _ON,
			"space_type" => _SPACE_TYPE_GROUP,
			"private_flag" => _OFF,
			"page_id = room_id" => null
		);
		$pages =& $this->_db->selectExecute("pages", $where_params);
		return $pages;
	}

//---------------------------------------------------------
// 自動登録時にデフォルトのルームに参加し、デフォルトの参加が一般で、登録会員のベース権限がゲスト権限の場合、
// ゲストとして参加させる必要がある。
//---------------------------------------------------------
	function set_pages_default_guest()
	{
		$pages =& $this->get_pages_default_guest();
		if ($pages === false) {
			return false;
		}
		foreach($pages as $page) 
		{
			$user_params = array(
				"room_id" => $page['page_id'],
		    	"user_id" => $new_user_id,
		    	"role_authority_id" => _ROLE_AUTH_GUEST,
		    	"createroom_flag" => _OFF
		    );
			$result = $this->_pagesAction->insPageUsersLink($user_params);
			if ($result === false) {
				return false;
			}
		}
		return true;
	}

	function get_pages_default_guest()
	{
		$pages = null;
		$where_params = null;

		$auth_public = $this->_session->getParameter("_default_entry_auth_public");
		$auth_group  = $this->_session->getParameter("_default_entry_auth_group");

		//$this->_session->getParameter("_default_entry_auth_private")

		if ( $auth_public == _AUTH_GENERAL &&
			 $auth_group == _AUTH_GENERAL ) {
			$where_params = array(
				"page_id = room_id" => null,
				"default_entry_flag" => _ON,
				"private_flag" => _OFF
			);
		
		} elseif ( $auth_public == _AUTH_GENERAL ) {
			$where_params = array(
				"page_id = room_id" => null,
				"default_entry_flag" => _ON,
				"private_flag" => _OFF,
				"space_type" => _SPACE_TYPE_PUBLIC
			);

		} elseif ( $auth_group == _AUTH_GENERAL ) {
			$where_params = array(
				"page_id = room_id" => null,
				"default_entry_flag" => _ON,
				"private_flag" => _OFF,
				"space_type" => _SPACE_TYPE_GROUP
			);
		}

		if($where_params != null) {
			$pages =& $this->_db->selectExecute("pages", $where_params);
		}
		return $pages;
	}

//---------------------------------------------------------
// プライベートスペースを作成する
//---------------------------------------------------------
	function set_page_private( $new_user_id, $user, $handle, $permalink_handle, $authoritiy )
	{
   		//権限テーブルのmyroom_use_flagにかかわらずプライベートスペース作成

    	if($authoritiy !== false && $authoritiy['myroom_use_flag'] == _ON) {
    		$myroom_display_flag = _ON;
    	} else {
    		$myroom_display_flag = _PAGES_DISPLAY_FLAG_DISABLED;
    	}

		//
		// ページテーブル追加
		//
		$buf_page_private =& $this->get_page_private();
		if ($buf_page_private === false) {
			return false;
		}

		$display_sequence = $buf_page_private['display_sequence'];

		// プライベートスペース名称取得
//		if(!isset($handle) || $handle == "") $handle = _PRIVATE_SPACE_NAME;

		$private_space_name = str_replace("{X-HANDLE}", $handle, $this->_config_general['add_private_space_name']['conf_value']);
		//if($this->_config_general['open_private_space']['conf_value'] == _ON) {
		//	// プライベートスペースが公開していれば、default_entry_flagをonにする
		//	$default_entry_flag = _ON;
		//} else {
			$default_entry_flag = _OFF;
		//}

//		$permalink_handle = preg_replace(_PERMALINK_PROHIBITION, _PERMALINK_PROHIBITION_REPLACE, $handle);

		if(_PERMALINK_PRIVATE_PREFIX_NAME != '') {
    		$permalink = _PERMALINK_PRIVATE_PREFIX_NAME.'/'.$permalink_handle;
    	} else {
    		$permalink = $permalink_handle;
    	}
    	$permalink = $this->_pagesAction->getRenamePermaLink($permalink);

		$user_params = array(
    		"site_id" => $this->_session->getParameter("_site_id"),
    		"root_id" => 0,
    		"parent_id" => 0,
    		"thread_num" => 0,
    		"display_sequence" => $display_sequence,
    		"action_name" => DEFAULT_ACTION,
    		"parameters" => "",
    		"page_name" => $private_space_name,
    		"permalink" => $permalink,
    		"show_count" => 0,
    		"private_flag" => _ON,
    		"default_entry_flag" => $default_entry_flag,
    		"space_type" => _SPACE_TYPE_GROUP,
    		"node_flag" => _ON,
    		"shortcut_flag" => _OFF,
    		"copyprotect_flag" => _OFF,
    		"display_scope" => _DISPLAY_SCOPE_NONE,
    		"display_position" => _DISPLAY_POSITION_CENTER,
    		"display_flag" => $myroom_display_flag,
			"insert_time" => $this->_timezone_data,
			"insert_site_id" => $this->_session->getParameter("_site_id"),
			"insert_user_id" => $new_user_id,
			"insert_user_name" => $user["handle"],
			"update_time" => $this->_timezone_data,
			"update_site_id" => $this->_session->getParameter("_site_id"),
			"update_user_id" => $new_user_id,
			"update_user_name" => $user["handle"]
    	);
    	$private_page_id = $this->_pagesAction->insPage($user_params, true, false);
    	if ($private_page_id === false) {
			return false;
		}

    	//
		// ページユーザリンクテーブル追加
		//
		$user_params = array(
			"room_id" => $private_page_id,
			"user_id" => $new_user_id,
			"role_authority_id" => _ROLE_AUTH_CHIEF,
			"createroom_flag" => _OFF
		);
		$result = $this->_pagesAction->insPageUsersLink($user_params);
    	if ($result === false) {
			return false;
		}

		return $private_page_id;
	}

	function get_page_private()
	{
		$private_where_params = array(
			"thread_num" => 0,
			"private_flag" => _ON,
			"display_sequence!=0" => null
		);
		$buf_page_private =& $this->_pagesView->getPages($private_where_params, null, 1);
		if ($buf_page_private === false) {
			return false;
		}
		if(!isset($buf_page_private[0])) {
			$this->set_db_error();
			return false;
		}
		return $buf_page_private[0];
	}

//---------------------------------------------------------
// 月別アクセス回数初期値登録
//---------------------------------------------------------
	function set_monthly_number( $new_user_id, $private_page_id )
	{
		$monthlynumberAction =& $this->_container->getComponent("monthlynumberAction");

		$name = "_hit_number";
//		$time = timezone_date();
		$year = intval(substr($this->_timezone_data, 0, 4));
		$month = intval(substr($this->_timezone_data, 4, 2));
		$user_params = array(
			"user_id" => $new_user_id,
			"room_id" => $private_page_id,
			"module_id" => 0,
			"name" => $name,
			"year" => $year,
			"month" => $month,
			"number" => 0
		);
		$result = $monthlynumberAction->insMonthlynumber($user_params);
		if($result === false)  {
    		return false;
    	}
		return true;
	}

//---------------------------------------------------------
// 初期ページ追加
//---------------------------------------------------------
	function set_private_room( $private_page_id, $new_user_id, $handle )
	{
		$blocksAction  =& $this->_container->getComponent("blocksAction");

		$result = $blocksAction->defaultPrivateRoomInsert( $private_page_id, $new_user_id, $handle );
		if($result === false) {
    		return false;
    	}
		return true;
	}

//---------------------------------------------------------
// マイポータル作成
//---------------------------------------------------------
	function set_page_mypotal( $user, $permalink_handle, $authoritiy )
	{
		//
		// display_sequence取得
		//
		$buf_page_private =& $this->get_page_mypotal();
		if ($buf_page_private === false) {
			return false;
		}

		if(isset($authoritiy['myportal_use_flag']) && $authoritiy['myportal_use_flag'] == _ON) {
			$display_flag = _ON;
		} else {
			$display_flag = _PAGES_DISPLAY_FLAG_DISABLED;
		}

		$display_sequence = $buf_page_private['display_sequence'];

		//
		// ページテーブル追加
		//
		$pages_params['page_name'] = $user["handle"];

		if(_PERMALINK_MYPORTAL_PREFIX_NAME != '') {
	    	$permalink = _PERMALINK_MYPORTAL_PREFIX_NAME.'/'.$permalink_handle;
	    } else {
	    	$permalink = $permalink_handle;
	    }
	    $permalink = $this->_pagesAction->getRenamePermaLink($permalink);
 
		$pages_params['permalink'] = $permalink;
		$pages_params['default_entry_flag'] = _ON;
		$pages_params['display_flag'] = $display_flag;
		$pages_params['display_sequence'] = $display_sequence;

		$private_page_id = $this->_pagesAction->insPage($pages_params, true, false);
	    if ($private_page_id === false) {
			return false;
		}

    	//
		// ページユーザリンクテーブル追加
		//
		$pages_users_link_params['room_id'] = $private_page_id;
		$result = $this->_pagesAction->insPageUsersLink($pages_users_link_params);
	    if ($private_page_id === false) {
			return false;
		}

		//
		// 月別アクセス回数初期値登録
		//
		$monthlynumber_params['room_id'] = $private_page_id;
		$result = $this->monthlynumberAction->insMonthlynumber($monthlynumber_params);
		if($result === false) {
    		return false;
    	}
		return true;
	}

	function get_page_mypotal()
	{
		$private_where_params = array(
			"thread_num" => 0,
			"private_flag" => _ON,
			"display_sequence!=0" => null,
			"default_entry_flag" => _ON
		);
		$buf_page_private =& $this->_pagesView->getPages($private_where_params, null, 1);
		if ($buf_page_private === false) {
			return false;
		}
		if(!isset($buf_page_private[0])) {
			$this->set_db_error();
			return false;
		}
		return $buf_page_private[0];
	}

//---------------------------------------------------------
// メール送信処理
//---------------------------------------------------------
	function send_mail( $new_user_id, $autoregist_approver, $user_param, $email_arr )
	{
		$mailMain =& $this->_container->getComponent("mailMain");

		$activate_key            = $user_param['activate_key'];
		$user                    = $user_param['user'];
		$mail_autoregist_subject = $user_param['mail_autoregist_subject'];
		$mail_autoregist_body    = $user_param['mail_autoregist_body'];
		$post_mail_body          = $user_param['post_mail_body'];

		if ( $mail_autoregist_subject == "" || count($email_arr) == 0) {
			return true;
		}

		if ( $autoregist_approver == _AUTOREGIST_SELF) {
			// ユーザ自身の確認が必要
			$mail_autoregist_body .= "<br />".BASE_URL. INDEX_FILE_NAME.
						"?action=login_action_main_approver" .
						"&user_id=" . $new_user_id . "&activate_key=". $activate_key."&_header="._OFF. "<br />";

			foreach($email_arr as $email) 
			{
				$user['email'] = $email;
				$user['type'] = "text";	// Text固定(html or text)
				$mailMain->addToUser($user);
			}

		} else {
			// 管理者の承認が必要
			$mail_autoregist_body .= $post_mail_body."<br />".BASE_URL. INDEX_FILE_NAME.
						"?action=login_action_main_approver" .
						"&user_id=" . $new_user_id . "&activate_key=". $activate_key."&_header="._OFF. "<br />";
			// 管理者取得
			$users = $this->get_send_mail_users_admin();
			$mailMain->setToUsers($users);
		}

		$mailMain->setSubject($mail_autoregist_subject);
		$mailMain->setBody($mail_autoregist_body);

		$meta =& $this->_session->getParameter("_meta");
		$tags["X-SITE_NAME"] = htmlspecialchars($meta['sitename']);

		$mailMain->assign($tags);
		$mailMain->send();

		return true;
	}

	function get_send_mail_users_admin()
	{
		$this->_usersView =& $this->_container->getComponent("usersView");
		$users = $this->_usersView->getSendMailUsers(null, _AUTH_ADMIN, "text");
		return $users;
	}

//---------------------------------------------------------
// DBエラーを設定する
//---------------------------------------------------------
	function set_db_error()
	{
		$this->_db->addError(get_class($this), sprintf(_INVALID_SELECTDB, "pages"));
	}

//---------------------------------------------------------
// ログイン処理
// Openid_View_Main_Callback Openid_Action_Main_Login Openid_Action_Main_Register
// 参照 Login_Action_Main_Init
//---------------------------------------------------------
	function login_excute( $p )
	{
		$user_id         = $p['user_id'] ;
		$login_id        = $p['login_id'] ;
		$last_login_time = $p['last_login_time'];
		$redirect_url    = isset($p['redirect_url']) ? $p['redirect_url'] : null ;

		$mobile_flag = $this->_session->getParameter("_mobile_flag");

		$this->set_session_in_login( $p );

		$ret = $this->update_last_login_time( $user_id, $last_login_time );
		if ( ( $mobile_flag != _ON ) && $ret ) {
			$this->set_cookie_in_login( $login_id );
		}

		$this->_redirect_url = $this->get_login_redirect_url( $user_id, $redirect_url );
		return true;
	}

	function get_redirect_url()	
	{
		return $this->_redirect_url;
	}

	function set_session_in_login( $p )
	{
		$login_id            = $p['login_id'] ;
		$user_id             = $p['user_id'] ;
		$handle              = $p['handle'] ;
		$role_authority_id   = $p['role_authority_id'] ;
		$timezone_offset     = $p['timezone_offset'] ;
		$last_login_time     = $p['last_login_time'] ;
		$system_flag         = $p['system_flag'] ;
		$lang_dirname        = $p['lang_dirname'] ;
		$user_authority_id   = $p['user_authority_id'] ;
		$allow_attachment    = $p['allow_attachment'] ;
		$allow_htmltag_flag  = $p['allow_htmltag_flag'] ;
		$role_authority_name = $p['role_authority_name'] ;
		$allow_attachment    = $p['allow_attachment'] ;
		$allow_layout_flag   = $p['allow_layout_flag'] ;
		$max_size            = $p['max_size'] ;
		$allow_video         = $p['allow_video'] ;

   		$this->_session->setParameter("_user_id", $user_id);  
   		$this->_session->setParameter("_login_id", $login_id);
		$this->_session->setParameter("_site_id", 0);
		$this->_session->setParameter("_handle", $handle);
		$this->_session->setParameter("_role_auth_id", $role_authority_id);
		$this->_session->setParameter("_timezone_offset", $timezone_offset);

	//role_authority_idよりデフォルト権限をセッションにセット
		$this->_session->setParameter("_role_authority_name", $role_authority_name);
		$this->_session->setParameter("_user_auth_id", $user_authority_id);

		if( !empty($lang_dirname) ) {
			$this->_session->setParameter("_lang", $lang_dirname);
		}

	// 添付関連をセッションに保存
		$this->_session->setParameter("_allow_attachment_flag", $allow_attachment);
    	$this->_session->setParameter("_allow_htmltag_flag", $allow_htmltag_flag);
    	$this->_session->setParameter("_allow_video_flag", $allow_video);

    // レイアウトできるかどうか(ヘッダー、左右カラムの表示非表示切り替え)
    // この値がON＋主担であれば切り替え可能
    	$this->_session->setParameter("_allow_layout_flag", $allow_layout_flag);

    // プライベートスペースに対する
	// アップロードの最大容量
    	$this->_session->setParameter("_private_max_size", $max_size);

	}

	function set_cookie_in_login( $login_id, $rememberme=false, $flag_pass=false )
	{
		$config = $this->get_config_general();

		$path = ini_get("session.cookie_path");
		$domain = ini_get("session.cookie_domain");
		$secure = ini_get("session.cookie_secure");

		$lifetime = time() + _AUTOLOGIN_LIFETIME; 	// 1 week default
		$autologin_login_cookie_name = $config['autologin_login_cookie_name']['conf_value'];
		$autologin_pass_cookie_name = $config['autologin_pass_cookie_name']['conf_value'];

		if( ($config['autologin_use']['conf_value'] == _AUTOLOGIN_LOGIN_ID || $config['autologin_use']['conf_value'] == _AUTOLOGIN_OK) &&
			$autologin_login_cookie_name != "") {
			setcookie($autologin_login_cookie_name, $login_id, $lifetime, $path, $domain, $secure);
		}

		if( $rememberme == _ON && $config['autologin_use']['conf_value'] == _AUTOLOGIN_OK &&
			$autologin_login_cookie_name != "" && $autologin_pass_cookie_name != "") {
			if ( $flag_pass ) {
				setcookie($autologin_pass_cookie_name, md5($this->password), $lifetime, $path, $domain, $secure);
			}
			setcookie($autologin_login_cookie_name, $login_id, $lifetime, $path, $domain, $secure);
		}
	}

//---------------------------------------------------------
// ログイン後のリダイレクト先を取得する
// Openid_View_Main_Attach
// 参照 Login_Action_Main_Init
//---------------------------------------------------------
	function get_login_redirect_url( $user_id, $redirect_url=null )
	{
		$myroom_page = $this->get_myroom_page( $user_id );
		if( $myroom_page ) {
			$this->_session->setParameter("_self_myroom_page", $myroom_page );
		}

		if ( $redirect_url ) {
			return $redirect_url;
		}

	// リダイレクト先がないならば、デフォルト表示するページIDを取得
		$active_page = $this->_getDefaultPage();
		if ( $active_page['permalink'] != "" ) {
		 	 $active_page['permalink'] .= '/';
		}

		$permalink_flag = $this->_session->getParameter("_permalink_flag");
		if ( $permalink_flag ) {
			$url = $active_page['permalink'];
		} else {
			$url = "index.php?".ACTION_KEY."=".$active_page['action_name']."&page_id=".$active_page['page_id'].$active_page['parameters'] ;
		}

		$url = BASE_URL.'/'.$url;
		return $url;
	}

	function get_myroom_page( $user_id )
	{
		$result = $this->_db->selectExecute("pages", array("private_flag" => _ON, "thread_num" => 0, "insert_user_id" => $user_id), array("default_entry_flag" => "ASC"), 2, 0);
		if( isset($result[0]) ) {
			return $result[0];
		}
		return false;
	}

/**
 * デフォルトのpage_idを取得
 * 
 * @return array page
 * @access  public
 */
	function _getDefaultPage() 
	{
		$getData   =& $this->_container->getComponent("GetData");

    	$page = array();
    	$page_id_arr = array();
    	$_user_id = $this->_session->getParameter("_user_id");
		$config = $getData->getParameter("config");
		$first_choice_startpage = intval($config[_GENERAL_CONF_CATID]['first_choice_startpage']['conf_value']);
  		$second_choice_startpage = intval($config[_GENERAL_CONF_CATID]['second_choice_startpage']['conf_value']);
  		$third_choice_startpage = intval($config[_GENERAL_CONF_CATID]['third_choice_startpage']['conf_value']);
		$default_private_space = 0;
		
  		if ($first_choice_startpage == 0) {
  			//指定なし
  			;
  		} elseif($first_choice_startpage != -1) {
  			$page_id_arr[] = $first_choice_startpage;
  		} else {
  			//プライベートスペース
  			$default_private_space = 1;
  		}

		if($second_choice_startpage == 0) {
			//指定なし
			;
		} elseif($second_choice_startpage != -1) {
			$page_id_arr[] = $second_choice_startpage;
		} else {
			//プライベートスペース
			if($default_private_space == 0) $default_private_space = 2;
		}

		if($third_choice_startpage == 0) {
			//指定なし
		;
		} elseif($third_choice_startpage != -1) {
			$page_id_arr[] = $third_choice_startpage;
		} else {
			//プライベートスペース
			if($default_private_space == 0) $default_private_space = 3;
		}

		$buf_pages_obj =& $this->_pagesView->getPageById($page_id_arr);
		$buf_page_obj = "";
		$show_page_id = 0;
		$set_default_private_space = 4;

		foreach($buf_pages_obj as $page_obj) {
			if(($page_obj['space_type'] == _SPACE_TYPE_PUBLIC && $page_obj['display_flag'] == _ON) ||
				($page_obj['space_type'] == _SPACE_TYPE_GROUP && $page_obj['default_entry_flag'] == _ON && $page_obj['display_flag'] == _ON && $_user_id != "0" && 
				(!isset($page_obj['role_authority_id']) || $page_obj['role_authority_id'] != _ROLE_AUTH_OTHER)) ||
				($page_obj['space_type'] == _SPACE_TYPE_GROUP && $page_obj['display_flag'] == _ON && $_user_id != "0") && (isset($page_obj['authority_id']))) {

				//閲覧できるpage_id有
				if($first_choice_startpage == $page_obj['page_id']) {
					$show_page_id = $page_obj['page_id'];
					$buf_pages_obj[$show_page_id] = $page_obj;
					$set_default_private_space = 1;
				} else if($second_choice_startpage == $page_obj['page_id'] && $set_default_private_space > 2) {
					$show_page_id = $page_obj['page_id'];
					$buf_pages_obj[$show_page_id] = $page_obj;
					$set_default_private_space = 2;
				} else if($third_choice_startpage == $page_obj['page_id'] && $set_default_private_space > 3) {
					$show_page_id = $page_obj['page_id'];
					$buf_pages_obj[$show_page_id] = $page_obj;
					$set_default_private_space = 3;
				}
			}
		}

	//優先順位がプライベートスペースのほうが高い場合
		if(($set_default_private_space == _OFF || $set_default_private_space > $default_private_space) && $default_private_space != 0 && $_user_id != "0") {
			//マイページからpage_id取得
			$buf_page_obj_private =& $this->_pagesView->getPrivateSpaceByUserId($_user_id, 1);
			if($buf_page_obj_private) {
				$show_page_id = $buf_page_obj_private[0]['page_id'];
				$buf_pages_obj[$show_page_id] = $buf_page_obj_private[0];
			}
		}

		if($show_page_id != 0) {
			$page_id = $show_page_id;
			$page = $buf_pages_obj[$page_id];
		}

		if(isset($page_id) && $page_id != 0){
			if(isset($buf_pages_obj[$page_id]) && $buf_pages_obj[$page_id]['node_flag'] == _ON && $buf_pages_obj[$page_id]['action_name'] == "") {
				//指定したpage_idがnodeであるならば
				//nodeの子供のうち最も近いページIDを取得
				if($buf_pages_obj[$page_id]['root_id'] == 0) {
					$root_id = $buf_pages_obj[$page_id]['page_id'];
				} else {
					$root_id = $buf_pages_obj[$page_id]['root_id'];
				}
				$where_params = array(
					"action_name!=''"=>null,
					"display_sequence!=0"=>null,
					"display_flag"=>_ON,
					"root_id"=>$root_id,
					"display_position"=>$buf_pages_obj[$page_id]['display_position'],
					"thread_num>".$buf_pages_obj[$page_id]['thread_num']=>null
				);
				$order_params =array(
					"{pages}.thread_num" => "ASC",
					"{pages}.display_sequence" => "ASC"
				);

				$buf_pages_obj_child =& $this->_pagesView->getShowPagesList($where_params, $order_params, 1, 0, array($this->_pagesView, 'fetchcallback'));

				if($buf_pages_obj_child && isset($buf_pages_obj_child[0])) {
					//親ノードの子供
					$page_id = $buf_pages_obj_child[0]['page_id'];
					$buf_pages_obj[$page_id] = $buf_pages_obj_child[0];
					$page = $buf_pages_obj[$page_id];
				}
			}
		}

		if(!isset($page_id)) {
			//デフォルトページがみつからない
			//見れるページIDを取得
			$where_params = array(
				"action_name!=''"=>null,
				"display_flag"=>_ON,
				"display_sequence!"=>0
			);
			$order_params =array(
				"{pages}.thread_num" => "ASC",
				"{pages}.display_sequence" => "ASC"
			);
			$buf_pages_obj_sub =& $this->_pagesView->getShowPagesList($where_params, $order_params, 1, 0, array($this->_pagesView, 'fetchcallback'));
			
			//少なくともバブリックページは１ページはあるとして処理
			$page_id = $buf_pages_obj_sub[0]['page_id'];
			$buf_pages_obj[$page_id] = $buf_pages_obj_sub[0];
			$page = $buf_pages_obj[$page_id];
		}

		return $page;
	}

	function update_last_login_time( $user_id, $last_login_time )
	{
		//最終ログイン日時、前回ログイン日時更新
		$params = array(
			"last_login_time"     => timezone_date(),
			"previous_login_time" => $last_login_time
		);
		$where_params = array("user_id" => $user_id);

		$ret = $this->_usersAction->updUsers($params, $where_params, false);
		if ( !$ret ) {
			$this->set_error_admin(  $this->_usersAction->_db->ErrorMsg() );
			$this->set_error_code( 231 );
			return false;
		}
		return true;
	}

//---------------------------------------------------------
// ログイン認証を行う
// Openid_Action_Main_Login
// 参照 Login_Validator_Logincheck
//---------------------------------------------------------
	function get_user_by_login_password( $login_id, $password )
	{
		$params = array(
			"login_id" => $login_id ,
			"password" => md5( $password )
		);

		$result = $this->_db->execute("SELECT user_id,handle,role_authority_id,timezone_offset,last_login_time,system_flag,lang_dirname FROM {users} WHERE login_id=? AND password=? AND active_flag="._USER_ACTIVE_FLAG_ON,$params,0,null,false);

		if( !is_array($result) ) {
			$this->set_error_admin( $this->_db->ErrorMsg() );
			$this->set_error_code( 232 );
			return false;
		}

		if( !isset($result[0][0]) ) {
			$this->set_error_code( 233 );
			return false;
		}

		$ret = array(
			"login_id"            => $login_id,
			"user_id"             => $result[0][0],
			"handle"              => $result[0][1],
			"role_authority_id"   => $result[0][2],
			"timezone_offset"     => $result[0][3],
			"last_login_time"     => $result[0][4],
			"system_flag"         => $result[0][5],
			"lang_dirname"        => $result[0][6],
		);

		return $ret;
	}

//---------------------------------------------------------
// user 情報を取得する
// Openid_View_Main_Callback Openid_Action_Main_Register
// 参照 Login_Validator_Logincheck
//---------------------------------------------------------
	function get_login_user_param( $user_id )
	{
		$user = $this->get_user_by_user_id( $user_id );
		return $this->get_user_param_extra( $user );
	}

	function get_user_by_user_id( $user_id )
	{
		$result = $this->_db->execute("SELECT login_id,handle,role_authority_id,timezone_offset,last_login_time,system_flag,lang_dirname FROM {users} WHERE user_id=? AND active_flag="._USER_ACTIVE_FLAG_ON,array($user_id),0,null,false);
		if( !is_array($result) ) {
			$this->set_error_admin( $this->_db->ErrorMsg() );
			$this->set_error_code( 234 );
			return false;
		}

		if( !isset($result[0][0]) ) {
			$this->set_error_code( 235 );
			return false;
		}

		$ret = array(
			"user_id"             => $user_id,
			"login_id"            => $result[0][0],
			"handle"              => $result[0][1],
			"role_authority_id"   => $result[0][2],
			"timezone_offset"     => $result[0][3],
			"last_login_time"     => $result[0][4],
			"system_flag"         => $result[0][5],
			"lang_dirname"        => $result[0][6],
		);
		return $ret;
	}

//---------------------------------------------------------
// user 拡張情報を取得する
// Openid_Action_Main_Login
// 参照 Login_Validator_Logincheck
//---------------------------------------------------------
	function get_user_param_extra( $p )
	{
		$role_authority_id = $p['role_authority_id'] ;

		$authorities =& $this->get_authority_by_id( $role_authority_id );

		if( $authorities === false || !isset($authorities['user_authority_id']) ) {
			$this->set_error_code( 236 );
			return false;
		}

		$config = $this->get_config_general();
		if( $config['closesite']['conf_value'] == _ON && $authorities['user_authority_id'] < $config['closesite_okgrp']['conf_value']) {
			// return LOGIN_ACTION_CLOSESITE;
			$this->set_error_msg( $this->_lang_action_closesite );
			$this->set_error_code( 237 );
			return false;
		}

// TODO : fatal error
//		$mobileAction =& $container->getComponent("mobileAction");
//		$mobileAction->setLogin( $result[0][0], $login_id, md5($password), $result[0][1] );

		if( $authorities['allow_video'] != _OFF ) {
			$module = $this->_modulesView->getModuleByDirname("multimedia");
		   	if(isset($module['module_id'])) {
				$allow_video = 2 ;
			} else {
				$allow_video =_ON ;
			}
		} else {
			$allow_video = $authorities['allow_video'] ;
		}

		$ret = array(
			"user_id"             => $p['user_id'] ,
			"login_id"            => $p['login_id'] ,
			"handle"              => $p['handle'] ,
			"role_authority_id"   => $role_authority_id ,
			"timezone_offset"     => $p['timezone_offset'] ,
			"last_login_time"     => $p['last_login_time'] ,
			"system_flag"         => $p['system_flag'] ,
			"lang_dirname"        => $p['lang_dirname'] ,
			"user_authority_id"   => $authorities['user_authority_id'],
			"allow_attachment"    => $authorities['allow_attachment'],
			"allow_htmltag_flag"  => $authorities['allow_htmltag_flag'],
			"role_authority_name" => $authorities['role_authority_name'],
			"allow_attachment"    => $authorities['allow_attachment'],
			"allow_layout_flag"   => $authorities['allow_layout_flag'],
			"max_size"            => $authorities['max_size'],
			"allow_video"         => $allow_video ,
		);

		return $ret;
	}

//---------------------------------------------------------
// users_item_link を取得する
//---------------------------------------------------------
	function get_users_item_link( $user_id, $name )
	{
		$item_id = $this->get_item_id_by_name( $name );
		if ( !$item_id ) {
			return false;
		}

		return $this->get_users_item_link_by_id( $user_id, $item_id );
	}

	function get_users_item_link_by_id( $user_id, $item_id )
	{
		$item = $this->_usersView->getUserItemLinkById( $user_id, $item_id );
		if ( isset($item['content']) ) {
			return $item['content'];
		}
		return false;
	}

	function get_item_id_by_name( $name )
	{
		$item_params = array(
			'item_name' => $name
		);

		$items = $this->_usersView->getItems( $item_params );

		$item_id = 0;
		if ( isset($items[0]['item_id']) ) {
			$item_id = $items[0]['item_id'];
		}

		if ( empty($item_id) ) {
			$this->set_error_code( 241 );
			return false;
		}

		return $item_id;
	}

//---------------------------------------------------------
// users_item_link に格納する
//---------------------------------------------------------
	function set_users_item_link( $user_id, $name, $value )
	{
		$item_id = $this->get_item_id_by_name( $name );
		if ( !$item_id ) {
			return false;
		}

		$content = $this->get_users_item_link_by_id( $user_id, $item_id );

		if ( $content === false ) {
			return $this->insert_users_item_link_by_id( $user_id, $item_id, $value );
		} else {
			return $this->update_users_item_link_by_id( $user_id, $item_id, $value );
		}
	}

	function insert_users_item_link_by_id( $user_id, $item_id, $value )
	{
		$public_flag          = 1;
		$email_reception_flag = 0;

		$params = array( 
			'user_id'              => $user_id ,
			'item_id'              => $item_id ,
			'public_flag'          => $public_flag ,
			'email_reception_flag' => $email_reception_flag ,
			'content'              => $value ,
		);

		$ret = $this->_usersAction->insUserItemLink( $params );
		if ( !$ret ) {
			$this->set_error_admin( $this->_usersAction->_db->ErrorMsg() );
			$this->set_error_code( 242 );
			return false;
		}
		return true;

	}

	function update_users_item_link_by_id( $user_id, $item_id, $value )
	{
		$params = array( 
			'content' => $value ,
		);

		$where = array( 
			'user_id' => $user_id ,
			'item_id' => $item_id ,
		);

		$ret = $this->_usersAction->updUsersItemsLink( $params, $where );
		if ( !$ret ) {
			$this->set_error_admin( $this->_usersAction->_db->ErrorMsg() );
			$this->set_error_code( 243 );
			return false;
		}
		return true;

	}

//---------------------------------------------------------
// config を取得する		
//---------------------------------------------------------
    function get_config_general()
	{
		$config = $this->_configView->getConfigByCatid(_SYS_CONF_MODID, _GENERAL_CONF_CATID);
		return $config;
	}

    function get_config_enter_exit()
	{
		$config = $this->_configView->getConfigByCatid(_SYS_CONF_MODID, _ENTER_EXIT_CONF_CATID);
		return $config;
	}

//---------------------------------------------------------
// 権限を取得する
//---------------------------------------------------------
	function get_authority_by_id( $id )
	{
		$authoritiesView =& $this->_container->getComponent("authoritiesView");
    	$authoritiy = $authoritiesView->getAuthorityById( $id );
		return $authoritiy;
	}

//---------------------------------------------------------
// cookie を設定する
// 未使用
//---------------------------------------------------------
	function set_cookie( $key, $value, $time=3600 )
	{
		$path   = ini_get("session.cookie_path");
		$domain = ini_get("session.cookie_domain");
		$secure = ini_get("session.cookie_secure");

		$lifetime = time() + $time;

		setcookie( $key, $value, $lifetime, $path, $domain, $secure );
	}

//---------------------------------------------------------
// cookie を取得する
// 未使用
//---------------------------------------------------------
	function get_cookie( $key )
	{
		$str = isset($_COOKIE[ $key ]) ? $_COOKIE[ $key ] : null;
		return $str;
	}

//---------------------------------------------------------
// token を検査する
// Openid_Action_Main_Login
//---------------------------------------------------------
	function check_token()
	{
		require_once MAPLE_DIR.'/nccore/TokenExtra.class.php';

		$request =& $this->_container->getComponent("Request");

		$token =& new TokenExtra();
		$token->setSession( $this->_session );
		return $token->check( $request );
	}

// === class end ===
}
?>