<?php
// $Id: Admin.class.php,v 1.1.1.1 2010/09/07 09:15:11 ohwada Exp $

//=========================================================
// Exauth Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Exauth_Admin
{
	// コンポーネント
	var $_container    = null;
	var $_configView   = null;
	var $_configAction = null;
	var $_modulesView  = null;

	// ローカル変数
	var $_module_id = null;
	var $_id = null;

/**
 * コンストラクター
 *
 * @access	public
 */
	function Exauth_Admin() 
	{
		$this->_container    =& DIContainerFactory::getContainer();
		$this->_configView   =& $this->_container->getComponent("configView");
		$this->_configAction =& $this->_container->getComponent("configAction");
		$this->_modulesView  =& $this->_container->getComponent("modulesView");
	}

    function set_id( $id )
    {
		$this->_id = $id;
	}

//---------------------------------------------------------
// config を取得する
//---------------------------------------------------------
	function get_config()
	{
		return $this->get_config_with_modid( $this->_module_id );
	}

	function get_config_with_modid( $conf_modid, $catid_as_key=false )
	{
		return $this->_configView->getConfig( $conf_modid, $catid_as_key );
	}

//---------------------------------------------------------
// config を設定する
//---------------------------------------------------------
    function update_config( $key )
	{
		$value = isset($_POST[$key]) ? $_POST[$key] : null;
    	return $this->upd_config_value_with_modid( 
			$this->_module_id, $key, $value );
	}

    function upd_config_value_with_modid( 
		$conf_modid, $conf_name, $conf_value, $conf_catid=_MAIN_CONF_CATID )
	{
    	return $this->_configAction->updConfigValue( 
			 $conf_modid, $conf_name, $conf_value, $conf_catid );
	}

//---------------------------------------------------------
// module_id を取得する
//---------------------------------------------------------
	function get_module_id_by_dirname( $dirname )
	{
	    $module = $this->_modulesView->getModuleByDirname( $dirname );
    	if ( isset($module['module_id']) ) {
			return $module['module_id'];	
		}
		return false;
	}

//---------------------------------------------------------
// テンプレートを表示する
//---------------------------------------------------------
	function fetch_template( $assign, $template_dir, $template )
	{
		$renderer = new SmartyTemplate;
		$renderer->setTemplateDir(  $template_dir );
		$renderer->assign( $assign );
		$result = $renderer->fetch( $template );
		return $result;
	}

// === class end ===
}

?>