<?php
// $Id: User.class.php,v 1.1.1.1 2010/09/07 09:15:12 ohwada Exp $

//=========================================================
// Exauth Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Exauth_User
{
	// R|[lg
	var $_container   = null;
	var $_usersView   = null;

/**
 * RXgN^[
 *
 * @access	public
 */
	function Exauth_User() 
	{
		$this->_container   =& DIContainerFactory::getContainer();
		$this->_usersView   =& $this->_container->getComponent("usersView");
	}

	function get_users_item_link( $user_id, $name )
	{
		$item_id = $this->get_item_id_by_name( $name );
		if ( !$item_id ) {
			return false;
		}
		return $this->get_users_item_link_by_id( $user_id, $item_id );
	}

	function get_users_item_link_by_id( $user_id, $item_id )
	{
		$item = $this->_usersView->getUserItemLinkById( $user_id, $item_id );
		if ( isset($item['content']) ) {
			return $item['content'];
		}
		return false;
	}

	function get_item_id_by_name( $name )
	{
		$item_params = array(
			'item_name' => $name
		);

		$items = $this->_usersView->getItems( $item_params );

		$item_id = 0;
		if ( isset($items[0]['item_id']) ) {
			$item_id = $items[0]['item_id'];
		}

		if ( empty($item_id) ) {
			return false;
		}

		return $item_id;
	}

// === class end ===
}

?>