<?php
// $Id: Utility.class.php,v 1.1.1.1 2010/09/07 09:15:13 ohwada Exp $

//=========================================================
// Exauth Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Exauth_Utility
{
/**
 * RXgN^[
 *
 * @access	public
 */
	function Exauth_Utility() 
	{
		// dummy
	}

	function clear_compiled_tpl_in_exauth()
	{
		$dir = WEBAPP_DIR . '/templates/exauth/';
 		$this->clear_compiled_tpl_in_dir( $dir );
	}

	function clear_compiled_tpl_in_dir( $dir )
	{
		$files = $this->get_files_in_dir( $dir, 'html' );
 		$this->clear_compiled_tpl( $dir, $files );
	}

	function clear_compiled_tpl( $dir, $files )
	{
		$renderer =& SmartyTemplate::getInstance();
		$renderer->setTemplateDir( $dir );
		foreach ( $files as $file ) {
			$renderer->clear_compiled_tpl( $file );
		}
		return true;
	}

	function get_files_in_dir( $path, $ext=null, $flag_dir=false, $flag_sort=false, $id_as_key=false  )
	{
		$arr = array();

		$lists = $this->get_lists_in_dir( $path );
		if ( !is_array($lists) ) {
			return false;
		}

		$pattern = "/\.". preg_quote($ext) ."$/";

		foreach ( $lists as $list ) 
		{
			$path_list = $path .'/'. $list;

// check is file
			if ( is_dir($path_list) || !is_file($path_list) ) {
				continue;
			}

// check ext
			if ( $ext && !preg_match($pattern, $list) ) {
				continue;
			}

			$arr[] = $list;
		}

		return $arr;
	}

	function get_lists_in_dir( $path )
	{
		$arr = array();

// check is dir
		if ( !is_dir($path) ) {
			return false;
		}

// open
		$dh = opendir($path);
		if ( !$dh ) {
			return false;
		}

// read
		while ( false !== ($list = readdir( $dh )) ) {
			$arr[] = $list;
		}

// close
		closedir( $dh );
		return $arr;
	}
// === class end ===
}

?>