<?php
// $Id: View.class.php,v 1.1.1.1 2010/09/07 09:15:12 ohwada Exp $

//=========================================================
// Exauth Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Exauth_View
{
	// コンポーネント
	var $_container   = null;
	var $_session     = null;
	var $_commonMain  = null;
	var $_configView  = null;
	var $_usersView   = null;
	var $_modulesView = null;

	// ローカル変数
	var $_error_msg  = null;
	var $_error_code = 0;

	var $_module_id    = 0;
	var $_template_dir = null;

	var $_lang_redirect_message = null ;
	var $_lang_redirect_submit  = null ;
	var $_lang_incorrect_login  = null ;
	var $_lang_caption_register = null ;
	var $_lang_caption_login    = null ;
	var $_lang_caption          = null ;
	var $_lang_register         = null ;
	var $_lang_dialog_name      = null ;
	var $_lang_top_description  = null ;
	var $_lang_require_flag     = null ;
	var $_lang_reception_email  = null ;
	var $_lang_public_flag      = null ;
	var $_lang_password_confirm = null ;
	var $_lang_login            = null ;
	var $_lang_ssl_login        = null ;
	var $_lang_login_id         = null ;
	var $_lang_password         = null ;
	var $_lang_cancel           = null ;
	var $_lang_lost_password    = null ;
	var $_lang_select_title     = null ;
	var $_lang_select_caption   = null ;
	var $_lang_select_note      = null ;
	var $_lang_select_override  = null ;
	var $_lang_yes              = null ;
	var $_lang_no               = null ;
	var $_lang_err_someting     = null ;
	var $_lang_err_autoregist   = null;
	var $_lang_register_login_title      = null ;
	var $_lang_register_login_note       = null ;
	var $_lang_register_note             = null ;
	var $_lang_login_note                = null ;
	var $_lang_autoregist_disclaimer     = null ;
	var $_lang_autoregist_disclaimer_ok  = null ;
	var $_lang_autoregist_input_key      = null ;
	var $_lang_autoregist_input_key_desc = null ;

	var $_ALLOW_ITEMS = array('login_id', 'handle', 'email');
	var $_SESSION_NAME_REDIRECT = 'exauth_redirect';

	var $_TEMPLATE_DIR_EXAUTH     = null;
	var $_TEMPLATE_REGISTER       = 'exauth_register.html';
	var $_TEMPLATE_LOGIN          = 'exauth_login.html';
	var $_TEMPLATE_REGISTER_LOGIN = 'exauth_register_login.html';
	var $_TEMPLATE_SELECT         = 'exauth_select.html';
	var $_TEMPLATE_REDIRECT       = 'exauth_redirect.html';

	var $_REDIRECT_TIME_SERVER  = 1;	// 1 sec
	var $_REDIRECT_TIME_SUCCESS = 1;	// 1 sec
	var $_REDIRECT_TIME_ERROR   = 5;	// 5 sec

/**
 * コンストラクター
 *
 * @access	public
 */
	function Exauth_View() 
	{
		$this->_container   =& DIContainerFactory::getContainer();
		$this->_session     =& $this->_container->getComponent("Session");
		$this->_commonMain  =& $this->_container->getComponent("commonMain");
		$this->_configView  =& $this->_container->getComponent("configView");
		$this->_usersView   =& $this->_container->getComponent("usersView");
		$this->_modulesView =& $this->_container->getComponent("modulesView");

		$this->_TEMPLATE_DIR_EXAUTH = WEBAPP_DIR . '/templates/exauth/';
	}

	function set_lang() 
	{
		$this->_lang_redirect_message   = EXAUTH_GOTO_AUTH_PAGE ;
		$this->_lang_redirect_submit    = EXAUTH_CLICK_HERE ;
		$this->_lang_incorrect_login    = EXAUTH_INCORRECT_LOGIN ;
		$this->_lang_caption_register   = EXAUTH_CAPTION_REGISTER ;
		$this->_lang_caption_login      = EXAUTH_CAPTION_LOGIN ;
		$this->_lang_caption            = EXAUTH_REGISTER_LOGIN_CAPTION ;
		$this->_lang_register           = EXAUTH_REGISTER ;
		$this->_lang_dialog_name        = EXAUTH_DIALOG_NAME ;
		$this->_lang_top_description    = EXAUTH_TOP_DESCRIPTION ;
		$this->_lang_require_flag       = EXAUTH_REQUIRE_FLAG ;
		$this->_lang_reception_email    = EXAUTH_RECEPTION_EMAIL ;
		$this->_lang_public_flag        = EXAUTH_PUBLIC_FLAG ;
		$this->_lang_password_confirm   = EXAUTH_PASSWORD_CONFIRM ;
		$this->_lang_login              = EXAUTH_LOGIN ;
		$this->_lang_ssl_login          = EXAUTH_SSL_LOGIN ;
		$this->_lang_login_id           = EXAUTH_LOGIN_ID ;
		$this->_lang_password           = EXAUTH_PASSWORD ;
		$this->_lang_cancel             = EXAUTH_CANCEL ;
		$this->_lang_lost_password      = EXAUTH_LOST_PASSWORD ;
		$this->_lang_select_title       = EXAUTH_SELECT_TITLE ;
		$this->_lang_select_caption     = EXAUTH_SELECT_CAPTION ;
		$this->_lang_select_note        = EXAUTH_SELECT_NOTE ;
		$this->_lang_select_override    = EXAUTH_SELECT_OVERRIDE ;
		$this->_lang_yes                = EXAUTH_YES ;
		$this->_lang_no                 = EXAUTH_NO ;
		$this->_lang_err_someting       = EXAUTH_ERR_SOMETING ;
		$this->_lang_err_autoregist     = EXAUTH_MES_ERR_AUTOREGIST;

		$this->_lang_register_login_title      = EXAUTH_REGISTER_LOGIN_TITLE ;
		$this->_lang_register_login_note       = EXAUTH_REGISTER_LOGIN_NOTE ;
		$this->_lang_register_note             = EXAUTH_REGISTER_NOTE ;
		$this->_lang_login_note                = EXAUTH_LOGIN_NOTE ;
		$this->_lang_autoregist_disclaimer     = EXAUTH_AUTOREGIST_DISCLAIMER ;
		$this->_lang_autoregist_disclaimer_ok  = EXAUTH_AUTOREGIST_DISCLAIMER_OK ;
		$this->_lang_autoregist_input_key      = EXAUTH_AUTOREGIST_INPUT_KEY ;
		$this->_lang_autoregist_input_key_desc = EXAUTH_AUTOREGIST_INPUT_KEY_DESC ;

	}

//---------------------------------------------------------
// エラーメッセージ
//---------------------------------------------------------
	function get_error_msg()
	{
		$code  = $this->get_error_code();
		$error = $this->get_error_msg_raw();
		if ( empty($error) && $code ) {
			$error = $this->_lang_err_someting .' ('.$code.')';
		}
		return $error;
	}

	function get_error_code() 
	{
		return $this->_error_code ;
	}

	function get_error_msg_raw() 
	{
		return $this->_error_msg ;
	}

//---------------------------------------------------------
// 会員登録を受け付ける場合の自動登録画面表示
//---------------------------------------------------------
    function get_register_param( $flag_allow=false )
    {
		$autoregist_use_items     = array();
		$autoregist_use_items_req = array();

    	$config = $this->get_config_enter_exit();

    	if ($config['autoregist_use']['conf_value'] != _ON) {
			$this->_error_code = 101 ;
			$this->_error_msg  = $this->_lang_err_autoregist;
    		return false;	
    	}

     	$items =& $this->get_users_admin();
    	if ($items === false) {
			$this->_error_code = 102 ;
			return false;
    	}

		if ( $flag_allow ) {
			$items = $this->build_users_allow( $items );
		}

    	$autoregist_use_items_array = explode("|", $config['autoregist_use_items']['conf_value']);
    	foreach( $autoregist_use_items_array as $autoregist_use_item ) 
		{
    		$buf_arr = explode(":", $autoregist_use_item);
    		if ( isset($buf_arr[0]) && $buf_arr[0] != "" ) {
    			$autoregist_use_items[     $buf_arr[0] ] = $buf_arr[0];
    			$autoregist_use_items_req[ $buf_arr[0] ] = $buf_arr[1];
    		}
    	}

    	$autoregist_disclaimer    = $config['autoregist_disclaimer']['conf_value'];
    	$autoregist_use_input_key = $config['autoregist_use_input_key']['conf_value'];

		$param = array(
			'items'                    => $items ,
			'autoregist_use_items'     => $autoregist_use_items ,
			'autoregist_use_items_req' => $autoregist_use_items_req ,
			'autoregist_disclaimer'    => $autoregist_disclaimer ,
		 	'autoregist_use_input_key' => $autoregist_use_input_key ,
		);

    	return $param;
    }

    function replace_register_param( $param, $input )
    {
		$param['items'] = $this->replace_users_item( $param['items'], $input['items'] );
		$param['autoregist_disclaimer_ok'] = $input['autoregist_disclaimer_ok'];
		$param['autoregist_input_key']     = $input['autoregist_input_key'];
		return $param;
	}

    function get_users_admin()
	{
	   	$_system_user_id = $this->_session->getParameter("_system_user_id");
    	$items =& $this->_usersView->getShowItems( $_system_user_id, _AUTH_ADMIN );
		return $items;
	}

    function build_users_allow( $items )
	{
		$arr1 = array();
		foreach ( $items as $item1 )
		{
			$arr2 = array();
			foreach ( $item1 as $item2 )
			{
				if ( in_array( $item2['tag_name'], $this->_ALLOW_ITEMS ) ) {
					$arr2[] = $item2;
				}
			}
			$arr1[] = $arr2;
		}
		return $arr1;
	}

    function replace_users_item( $items, $items_value )
	{
		$arr1 = array();
		foreach ( $items as $item1 )
		{
			$arr2 = array();
			foreach ( $item1 as $item2 )
			{
				foreach ( $items_value as $k => $v )
				{
					if ( $item2['item_id'] == $k ) {
						 $item2['content'] = $v;
					}
				}
				$arr2[] = $item2;
			}
			$arr1[] = $arr2;
		}
		return $arr1;
	}

//---------------------------------------------------------
// user_id を取得する
//---------------------------------------------------------
	function get_userid_by_key( $key, $value )
	{
		$items = $this->get_users_items( $key, $value );
		if ( isset($items[0]['user_id']) ) {
			return $items[0]['user_id'];
		}
		return false;
	}

	function get_users_items( $key, $value )
	{
		$where = array( 
			'item_name' => $key ,
			'content'   => $value ,
		);
		return $this->_usersView->getItems( $where );
	}

//---------------------------------------------------------
// 新規登録 か 関連付け かを取得する
//---------------------------------------------------------
    function get_mode_register_login( $mode )
    {
		$register = false;
		$login    = false;

		if ( ($mode == 1) || ($mode == 2) ) {
			$register = $this->is_config_autoregist_use_on();
		}

		if ( ($mode == 0) || ($mode == 2) || !$register ) {
			$login = true;
		}

		return array( $register, $login );
	}

//---------------------------------------------------------
// config を取得する
//---------------------------------------------------------
    function is_config_use_ssl_on()
	{
		if ( $this->get_config_use_ssl() == _ON ) {
			return true;
		}
		return false;
	}

    function is_config_autoregist_use_on()
	{
		if ( $this->get_config_autoregist_use() == _ON ) {
			return true;
		}
		return false;
	}

    function get_config_use_ssl()
	{
		return $this->get_config_general_by_key( 'use_ssl' );
	}

    function get_config_closesite()
	{
		return $this->get_config_general_by_key( 'closesite' );
	}

    function get_config_autoregist_use()
	{
		return $this->get_config_enter_exit_by_key( 'autoregist_use' );
	}

    function get_config_general_by_key( $key )
	{
		$config = $this->get_config_general();
		$val    = isset($config[ $key ]['conf_value']) ? $config[ $key ]['conf_value'] : null;
		return $val;
	}

    function get_config_enter_exit_by_key( $key )
	{
		$config = $this->get_config_enter_exit();
		$val    = isset($config[ $key ]['conf_value']) ? $config[ $key ]['conf_value'] : null;
		return $val;
	}

    function get_config_general()
	{
       	$config = $this->_configView->getConfigByCatid(_SYS_CONF_MODID, _GENERAL_CONF_CATID);
		return $config;
	}

    function get_config_enter_exit()
    {
    	$config = $this->_configView->getConfigByCatid(_SYS_CONF_MODID, _ENTER_EXIT_CONF_CATID);
		return $config;
	}

	function get_module_config_by_key( $module_id, $key )
	{
        $config = $this->get_module_config( $module_id );
		$val    = isset($config[ $key ]['conf_value']) ? $config[ $key ]['conf_value'] : null;
		return $val;
	}

	function get_module_config( $module_id )
	{
        $config = $this->_configView->getConfig( $module_id, false );
		return $config;
	}

//---------------------------------------------------------
// module_id を取得する
//---------------------------------------------------------
	function get_module_id_by_dirname( $dirname )
	{
	    $module = $this->_modulesView->getModuleByDirname( $dirname );
    	if ( isset($module['module_id']) ) {
			return $module['module_id'];	
		}
		return false;
	}

	function module_installed_by_dirname( $dirname )
	{
		if ( $this->get_module_id_by_dirname( $dirname ) ) {
			return true;
		}
		return false;
	}

//---------------------------------------------------------
// token を取得する
//---------------------------------------------------------
	function get_token_value()
	{
		require_once MAPLE_DIR.'/nccore/TokenExtra.class.php';

		$token =& new TokenExtra();
		$token->setSession( $this->_session );
		$token->build();
		return $token->getValue();
	}

//---------------------------------------------------------
// url の区切り記号を取得する
//---------------------------------------------------------
	function get_seprator_from_url( $url )
	{
		return $this->get_separator_from_type( $this->analyze_url_type( $url ) );
	}

//---------------------------------------------------------
// analyze_url_type
//
// url:
//   type 0: unknown
//   type 1: foo.php
//   type 2: foo.php?
//   type 3: foo.php?bar=abc
//---------------------------------------------------------
	function analyze_url_type( $url )
	{
		$type = 0;	// foo.php

// set url_type, if ? in url
		if ( preg_match('/\?/', $url) ) {
			$url_arr = explode('?', $url);
			if ( $url_arr[1] ) {
				$type = 3;	// foo.php?bar=abc
			} else {
				$type = 2;	// foo.php?
			}
		} else {
			$type = 1;	// foo.php
		}

		return $type;
	}

	function get_separator_from_type( $type )
	{
		$str = '';
		switch ($type)
		{
		case 1:
			$str = '?';
			break;

		case 2:
			$str = '';
			break;

		case 3:
			$str = '&';
			break;
		}
		return $str;
	}

//---------------------------------------------------------
// server へのリダイレクトを表示する
//---------------------------------------------------------
	function redirect_server( $url, $args )
	{
		$time_msec = 1000 * $this->_REDIRECT_TIME_SERVER;

		$action = array(
			'url'       => $url ,
			'args'      => $args ,
			'time_msec' => $time_msec ,
		);

		$lang = array(
			'redirect_message' => $this->_lang_redirect_message ,
			'redirect_submit'  => $this->_lang_redirect_submit ,
		);

		$assign = array(
			'action' => $action , 
			'lang'   => $lang ,
		);

		$this->header_content_type();
		echo $this->fetch_template( 
			$assign, $this->_TEMPLATE_DIR_EXAUTH, $this->_TEMPLATE_REDIRECT );
		exit();
	}

//---------------------------------------------------------
// 新規登録フォームを表示する
//---------------------------------------------------------
	function display_register_form( 
		$param, $error, $show_register=true, $show_login=false )
	{
		$action = array(
			'items'                    => $param['items'],
			'autoregist_use_items'     => $param['autoregist_use_items'] ,
			'autoregist_use_items_req' => $param['autoregist_use_items_req'] ,
			'autoregist_disclaimer'    => $param['autoregist_disclaimer'] ,
			'autoregist_disclaimer_ok' => $param['autoregist_disclaimer_ok'] ,
		 	'autoregist_use_input_key' => $param['autoregist_use_input_key'] ,
		 	'autoregist_input_key'     => $param['autoregist_input_key'] ,

//			'items_public'             => $param['items_public'],
//			'items_reception'          => $param['items_reception'],
//			'items_password_confirm'   => $param['items_password_confirm'],
		);

		$this->display_register_login_form( 
			$action, $error, $show_register, $show_login );
		exit();
	}

//---------------------------------------------------------
// ログイン フォームを表示する
//---------------------------------------------------------
	function display_login_form( 
		$param, $error=null, $show_register=false, $show_login=true )
	{
		if ( empty($error) ) {
			$error = $this->_lang_incorrect_login ;
		}

		$action = array(
			'login_id'  => $param['login_id'] ,
			'password'  => $param['password'] ,
			'closesite' => $this->get_config_closesite() ,
		);

		$this->display_register_login_form( 
			$action, $error, $show_register, $show_login );
		exit();
	}

//---------------------------------------------------------
// 新規登録 & ログイン フォームを表示する
//---------------------------------------------------------
	function display_register_login_form( 
		$action, $error, $show_register, $show_login )
	{

		$action['base_url']         = $this->get_base_url();
		$action['action_register']  = $this->_action_register ;
		$action['action_login']     = $this->_action_login ;
		$action['show_register']    = $show_register ;
		$action['show_login']       = $show_login ;
		$action['token']            = $this->get_token_value() ;

		$lang = array(
			'register_login_title'   => $this->_lang_register_login_title ,
			'register_login_caption' => $this->_lang_register_login_caption ,
			'register_login_note'    => $this->_lang_register_login_note ,
			'register_note'          => $this->_lang_register_note ,
			'login_note'             => $this->_lang_login_note ,
			'caption_register'       => $this->_lang_caption_register ,
			'caption_login'          => $this->_lang_caption_login ,

			'register'                  => $this->_lang_register ,
			'dialog_name'               => $this->_lang_dialog_name ,
			'top_description'           => $this->_lang_top_description ,
			'require_flag'              => $this->_lang_require_flag ,
			'reception_email'           => $this->_lang_reception_email ,
			'public_flag'               => $this->_lang_public_flag ,
			'password_confirm'          => $this->_lang_password_confirm ,
			'autoregist_disclaimer'     => $this->_lang_autoregist_disclaimer ,
			'autoregist_disclaimer_ok'  => $this->_lang_autoregist_disclaimer_ok ,
			'autoregist_input_key'      => $this->_lang_autoregist_input_key ,
			'autoregist_input_key_desc' => $this->_lang_autoregist_input_key_desc ,

			'login'         => $this->_lang_login ,
			'ssl_login'     => $this->_lang_ssl_login ,
			'login_id'      => $this->_lang_login_id ,
			'password'      => $this->_lang_password ,
			'cancel'        => $this->_lang_cancel ,
			'lost_password' => $this->_lang_lost_password ,

			'error'         => $error ,
		);

		if ( $error ) {
			$action['show_error'] = true;
		}

		$assign = array(
			'action' => $action , 
			'lang'   => $lang ,
		);

		if ( $show_register ) {
			$action['form_register'] = $this->fetch_template( 
				$assign, $this->_TEMPLATE_DIR_EXAUTH, $this->_TEMPLATE_REGISTER );
		}

		if ( $show_login ) {
			$action['form_login']    = $this->fetch_template( 
				$assign, $this->_TEMPLATE_DIR_EXAUTH, $this->_TEMPLATE_LOGIN );
		}

		$assign = array(
			'action' => $action , 
			'lang'   => $lang ,
		);

		$this->header_content_type();
		echo $this->fetch_template( 
			$assign, $this->_TEMPLATE_DIR_EXAUTH, $this->_TEMPLATE_REGISTER_LOGIN  );
		exit();
	}

//---------------------------------------------------------
// 上書きするか否かの選択肢を表示する
//---------------------------------------------------------
	function display_select_form( $id_new, $id_old )
	{
		$action = array(
			'base_url'      => $this->get_base_url() ,
			'token'         => $this->get_token_value() ,
			'action_select' => $this->_action_select ,
			'id_new'        => $id_new ,
			'id_old'        => $id_old ,
		);

		$lang = array(
			'select_title'    => $this->_lang_select_title ,
			'select_caption'  => $this->_lang_select_caption ,
			'select_note'     => $this->_lang_select_note ,
			'select_override' => $this->_lang_select_override ,
			'yes'             => $this->_lang_yes ,
			'no'              => $this->_lang_no ,
		);

		$assign = array(
			'action' => $action , 
			'lang'   => $lang ,
		);

		$this->header_content_type();
		echo $this->fetch_template( 
			$assign, $this->_TEMPLATE_DIR_EXAUTH, $this->_TEMPLATE_SELECT );
		exit();
	}

//---------------------------------------------------------
// テンプレートを表示する
//---------------------------------------------------------
	function header_content_type()
	{
		header("Content-type: text/html; charset=utf-8");
	}

	function fetch_template( $assign, $template_dir, $template )
	{
		$renderer =& SmartyTemplate::getInstance();
		$renderer->setTemplateDir(  $template_dir );
		$renderer->assign( $assign );
		$result = $renderer->fetch( $template );
		return $result;
	}

//---------------------------------------------------------
// ベースのURLを取得する
//---------------------------------------------------------
	function get_base_url_ssl() 
	{
		list( $url, $show ) =
			$this->get_base_url_ssl_and_show();
		return $url;
	}

	function get_base_url_ssl_and_show() 
	{
		$show = false;
		if ( $this->is_config_use_ssl_on() &&
			!$this->is_base_url_https() ) {
			$url  = $this->get_base_url_when_use_ssl_login();
			$show = true;
		} else {
			$url = $this->get_base_url();
		}
		return array( $url, $show );
	}

	function get_base_url() 
	{
		if ( ( CORE_BASE_URL == BASE_URL ) && 
			$this->is_server_https_on() ) {
			$url = BASE_URL_HTTPS;
		} else {
			$url = CORE_BASE_URL;
		}
		return $url;
	}

	function get_base_url_when_use_ssl_login()
	{
		$url = preg_replace("/^http:\/\//i","https://", BASE_URL);
		return $url;
	}

	function is_base_url_https()
	{
		$is = preg_match("/^https:\/\//i", BASE_URL);
		return $is;
	}

//---------------------------------------------------------
// SERVER 変数を取得する
//---------------------------------------------------------
	function is_server_https_on() 
	{
		if ( strtolower( $this->get_server_https() ) == 'on' ) {
			return true;
		}
		return false;
	}

	function get_server_https() 
	{
		return $this->get_server_by_key( 'HTTPS' );
	}

	function get_server_http_referer() 
	{
		return $this->get_server_by_key( 'HTTP_REFERER' );
	}

	function get_server_by_key( $key ) 
	{
		$str = isset($_SERVER[ $key ]) ? $_SERVER[ $key ] : null ;
		return $str;
	}

//---------------------------------------------------------
// リダイレクト先を設定する
//---------------------------------------------------------
    function set_session_redirect_with_current_url()
	{
		$this->set_session_redirect( 
			$this->get_current_url() );
	}

	function set_session_redirect_with_referer_if_not_set()
	{
// リダクレクト先が設定されて
		$url = $this->get_session_redirect();
		if ( empty($url) ) {
			$this->set_session_redirect_with_referer();
		}
	}

	function set_session_redirect_with_referer()
	{
		$url = $this->get_server_http_referer();
// サイト内であれば
		if ( strpos( $url, BASE_URL ) === 0 ) {
			$this->set_session_redirect( $url );
		}
	}

    function set_session_redirect( $v )
    {
		$this->_session->setParameter( 
			$this->_SESSION_NAME_REDIRECT, $v );
	}

//---------------------------------------------------------
// current_url を取得する
// http://framework.zend.com/manual/ja/zend.gdata.photos.html
//---------------------------------------------------------
	function get_current_url()
	{
		$protocol    = $this->get_http_protocol();
		$port        = $this->get_server_port( $protocol );
		$host        = $this->get_server_by_key( 'HTTP_HOST' );
		$request_uri = $this->get_server_by_key( 'REQUEST_URI' );

		$str = $protocol . $host . $port . $request_uri ;
		return $str;
	}

	function get_http_protocol()
	{
		if ( $this->is_server_https_on() ) {
        	$str = 'https://';
    	} else {
	        $str = 'http://';
	    }
		return $str;
	}

	function get_server_port( $protocol )
	{
		$server_port = $this->get_server_by_key( 'SERVER_PORT' );
		if ( $server_port &&
           (($protocol == 'http://'  && $server_port != '80') ||
            ($protocol == 'https://' && $server_port != '443'))) {
            $port = ':' . $server_port;
		} else {
        	$port = '';
    	}
		return $port;
	}

//---------------------------------------------------------
// リダイレクト先を取得する
//---------------------------------------------------------
    function get_session_redirect()
    {
		return $this->_session->getParameter( 
			$this->_SESSION_NAME_REDIRECT );
	}

    function get_redirect_url( $flag_admin=false )
    {
// セッションのリダイレクトURL を取得する
		$url = $this->get_session_redirect();

// リダイレクトURL がなければ、デフォルトへ
		if ( empty($url )) {

// ログイン中ならば、管理画面に
			if ( $flag_admin ) {
				$url = BASE_URL.'/index.php?action=control_view_main';

// そうでなければ、トップ管理画面に
			} else {
				$url = BASE_URL.'/';
			}
		}

		return $url;
	}

// === class end ===
}

?>