<?php
// $Id: Action.class.php,v 1.1.1.1 2010/09/07 08:59:37 ohwada Exp $

//=========================================================
// Exauthadmin Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Exauthadmin_Components_Action
{
    // コンポーネント
	var $_container     = null;
	var $_modulesView   = null;

	var $_dirname = null;

    /**
     * DB登録
     *
     * @access  public
     */
    function Exauthadmin_Components_Action()
    {
		$this->_container   =& DIContainerFactory::getContainer();
		$this->_modulesView =& $this->_container->getComponent("modulesView");
    }

    function set_dirname( $dirname )
	{
		$this->_dirname = $dirname ;
	}

    function module_installed()
	{
	    return $this->module_installed_by_dirname( $this->_dirname );
	}

    function module_installed_by_dirname( $dirname )
	{
	    $module = $this->_modulesView->getModuleByDirname( $dirname );
    	if ( isset($module['module_id']) ) {
			return true;	
		}
		return false;
	}

	function action()
	{
		return $this->action_by_dirname( $this->_dirname );
	}

	function action_by_dirname( $dirname )
	{
		$file = BASE_DIR.'/webapp/modules/'.$dirname.'/components/Admin.class.php' ;
		$class = ucfirst($dirname).'_Components_Admin';

		if ( !file_exists($file) ) {
			return false;
		}

		include_once $file;

		if ( !class_exists($class) ) {
			return false;
		}

		$admin = new $class;
		$admin->action();
	}

// ===class end ===
}
?>