<?php
// $Id: View.class.php,v 1.1.1.1 2010/09/07 08:59:37 ohwada Exp $

//=========================================================
// Exauthadmin Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Exauthadmin_Components_View
{
   // 使用コンポーネントを受け取るため
	var $_container   = null;
	var $_session     = null;
	var $_modulesView = null;

	var $_dirname = null;

	/**
	 * execute実行
	 *
	 * @access  public
	 */
    function Exauthadmin_Components_View()
    {
		$this->_container   =& DIContainerFactory::getContainer();
		$this->_session     =& $this->_container->getComponent("Session");
		$this->_modulesView =& $this->_container->getComponent("modulesView");
    }

    function set_dirname( $dirname )
	{
		$this->_dirname = $dirname ;
	}

    function module_installed()
	{
	    return $this->module_installed_by_dirname( $this->_dirname );
	}

    function module_installed_by_dirname( $dirname )
	{
	    $module = $this->_modulesView->getModuleByDirname( $dirname );
    	if ( isset($module['module_id']) ) {
			return true;	
		}
		return false;
	}

	function get_content()
	{
		return $this->get_content_by_dirname( $this->_dirname );
	}

	function get_content_by_dirname( $dirname )
	{
		$file = BASE_DIR.'/webapp/modules/'. $dirname .'/components/Admin.class.php' ;
		$class = ucfirst( $dirname ).'_Components_Admin';

		if ( !file_exists($file) ) {
			return false;
		}

		include_once $file;

		if ( !class_exists($class) ) {
			return false;
		}

		$admin = new $class;
		$admin->set_id( $this->_session->getParameter("_id") );
		return $admin->view();
	}

// === class end ===
}
?>