<?php
// $Id: View.class.php,v 1.1.1.1 2010/09/07 09:08:59 ohwada Exp $

//=========================================================
// Exauth Entry Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

include_once BASE_DIR.'/webapp/components/exauth/View.class.php' ;

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Exauthentry_Components_View extends Exauth_View
{

/**
 * コンストラクター
 *
 * @access	public
 */
	function Exauthentry_Components_View() 
	{
		$this->Exauth_View();

		$log =& LogFactory::getLog();
		$log->trace("component exauthentry View のコンストラクタが実行されました", "exauthentryVIew##Exauthentry_VIew");

		$template_dir = WEBAPP_DIR . '/modules/exauthentry/templates/main/';
		$this->_template_dir = $template_dir;

		$this->_module_id = $this->get_module_id_by_dirname( 'exauthentry' );
	}

//---------------------------------------------------------
// enter フォームを表示する
//---------------------------------------------------------
	function display_entry_form( $show_redirect_mes )
	{
		$show_login_nc = true;
		$show_login_twitter = $this->module_installed_by_dirname('twitter');
		$show_login_openid  = $this->module_installed_by_dirname('openid');
		$show_login_openid_form = false;

		list( $base_url, $show_ssl_login ) = 
			$this->get_base_url_ssl_and_show();

		$action = array(
			'base_url'           => $base_url ,
			'show_ssl_login'     => $show_ssl_login ,
			'show_redirect_mes'  => $show_redirect_mes ,
			'show_login_nc'      => $show_login_nc ,
			'show_login_twitter' => $show_login_twitter ,
			'show_login_openid'  => $show_login_openid ,
			'show_login_openid_form'  => $show_login_openid_form ,
		);

		$lang = array(
			'exauthentry_login'          => EXAUTHENTRY_LOGIN ,
			'exauthentry_login_nc'       => EXAUTHENTRY_LOGIN_NC ,
			'exauthentry_login_twitter'  => EXAUTHENTRY_LOGIN_TWITTER ,
			'exauthentry_login_openid'   => EXAUTHENTRY_LOGIN_OPENID ,
			'exauthentry_login_google'   => EXAUTHENTRY_LOGIN_GOOGLE ,
			'exauthentry_login_yahoo_jp' => EXAUTHENTRY_LOGIN_YAHOO_JP ,
			'exauthentry_login_mixi'     => EXAUTHENTRY_LOGIN_MIXI ,
			'exauthentry_login_livedoor' => EXAUTHENTRY_LOGIN_LIVEDOOR ,
			'exauthentry_login_flickr'   => EXAUTHENTRY_LOGIN_FLICKR ,

			'exauthentry_ssl_login'      => EXAUTH_SSL_LOGIN ,
			'exauthentry_cancel'         => EXAUTH_CANCEL ,
			'exauthentry_redirect_mes'   => _LOGINAGAIN_MES ,
		);

		$assign = array(
			'action' => $action , 
			'lang'   => $lang ,
		);

		$this->header_content_type();
		echo $this->fetch_template( $assign, $this->_template_dir, 'exauthentry_entry.html' );
		exit();
	}

// === class end ===
}

?>