<?php
// $Id: Init.class.php,v 1.1.1.1 2010/09/07 09:09:00 ohwada Exp $

//=========================================================
// Exauth Entry Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Exauthentry_View_Main_Init extends Action
{
	// コンポーネントを使用するため
	var $exauthentryView   = null;
	var $session      = null;

	// リクエストパラメータを受け取るため
    var $block_id = null;

	// 値をセットするため
	var $base_url           = null;
	var	$show_ssl_login     = null;
	var	$show_login_nc      = null;
	var	$show_login_twitter = null;
	var	$show_login_openid  = null;
	var	$show_login_openid_form = null;

    /**
     * Exauthentry モジュール
     *
     * @access  public
     */
//---------------------------------------------------------
// OpneID サーバーの入力画面を表示する
//---------------------------------------------------------
    function execute()
    {
//既にログイン済
       	if ( $this->session->getParameter("_user_id") ) {
        	if( $this->block_id == 0 ) {
        		return 'success_location';
        	} else {
        		return 'success_login';	
        	}
		}

// リダイレクト先を保存する
		$this->exauthentryView->set_session_redirect_with_current_url();

// base URL を設定する
		list( $this->base_url, $this->show_ssl_login ) = 
			$this->exauthentryView->get_base_url_ssl_and_show();

		$this->show_login_nc = true;
		$this->show_login_twitter = $this->exauthentryView->module_installed_by_dirname('twitter');
		$this->show_login_openid  = $this->exauthentryView->module_installed_by_dirname('openid');
		$this->show_login_openid_form = false;

		return 'success';
	}

// === class end ===
}
?>