<?php
// $Id: Init.class.php,v 1.1.1.1 2010/09/07 09:12:22 ohwada Exp $

//=========================================================
// Exauth User Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons View
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Exauthuser_View_Main_Init extends Action
{
    // 使用コンポーネントを受け取るため
    var $session     = null;
	var $usersView   = null;
	var $modulesView = null;

    // 値をセットするため
 	var $base_url = null;
	var	$auths    = array();

	/**
	 * execute実行
	 *
	 * @access  public
	 */
    function execute()
    {
   		$user_id = $this->session->getParameter("_user_id");

	   	$this->user     = $this->usersView->getUserById( $user_id );
		$this->auths    = $this->build_auths( $user_id );
		$this->base_url = $this->get_base_url();

        return 'success';
    }

//---------------------------------------------------------
// auths を取得する
//---------------------------------------------------------
	function build_auths( $user_id ) 
	{
		$modules = array('openid', 'twitter');
		$auths   = array();

		foreach ( $modules as $module )
		{
			if ( ! $this->module_installed( $module ) ) {
				continue;
			}

			$param = $this->build_auth_param( $module, $user_id );
			if ( is_array($param) ) {
				$auths[] = $param;
			}
		}

		return $auths;
	}

	function build_auth_param( $module, $user_id )
	{
		$file = BASE_DIR.'/webapp/modules/'.$module.'/components/User.class.php' ;
		$class = ucfirst($module).'_Components_User';

		if ( !file_exists($file) ) {
			return false;
		}

		include_once $file;

		if ( !class_exists($class) ) {
			return false;
		}

		$user = new $class;
		return $user->build_auth_param( $user_id );
	}

	function module_installed( $dirname )
	{
	    $module = $this->modulesView->getModuleByDirname( $dirname );
    	if ( isset($module['module_id']) ) {
			return true;	
		}
		return false;
	}

//---------------------------------------------------------
// base url を取得する
//---------------------------------------------------------
	function get_base_url() 
	{
		if ( ( CORE_BASE_URL == BASE_URL ) && 
			$this->is_server_https_on() ) {
			$url = BASE_URL_HTTPS;
		} else {
			$url = CORE_BASE_URL;
		}
		return $url;
	}

	function is_server_https_on() 
	{
		$https = isset($_SERVER['HTTPS']) ? $_SERVER['HTTPS'] : null ;
		if ( strtolower( $https ) == 'on' ) {
			return true;
		}
		return false;
	}

// === class end ===
}
?>