<?php
// $Id: Attach.class.php,v 1.1 2010/09/07 08:35:47 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons View
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Twitter_Action_Main_Attach extends Action
{
	// コンポーネントを使用するため
	var $twitterAction = null;
	var $session      = null;
	var $request      = null;
	var $commonMain   = null;

	var $_REDIRECT_TIME_ERROR   = 5;	// 5 sec

    /**
     * Twitter モジュール
     *
     * @access  public
     */
//---------------------------------------------------------
// 関連付けを上書きする
//---------------------------------------------------------
	function execute()
	{
		$user_id  = $this->session->getParameter("_user_id");
		$override = $this->request->getParameter('override');

// twitter を取得
		list( $twitter_id, $twitter_token, $twitter_secret )
			= $this->twitterAction->get_twitter_by_session();

// トークンが正しくないなら、エラー表示
		if ( ! $this->twitterAction->check_token() ) {
			$this->twitterView->display_error( EXAUTH_ERR_SOMETING.' (1)' );
		}

// パラメータがなければ、エラー表示
		if ( empty($user_id) || empty($twitter_id) ) {
			$this->twitterView->display_error( EXAUTH_ERR_SOMETING.' (2)' );
			exit();
		}

// 関連付けを上書きする
		if ( $override == 1 ) {
			$ret = $this->twitterAction->save_twitter( 
				$user_id, $twitter_id, $twitter_token, $twitter_secret );
			if ( !$ret ) {
				$this->twitterView->display_error( 
					$this->twitterAction->get_error_msg() );
				exit();
			}
		}

		$url = $this->twitterAction->get_redirect_url( $user_id );
		header("Location: ". $url );
		exit();

	}

// === class end ===
}
?>