<?php
// $Id: Login.class.php,v 1.2 2010/09/07 08:33:08 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Action
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Twitter_Action_Main_Login extends Action
{
	// コンポーネントを受け取るため
	var $twitterView   = null;
	var $twitterAction = null;
	var $request      = null;
	var $session      = null;
	var $commonMain   = null;

	var $_REDIRECT_TIME_SUCCESS = 1;	// 1 sec
	var $_REDIRECT_TIME_ERROR   = 5;	// 5 sec

    /**
     * @access  public
     */
//---------------------------------------------------------
// ログイン認証を行う
//---------------------------------------------------------
    function execute()
    {

// 既にログイン済
       	if ( $this->session->getParameter("_user_id") ) {
			header("Location: ". BASE_URL.'/' );
			exit();
        }

		$param_input = array(
			'login_id' => $this->request->getParameter('login_id') ,
			'password' => $this->request->getParameter('password') ,
		);

		$code = $this->twitterAction->login( $param_input );
		$msg  = $this->twitterAction->get_error_msg();
		switch ( $code )
		{
			case 0:
				break;

			case 271:
			case 272:
			case 273:
				$this->display_register_form( $param_input, $msg );
				exit();

			case 264:
				$this->twitterView->display_error( $msg );
				exit();	

			default:
				$this->twitterView->display_error( EXAUTH_ERR_SOMETING.' (4)' );
				exit();
		}

		$user_id      = $this->twitterAction->get_user_id();
		$redirect_url = $this->twitterAction->get_redirect_url();

// twitter を取得
		list( $twitter_id, $twitter_token, $twitter_secret )
			= $this->twitterAction->get_twitter_by_session();

// すでに関連付けされていれば、選択画面を表示する
		$twitter_id_old = $this->twitterAction->get_twitterid_by_userid( $user_id );
		if ( $twitter_id_old ) {
			$this->twitterView->display_select_form( $twitter_id, $twitter_id_old );
			exit();
		}

// 関連付け
		$ret = $this->twitterAction->save_twitter( 
			$user_id, $twitter_id, $twitter_token, $twitter_secret );
		if ( !$ret ) {
			$this->twitterView->display_error( 
				$this->twitterAction->get_error_msg() );
			exit();
		}

		$this->commonMain->redirectHeader(
			$redirect_url ,  
			$this->_REDIRECT_TIME_SUCCESS, 
			EXAUTH_LOGINED );
		exit();
	}

// ===class end ===
}
?>