<?php
// $Id: Register.class.php,v 1.2 2010/09/07 08:33:08 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Action
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Twitter_Action_Main_Register extends Action
{
	// コンポーネントを受け取るため
	var $twitterView   = null;
	var $twitterAction = null;
	var $request      = null;
	var $session      = null;
	var $commonMain   = null;

	var $_REDIRECT_TIME_SUCCESS = 1;	// 1 sec
	var $_REDIRECT_TIME_ERROR   = 5;	// 5 sec

    /**
     * opneid モジュール
     *
     * @access  public
     */
//---------------------------------------------------------
// ログイン認証を行う
//---------------------------------------------------------
    function execute()
    {

// 既にログイン済
       	if ( $this->session->getParameter("_user_id") ) {
			header("Location: ". BASE_URL.'/' );
			exit();
        }

		$items = $this->request->getParameter('items');
		$items = $this->twitterAction->create_password_in_items( $items );

		$param0 = null;
		$param_input = array(
			'items'                    => $items ,
			'items_public'             => $this->request->getParameter('items_public'),
			'items_reception'          => $this->request->getParameter('items_reception'),
			'items_password_confirm'   => $this->request->getParameter('items_password_confirm'),
			'autoregist_disclaimer_ok' => $this->request->getParameter('autoregist_disclaimer_ok'),
			'autoregist_input_key'     => $this->request->getParameter('autoregist_input_key'),
			'param0'                   => $param0,
		);

		$code = $this->twitterAction->register( $param_input );
		$msg  = $this->twitterAction->get_error_msg();
		switch ( $code )
		{
			case 0:
				break;

			case 261:
			case 262:
			case 263:
				$this->display_register_form( $param_input, $msg );
				exit();

			case 264:
				$this->twitterView->display_error( $msg );
				exit();	

			default:
				$this->twitterView->display_error( EXAUTH_ERR_SOMETING.' (2)' );
				exit();
		}

		$user_id      =	$this->twitterAction->get_user_id(); 
		$redirect_url =	$this->twitterAction->get_redirect_url(); 

// twitter を取得
		list( $twitter_id, $twitter_token, $twitter_secret )
			= $this->twitterAction->get_twitter_by_session();
		if ( empty($twitter_id) || empty($twitter_token) || empty($twitter_secret) ) {
			$this->twitterView->display_error( EXAUTH_ERR_SOMETING.' (3)' );
			exit();	
		}

// 関連付け
		$ret = $this->twitterAction->save_twitter( 
			$user_id, $twitter_id, $twitter_token, $twitter_secret );
		if ( !$ret ) {
			$this->twitterView->display_error( 
				$this->twitterAction->get_error_msg() );
			exit();
		}

		$this->commonMain->redirectHeader( 
			$redirect_url , 
			$this->_REDIRECT_TIME_SUCCESS, 
			EXAUTH_REGISTERED );
		exit();
	}

//---------------------------------------------------------
// 新規登録 を表示する
//---------------------------------------------------------
    function display_register_form( $param_input, $error )
    {
		$param = $this->twitterView->get_register_param( true );

// $param が取得できないときは、エラー表示
		if ( !$param ) {
			$this->twitterView->display_error( 
				$this->twitterView->get_error_msg() );
			exit();
		}

		$action = $this->twitterView->replace_register_param( $param, $param_input );

		$this->twitterView->display_register_form( $action, $error );
		exit();
	}

// ===class end ===
}
?>