<?php
// $Id: Tweet.class.php,v 1.2 2010/09/07 08:33:08 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

include_once BASE_DIR."/webapp/modules/twitter/components/Service.class.php";

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Action
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Twitter_Action_Main_Tweet extends Action
{
	// コンポーネントを受け取るため
	var $twitterView   = null;
	var $twitterAction = null;
	var $request       = null;
	var $session       = null;
	var $commonMain    = null;

	var $_REDIRECT_TIME_SUCCESS = 1;	// 1 sec
	var $_REDIRECT_TIME_ERROR   = 5;	// 5 sec

    /**
     * opneid モジュール
     *
     * @access  public
     */
//---------------------------------------------------------
// ログイン認証を行う
//---------------------------------------------------------
    function execute()
    {
		$user_id = $this->session->getParameter("_user_id");

// ログインしていないとき
       	if ( empty($user_id) ) {
			header("Location: ". BASE_URL.'/' );
			exit();
        }

		$code = 0;
		$msg  = null;

		$twitter_status = $this->request->getParameter('twitter_status');

		if ( empty($twitter_status) ) {
			$this->redirect( 11, TWITTER_ERR_TWEET_EMPTY );
			exit();
		}

		if ( mb_strlen($twitter_status) > 140 ) {
			$this->redirect( 11, TWITTER_ERR_TWEET_OVER_140 );
			exit();
		}

		$twitterService =& new Twitter_Components_Service();
		$ret = $twitterService->init();
		if ( !$ret ) {
			$this->redirect( 12, TWITTER_ERR_CONSUMER_KEY );
			exit();
		}

		$ret = $twitterService->set_user( $user_id );
		if ( !$ret ) {
			$this->redirect( 13 );
			exit();
		}

		$ret = $twitterService->tweet( $twitter_status );

		if ( !$ret ) {
			$msg  = TWITTER_ERR_TWEET_POST ;
			$msg .= '<br />';
			$msg .= $twitterService->get_error_msg();
			$this->redirect( 11, $msg );
		}

		$this->redirect( 1 );
		exit();
	}

	function redirect( $code, $msg=null )
	{
		$this->session->setParameter( TWITTER_SESSION_NAME_TWEET, $msg );

		$redirect = $this->twitterView->get_session_redirect();
		if ( $redirect ) {
			$separator = $this->twitterView->get_seprator_from_url( $redirect );
			$url  = $redirect . $separator ;
			$url .= 'code='.$code;

		} else {
			$url = BASE_URL.'/';
		}

		header("Location: ". $url );
		exit();
	}

// ===class end ===
}
?>