<?php
// $Id: Action.class.php,v 1.2 2010/09/07 08:33:08 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

include_once BASE_DIR.'/webapp/components/exauth/Action.class.php' ;

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Twitter_Components_Action extends Exauth_Action 
{

/**
 * コンストラクター
 *
 * @access	public
 */
	function Twitter_Components_Action() 
	{
		$this->Exauth_Action();

		$log =& LogFactory::getLog();
		$log->trace("component twitter Action のコンストラクタが実行されました", 
			"twitterAction##Twitter_Action" );

		$this->set_lang();
	}

//---------------------------------------------------------
// twitter_id を取得する
//---------------------------------------------------------
	function get_twitterid_by_userid( $user_id )
	{
		return $this->get_users_item_link( $user_id, TWITTER_ITEM_NAME_TWITTER_ID );
	}

	function get_twitter_by_session()
	{
		$twitter = $this->_session->getParameter( TWITTER_SESSION_NAME_TWITTER );
		$param   = unserialize($twitter);
		$twitter_id     = $param['screen_name'];
		$twitter_token  = $param['token'];
		$twitter_secret = $param['token_secret'];
		return array( $twitter_id, $twitter_token, $twitter_secret );
	}

//---------------------------------------------------------
// twitter_id を格納する
//---------------------------------------------------------
	function save_twitter( $user_id, $twitter_id, $twitter_token, $twitter_secret )
	{
		$this->set_users_item_link( 
			$user_id, TWITTER_ITEM_NAME_TWITTER_ID, $twitter_id );
		$this->set_users_item_link( 
			$user_id, TWITTER_ITEM_NAME_TWITTER_TOKEN, $twitter_token );
		$this->set_users_item_link( 
			$user_id, TWITTER_ITEM_NAME_TWITTER_SECRET, $twitter_secret );
		return true;
	}

// === class end ===
}
?>