<?php
// $Id: Admin.class.php,v 1.2 2010/09/10 21:15:36 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

include_once BASE_DIR.'/webapp/components/exauth/Admin.class.php' ;
include_once BASE_DIR.'/webapp/modules/twitter/language/japanese/admin.inc.php' ;

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Twitter_Components_Admin extends Exauth_Admin
{

/**
 * コンストラクター
 *
 * @access	public
 */
	function Twitter_Components_Admin() 
	{
		$this->Exauth_Admin();

		$this->_module_id = $this->get_module_id_by_dirname('twitter');
	}

	/**
	 * execute実行
	 *
	 * @access  public
	 */
    function view()
    {
		$template_dir = WEBAPP_DIR . '/modules/twitter/templates/main/';
		$template = 'twitter_admin.html';

		$action = array(
			'id'     => $this->_id ,
			'config' => $this->get_config() ,
		);

		$lang = array(
			'title'           => TWITTER_AD_TITLE ,
			'note'            => TWITTER_AD_NOTE ,
			'mode_register'   => TWITTER_AD_MODE_REGISTER ,
			'mode_register_0' => TWITTER_AD_MODE_REGISTER_0 ,
			'mode_register_1' => TWITTER_AD_MODE_REGISTER_1 ,
			'mode_register_2' => TWITTER_AD_MODE_REGISTER_2 ,
			'consumer_key'    => TWITTER_AD_CONSUMER_KEY ,
			'consumer_secret' => TWITTER_AD_CONSUMER_SECRET ,
		);

		$assign = array(
			'id'     => $this->_id ,
			'config' => $this->get_config() ,
			'lang'   => $lang ,
		);

		return $this->fetch_template( $assign, $template_dir, $template );
    }

    function action()
    {
		$this->update_config( 'mode_register' );
		$this->update_config( 'consumer_key' );
		$this->update_config( 'consumer_secret' );
    	return true;
    }

// === class end ===
}
?>