<?php
// $Id: View.class.php,v 1.2 2010/09/07 08:33:08 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

include_once BASE_DIR.'/webapp/components/exauth/View.class.php' ;

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Twitter_Components_View extends Exauth_View
{

/**
 * コンストラクター
 *
 * @access	public
 */
	function Twitter_Components_View() 
	{
		$this->Exauth_View();

		$log =& LogFactory::getLog();
		$log->trace("component twitter View のコンストラクタが実行されました", "twitterVIew##Twitter_VIew");

		$this->_template_dir = WEBAPP_DIR . '/modules/twitter/templates/main/';

		$this->_module_id = $this->get_module_id_by_dirname( 'twitter' );

		$this->_action_register  = 'twitter_action_main_register';
		$this->_action_login     = 'twitter_action_main_login';
		$this->_action_select    = 'twitter_action_main_attach';

		$this->set_lang();
		$this->_lang_register_login_title   = TWITTER_REGISTER_LOGIN_TITLE ;
		$this->_lang_register_login_caption = TWITTER_REGISTER_LOGIN_CAPTION ;
		$this->_lang_login_note     = TWITTER_LOGIN_NOTE ;
		$this->_lang_select_title   = TWITTER_SELECT_TITLE ;
		$this->_lang_select_caption = TWITTER_SELECT_CAPTION ;
		$this->_lang_select_note    = TWITTER_SELECT_NOTE ;

	}

//---------------------------------------------------------
// user_id を取得する
//---------------------------------------------------------
	function get_userid_by_twitterid( $twitter_id )
	{
		return $this->get_userid_by_key( TWITTER_ITEM_NAME_TWITTER_ID, $twitter_id );
	}

//---------------------------------------------------------
// 新規登録 か 関連付け かを取得する
//---------------------------------------------------------
    function get_show_register_login()
    {
		$mode = $this->get_config_mode_register();
		return $this->get_mode_register_login( $mode );
//		return array( $register, $login )
	}

	function get_config_mode_register()
	{
		return $this->get_module_config_by_key( $this->_module_id, 'mode_register' );
	}

//---------------------------------------------------------
// リダイレクトURLを取得
//---------------------------------------------------------
    function display_error( $msg, $flag_admin=false )
    {
		$this->_commonMain->redirectHeader( 
			$this->get_redirect_url( $flag_admin ), 
			$this->_REDIRECT_TIME_ERROR, 
			$msg );
		exit();
	}

// === class end ===
}

?>