<?php
// $Id: Install.class.php,v 1.1.1.1 2010/09/01 07:38:06 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Twitter_Install extends Action
{
	var $_db = null;
	var $_usersAction = null;

    /**
     * Gdata 追加アクション
     *
     * @access  public
     */

function execute()
{
	$this->add_user_item();
	return true;
}

//---------------------------------------------------------
// ユーザ項目を追加する
//---------------------------------------------------------
function add_user_item()
{
    $container =& DIContainerFactory::getContainer();
	$usersView =& $container->getComponent("usersView");

	$this->_db          =& $container->getComponent("DbObject");
	$this->_usersAction =& $container->getComponent("usersAction");

	$items = $usersView->getItems();

	$flag_user   = false;
	$flag_token  = false;
	$flag_secret = false;

	foreach ( $items as $item )
	{
		if ( $item['item_name'] == TWITTER_ITEM_NAME_TWITTER_ID ) {
			$flag_user = true;
		}
		if ( $item['item_name'] == TWITTER_ITEM_NAME_TWITTER_TOKEN ) {
			$flag_token = true;
		}
		if ( $item['item_name'] == TWITTER_ITEM_NAME_TWITTER_SECRET ) {
			$flag_secret = true;
		}
	}

	if ( !$flag_user ) {
		$this->add_item( TWITTER_ITEM_NAME_TWITTER_ID, 'text' );
	}
	if ( !$flag_token ) {
		$this->add_item( TWITTER_ITEM_NAME_TWITTER_TOKEN, 'text' );
	}
	if ( !$flag_secret ) {
		$this->add_item( TWITTER_ITEM_NAME_TWITTER_SECRET, 'text' );
	}

	return true;
}

//---------------------------------------------------------
// 参照 User_Action_Admin_Additem
//---------------------------------------------------------
function add_item( $item_name, $type )
{
	$max_row = $this->_db->maxExecute("items", "row_num") + 1;

	$type = 'text';
	$require_flag = 0;	// 必須項目にするか
	$define_flag  = 0;
	$allow_public_flag = 0;
	$allow_email_reception_flag = 0;

	$param = array(
		"item_name" => $item_name,
		"type" => $type,
		"tag_name" => "",			//固定
		"system_flag" => _OFF,		//固定
		"require_flag" => intval($require_flag),
		"define_flag" => intval($define_flag),
		"display_flag" => _ON,		//固定
		"allow_public_flag" => intval($allow_public_flag),
		"allow_email_reception_flag" => $allow_email_reception_flag,
		"col_num" => 1,				//固定
		"row_num" => $max_row
	);
	// 追加
	$item_id = $this->_usersAction->insItem($param);
	if ($item_id === false) {
		return false;
	}
			
	//
	// items_authorities_link デフォルト値登録
	//
	$param = array(
		"item_id"           => $item_id ,
		'under_public_flag' => USER_NO_PUBLIC ,
		'self_public_flag'  => USER_NO_PUBLIC ,
		'over_public_flag'  => USER_NO_PUBLIC ,
	);
	
	// 管理者
	$param_admin = $param ;
	$param_admin['user_authority_id'] = _AUTH_ADMIN;
	$param_admin['self_public_flag']  = USER_EDIT;
	$param_admin['over_public_flag']  = USER_EDIT;

	$result = $this->_usersAction->insItemsAuthLink($param_admin);
	if ($result === false) {
		return false;
	}

	// 主担 
	$param['user_authority_id'] = _AUTH_CHIEF;
			
	$result = $this->_usersAction->insItemsAuthLink($param);
	if ($result === false) {
		return false;
	}
			
	// モデレータ
	$param['user_authority_id'] = _AUTH_MODERATE;
			
	$result = $this->_usersAction->insItemsAuthLink($param);
	if ($result === false) {
		return false;
	}
			
	// 一般
	$param['user_authority_id'] = _AUTH_GENERAL;
			
	$result = $this->_usersAction->insItemsAuthLink($param);
	if ($result === false) {
		return false;
	}
	
	// ゲスト
	$param['user_authority_id'] = _AUTH_GUEST;

	$result = $this->_usersAction->insItemsAuthLink($param);
	if ($result === false) {
		return false;
	}
	
	return true;
}		

// === class end ===
}
?>