<?php
// $Id: Auth.class.php,v 1.2 2010/09/07 08:33:09 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

include_once BASE_DIR."/webapp/modules/twitter/components/Service.class.php";

/**
 * @package     NetCommons View
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Twitter_View_Main_Auth extends Action
{
	// コンポーネントを使用するため
	var $session      = null;
	var $request      = null;
	var $commonMain   = null;
	var $configView   = null;
	var $twitterView  = null;

	// 内部変数
	var $_flag_login = false;

	var $_REDIRECT_TIME_ERROR  = 5;	// 5 sec
	var $_REDIRECT_TIME_SERVER = 1;	// 1 sec

    /**
     * Twitter モジュール
     *
     * @access  public
     */
//---------------------------------------------------------
// Twitter サーバーにリダイレクイトする
//---------------------------------------------------------
    function execute()
    {
		$user_id = $this->session->getParameter("_user_id");
		$mode    = $this->request->getParameter('mode');

// ログイン中で
       	if ( $this->session->getParameter("_user_id") ) {
// 関連付けでなければ
			if ( !$mode ) {
				header("Location: ". BASE_URL.'/' );
				exit();
			}
			$this->_flag_login = true;
        }

// リダクレクト先を設定する
		$this->twitterView->set_session_redirect_with_referer_if_not_set();

		$twitterService =& new Twitter_Components_Service();
		$ret = $twitterService->init();
		if ( !$ret ) {
			$this->display_error( 
				$twitterService->get_error_msg() );
			exit();
		}

		$twitterService->login( 
			$this->twitterView->get_base_url() );

// auth から戻るときは 常にエラー
		$this->display_error( 
			$this->twitterView->get_error_msg() );
		exit();
	}

//---------------------------------------------------------
// エラーを表示する
//---------------------------------------------------------
    function display_error( $msg )
    {
		$this->twitterView->display_error( $msg, $this->_flag_login );
		exit();
	}

// === class end ===
}
?>