<?php
// $Id: Callback.class.php,v 1.2 2010/09/07 08:33:09 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

include_once BASE_DIR."/webapp/modules/twitter/components/Service.class.php";

/**
 * @package     NetCommons View
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Twitter_View_Main_Callback extends Action
{
	// コンポーネントを使用するため
	var $twitterView   = null;
	var $twitterAction = null;
	var $commonMain   = null;
	var $session      = null;

	// 内部変数
	var $_flag_login = false;

	var $_REDIRECT_TIME_SUCCESS = 1;	// 1 sec
	var $_REDIRECT_TIME_ERROR   = 5;	// 5 sec

    /**
     * @access  public
     */
//---------------------------------------------------------
// Twitter サーバ―からの callback を受け付ける
//---------------------------------------------------------
    function execute()
    {
		$twitterService =& new Twitter_Components_Service();
		$ret = $twitterService->init();
		if ( !$ret ) {
			$this->display_error( 
				$twitterService->get_error_msg() );
			exit();
		}

		$param_callback = $twitterService->callback();

// Twitter ID が取得できないときは、エラー表示
		if ( !is_array($param_callback) ) {
			$msg = $this->get_error(
				$twitterService->get_error_code(), 
				$twitterService->get_error_msg() );
			$this->display_error( $msg );
			exit();
		}

		$user_id = $this->session->getParameter("_user_id");

// ログイン中か否かで処理が異なる
       	if ( $this->session->getParameter("_user_id") ) {
			$this->_flag_login = true;
			$this->callback2( $user_id, $param_callback );
        } else {
			$this->callback1( $param_callback );
		}

		exit();
	}

//---------------------------------------------------------
// ログインしていないときの処理
//---------------------------------------------------------
    function callback1( $param_callback )
    {
		$twitter_id     = $param_callback['screen_name'];
		$twitter_token  = $param_callback['token'];
		$twitter_secret = $param_callback['token_secret'];

		$user_id = $this->twitterView->get_userid_by_twitterid( $twitter_id );

// twitter ID が登録されていないなら、ログイン画面を表示する
		if ( empty($user_id) ) {
			$this->display_register_login_form( $param_callback );
			exit();
		}

// user 情報を取得する
		$param = $this->twitterAction->get_login_user_param( $user_id );

// user 情報が取得できないときは、エラー表示
		if ( !$param ) {
			$this->display_error( 
				$this->twitterAction->get_error_msg() );
			exit();
		}

// リダイレクトURLを取得
		$param['redirect_url'] = $this->twitterView->get_session_redirect();

// ログイン処理
		$this->twitterAction->login_excute( $param );
		$redirect_url = $this->twitterAction->get_redirect_url();

		$this->commonMain->redirectHeader( 
			$redirect_url , 
			$this->_REDIRECT_TIME_SUCCESS, 
			EXAUTH_LOGINED );
		exit();
	}

//---------------------------------------------------------
// ログインしているときの処理
//---------------------------------------------------------
    function callback2( $user_id, $param_callback )
    {
		$twitter_id     = $param_callback['screen_name'];
		$twitter_token  = $param_callback['token'];
		$twitter_secret = $param_callback['token_secret'];

		$user_id_already = $this->twitterView->get_userid_by_twitterid( $twitter_id );

// 自分以外に使われていれば、エラー表示
		if ( $user_id_already && ($user_id != $user_id_already) ) {
			$msg  = TWITTER_ERR_ID_ALREADY .'<br />';
			$msg .= $twitter_id ;
			$this->display_error( $msg );
			exit();
		}

// Twitter ID を保存する
		$ret = $this->twitterAction->save_twitter( 
			$user_id, $twitter_id, $twitter_token, $twitter_secret );
		if ( !$ret ) {
			$this->display_error( 
				$this->twitterAction->get_error_msg() );
			exit();
		}

		$this->commonMain->redirectHeader( 
			$this->get_redirect_url(), 
			$this->_REDIRECT_TIME_SUCCESS, 
			TWITTER_ID_CHANGED );
		exit();
	}

//---------------------------------------------------------
// 新規登録 & ログイン フォームを表示する
//---------------------------------------------------------
    function display_register_login_form( $param_callback )
    {
		$action = $this->twitterView->get_register_param( true );

// action が取得できないときは、エラー表示
		if ( !$action ) {
			$this->display_error( 
				$this->twitterView->get_error_code(), 
				$this->twitterView->get_error_msg() );
			exit();
		}

// twitter を保存
		$this->session->setParameter( 
			TWITTER_SESSION_NAME_TWITTER, 
			serialize($param_callback) );

		$error = null;
		list( $show_register, $show_login ) 
			= $this->twitterView->get_show_register_login();

		$this->twitterView->display_register_login_form( 
			$action, $error, $show_register, $show_login );
		exit();
	}

//---------------------------------------------------------
// エラーを表示する
//---------------------------------------------------------
    function get_error( $code, $msg )
    {
		$str = '';
		switch ( $code )
		{
		case 21:
		case 22:
		case 23:
			$str  = EXAUTH_ERR_AUTH_FAILED ;
			$str .= '<br />';
			$str .= $msg;
			break;

		default:
			$str = EXAUTH_ERR_UNKNOWN;
			break;
		}
		return $str;
	}

    function display_error( $msg )
    {
		$this->twitterView->display_error( $msg, $this->_flag_login );
		exit();
	}

    function get_redirect_url()
	{
		return $this->twitterView->get_redirect_url( $this->_flag_login ); 
	}

// === class end ===
}
?>