<?php
// $Id: Init.class.php,v 1.2 2010/09/07 08:33:09 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

include_once BASE_DIR."/webapp/modules/twitter/components/Service.class.php";

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons View
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Twitter_View_Main_Init extends Action
{
	// コンポーネントを使用するため
	var $twitterView  = null;
	var $session      = null;
	var $request      = null;

	// リクエストパラメータを受け取るため
    var $block_id = null;

	// 値をセットするため
	var $items   = null;
	var $message = null;
	var $error   = null;
	var $base_url           = null;
	var	$show_login_nc      = false;
	var	$show_login_twitter = false;
	var	$show_login_openid  = false;
	var	$show_goto_control  = false;

    /**
     * Twitter モジュール
     *
     * @access  public
     */
//---------------------------------------------------------
// OpneID サーバーの入力画面を表示する
//---------------------------------------------------------
    function execute()
    {
// リダイレクト先を保存する
		$this->twitterView->set_session_redirect_with_current_url();

		$user_id = $this->session->getParameter("_user_id");

       	if ( empty($user_id) ) {
			$this->please_login();
       		return 'success_login';	
		}

		$twitterService =& new Twitter_Components_Service();
		$ret = $twitterService->init();
		if ( !$ret ) {
			$this->show_goto_control = true;
			$this->error = $twitterService->get_error_msg();
       		return 'success_error';	
		}

		$ret = $twitterService->set_user( $user_id );
		if ( !$ret ) {
       		return 'success_twitter';	
		}

		$items = $twitterService->get_home_timeline( true );
		if ( !$items ) {
			$this->error = $twitterService->get_error_msg();
       		return 'success_error';	
		}

		$this->chech_return_code();

		$this->items = $items;

		return 'success';
	}

    function please_login()
	{
// base URL を設定する
		$this->base_url = $this->twitterView->get_base_url_ssl();

		$this->show_login_nc      = true;
		$this->show_login_twitter = true;

// openid モジュールがインストールされているいか
		if ( $this->twitterView->module_installed_by_dirname( 'openid' ) ) {
			$this->show_login_openid  = true;
		}

		return 'success_login';	
	}

    function chech_return_code()
	{

// メモ： request コンポーネント では取得できなかった
		$code = isset($_GET['code']) ? $_GET['code'] : null; 
		$msg  = $this->session->getParameter( TWITTER_SESSION_NAME_TWEET );

		$message = '';
		$error   = '';

		switch ($code)
		{
			case 1:
				$message = TWITTER_TWEET_SUCCESS;
				break;

			case 11:
				$error = $msg;
				break;

			case 12:
				$this->error = $msg;
				$this->show_goto_control = true;
       			return 'success_error';	

			case 13:
      			return 'success_twitter';
				break;

		}

		$this->message = $message;
		$this->error   = $error;
	}

// === class end ===
}
?>