<?php
// $Id: callback.php,v 1.2 2011/03/03 13:36:22 ohwada Exp $

//================================================================
// Twitter Module
// 2010-08-01 K.OHWADA
//================================================================

//---------------------------------------------------------
// change log
// 2011-03-01 K.OHWADA
// get_user_token()
//---------------------------------------------------------

//---------------------------------------------------------
// header
//---------------------------------------------------------
include 'header.php';

//---------------------------------------------------------
// main
//---------------------------------------------------------
$REDIRECT_URL = XOOPS_URL.'/modules/twitter/index.php';
$REDIRECT_TIME_SUCCESS = 1;

if (empty($xoopsUser)) {
	twitter_callback_error( _TWITTER_ERR_SOMETHING .' (1)' );
	exit();
}

$uid = $xoopsUser->getVar('uid');

$service =& twitter_xoops_service::getInstance();
$exauth  =& $service->get_exauth_Instance();

$ret = $service->init();
if ( !$ret ) {
	twitter_callback_error( _TWITTER_ERR_SOMETHING .' (2)' );
	exit();
}

$param_callback = $service->callback();
if ( !is_array($param_callback) ) {
	$msg  = _TWITTER_ERR_CALLBACK ;
	$msg .= $service->get_error_msg();
	twitter_callback_error( $msg );
	exit();
}

$screen_name = $param_callback['screen_name'] ;
$token       = $param_callback['token'] ;
$secret      = $param_callback['token_secret'] ;

$exauth_id = $exauth->get_exauth_id( $uid );
if ( !$exauth_id ) {
	twitter_callback_error( _TWITTER_ERR_SOMETHING .' (3)' );
	exit();
}

if ( $screen_name != $exauth_id ) {
	twitter_callback_error( _TWITTER_ERR_SOMETHING .' (4)' );
	exit();
}

list( $token_old, $secret_old ) = $exauth->get_user_token( $uid );
if( $token_old ) {
	twitter_callback_error( _TWITTER_ERR_SOMETHING .' (5)' );
	exit();
}

$ret = $exauth->set_user_token( $uid, $token, $secret );
if( !$ret ) {
	twitter_callback_error( _TWITTER_ERR_SOMETHING .' (6)' );
	exit();
}

redirect_header( $REDIRECT_URL, $REDIRECT_TIME_SUCCESS, _TWITTER_LOGINED );
exit();
// === main end ===

function twitter_callback_error( $msg )
{
	$REDIRECT_URL = XOOPS_URL.'/modules/twitter/index.php';
	$REDIRECT_TIME_ERROR  = 5;

	redirect_header( $REDIRECT_URL, $REDIRECT_TIME_ERROR, $msg );
	exit();
}

?>