﻿<?php
/**
 * @package exauth
 * @subpackage language_japanese
 * @version $Id: modinfo.php 239 2009-03-21 13:55:20Z kisara $
 */

/**#@+ Message Define */
define('_MI_EXAUTH_NAME', '外部認証モジュール');
define('_MI_EXAUTH_NAME_SINPLE', '外部認証');
define('_MI_EXAUTH_DESC', 'XOOPSを外部認証APIに対応させるモジュール');

define('_MI_EXAUTH_BNAME1', '外部認証ログイン');
define('_MI_EXAUTH_BNAME1_DESC', '外部認証ログインブロックを表示');

define('_MI_EXAAUTH_BNAME2', '外部認証ツール');
define('_MI_EXAAUTH_BNAME2_DESC', '外部認証関連のツール');

define('_MI_EXAUTH_INFO_MENU2','外部認証ユーザ管理');

define('_MI_EXAUTH_INFO_MENU3','unameフィールドを拡張');

define('_MI_EXAUTH_INFO_MENU_MODULE_SETTING','外部認証モジュール一般設定');

define('_MI_EXAUTH_ADMIN_MENU_ABOUT_T','外部認証モジュールについて');

// for Config
define('_MI_EXAUTH_CFG_USE_MSG', '外部認証機能を使用する');
define('_MI_EXAUTH_CFG_USE_DESC', '');

define('_MI_EXAUTH_CFG_ALLOW_REGISTER', '新規ユーザの登録を許可する');
define('_MI_EXAUTH_CFG_ALW_RG_DESC', '「はい」を選択すると新規ユーザの登録を許可します。');

define('_MI_EXAUTH_CFG_AUTO_REGIST', '自動登録：認証に成功したら自動で新規登録する');
define('_MI_EXAUTH_CFG_AUTO_REGIST_DSC', '認証に成功した際、未登録であればユーザの操作なく自動で登録します。');

define('_MI_EXAUTH_CFG_AREG_TYPE', '自動登録：自動登録時のuname決定方法');
define('_MI_EXAUTH_CFG_AREG_TYPE_DSC', '『外部認証のIDそのまま』を指定する場合はプラグインが一つしかインストールされていない状態である必要があります。');

define('_MI_EXAUTH_CFG_AREG_SEL_PREFIX', '接頭子を付加');
define('_MI_EXAUTH_CFG_AREG_SEL_PLAIN', '外部認証のIDそのまま');

define('_MI_EXAUTH_CFG4_MSG', 'ログインフォームを同じブロックに表示する');
define('_MI_EXAUTH_CFG4_DESC', 'ログイン時に外部認証へのリンクとデフォルトのログインフォームを同じブロックに表示します。');

define('_MI_EXAUTH_CFG5_MSG', 'sysutil/cubeUtilsのディレクトリ名');
define('_MI_EXAUTH_CFG5_DESC', '上記設定時にsysutil/cubeUtilsのログインフォームを使用する場合指定します。使用しない場合は空欄のままにしてください。');

if (defined('XOOPS_CUBE_LEGACY')) {
    define ('_MI_EXAUTH_URL_USER_PREFEENCE_EDIT', XOOPS_URL . '/modules/legacy/admin/index.php?action=PreferenceEdit&confmod_id=3');
}
else {
    define ('_MI_EXAUTH_URL_USER_PREFEENCE_EDIT', XOOPS_URL . '/modules/system/admin.php?fct=preferences&op=show&confcat_id=2');
}

define('_MI_EXAUTH_CFG6_MSG', '新規登録時にユーザ名(uname)を自動で割り当てる');
define('_MI_EXAUTH_CFG6_DESC',
  '各IDの頭に接頭子を付加して自動的にユーザ名を割り当てます。<br />' .
  '登録時のuname入力との選択式になります。<br />' .
  'この機能を使用するには以下の設定を行う必要があります。<br />' .
  '<ul>' .
  '<li><a href="' . XOOPS_URL . (defined('XOOPS_CUBE_LEGACY')?'/modules/legacy/admin/index.php?action=PreferenceEdit&confmod_id=3':'/modules/system/admin.php?fct=preferences&op=show&confcat_id=2') . '">ユーザ情報設定</a>の『<strong>ユーザ名として使用可能な文字の設定を行います。～～</strong>』を『<strong>強</strong>』<br />' .
  '<li><a href="' . XOOPS_URL . '/modules/' . basename(dirname(dirname(dirname(__FILE__)))) . '/admin/expand_uname.php">' . _MI_EXAUTH_INFO_MENU3 . '</a>' .
  '</ul>' .
  '<span style="color:#ff0000; font-weight:bold;">これらの設定がされていないと、この機能は有効になりません。</span>'
);


define('_MI_EXAUTH_CFG7_MSG', '新規登録時のメールアドレスの未入力を許可する。');
define('_MI_EXAUTH_CFG7_DESC', '新規登録時のメールアドレスの未入力を許可します。<br />xoops本体の「アカウント編集」メニューでは従来のまま入力必須になってしまいますので、白扇等でメールアドレスの未入力を許可するように変更するなどしてください。');

define('_MI_EXAUTH_CFG8_MSG', 'uname自動割り当て機能使用時に自動割り当てのみにする');
define('_MI_EXAUTH_CFG8_DESC', '新規登録時にユーザ名(uname)を自動で割り当てのみにして、uname入力との選択を出来なくします。');

define('_MI_EXAUTH_CFG9_MSG', 'ユーザによる外部認証IDの関連付け削除を出来ないようにする');
define('_MI_EXAUTH_CFG9_DESC', '一度登録した外部認証IDの関連付けをユーザが削除できないようにします。');

define('_MI_EXAUTH_CFG_DEFGROUP_MSG', '外部認証経由でユーザ登録する際の登録グループ');
define('_MI_EXAUTH_CFG_DEFGROUP_DESC', '外部認証モジュールによる新規登録時のデフォルトのグループを指定します。');

define('_MI_EXAUTH_CFG_AUTOREG', '認証に成功したら自動でユーザ登録する。');
define('_MI_EXAUTH_CFG_AUTOREG_DESC', '認証に成功したら自動的にユーザ登録を行います。イントラネットなど、セキュリティ的に安全な所での運用を想定しています。');
/**#@-*/

// load plugin languages
$plugin_dir = XOOPS_ROOT_PATH . '/modules/exauth/plugins';
$dir = opendir($plugin_dir);
if ($dir) {
    while (($name = readdir($dir)) !== false) {
        if (preg_match('/^\./', $name) || !is_dir($plugin_dir.'/'.$name)) {
            continue;
        }
        $language = basename(dirname(__FILE__));
        $language_file = $plugin_dir.'/'.$name.'/language/'.$language.'/modinfo.php';
        if (file_exists($language_file)) {
            /** @ignore */
            include_once $language_file;
        }
        else {
            $filename = $plugin_dir.'/'.$name.'/language/english/modinfo.php';
            if (file_exists($filename)) {
                /** @ignore */
                include_once $filename;
            }
        }
    }
    closedir($dir);
}
